/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClient.jdbc;

import edu.internet2.middleware.grouperClient.collections.MultiKey;
import edu.internet2.middleware.grouperClient.jdbc.GcBoundDataConversion;
import edu.internet2.middleware.grouperClient.jdbc.GcBoundDataConversionImpl;
import edu.internet2.middleware.grouperClient.jdbc.GcCallableStatementCallback;
import edu.internet2.middleware.grouperClient.jdbc.GcCaseIgnoreHashMap;
import edu.internet2.middleware.grouperClient.jdbc.GcConnectionCallback;
import edu.internet2.middleware.grouperClient.jdbc.GcDbQueryCache;
import edu.internet2.middleware.grouperClient.jdbc.GcDbQueryCacheMap;
import edu.internet2.middleware.grouperClient.jdbc.GcEntityCallback;
import edu.internet2.middleware.grouperClient.jdbc.GcPersistableHelper;
import edu.internet2.middleware.grouperClient.jdbc.GcPreparedStatementCallback;
import edu.internet2.middleware.grouperClient.jdbc.GcQueryReport;
import edu.internet2.middleware.grouperClient.jdbc.GcResultSetCallback;
import edu.internet2.middleware.grouperClient.jdbc.GcSqlAssignPrimaryKey;
import edu.internet2.middleware.grouperClient.jdbc.GcTransactionCallback;
import edu.internet2.middleware.grouperClient.jdbc.GcTransactionEnd;
import edu.internet2.middleware.grouperClient.util.GrouperClientConfig;
import edu.internet2.middleware.grouperClient.util.GrouperClientUtils;
import java.lang.reflect.Field;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class GcDbAccess {
    private static Map<MultiKey, GcDbQueryCache> dbQueryCacheMap = new GcDbQueryCacheMap();
    private Integer cacheMinutes;
    private static boolean accumulateQueryMillis;
    private static Map<String, GcQueryReport> queriesAndMillis;
    private Integer queryTimeoutSeconds;
    private List<Object> bindVars;
    private List<List<Object>> batchBindVars;
    private String sql;
    private List<Object> primaryKeys;
    private String connectionName;
    private Connection connection;
    private Object example;
    private boolean omitNullValuesForExample;
    private int numberOfRowsAffected;
    private int[] numberOfBatchRowsAffected;
    private static GcBoundDataConversion boundDataConversion;
    private static boolean dbConnectionClassesRegistered;
    private static ThreadLocal<Map<String, Connection>> connectionThreadLocal;
    private static ThreadLocal<Boolean> transactionThreadLocal;

    public GcDbAccess connectionName(String theConnectionName) {
        this.connectionName = theConnectionName;
        return this;
    }

    public static void transactionEnd(GcTransactionEnd transactionEnd, boolean endOnlyIfStarted) {
        GcDbAccess.transactionEnd(transactionEnd, endOnlyIfStarted, null);
    }

    public static void transactionEnd(GcTransactionEnd transactionEnd, boolean endOnlyIfStarted, String connectionName) {
        ConnectionBean connectionBean = GcDbAccess.connection(false, false, connectionName);
        Connection connection = connectionBean.getConnection();
        if (connection == null) {
            throw new RuntimeException("There is no connection!");
        }
        ConnectionBean.transactionEnd(connectionBean, transactionEnd, endOnlyIfStarted, true, false);
    }

    public static void loadBoundDataConversion(GcBoundDataConversion _boundDataConversion) {
        boundDataConversion = _boundDataConversion;
    }

    public static String createInString(int numberOfBindVariables) {
        StringBuilder results = new StringBuilder(" (");
        for (int i = 0; i < numberOfBindVariables; ++i) {
            results.append("?,");
        }
        GrouperClientUtils.removeEnd(results, ",");
        results.append(") ");
        return results.toString();
    }

    public GcDbAccess bindVars(Object ... _bindVars) {
        this.bindVars = new ArrayList<Object>();
        for (Object bindVar : _bindVars) {
            if (bindVar instanceof List) {
                List arrayData = (List)bindVar;
                for (Object value : arrayData) {
                    this.bindVars.add(value);
                }
                continue;
            }
            this.bindVars.add(bindVar);
        }
        return this;
    }

    public GcDbAccess addBindVar(Object _bindVar) {
        if (this.bindVars == null) {
            this.bindVars = new ArrayList<Object>();
        }
        this.bindVars.add(_bindVar);
        return this;
    }

    public GcDbAccess batchBindVars(List<List<Object>> _batchBindVars) {
        this.batchBindVars = _batchBindVars;
        return this;
    }

    public GcDbAccess cacheMinutes(Integer _cacheMinutes) {
        this.cacheMinutes = _cacheMinutes;
        return this;
    }

    public GcDbAccess sql(String _sql) {
        this.sql = _sql;
        return this;
    }

    public GcDbAccess omitNullValuesForExample() {
        this.omitNullValuesForExample = true;
        return this;
    }

    public GcDbAccess example(Object _example) {
        this.example = _example;
        return this;
    }

    public GcDbAccess queryTimeoutSeconds(Integer _queryTimeoutSeconds) {
        this.queryTimeoutSeconds = _queryTimeoutSeconds;
        return this;
    }

    public static void accumulateQueryMillis(boolean _accumulateQueryMillis) {
        if (_accumulateQueryMillis) {
            queriesAndMillis = new LinkedHashMap<String, GcQueryReport>();
        } else {
            queriesAndMillis.clear();
        }
        accumulateQueryMillis = _accumulateQueryMillis;
    }

    public static void reportQueriesAndMillisAndTurnOffAccumulation(String fileLocation) {
        if (!accumulateQueryMillis) {
            throw new RuntimeException("accumulateQueryMillis must be set to true first!");
        }
        GcQueryReport.reportToFile(fileLocation, queriesAndMillis);
    }

    public GcDbAccess primaryKey(Object ... _primaryKey) {
        block3: {
            block2: {
                this.primaryKeys = new ArrayList<Object>();
                if (_primaryKey == null || _primaryKey.length != 1 || !(_primaryKey[0] instanceof List)) break block2;
                List arrayData = (List)_primaryKey[0];
                for (Object value : arrayData) {
                    this.primaryKeys.add(value);
                }
                break block3;
            }
            if (_primaryKey == null) break block3;
            for (Object primaryKey : _primaryKey) {
                this.primaryKeys.add(primaryKey);
            }
        }
        return this;
    }

    private void addQueryToQueriesAndMillis(String query, Long nanoTimeStarted) {
        if (!accumulateQueryMillis) {
            return;
        }
        GcQueryReport queryReport = queriesAndMillis.get(query);
        if (queryReport == null) {
            queryReport = new GcQueryReport();
            queryReport.setQuery(query);
            queriesAndMillis.put(query, queryReport);
        }
        queryReport.addExecutionTime((System.nanoTime() - nanoTimeStarted) / 1000000L);
    }

    public boolean isPreviouslyPersisted(Object o) {
        Field field = GcPersistableHelper.primaryKeyField(o.getClass());
        List<Field> compoundPrimaryKeys = GcPersistableHelper.compoundPrimaryKeyFields(o.getClass());
        if (field == null && compoundPrimaryKeys.size() == 0) {
            return false;
        }
        if (field != null) {
            Object fieldValue = null;
            try {
                fieldValue = field.get(o);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (fieldValue == null) {
                return false;
            }
            if (GcPersistableHelper.primaryKeyManuallyAssigned(field)) {
                Long startTime = System.nanoTime();
                String query = "select count(*) from " + GcPersistableHelper.tableName(o.getClass()) + " where " + GcPersistableHelper.columnName(field) + " =  ?";
                int count = new GcDbAccess().sql(query).bindVars(fieldValue).select(Integer.TYPE);
                this.addQueryToQueriesAndMillis(query, startTime);
                return count > 0;
            }
            try {
                Long theId = new Long(String.valueOf(fieldValue));
                return theId > 0L;
            }
            catch (Exception e) {
                throw new RuntimeException("Expected primary key field of numeric type but got " + field.getName() + " of type " + field.getClass() + ". You need to override isPreviouslyPersisted() or provide a Persistable annotation for your primary key!", e);
            }
        }
        if (compoundPrimaryKeys.size() > 0) {
            ArrayList<Object> theBindVariables = new ArrayList<Object>();
            String theSql = "select count(*) from " + GcPersistableHelper.tableName(o.getClass()) + " where ";
            for (Field compoundPrimaryKey : compoundPrimaryKeys) {
                Object fieldValue = null;
                try {
                    fieldValue = compoundPrimaryKey.get(o);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                theSql = theSql + GcPersistableHelper.columnName(compoundPrimaryKey) + " = ? and ";
                theBindVariables.add(fieldValue);
            }
            theSql = theSql.substring(0, theSql.length() - 4);
            Long startTime = System.nanoTime();
            int count = new GcDbAccess().sql(theSql).bindVars(theBindVariables).select(Integer.TYPE);
            this.addQueryToQueriesAndMillis(theSql, startTime);
            return count > 0;
        }
        throw new RuntimeException("No primary key or compound primary keys specified!");
    }

    public void deleteFromDatabase(Object o) {
        if (!this.isPreviouslyPersisted(o)) {
            return;
        }
        Field primaryKeyField = GcPersistableHelper.primaryKeyField(o.getClass());
        List<Field> compoundPrimaryKeys = GcPersistableHelper.compoundPrimaryKeyFields(o.getClass());
        if (primaryKeyField == null && compoundPrimaryKeys.size() == 0) {
            throw new RuntimeException("Cannot delete a row with no primary key or compound primary keys - use sql to delete the row instead of the method deleteFromDatabase().");
        }
        if (primaryKeyField != null) {
            String primaryKeyColumnName = GcPersistableHelper.columnName(primaryKeyField);
            Object primaryKey = null;
            try {
                primaryKey = primaryKeyField.get(o);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            String tableName = GcPersistableHelper.tableName(o.getClass());
            String sqlToUse = "delete from " + tableName + " where " + primaryKeyColumnName + " = ? ";
            this.sql(sqlToUse);
            this.bindVars(primaryKey);
            this.executeSql();
            return;
        }
        if (compoundPrimaryKeys.size() > 0) {
            ArrayList<Object> theBindVariables = new ArrayList<Object>();
            String theSql = "delete from " + GcPersistableHelper.tableName(o.getClass()) + " where ";
            for (Field compoundPrimaryKey : compoundPrimaryKeys) {
                Object fieldValue = null;
                try {
                    fieldValue = compoundPrimaryKey.get(o);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                theSql = theSql + GcPersistableHelper.columnName(compoundPrimaryKey) + " = ? and ";
                theBindVariables.add(fieldValue);
            }
            theSql = theSql.substring(0, theSql.length() - 4);
            this.sql(theSql);
            this.bindVars(theBindVariables);
            this.executeSql();
        }
    }

    public <T> void storeListToDatabase(List<T> objects) {
        this.storeBatchToDatabase(objects, 200);
    }

    public <T> void storeToDatabase(T t) {
        if (!GrouperClientUtils.isBlank(this.sql)) {
            throw new RuntimeException("Cannot use both sql and set an object to store.");
        }
        HashMap<String, Object> columnNamesAndValues = new HashMap<String, Object>();
        Object primaryKeyValue = null;
        Field primaryKey = GcPersistableHelper.primaryKeyField(t.getClass());
        List<Field> compoundPrimaryKeys = GcPersistableHelper.compoundPrimaryKeyFields(t.getClass());
        try {
            boolean keepPrimaryKeyColumns;
            boolean previouslyPersisted = this.isPreviouslyPersisted(t);
            boolean bl = keepPrimaryKeyColumns = t instanceof GcSqlAssignPrimaryKey && !previouslyPersisted;
            if (keepPrimaryKeyColumns) {
                ((GcSqlAssignPrimaryKey)t).gcSqlAssignNewPrimaryKeyForInsert();
            }
            for (Field field : GcPersistableHelper.heirarchicalFields(t.getClass())) {
                field.setAccessible(true);
                if ((primaryKey != null || !GcPersistableHelper.isPersist(field, t.getClass())) && (!GcPersistableHelper.isPersist(field, t.getClass()) || !keepPrimaryKeyColumns && !GcPersistableHelper.primaryKeyManuallyAssigned(primaryKey) && GcPersistableHelper.isPrimaryKey(field))) continue;
                columnNamesAndValues.put(GcPersistableHelper.columnName(field), field.get(t));
            }
            String sqlToUse = "";
            ArrayList<Object> bindVarstoUse = new ArrayList<Object>();
            if (previouslyPersisted) {
                sqlToUse = " update " + GcPersistableHelper.tableName(t.getClass()) + " set ";
                for (String columnName : columnNamesAndValues.keySet()) {
                    sqlToUse = sqlToUse + " " + columnName + " = ?, ";
                    bindVarstoUse.add(columnNamesAndValues.get(columnName));
                }
                sqlToUse = GrouperClientUtils.removeEnd(sqlToUse, ", ");
                if (primaryKey != null) {
                    sqlToUse = sqlToUse + " where " + GcPersistableHelper.columnName(primaryKey) + " = ? ";
                    bindVarstoUse.add(primaryKey.get(t));
                } else if (compoundPrimaryKeys.size() > 0) {
                    sqlToUse = sqlToUse + " where ";
                    for (Field compoundPrimaryKey : compoundPrimaryKeys) {
                        Object fieldValue = null;
                        try {
                            fieldValue = compoundPrimaryKey.get(t);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                        sqlToUse = sqlToUse + GcPersistableHelper.columnName(compoundPrimaryKey) + " = ? and ";
                        bindVarstoUse.add(fieldValue);
                    }
                    sqlToUse = sqlToUse.substring(0, sqlToUse.length() - 4);
                }
            } else {
                sqlToUse = " insert into " + GcPersistableHelper.tableName(t.getClass()) + " ( ";
                String bindVarString = "values (";
                for (String columnName : columnNamesAndValues.keySet()) {
                    sqlToUse = sqlToUse + columnName + ",";
                    bindVarString = bindVarString + "?,";
                    bindVarstoUse.add(columnNamesAndValues.get(columnName));
                }
                if (primaryKey != null && !GcPersistableHelper.primaryKeyManuallyAssigned(primaryKey) && !GcPersistableHelper.findPersistableClassAnnotation(t.getClass()).hasNoPrimaryKey()) {
                    sqlToUse = sqlToUse + GcPersistableHelper.columnName(primaryKey);
                    sqlToUse = sqlToUse + ") ";
                    primaryKeyValue = new GcDbAccess().sql(" select " + GcPersistableHelper.primaryKeySequenceName(primaryKey) + ".nextval from dual").select(primaryKey.getType());
                    bindVarstoUse.add(primaryKeyValue);
                    bindVarString = bindVarString + "?) ";
                } else {
                    sqlToUse = GrouperClientUtils.removeEnd(sqlToUse, ",") + ") ";
                    bindVarString = GrouperClientUtils.removeEnd(bindVarString, ",") + ") ";
                }
                sqlToUse = sqlToUse + bindVarString;
            }
            this.sql(sqlToUse);
            this.bindVars(bindVarstoUse);
            this.executeSql();
            if (primaryKeyValue != null) {
                boundDataConversion.setFieldValue(t, primaryKey, primaryKeyValue);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public <T> void storeBatchToDatabase(List<T> objects, int batchSize) {
        this.storeBatchToDatabase(objects, batchSize, false);
    }

    public <T> void storeBatchToDatabase(final List<T> objects, final int batchSize, final boolean omitPrimaryKeyPopulation) {
        if (objects == null || objects.size() == 0) {
            return;
        }
        final ArrayList objectsToStore = new ArrayList();
        final ArrayList objectsToReturn = new ArrayList();
        this.callbackTransaction(new GcTransactionCallback<Boolean>(){

            @Override
            public Boolean callback(GcDbAccess dbAccessForStorage) {
                for (int i = 0; i < objects.size(); ++i) {
                    objectsToStore.add(objects.get(i));
                    if (objectsToStore.size() < batchSize && i != objects.size() - 1) continue;
                    dbAccessForStorage.storeBatchToDatabase(objectsToStore, omitPrimaryKeyPopulation);
                    objectsToReturn.addAll(objectsToStore);
                    objectsToStore.clear();
                }
                return null;
            }
        });
        int existingLength = objects.size();
        objects.clear();
        objects.addAll(objectsToReturn);
        if (objects.size() != existingLength) {
            throw new RuntimeException("There should have been " + existingLength + " objects returned but there are only " + objects.size() + "!");
        }
    }

    public <T> void storeBatchToDatabase(List<T> objects) {
        this.storeBatchToDatabase(objects, false);
    }

    public <T> void storeBatchToDatabase(List<T> objects, boolean omitPrimaryKeyPopulation) {
        if (objects == null || objects.size() == 0) {
            return;
        }
        String insertSql = null;
        String updateSql = null;
        boolean updateSqlInitialized = false;
        boolean insertSqlInitialized = false;
        if (!GrouperClientUtils.isBlank(this.sql)) {
            throw new RuntimeException("Cannot use both sql and set objects to store.");
        }
        Field primaryKey = GcPersistableHelper.primaryKeyField(objects.get(0).getClass());
        List<Field> compoundPrimaryKeys = GcPersistableHelper.compoundPrimaryKeyFields(objects.get(0).getClass());
        List<Field> allFields = GcPersistableHelper.heirarchicalFields(objects.get(0).getClass());
        HashMap<Field, Boolean> fieldAndIncludeStatuses = new HashMap<Field, Boolean>();
        for (Field field : allFields) {
            field.setAccessible(true);
            if (primaryKey == null && GcPersistableHelper.isPersist(field, objects.get(0).getClass()) || GcPersistableHelper.isPersist(field, objects.get(0).getClass()) && (GcPersistableHelper.primaryKeyManuallyAssigned(primaryKey) || !GcPersistableHelper.isPrimaryKey(field))) {
                fieldAndIncludeStatuses.put(field, true);
                continue;
            }
            fieldAndIncludeStatuses.put(field, false);
        }
        try {
            ArrayList<List<Object>> listsOfBindVars = new ArrayList<List<Object>>();
            HashMap indexOfObjectAndPrimaryKeyToSet = new HashMap();
            int objectIndex = 0;
            for (T object : objects) {
                HashMap<String, Object> columnNamesAndValues = new HashMap<String, Object>();
                for (Field field : allFields) {
                    if (!((Boolean)fieldAndIncludeStatuses.get(field)).booleanValue()) continue;
                    columnNamesAndValues.put(GcPersistableHelper.columnName(field), field.get(object));
                }
                ArrayList<Object> bindVarstoUse = new ArrayList<Object>();
                if (this.isPreviouslyPersisted(object)) {
                    if (!updateSqlInitialized) {
                        updateSql = " update " + GcPersistableHelper.tableName(object.getClass()) + " set ";
                        for (String columnName : columnNamesAndValues.keySet()) {
                            updateSql = updateSql + " " + columnName + " = ?, ";
                        }
                        updateSql = GrouperClientUtils.removeEnd(updateSql, ", ");
                    }
                    for (String columnName : columnNamesAndValues.keySet()) {
                        bindVarstoUse.add(columnNamesAndValues.get(columnName));
                    }
                    if (primaryKey != null) {
                        if (!updateSqlInitialized) {
                            updateSql = updateSql + " where " + GcPersistableHelper.columnName(primaryKey) + " = ? ";
                        }
                        bindVarstoUse.add(primaryKey.get(object));
                    } else if (compoundPrimaryKeys.size() > 0) {
                        if (!updateSqlInitialized) {
                            updateSql = updateSql + " where ";
                        }
                        for (Field compoundPrimaryKey : compoundPrimaryKeys) {
                            Object fieldValue = null;
                            try {
                                fieldValue = compoundPrimaryKey.get(object);
                                bindVarstoUse.add(fieldValue);
                            }
                            catch (Exception e) {
                                throw new RuntimeException(e);
                            }
                            if (updateSqlInitialized) continue;
                            updateSql = updateSql + GcPersistableHelper.columnName(compoundPrimaryKey) + " = ? and ";
                        }
                        if (!updateSqlInitialized) {
                            updateSql = updateSql.substring(0, updateSql.length() - 4);
                        }
                    }
                    updateSqlInitialized = true;
                    listsOfBindVars.add(bindVarstoUse);
                } else {
                    String bindVarString = "";
                    if (!insertSqlInitialized) {
                        insertSql = " insert into " + GcPersistableHelper.tableName(object.getClass()) + " ( ";
                        bindVarString = "values (";
                        for (String columnName : columnNamesAndValues.keySet()) {
                            insertSql = insertSql + columnName + ",";
                            bindVarString = bindVarString + "?,";
                        }
                    }
                    for (String columnName : columnNamesAndValues.keySet()) {
                        bindVarstoUse.add(columnNamesAndValues.get(columnName));
                    }
                    if (primaryKey != null && !GcPersistableHelper.primaryKeyManuallyAssigned(primaryKey) && !GcPersistableHelper.findPersistableClassAnnotation(object.getClass()).hasNoPrimaryKey()) {
                        if (!insertSqlInitialized) {
                            insertSql = insertSql + GcPersistableHelper.columnName(primaryKey);
                            insertSql = insertSql + ") ";
                            bindVarString = !omitPrimaryKeyPopulation ? bindVarString + "?) " : bindVarString + GcPersistableHelper.primaryKeySequenceName(primaryKey) + ".nextval) ";
                        }
                        if (!omitPrimaryKeyPopulation) {
                            Object primaryKeyValue = new GcDbAccess().sql(" select " + GcPersistableHelper.primaryKeySequenceName(primaryKey) + ".nextval from dual").select(primaryKey.getType().getClass());
                            bindVarstoUse.add(primaryKeyValue);
                            indexOfObjectAndPrimaryKeyToSet.put(objectIndex, primaryKeyValue);
                        }
                    } else if (!insertSqlInitialized) {
                        insertSql = GrouperClientUtils.removeEnd(insertSql, ",") + ") ";
                        bindVarString = GrouperClientUtils.removeEnd(bindVarString, ",") + ") ";
                    }
                    if (!insertSqlInitialized) {
                        insertSql = insertSql + bindVarString;
                    }
                    insertSqlInitialized = true;
                    listsOfBindVars.add(bindVarstoUse);
                }
                ++objectIndex;
            }
            if (updateSql != null && insertSql != null) {
                throw new RuntimeException("It is not possible to mix updates and inserts in one batch; Statement supports it but not with bind variables so we do not support it.");
            }
            if (updateSql == null && insertSql == null) {
                throw new RuntimeException("No sql was created!");
            }
            this.batchBindVars(listsOfBindVars);
            this.sql(updateSql != null ? updateSql : insertSql);
            this.executeBatchSql();
            this.sql(null);
            this.batchBindVars(null);
            for (Integer objectIndexInList : indexOfObjectAndPrimaryKeyToSet.keySet()) {
                boundDataConversion.setFieldValue(objects.get(objectIndexInList), primaryKey, indexOfObjectAndPrimaryKeyToSet.get(objectIndexInList));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public <T> void callbackEntity(Class<T> clazz, GcEntityCallback<T> entityCallback) {
        this.selectList(clazz, entityCallback);
    }

    public <T> T callbackTransaction(GcTransactionCallback<T> transactionCallback) {
        T t;
        ConnectionBean connectionBean = null;
        try {
            connectionBean = GcDbAccess.connection(true, true, this.connectionName);
            this.connection = connectionBean.getConnection();
            T t2 = transactionCallback.callback(this);
            ConnectionBean.transactionEnd(connectionBean, GcTransactionEnd.commit, true, true, true);
            t = t2;
        }
        catch (Exception e) {
            try {
                ConnectionBean.transactionEnd(connectionBean, GcTransactionEnd.rollback, true, true, true);
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                ConnectionBean.closeIfStarted(connectionBean);
                throw throwable;
            }
        }
        ConnectionBean.closeIfStarted(connectionBean);
        return t;
    }

    public <K, V> Map<K, V> selectMap(Class<K> keyClass, Class<V> valueClass) {
        List<Map> list = this.selectList(Map.class);
        if (list.size() == 0) {
            return null;
        }
        if (list.size() > 1) {
            throw new RuntimeException("Only one object expected but " + list.size() + " were returned for sql " + this.sql);
        }
        if (keyClass.equals(String.class)) {
            GcCaseIgnoreHashMap mapToReturn = new GcCaseIgnoreHashMap();
            for (Object key : list.get(0).keySet()) {
                mapToReturn.put(String.valueOf(key), boundDataConversion.getFieldValue(valueClass, list.get(0).get(key)));
            }
            return mapToReturn;
        }
        HashMap mapToReturn = new HashMap();
        for (Object key : list.get(0).keySet()) {
            mapToReturn.put(key, boundDataConversion.getFieldValue(valueClass, list.get(0).get(key)));
        }
        return mapToReturn;
    }

    public <K, V> Map<K, V> selectMapMultipleRows(Class<K> keyClass, Class<V> valueClass) {
        List<Map> list = this.selectList(Map.class);
        if (list.size() == 0) {
            return null;
        }
        Iterator columnNames = list.get(0).keySet().iterator();
        Object keyName = columnNames.next();
        Object valueName = columnNames.next();
        HashMap mapToReturn = new HashMap();
        for (Map theMap : list) {
            mapToReturn.put(theMap.get(keyName), boundDataConversion.getFieldValue(valueClass, theMap.get(valueName)));
        }
        return mapToReturn;
    }

    public List<GcCaseIgnoreHashMap> selectListMap() {
        List<Map> list = this.selectList(Map.class);
        ArrayList<GcCaseIgnoreHashMap> newList = new ArrayList<GcCaseIgnoreHashMap>();
        for (Map map : list) {
            GcCaseIgnoreHashMap mapToReturn = new GcCaseIgnoreHashMap();
            mapToReturn.putAll(map);
            newList.add(mapToReturn);
        }
        return newList;
    }

    public GcCaseIgnoreHashMap selectMapMultipleColumnsOneRow() {
        List<GcCaseIgnoreHashMap> caseIgnoreHashMaps = this.selectListMap();
        if (caseIgnoreHashMaps.size() > 1) {
            throw new RuntimeException("More than one row was returned for query " + this.sql);
        }
        if (caseIgnoreHashMaps.size() == 1) {
            return caseIgnoreHashMaps.get(0);
        }
        return null;
    }

    public <T> T select(Class<T> clazz) {
        Object cachedObject;
        if (this.cacheMinutes != null && (cachedObject = this.selectFromQueryCache(false, clazz)) != null) {
            return (T)cachedObject;
        }
        List<T> list = this.selectList(clazz, true);
        if (list.size() == 0) {
            return null;
        }
        if (list.size() > 1) {
            throw new RuntimeException("Only one object expected but " + list.size() + " were returned for sql " + this.sql);
        }
        if (this.cacheMinutes != null) {
            this.populateQueryCache(clazz, list.get(0), false);
        }
        return list.get(0);
    }

    public <T> List<T> selectList(Class<T> clazz) {
        return this.selectList(clazz, false);
    }

    private <T> List<T> selectList(Class<T> clazz, boolean calledFromSelect) {
        Object cachedObject;
        if (!calledFromSelect && this.cacheMinutes != null && (cachedObject = this.selectFromQueryCache(true, clazz)) != null) {
            return (List)cachedObject;
        }
        List<T> resultList = this.selectList(clazz, null);
        if (!calledFromSelect && this.cacheMinutes != null) {
            this.populateQueryCache(clazz, resultList, true);
        }
        return resultList;
    }

    private <T> List<T> selectList(final Class<T> clazz, final GcEntityCallback<T> entityCallback) {
        if (this.primaryKeys != null && (this.sql != null || this.example != null) || this.sql != null && (this.primaryKeys != null || this.example != null) || this.example != null && (this.primaryKeys != null || this.sql != null)) {
            throw new RuntimeException("Set sql(), primaryKey(), or example() but not more than one! primaryKey() will formulate sql.");
        }
        ArrayList<String> columnNamesList = new ArrayList<String>();
        for (Field field : GcPersistableHelper.heirarchicalFields(clazz)) {
            if (!GcPersistableHelper.isSelect(field, clazz)) continue;
            String columnName = GcPersistableHelper.columnName(field);
            columnNamesList.add(columnName);
        }
        String columnNames = GrouperClientUtils.join(columnNamesList.iterator(), ",");
        if (this.primaryKeys != null) {
            if (this.bindVars != null) {
                throw new RuntimeException("Set bindVars() or primaryKey() but not both! primaryKey() will formulate sql.");
            }
            Field primaryKeyField = GcPersistableHelper.primaryKeyField(clazz);
            String theSql = " select " + columnNames + " from " + GcPersistableHelper.tableName(clazz) + " where " + GcPersistableHelper.columnName(primaryKeyField);
            if (this.primaryKeys.size() == 1) {
                theSql = theSql + " = ? ";
                this.bindVars(this.primaryKeys.get(0));
            } else if (this.primaryKeys.size() > 1) {
                theSql = theSql + " in (";
                for (int i = 0; i < this.primaryKeys.size(); ++i) {
                    theSql = theSql + "?,";
                }
                theSql = GrouperClientUtils.removeEnd(theSql, ",") + ")";
                this.bindVars(this.primaryKeys);
            }
            this.sql(theSql);
        } else if (this.sql == null && this.example == null) {
            this.sql(" select " + columnNames + " from " + GcPersistableHelper.tableName(clazz));
        } else if (this.example != null) {
            String theSql = " select * from " + GcPersistableHelper.tableName(clazz) + " where ";
            String whereClauseToUse = "";
            ArrayList<Object> bindVarstoUse = new ArrayList<Object>();
            for (Field field : GcPersistableHelper.heirarchicalFields(clazz)) {
                field.setAccessible(true);
                try {
                    if (!GcPersistableHelper.isSelect(field, clazz) || GcPersistableHelper.isPrimaryKey(field)) continue;
                    Object fieldValue = field.get(this.example);
                    if (this.omitNullValuesForExample && fieldValue == null) continue;
                    String columnName = "";
                    if (field.getType().equals(String.class)) {
                        columnName = "to_char(" + GcPersistableHelper.columnName(field) + ")";
                        if (fieldValue != null) {
                            bindVarstoUse.add(fieldValue);
                        }
                    } else if (field.getType().equals(Date.class)) {
                        columnName = "to_char(" + GcPersistableHelper.columnName(field) + ", 'MM/DD/YYYY HH24:MI:SS')";
                        if (fieldValue != null) {
                            bindVarstoUse.add(new SimpleDateFormat("MM/dd/yyyy HH:mm:ss").format((Date)fieldValue));
                        }
                    } else {
                        columnName = GcPersistableHelper.columnName(field);
                        if (fieldValue != null) {
                            bindVarstoUse.add(fieldValue);
                        }
                    }
                    String bindOrEquals = fieldValue == null ? " is null and " : " = ? and ";
                    whereClauseToUse = whereClauseToUse + columnName + bindOrEquals;
                }
                catch (Exception e) {
                    throw new RuntimeException("Issues encountered trying to read field " + field.getName() + " in class " + this.example.getClass(), e);
                }
            }
            whereClauseToUse = GrouperClientUtils.removeEnd(whereClauseToUse, "and ");
            theSql = theSql + whereClauseToUse;
            this.sql(theSql);
            this.bindVars(bindVarstoUse);
        }
        Long startTime = System.nanoTime();
        String sqlToRecord = this.sql;
        List list = (List)this.callbackResultSet(new GcResultSetCallback<List<T>>(){

            @Override
            public List<T> callback(ResultSet resultSet) throws Exception {
                ArrayList theList = new ArrayList();
                HashMap fieldIsIncludedInResults = new HashMap();
                while (resultSet.next()) {
                    if (entityCallback != null) {
                        Object t = GcDbAccess.this.addObjectToList(clazz, fieldIsIncludedInResults, resultSet, null);
                        boolean keepScrolling = entityCallback.callback(t);
                        if (keepScrolling) continue;
                        break;
                    }
                    GcDbAccess.this.addObjectToList(clazz, fieldIsIncludedInResults, resultSet, theList);
                }
                return theList;
            }
        });
        this.addQueryToQueriesAndMillis(sqlToRecord, startTime);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static ConnectionBean connection(boolean needsTransaction, boolean startIfNotStarted, String connectionName) {
        Connection connection;
        if (GrouperClientUtils.isBlank(connectionName)) {
            connectionName = GrouperClientUtils.defaultIfBlank(connectionName, GrouperClientConfig.retrieveConfig().propertyValueStringRequired("grouperClient.jdbc.defaultName"));
        }
        ConnectionBean connectionBean = new ConnectionBean();
        Map<String, Connection> connectionMapByName = connectionThreadLocal.get();
        if (connectionMapByName == null) {
            Class<GcDbAccess> clazz = GcDbAccess.class;
            // MONITORENTER : edu.internet2.middleware.grouperClient.jdbc.GcDbAccess.class
            connectionMapByName = connectionThreadLocal.get();
            if (connectionMapByName == null) {
                connectionMapByName = new HashMap<String, Connection>();
                connectionThreadLocal.set(connectionMapByName);
            }
            // MONITOREXIT : clazz
        }
        if ((connection = connectionMapByName.get(connectionName)) == null && !startIfNotStarted) {
            return connectionBean;
        }
        Boolean transaction = transactionThreadLocal.get();
        connectionBean.setInTransaction(needsTransaction || transaction != null);
        if (needsTransaction) {
            if (transaction != null) {
                connectionBean.setTransactionStarted(false);
            } else {
                transactionThreadLocal.set(true);
                connectionBean.setTransactionStarted(true);
            }
        }
        if (connection != null) {
            connectionBean.setConnectionStarted(false);
            connectionBean.setConnection(connection);
            try {
                if (!connectionBean.isTransactionStarted()) return connectionBean;
                connection.setAutoCommit(false);
                return connectionBean;
            }
            catch (SQLException sqle) {
                throw new RuntimeException(sqle);
            }
        }
        if (transaction != null) {
            throw new RuntimeException("How can you have a transaction without a connection???");
        }
        connectionBean.setConnectionStarted(true);
        String url = null;
        try {
            String defaultName = GrouperClientConfig.retrieveConfig().propertyValueStringRequired("grouperClient.jdbc.defaultName");
            String driver = GrouperClientConfig.retrieveConfig().propertyValueStringRequired("grouperClient.jdbc." + defaultName + ".driver");
            Class.forName(driver);
            url = GrouperClientConfig.retrieveConfig().propertyValueStringRequired("grouperClient.jdbc." + defaultName + ".url");
            String user = GrouperClientConfig.retrieveConfig().propertyValueStringRequired("grouperClient.jdbc." + defaultName + ".user");
            String pass = GrouperClientConfig.retrieveConfig().propertyValueStringRequired("grouperClient.jdbc." + defaultName + ".pass");
            connection = DriverManager.getConnection(url, user, pass);
            connectionMapByName.put(connectionName, connection);
            connectionBean.setConnection(connection);
            if (connectionBean.isTransactionStarted()) {
                connection.setAutoCommit(false);
                return connectionBean;
            }
            connection.setAutoCommit(true);
            return connectionBean;
        }
        catch (Exception e) {
            connectionThreadLocal.remove();
            transactionThreadLocal.remove();
            throw new RuntimeException("Error connecting to: " + url, e);
        }
    }

    public <T> T callbackCallableStatement(GcCallableStatementCallback<T> callableStatementCallback) {
        Statement callableStatement = null;
        ConnectionBean connectionBean = null;
        try {
            connectionBean = GcDbAccess.connection(false, true, this.connectionName);
            this.connection = connectionBean.getConnection();
            callableStatement = this.connection.prepareCall(callableStatementCallback.getQuery());
            Long startTime = System.nanoTime();
            T t = callableStatementCallback.callback((CallableStatement)callableStatement);
            this.addQueryToQueriesAndMillis(callableStatementCallback.getQuery(), startTime);
            T t2 = t;
            return t2;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (callableStatement != null) {
                    callableStatement.close();
                }
            }
            catch (Exception e) {}
            ConnectionBean.closeIfStarted(connectionBean);
        }
    }

    public <T> T callbackPreparedStatement(GcPreparedStatementCallback<T> preparedStatementCallback) {
        Statement callableStatement = null;
        ConnectionBean connectionBean = null;
        try {
            connectionBean = GcDbAccess.connection(false, true, this.connectionName);
            this.connection = connectionBean.getConnection();
            callableStatement = this.connection.prepareStatement(preparedStatementCallback.getQuery());
            Long startTime = System.nanoTime();
            T t = preparedStatementCallback.callback((PreparedStatement)callableStatement);
            this.addQueryToQueriesAndMillis(preparedStatementCallback.getQuery(), startTime);
            T t2 = t;
            return t2;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (callableStatement != null) {
                    callableStatement.close();
                }
            }
            catch (Exception e) {}
            ConnectionBean.closeIfStarted(connectionBean);
        }
    }

    public <T> T callbackConnection(GcConnectionCallback<T> connectionCallback) {
        T t;
        ConnectionBean connectionBean = null;
        try {
            connectionBean = GcDbAccess.connection(false, true, this.connectionName);
            this.connection = connectionBean.getConnection();
            Long startTime = System.nanoTime();
            T t2 = connectionCallback.callback(this.connection);
            this.addQueryToQueriesAndMillis("Connection callback, SQL unknown", startTime);
            t = t2;
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                ConnectionBean.closeIfStarted(connectionBean);
                throw throwable;
            }
        }
        ConnectionBean.closeIfStarted(connectionBean);
        return t;
    }

    public <T> T callbackResultSet(GcResultSetCallback<T> resultSetCallback) {
        if (this.sql == null) {
            throw new RuntimeException("You must set sql!");
        }
        Statement preparedStatement = null;
        ConnectionBean connectionBean = null;
        try {
            T t;
            connectionBean = GcDbAccess.connection(false, true, this.connectionName);
            this.connection = connectionBean.getConnection();
            preparedStatement = this.connection.prepareStatement(this.sql);
            String sqltoRecord = this.sql;
            if (this.queryTimeoutSeconds != null) {
                preparedStatement.setQueryTimeout(this.queryTimeoutSeconds);
            }
            if (this.bindVars != null) {
                int i = 1;
                for (Object bindVar : this.bindVars) {
                    boundDataConversion.addBindVariableToStatement((PreparedStatement)preparedStatement, bindVar, i);
                    ++i;
                }
            }
            if (this.batchBindVars != null) {
                for (List<Object> theBindVars : this.batchBindVars) {
                    int i = 1;
                    for (Object bindVar : theBindVars) {
                        boundDataConversion.addBindVariableToStatement((PreparedStatement)preparedStatement, bindVar, i);
                        ++i;
                    }
                    preparedStatement.addBatch();
                }
            }
            if (resultSetCallback == null) {
                if (this.batchBindVars != null) {
                    Long startTime = System.nanoTime();
                    this.numberOfBatchRowsAffected = preparedStatement.executeBatch();
                    this.addQueryToQueriesAndMillis(sqltoRecord, startTime);
                    t = null;
                    return t;
                }
                Long startTime = System.nanoTime();
                this.numberOfRowsAffected = preparedStatement.executeUpdate();
                this.addQueryToQueriesAndMillis(sqltoRecord, startTime);
                t = null;
                return t;
            }
            ResultSet rs = preparedStatement.executeQuery();
            t = resultSetCallback.callback(rs);
            return t;
        }
        catch (Exception e) {
            GrouperClientUtils.injectInException(e, "sql: " + this.sql);
            throw new RuntimeException(e);
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            ConnectionBean.closeIfStarted(connectionBean);
        }
    }

    public int executeSql() {
        if (this.batchBindVars != null) {
            throw new RuntimeException("Use executeBatchSql() with batchBindVars!");
        }
        this.callbackResultSet(null);
        return this.numberOfRowsAffected;
    }

    public int[] executeBatchSql() {
        if (this.bindVars != null) {
            throw new RuntimeException("Use batchBindVars with executeBatchSql(), not bindVars!");
        }
        this.callbackResultSet(null);
        return this.numberOfBatchRowsAffected;
    }

    private <T> T addObjectToList(Class<T> clazz, Map<String, Boolean> fieldIsIncludedInResults, ResultSet resultSet, List<T> theList) throws Exception {
        if (GcPersistableHelper.hasPersistableAnnotation(clazz)) {
            T t = clazz.newInstance();
            for (Field field : GcPersistableHelper.heirarchicalFields(clazz)) {
                if (!GcPersistableHelper.isSelect(field, clazz)) continue;
                String columnName = GcPersistableHelper.columnName(field);
                Boolean columnInQueryResults = fieldIsIncludedInResults.get(columnName);
                if (columnInQueryResults == null) {
                    try {
                        resultSet.findColumn(columnName);
                        fieldIsIncludedInResults.put(columnName, new Boolean(true));
                        columnInQueryResults = new Boolean(true);
                    }
                    catch (SQLException e) {
                        fieldIsIncludedInResults.put(columnName, new Boolean(false));
                        columnInQueryResults = new Boolean(false);
                    }
                }
                if (!columnInQueryResults.booleanValue()) continue;
                Object value = resultSet.getObject(columnName);
                boundDataConversion.setFieldValue(t, field, value);
            }
            if (theList != null) {
                theList.add(t);
            }
            return t;
        }
        if (clazz.isAssignableFrom(Map.class)) {
            int columnCount = resultSet.getMetaData().getColumnCount();
            LinkedHashMap<String, Object> results = new LinkedHashMap<String, Object>();
            for (int columnNumber = 1; columnNumber <= columnCount; ++columnNumber) {
                results.put(resultSet.getMetaData().getColumnName(columnNumber), resultSet.getObject(columnNumber));
            }
            LinkedHashMap<String, Object> t = results;
            if (theList != null) {
                theList.add(t);
            }
            return (T)t;
        }
        T t = boundDataConversion.getFieldValue(clazz, resultSet.getObject(1));
        if (theList != null) {
            theList.add(t);
        }
        return t;
    }

    public static Map<MultiKey, GcDbQueryCache> getGcDbQueryCacheMap() {
        return dbQueryCacheMap;
    }

    public static Map<String, GcQueryReport> getQueriesAndMillis() {
        return queriesAndMillis;
    }

    private Object selectFromQueryCache(boolean isList, Class<?> clazz) {
        if (this.cacheMinutes == null) {
            return null;
        }
        MultiKey queryKey = this.queryCacheKey(isList, clazz);
        GcDbQueryCache dbQueryCache = dbQueryCacheMap.get(queryKey);
        if (dbQueryCache == null) {
            return null;
        }
        return dbQueryCache.getThingBeingCached();
    }

    private void populateQueryCache(Class<?> clazz, Object thingBeingCached, boolean isList) {
        if (this.cacheMinutes == null) {
            return;
        }
        MultiKey queryKey = this.queryCacheKey(isList, clazz);
        dbQueryCacheMap.put(queryKey, new GcDbQueryCache(this.cacheMinutes, thingBeingCached));
    }

    private MultiKey queryCacheKey(boolean isList, Class<?> clazz) {
        ArrayList<Object> key = new ArrayList<Object>();
        key.add(this.sql);
        key.add(clazz.getName());
        key.add(isList);
        if (this.bindVars != null && this.bindVars.size() > 0) {
            for (Object object : this.bindVars) {
                key.add(object);
            }
        }
        if (this.batchBindVars != null && this.batchBindVars.size() > 0) {
            for (List list : this.batchBindVars) {
                for (Object bindVar : list) {
                    key.add(bindVar);
                }
            }
        }
        if (this.primaryKeys != null) {
            for (Object object : this.primaryKeys) {
                key.add(object);
            }
        }
        return new MultiKey(key.toArray());
    }

    private GcDbAccess cloneDbAccess() {
        GcDbAccess dbAccess = new GcDbAccess();
        for (Field field : GcDbAccess.class.getDeclaredFields()) {
            try {
                field.setAccessible(true);
                field.set(dbAccess, field.get(this));
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot clone value of field " + field.getName());
            }
        }
        return dbAccess;
    }

    static {
        boundDataConversion = new GcBoundDataConversionImpl();
        dbConnectionClassesRegistered = false;
        connectionThreadLocal = new ThreadLocal();
        transactionThreadLocal = new ThreadLocal();
    }

    public static class ConnectionBean {
        private boolean inTransaction;
        private Connection connection;
        private boolean transactionStarted;
        private boolean connectionStarted;

        public boolean isInTransaction() {
            return this.inTransaction;
        }

        public void setInTransaction(boolean inTransaction1) {
            this.inTransaction = inTransaction1;
        }

        public Connection getConnection() {
            return this.connection;
        }

        public void setConnection(Connection connection1) {
            this.connection = connection1;
        }

        public boolean isTransactionStarted() {
            return this.transactionStarted;
        }

        public void setTransactionStarted(boolean transactionStarted1) {
            this.transactionStarted = transactionStarted1;
        }

        public boolean isConnectionStarted() {
            return this.connectionStarted;
        }

        public void setConnectionStarted(boolean connectionStarted1) {
            this.connectionStarted = connectionStarted1;
        }

        public static void transactionEnd(ConnectionBean connectionBean, GcTransactionEnd transactionEnd, boolean endOnlyIfStarted, boolean errorIfNoTransaction, boolean endTransaction) {
            if (connectionBean == null) {
                return;
            }
            if (!connectionBean.isInTransaction()) {
                if (errorIfNoTransaction) {
                    throw new RuntimeException("Cannot end a transaction when not in a transaction!");
                }
                return;
            }
            if (endOnlyIfStarted && !connectionBean.isTransactionStarted()) {
                return;
            }
            if (endTransaction) {
                transactionThreadLocal.remove();
            }
            try {
                switch (transactionEnd) {
                    case commit: {
                        connectionBean.connection.commit();
                        break;
                    }
                    case rollback: {
                        connectionBean.connection.rollback();
                        break;
                    }
                    default: {
                        throw new RuntimeException("Not expecting: " + (Object)((Object)transactionEnd));
                    }
                }
            }
            catch (SQLException sqle) {
                throw new RuntimeException("Error: " + (Object)((Object)transactionEnd) + ", " + endOnlyIfStarted);
            }
            if (endTransaction) {
                try {
                    connectionBean.connection.setAutoCommit(true);
                }
                catch (SQLException sqle) {
                    throw new RuntimeException(sqle);
                }
            }
        }

        public static void closeIfStarted(ConnectionBean connectionBean) {
            ConnectionBean.transactionEnd(connectionBean, GcTransactionEnd.rollback, true, false, true);
            if (connectionBean != null && connectionBean.isConnectionStarted()) {
                connectionThreadLocal.remove();
                GrouperClientUtils.closeQuietly(connectionBean.getConnection());
            }
        }
    }
}

