/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClient.api;

import edu.internet2.middleware.grouperClient.util.GrouperClientUtils;
import edu.internet2.middleware.grouperClient.ws.GrouperClientWs;
import edu.internet2.middleware.grouperClient.ws.beans.WsMessageAcknowledgeResults;
import edu.internet2.middleware.grouperClient.ws.beans.WsParam;
import edu.internet2.middleware.grouperClient.ws.beans.WsRestAcknowledgeMessageRequest;
import edu.internet2.middleware.grouperClient.ws.beans.WsSubjectLookup;
import java.util.ArrayList;
import java.util.List;

public class GcMessageAcknowledge {
    private String queueOrTopicName;
    private String messageSystemName;
    private String acknowledgeType;
    private List<String> messageIds = new ArrayList<String>();
    private String anotherQueueOrTopicName;
    private String anotherQueueOrTopic;
    private List<WsParam> params = new ArrayList<WsParam>();
    private WsSubjectLookup actAsSubject;
    private String clientVersion;

    public GcMessageAcknowledge assignAcknowledgeType(String theAcknowledgeType) {
        this.acknowledgeType = theAcknowledgeType;
        return this;
    }

    public GcMessageAcknowledge assignAnotherQueueOrTopicName(String theAnotherQueueOrTopicName) {
        this.anotherQueueOrTopicName = theAnotherQueueOrTopicName;
        return this;
    }

    public GcMessageAcknowledge assignAnotherQueueOrTopic(String theAnotherQueueOrTopic) {
        this.anotherQueueOrTopic = theAnotherQueueOrTopic;
        return this;
    }

    public GcMessageAcknowledge addMessageId(String messageId) {
        this.messageIds.add(messageId);
        return this;
    }

    public GcMessageAcknowledge assignQueueOrTopicName(String theQueueOrTopicName) {
        this.queueOrTopicName = theQueueOrTopicName;
        return this;
    }

    public GcMessageAcknowledge assignMessageSystemName(String theMessageSystemName) {
        this.messageSystemName = theMessageSystemName;
        return this;
    }

    public GcMessageAcknowledge addParam(String paramName, String paramValue) {
        this.params.add(new WsParam(paramName, paramValue));
        return this;
    }

    public GcMessageAcknowledge addParam(WsParam wsParam) {
        this.params.add(wsParam);
        return this;
    }

    public GcMessageAcknowledge assignActAsSubject(WsSubjectLookup theActAsSubject) {
        this.actAsSubject = theActAsSubject;
        return this;
    }

    private void validate() {
        if (GrouperClientUtils.isBlank(this.queueOrTopicName)) {
            throw new RuntimeException("Need queue or topic name where the message(s) needs to be received from " + this);
        }
        if (GrouperClientUtils.length(this.messageIds) == 0) {
            throw new RuntimeException("Need at least one message: " + this);
        }
    }

    public GcMessageAcknowledge assignClientVersion(String theClientVersion) {
        this.clientVersion = theClientVersion;
        return this;
    }

    public WsMessageAcknowledgeResults execute() {
        this.validate();
        WsMessageAcknowledgeResults wsAcknowlesgeMessageResults = null;
        try {
            WsRestAcknowledgeMessageRequest messageAcknowledgeRequest = new WsRestAcknowledgeMessageRequest();
            messageAcknowledgeRequest.setActAsSubjectLookup(this.actAsSubject);
            messageAcknowledgeRequest.setQueueOrTopicName(this.queueOrTopicName);
            messageAcknowledgeRequest.setMessageSystemName(this.messageSystemName);
            messageAcknowledgeRequest.setMessageIds(GrouperClientUtils.toArray(this.messageIds, String.class));
            messageAcknowledgeRequest.setAcknowledgeType(this.acknowledgeType);
            messageAcknowledgeRequest.setAnotherQueueOrTopic(this.anotherQueueOrTopic);
            messageAcknowledgeRequest.setAnotherQueueOrTopicName(this.anotherQueueOrTopicName);
            if (this.params.size() > 0) {
                messageAcknowledgeRequest.setParams(GrouperClientUtils.toArray(this.params, WsParam.class));
            }
            GrouperClientWs grouperClientWs = new GrouperClientWs();
            wsAcknowlesgeMessageResults = (WsMessageAcknowledgeResults)grouperClientWs.executeService("messaging", messageAcknowledgeRequest, "acknowledge messages", this.clientVersion, false);
            String resultMessage = wsAcknowlesgeMessageResults.getResultMetadata().getResultMessage();
            grouperClientWs.handleFailure(wsAcknowlesgeMessageResults, null, resultMessage);
        }
        catch (Exception e) {
            GrouperClientUtils.convertToRuntimeException(e);
        }
        return wsAcknowlesgeMessageResults;
    }
}

