/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClient.api;

import edu.internet2.middleware.grouperClient.failover.FailoverClient;
import edu.internet2.middleware.grouperClient.failover.FailoverLogic;
import edu.internet2.middleware.grouperClient.failover.FailoverLogicBean;
import edu.internet2.middleware.grouperClient.util.GrouperClientLdapUtils;
import edu.internet2.middleware.grouperClient.util.GrouperClientUtils;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.logging.Log;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;

public class GcLdapSearchAttribute {
    private String ldapName;
    private Set<String> returningAttributes = new LinkedHashSet<String>();
    private Map<String, String> matchingAttributes = new LinkedHashMap<String, String>();
    private NamingEnumeration<?> namingEnumeration = null;
    private static Log LOG = GrouperClientUtils.retrieveLog(GcLdapSearchAttribute.class);

    public void copyFrom(GcLdapSearchAttribute gcLdapSearchAttribute) {
        this.ldapName = gcLdapSearchAttribute.ldapName;
        this.matchingAttributes = gcLdapSearchAttribute.matchingAttributes;
        this.namingEnumeration = gcLdapSearchAttribute.namingEnumeration;
        this.returningAttributes = gcLdapSearchAttribute.returningAttributes;
    }

    public String retrieveResultAttributeString() {
        if (this.returningAttributes.size() != 1) {
            throw new RuntimeException("Should be looking for 1 attribute, but was looking for " + this.returningAttributes.size() + ", " + GrouperClientUtils.toStringForLog(this.returningAttributes));
        }
        try {
            String ldapAttribute = this.returningAttributes.iterator().next();
            if (LOG.isDebugEnabled()) {
                LOG.debug("method: GcLdapSearchAttribute.retrieveAttributeString, LDAP looking for attribute: '" + ldapAttribute + "'");
            }
            return GrouperClientLdapUtils.retrieveAttributeStringValue(this.namingEnumeration, ldapAttribute);
        }
        catch (NamingException ne) {
            throw new RuntimeException("Problem returning one attribute string: " + this.toString(), ne);
        }
    }

    public boolean retrieveResultAttributeStringMatch(String valueToMatch) {
        String attributeValue = this.retrieveResultAttributeString();
        return GrouperClientUtils.equals(valueToMatch, attributeValue);
    }

    public List<String> retrieveResultAttributeStringList() {
        if (this.returningAttributes.size() != 1) {
            throw new RuntimeException("Should be looking for 1 attribute, but was looking for " + this.returningAttributes.size() + ", " + GrouperClientUtils.toStringForLog(this.returningAttributes));
        }
        try {
            return GrouperClientLdapUtils.retrieveAttributeStringListValue(this.namingEnumeration, this.returningAttributes.iterator().next());
        }
        catch (NamingException ne) {
            throw new RuntimeException("Problem returning one attribute list: " + this.toString(), ne);
        }
    }

    public String getMatchingAttribute(String matchingAttributeName) {
        return this.matchingAttributes.get(matchingAttributeName);
    }

    public GcLdapSearchAttribute addMatchingAttribute(String attributeName, String attributeValue) {
        this.matchingAttributes.put(attributeName, attributeValue);
        return this;
    }

    public GcLdapSearchAttribute addReturningAttribute(String returningAttribute) {
        this.returningAttributes.add(returningAttribute);
        return this;
    }

    public void validate() {
        if (this.returningAttributes.isEmpty()) {
            throw new RuntimeException("Returning attributes are empty!");
        }
        if (this.matchingAttributes.isEmpty()) {
            throw new RuntimeException("Matching attributes are empty!");
        }
        if (GrouperClientUtils.isBlank(this.ldapName)) {
            throw new RuntimeException("Name is blank!");
        }
    }

    public void execute() {
        GrouperClientLdapUtils.configureFailoverClient();
        GcLdapSearchAttribute gcLdapSearchAttribute = FailoverClient.failoverLogic("grouperLdap", new FailoverLogic<GcLdapSearchAttribute>(){

            @Override
            public GcLdapSearchAttribute logic(FailoverLogicBean failoverLogicBean) {
                return GcLdapSearchAttribute.executeHelper(GcLdapSearchAttribute.this, failoverLogicBean.getConnectionName());
            }
        });
        if (gcLdapSearchAttribute != null) {
            this.copyFrom(gcLdapSearchAttribute);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GcLdapSearchAttribute executeHelper(GcLdapSearchAttribute input, String url) {
        GcLdapSearchAttribute gcLdapSearchAttribute = new GcLdapSearchAttribute();
        gcLdapSearchAttribute.copyFrom(input);
        gcLdapSearchAttribute.validate();
        DirContext context = GrouperClientLdapUtils.retrieveContext(url);
        try {
            String[] returningAttributesArray;
            LOG.debug("LDAP search name: '" + gcLdapSearchAttribute.ldapName + "'");
            BasicAttributes searchAttributes = new BasicAttributes();
            for (String key : gcLdapSearchAttribute.matchingAttributes.keySet()) {
                String value = gcLdapSearchAttribute.matchingAttributes.get(key);
                searchAttributes.put(new BasicAttribute(key, value));
                LOG.debug("LDAP search attribute: '" + key + "' = '" + value + "'");
            }
            for (String returningAttribute : returningAttributesArray = GrouperClientUtils.toArray(gcLdapSearchAttribute.returningAttributes, String.class)) {
                LOG.debug("LDAP search returning attribute: '" + returningAttribute + "'");
            }
            try {
                gcLdapSearchAttribute.namingEnumeration = context.search(gcLdapSearchAttribute.ldapName, (Attributes)searchAttributes, returningAttributesArray);
            }
            catch (Exception e) {
                throw new RuntimeException("Error querying ldap for name: '" + gcLdapSearchAttribute.ldapName + "', searchAttributes: " + GrouperClientUtils.toStringForLog(gcLdapSearchAttribute.matchingAttributes) + ", returning attributes: " + GrouperClientUtils.toStringForLog(gcLdapSearchAttribute.returningAttributes), e);
            }
        }
        finally {
            try {
                context.close();
            }
            catch (Exception e) {}
        }
        return gcLdapSearchAttribute;
    }

    public String toString() {
        return this.ldapName + "', searchAttributes: " + GrouperClientUtils.toStringForLog(this.matchingAttributes) + ", returning attributes: " + GrouperClientUtils.toStringForLog(this.returningAttributes);
    }

    public GcLdapSearchAttribute assignLdapName(String theName) {
        this.ldapName = theName;
        return this;
    }
}

