/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClient.api;

import edu.internet2.middleware.grouperClient.util.GrouperClientUtils;
import edu.internet2.middleware.grouperClient.ws.GrouperClientWs;
import edu.internet2.middleware.grouperClient.ws.WsMemberFilter;
import edu.internet2.middleware.grouperClient.ws.beans.WsAttributeDefLookup;
import edu.internet2.middleware.grouperClient.ws.beans.WsAttributeDefNameLookup;
import edu.internet2.middleware.grouperClient.ws.beans.WsGetMembershipsResults;
import edu.internet2.middleware.grouperClient.ws.beans.WsGroupLookup;
import edu.internet2.middleware.grouperClient.ws.beans.WsParam;
import edu.internet2.middleware.grouperClient.ws.beans.WsRestGetMembershipsRequest;
import edu.internet2.middleware.grouperClient.ws.beans.WsStemLookup;
import edu.internet2.middleware.grouperClient.ws.beans.WsSubjectLookup;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class GcGetMemberships {
    private String enabled;
    private Set<WsSubjectLookup> wsSubjectLookups = new LinkedHashSet<WsSubjectLookup>();
    private String stemScope = null;
    private WsStemLookup wsStemLookup = null;
    private String clientVersion;
    private Set<String> groupNames = new LinkedHashSet<String>();
    private Set<String> groupUuids = new LinkedHashSet<String>();
    private Set<String> ownerNamesOfAttributeDefs = new LinkedHashSet<String>();
    private Set<String> ownerUuidsOfAttributeDefs = new LinkedHashSet<String>();
    private Set<String> ownerStemNames = new LinkedHashSet<String>();
    private Set<String> ownerStemUuids = new LinkedHashSet<String>();
    private Set<Long> groupIdIndexes = new LinkedHashSet<Long>();
    private List<WsParam> params = new ArrayList<WsParam>();
    private WsMemberFilter memberFilter;
    private WsSubjectLookup actAsSubject;
    private String fieldName;
    private String fieldType;
    private String scope;
    private String serviceRole;
    private WsAttributeDefNameLookup serviceLookup;
    private Boolean includeGroupDetail;
    private Boolean includeSubjectDetail;
    private Set<String> subjectAttributeNames = new LinkedHashSet<String>();
    private Set<String> sourceIds = null;
    private Set<String> membershipIds = null;

    public GcGetMemberships assignClientVersion(String theClientVersion) {
        this.clientVersion = theClientVersion;
        return this;
    }

    public GcGetMemberships assignWsStem(WsStemLookup theWsStemLookup) {
        this.wsStemLookup = theWsStemLookup;
        return this;
    }

    public GcGetMemberships addGroupName(String theGroupName) {
        this.groupNames.add(theGroupName);
        return this;
    }

    public GcGetMemberships addGroupIdIndex(Long theGroupIdIndex) {
        this.groupIdIndexes.add(theGroupIdIndex);
        return this;
    }

    public GcGetMemberships addOwnerStemName(String theOwnerStemName) {
        this.ownerStemNames.add(theOwnerStemName);
        return this;
    }

    public GcGetMemberships addOwnerStemUuid(String theOwnerStemUuid) {
        this.ownerStemUuids.add(theOwnerStemUuid);
        return this;
    }

    public GcGetMemberships addOwnerNameOfAttributeDef(String theOwnerNameOfAttributeDef) {
        this.ownerNamesOfAttributeDefs.add(theOwnerNameOfAttributeDef);
        return this;
    }

    public GcGetMemberships addOwnerUuidOfAttributeDef(String theOwnerUuidOfAttributeDef) {
        this.ownerUuidsOfAttributeDefs.add(theOwnerUuidOfAttributeDef);
        return this;
    }

    public GcGetMemberships addWsSubjectLookup(WsSubjectLookup wsSubjectLookup) {
        this.wsSubjectLookups.add(wsSubjectLookup);
        return this;
    }

    public GcGetMemberships addGroupUuid(String theGroupUuid) {
        this.groupUuids.add(theGroupUuid);
        return this;
    }

    public GcGetMemberships addParam(String paramName, String paramValue) {
        this.params.add(new WsParam(paramName, paramValue));
        return this;
    }

    public GcGetMemberships addParam(WsParam wsParam) {
        this.params.add(wsParam);
        return this;
    }

    public GcGetMemberships assignMemberFilter(WsMemberFilter theMemberFilter) {
        this.memberFilter = theMemberFilter;
        return this;
    }

    public GcGetMemberships assignActAsSubject(WsSubjectLookup theActAsSubject) {
        this.actAsSubject = theActAsSubject;
        return this;
    }

    private void validate() {
        if (GrouperClientUtils.length(this.groupNames) == 0 && GrouperClientUtils.length(this.groupUuids) == 0 && GrouperClientUtils.length(this.ownerStemNames) == 0 && GrouperClientUtils.length(this.ownerStemUuids) == 0 && GrouperClientUtils.length(this.ownerNamesOfAttributeDefs) == 0 && GrouperClientUtils.length(this.ownerUuidsOfAttributeDefs) == 0 && GrouperClientUtils.length(this.groupIdIndexes) == 0 && GrouperClientUtils.length(this.membershipIds) == 0 && GrouperClientUtils.length(this.wsSubjectLookups) == 0 && GrouperClientUtils.isBlank(this.serviceRole) && this.wsStemLookup == null) {
            throw new RuntimeException("Group name or uuid or id index or subject lookup or membership id or owner stem uuid or name or owner uuid or name of attribute def or serviceRole or stem lookup is required: " + this);
        }
        if (GrouperClientUtils.isBlank(this.serviceRole) != (this.serviceLookup == null || GrouperClientUtils.isBlank(this.serviceLookup.getIdIndex()) && GrouperClientUtils.isBlank(this.serviceLookup.getName()) && GrouperClientUtils.isBlank(this.serviceLookup.getUuid()))) {
            throw new RuntimeException("If serviceRole is passed in, then a serviceId or serviceName needs to be passed in");
        }
    }

    public GcGetMemberships assignFieldType(String fieldType1) {
        this.fieldType = fieldType1;
        return this;
    }

    public GcGetMemberships assignServiceLookup(WsAttributeDefNameLookup serviceLookup1) {
        this.serviceLookup = serviceLookup1;
        return this;
    }

    public GcGetMemberships assignServiceRole(String serviceRole1) {
        this.serviceRole = serviceRole1;
        return this;
    }

    public GcGetMemberships assignFieldName(String theFieldName) {
        this.fieldName = theFieldName;
        return this;
    }

    public GcGetMemberships assignScope(String theScope) {
        this.scope = theScope;
        return this;
    }

    public GcGetMemberships addSourceId(String sourceId) {
        if (this.sourceIds == null) {
            this.sourceIds = new LinkedHashSet<String>();
        }
        this.sourceIds.add(sourceId);
        return this;
    }

    public GcGetMemberships addMembershipId(String sourceId) {
        if (this.membershipIds == null) {
            this.membershipIds = new LinkedHashSet<String>();
        }
        this.membershipIds.add(sourceId);
        return this;
    }

    public GcGetMemberships addSubjectAttributeName(String subjectAttributeName) {
        this.subjectAttributeNames.add(subjectAttributeName);
        return this;
    }

    public GcGetMemberships assignIncludeGroupDetail(Boolean theIncludeGroupDetail) {
        this.includeGroupDetail = theIncludeGroupDetail;
        return this;
    }

    public GcGetMemberships assignIncludeSubjectDetail(Boolean theIncludeSubjectDetail) {
        this.includeSubjectDetail = theIncludeSubjectDetail;
        return this;
    }

    public WsGetMembershipsResults execute() {
        this.validate();
        WsGetMembershipsResults wsGetMembershipsResults = null;
        try {
            WsRestGetMembershipsRequest getMemberships = new WsRestGetMembershipsRequest();
            getMemberships.setActAsSubjectLookup(this.actAsSubject);
            getMemberships.setEnabled(this.enabled);
            getMemberships.setFieldName(this.fieldName);
            getMemberships.setFieldType(this.fieldType);
            ArrayList<WsGroupLookup> groupLookups = new ArrayList<WsGroupLookup>();
            for (String groupName : this.groupNames) {
                groupLookups.add(new WsGroupLookup(groupName, null));
            }
            for (String groupUuid : this.groupUuids) {
                groupLookups.add(new WsGroupLookup(null, groupUuid));
            }
            for (Long groupIdIndex : this.groupIdIndexes) {
                groupLookups.add(new WsGroupLookup(null, null, groupIdIndex.toString()));
            }
            if (GrouperClientUtils.length(groupLookups) > 0) {
                getMemberships.setWsGroupLookups(GrouperClientUtils.toArray(groupLookups, WsGroupLookup.class));
            }
            ArrayList<WsStemLookup> ownerStemLookups = new ArrayList<WsStemLookup>();
            for (String ownerStemName : this.ownerStemNames) {
                ownerStemLookups.add(new WsStemLookup(ownerStemName, null));
            }
            for (String ownerStemUuid : this.ownerStemUuids) {
                ownerStemLookups.add(new WsStemLookup(null, ownerStemUuid));
            }
            if (GrouperClientUtils.length(ownerStemLookups) > 0) {
                getMemberships.setWsOwnerStemLookups(GrouperClientUtils.toArray(ownerStemLookups, WsStemLookup.class));
            }
            ArrayList<WsAttributeDefLookup> ownerAttributeDefLookups = new ArrayList<WsAttributeDefLookup>();
            for (String ownerNameOfAttributeDef : this.ownerNamesOfAttributeDefs) {
                ownerAttributeDefLookups.add(new WsAttributeDefLookup(ownerNameOfAttributeDef, null));
            }
            for (String ownerUuidOfAttributeDef : this.ownerUuidsOfAttributeDefs) {
                ownerAttributeDefLookups.add(new WsAttributeDefLookup(null, ownerUuidOfAttributeDef));
            }
            if (GrouperClientUtils.length(ownerAttributeDefLookups) > 0) {
                getMemberships.setWsOwnerAttributeDefLookups(GrouperClientUtils.toArray(ownerAttributeDefLookups, WsAttributeDefLookup.class));
            }
            if (this.includeGroupDetail != null) {
                getMemberships.setIncludeGroupDetail(this.includeGroupDetail != false ? "T" : "F");
            }
            if (this.includeSubjectDetail != null) {
                getMemberships.setIncludeSubjectDetail(this.includeSubjectDetail != false ? "T" : "F");
            }
            if (this.serviceLookup != null) {
                getMemberships.setServiceLookup(this.serviceLookup);
            }
            if (this.serviceRole != null) {
                getMemberships.setServiceRole(this.serviceRole);
            }
            getMemberships.setMemberFilter(this.memberFilter == null ? null : this.memberFilter.name());
            if (GrouperClientUtils.length(this.membershipIds) > 0) {
                getMemberships.setMembershipIds(GrouperClientUtils.toArray(this.membershipIds, String.class));
            }
            if (this.params.size() > 0) {
                getMemberships.setParams(GrouperClientUtils.toArray(this.params, WsParam.class));
            }
            getMemberships.setScope(this.scope);
            if (GrouperClientUtils.length(this.sourceIds) > 0) {
                getMemberships.setSourceIds(GrouperClientUtils.toArray(this.sourceIds, String.class));
            }
            getMemberships.setStemScope(this.stemScope);
            if (this.subjectAttributeNames.size() > 0) {
                getMemberships.setSubjectAttributeNames(GrouperClientUtils.toArray(this.subjectAttributeNames, String.class));
            }
            getMemberships.setWsStemLookup(this.wsStemLookup);
            if (GrouperClientUtils.length(this.wsSubjectLookups) > 0) {
                getMemberships.setWsSubjectLookups(GrouperClientUtils.toArray(this.wsSubjectLookups, WsSubjectLookup.class));
            }
            GrouperClientWs grouperClientWs = new GrouperClientWs();
            wsGetMembershipsResults = (WsGetMembershipsResults)grouperClientWs.executeService("memberships", getMemberships, "getMemberships", this.clientVersion, true);
            String resultMessage = wsGetMembershipsResults.getResultMetadata().getResultMessage();
            grouperClientWs.handleFailure(wsGetMembershipsResults, null, resultMessage);
        }
        catch (Exception e) {
            GrouperClientUtils.convertToRuntimeException(e);
        }
        return wsGetMembershipsResults;
    }

    @Deprecated
    public GcGetMemberships assigStemScope(String theStemScope) {
        return this.assignStemScope(theStemScope);
    }

    public GcGetMemberships assignStemScope(String theStemScope) {
        this.stemScope = theStemScope;
        return this;
    }

    public GcGetMemberships assignEnabled(String theEnabled) {
        this.enabled = theEnabled;
        return this;
    }
}

