/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.nondex.shuffling;

import edu.illinois.nondex.common.Configuration;
import edu.illinois.nondex.common.Logger;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.logging.Level;

public class ControlNondeterminism {
    private static int count = 0;
    private static int shuffleCount = 0;
    private static final Logger logger = Logger.getGlobal();
    private static Random r;
    private static JVMShutdownHook jvmShutdownHook;
    private static Configuration config;
    private static boolean shouldOutputTrace;

    public static Configuration getConfiguration() {
        return config;
    }

    private static Random getRandomnessSource(String source) {
        logger.log(Level.FINEST, "getRandomnessSource for API: " + source);
        if (!ControlNondeterminism.config.filter.matcher(source).matches()) {
            logger.log(Level.FINE, "Source does not apply " + source + "");
            return null;
        }
        switch (ControlNondeterminism.config.mode) {
            case FULL: {
                return r;
            }
            case ONE: {
                return new Random(ControlNondeterminism.config.seed);
            }
        }
        logger.log(Level.WARNING, "Unrecognized option for shuffle kind. Not shuffling.");
        return null;
    }

    public static <T> List<T> shuffle(List<T> originalOrder) {
        return ControlNondeterminism.internalShuffle(originalOrder, ControlNondeterminism.getSource());
    }

    public static <T> T[] shuffle(T[] originalOrder) {
        if (originalOrder == null) {
            return null;
        }
        List<T> newOrder = Arrays.asList(originalOrder);
        newOrder = ControlNondeterminism.internalShuffle(newOrder, ControlNondeterminism.getSource());
        newOrder.toArray(originalOrder);
        return originalOrder;
    }

    public static String[][] extendZoneStrings(String[][] originalArrays) {
        logger.log(Level.FINEST, "extendZoneStrings");
        if (!shouldOutputTrace) {
            return originalArrays;
        }
        Random currentRandom = ControlNondeterminism.getRandomnessSource(ControlNondeterminism.getSource());
        if (currentRandom == null) {
            return originalArrays;
        }
        boolean shouldFlip = currentRandom.nextBoolean();
        if (ControlNondeterminism.shouldExploreForInstance()) {
            ControlNondeterminism.printStackTraceIfUniqueDebugPoint();
            ++shuffleCount;
            if (shouldFlip) {
                for (int i = 0; i < originalArrays.length; ++i) {
                    originalArrays[i] = Arrays.copyOf(originalArrays[i], originalArrays[i].length + 1);
                }
            }
        }
        ++count;
        return originalArrays;
    }

    private static <T> List<T> internalShuffle(List<T> originalOrder, String source) {
        if (!shouldOutputTrace) {
            return originalOrder;
        }
        if (originalOrder.size() <= 1) {
            return originalOrder;
        }
        Random currentRandom = ControlNondeterminism.getRandomnessSource(source);
        if (currentRandom == null) {
            return originalOrder;
        }
        ArrayList<T> newOrder = new ArrayList<T>(originalOrder);
        Collections.shuffle(newOrder, currentRandom);
        if (ControlNondeterminism.shouldExploreForInstance()) {
            ControlNondeterminism.printStackTraceIfUniqueDebugPoint();
            ++count;
            ++shuffleCount;
            return newOrder;
        }
        ++count;
        return originalOrder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printStackTraceIfUniqueDebugPoint() {
        if (ControlNondeterminism.config.shouldPrintStackTrace && ControlNondeterminism.isDebuggingUniquePoint()) {
            StackTraceElement[] traces = Thread.currentThread().getStackTrace();
            StringBuilder stackstring = new StringBuilder();
            for (StackTraceElement traceElement : traces) {
                stackstring.append(traceElement.toString() + "\n");
            }
            try {
                shouldOutputTrace = false;
                Files.write(config.getDebugPath(), ("TEST: " + ControlNondeterminism.config.testName + "\n" + stackstring.toString()).getBytes(), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
            }
            catch (IOException ioe) {
                Logger.getGlobal().log(Level.SEVERE, "Exception when printing debug info.", ioe);
            }
            finally {
                shouldOutputTrace = true;
            }
        }
    }

    private static boolean isDebuggingUniquePoint() {
        return ControlNondeterminism.config.start >= 0L && ControlNondeterminism.config.end >= 0L && ControlNondeterminism.config.start == ControlNondeterminism.config.end && (long)count == ControlNondeterminism.config.start;
    }

    private static boolean shouldExploreForInstance() {
        return (long)count >= ControlNondeterminism.config.start && (long)count <= ControlNondeterminism.config.end;
    }

    private static String getSource() {
        return Thread.currentThread().getStackTrace()[3].toString();
    }

    static {
        jvmShutdownHook = new JVMShutdownHook();
        config = Configuration.parseArgs();
        shouldOutputTrace = true;
        Runtime.getRuntime().addShutdownHook(jvmShutdownHook);
        r = new Random(ControlNondeterminism.config.seed);
    }

    private static class JVMShutdownHook
    extends Thread {
        private JVMShutdownHook() {
        }

        @Override
        public void run() {
            config.createNondexDirIfNeeded();
            try {
                int localCount = count;
                int localShufflesCount = shuffleCount;
                Files.write(config.getConfigPath(), config.toString().getBytes(), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
                Files.write(config.getInvocationsPath(), ("COUNT:" + localCount + "\n").getBytes(), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
                Files.write(config.getInvocationsPath(), ("SHUFFLES:" + localShufflesCount + "\n").getBytes(), StandardOpenOption.APPEND);
            }
            catch (IOException ioe) {
                Logger.getGlobal().log(Level.SEVERE, "Exception when printing shuflling counts in shutdown hook.", ioe);
            }
        }
    }
}

