/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.nondex.common;

import edu.illinois.nondex.common.Logger;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Properties;
import java.util.logging.Level;
import javax.xml.bind.DatatypeConverter;

public class Utils {
    public static Throwable linkException(Throwable nestedThrowable, Throwable pastSupressedException) {
        if (pastSupressedException == null) {
            return nestedThrowable;
        }
        if (nestedThrowable == null) {
            return pastSupressedException;
        }
        pastSupressedException.addSuppressed(nestedThrowable);
        return pastSupressedException;
    }

    public static Properties openPropertiesFrom(Path path) {
        Properties props = new Properties();
        try {
            props.load(new FileInputStream(path.toFile()));
        }
        catch (IOException ioe) {
            Logger.getGlobal().log(Level.CONFIG, "Cannot open properties file!", ioe);
        }
        return props;
    }

    public static int computeIthSeed(int ithSeed, boolean rerun, int seed) {
        if (rerun) {
            return seed;
        }
        return seed + ithSeed * 41444;
    }

    public static String getFreshExecutionId() {
        try {
            String id = DatatypeConverter.printBase64Binary((byte[])MessageDigest.getInstance("SHA-256").digest(Long.toString(System.currentTimeMillis()).getBytes()));
            id = id.replace("/", "");
            id = id.replace("\\", "");
            return id;
        }
        catch (NoSuchAlgorithmException nsae) {
            return "No_ID";
        }
    }

    public static Path getRtJarLocation() {
        if (!System.getProperty("java.version").startsWith("1.8.")) {
            Logger.getGlobal().log(Level.SEVERE, System.getProperty("java.version"));
            throw new UnsupportedOperationException("NonDex only supports Java 8");
        }
        String javaHome = System.getProperty("java.home");
        if (javaHome == null) {
            Logger.getGlobal().log(Level.SEVERE, "JAVA_HOME is not set!");
            throw new IllegalStateException("JAVA_HOME is not set!");
        }
        Path pathToRt = Paths.get(javaHome, "jre", "lib", "rt.jar");
        Logger.getGlobal().log(Level.FINE, pathToRt.toString());
        if (Files.exists(pathToRt, new LinkOption[0])) {
            return pathToRt;
        }
        pathToRt = Paths.get(javaHome, "lib", "rt.jar");
        Logger.getGlobal().log(Level.FINE, pathToRt.toString());
        if (Files.exists(pathToRt, new LinkOption[0])) {
            return pathToRt;
        }
        return null;
    }
}

