/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.nondex.common;

import edu.illinois.nondex.common.ConfigurationDefaults;
import edu.illinois.nondex.common.Logger;
import edu.illinois.nondex.common.Mode;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Pattern;

public class Configuration {
    public final Mode mode;
    public final int seed;
    public final Pattern filter;
    public final String executionId;
    public final long start;
    public final long end;
    public final boolean shouldPrintStackTrace;
    public final String nondexDir;
    public final String nondexJarDir;
    public final String testName;
    private Integer invoCount = null;
    private Set<String> failedTests = null;

    protected Configuration(Mode mode, int seed, Pattern filter, String executionId) {
        this(mode, seed, filter, 0L, Long.MAX_VALUE, ".nondex", ".nondex", null, executionId);
    }

    public Configuration(Mode mode, int seed, Pattern filter, long start, long end, String nondexDir, String nondexJarDir, String testName, String executionId) {
        this(mode, seed, filter, start, end, nondexDir, nondexJarDir, testName, executionId, false);
    }

    public Configuration(Mode mode, int seed, Pattern filter, long start, long end, String nondexDir, String nondexJarDir, String testName, String executionId, boolean printStackTrace) {
        this.mode = mode;
        this.seed = seed;
        this.filter = filter;
        this.start = start;
        this.end = end;
        this.nondexDir = nondexDir;
        this.nondexJarDir = nondexJarDir;
        this.testName = testName;
        this.executionId = executionId;
        this.shouldPrintStackTrace = printStackTrace;
        this.createExecutionDirIfNeeded();
    }

    public Configuration(String executionId, String nondexDir) {
        this(ConfigurationDefaults.DEFAULT_MODE, ConfigurationDefaults.DEFAULT_SEED, Pattern.compile(".*"), 0L, Long.MAX_VALUE, nondexDir, ".nondex", null, executionId);
    }

    public void createNondexDirIfNeeded() {
        new File(this.nondexDir).mkdir();
    }

    public String toArgLine() {
        StringBuilder sb = new StringBuilder();
        sb.append(" -DnondexFilter='" + this.filter + "'");
        sb.append(" -DnondexMode=" + (Object)((Object)this.mode));
        sb.append(" -DnondexSeed=" + this.seed);
        sb.append(" -DnondexStart=" + this.start);
        sb.append(" -DnondexEnd=" + this.end);
        sb.append(" -DnondexPrintstack=" + this.shouldPrintStackTrace);
        sb.append(" -DnondexDir=\"" + this.nondexDir + "\"");
        sb.append(" -DnondexJarDir=\"" + this.nondexJarDir + "\"");
        sb.append(" -DnondexExecid=" + this.executionId);
        sb.append(this.testName == null ? "" : " -Dtest=" + this.testName);
        return sb.toString();
    }

    public String toString() {
        return "nondexFilter=" + this.filter + "\n" + "nondexMode" + "=" + (Object)((Object)this.mode) + "\n" + "nondexSeed" + "=" + this.seed + "\n" + "nondexStart" + "=" + this.start + "\n" + "nondexEnd" + "=" + this.end + "\n" + "nondexPrintstack" + "=" + this.shouldPrintStackTrace + "\n" + "nondexDir" + "=" + this.nondexDir + "\n" + "nondexJarDir" + "=" + this.nondexJarDir + "\n" + "nondexExecid" + "=" + this.executionId + "\n" + "test=" + (this.testName == null ? "" : this.testName);
    }

    public static Configuration parseArgs() {
        return Configuration.parseArgs(System.getProperties());
    }

    public static Configuration parseArgs(Properties props) {
        String executionId = props.getProperty("nondexExecid", "NoId");
        int seed = Integer.parseInt(props.getProperty("nondexSeed", "9928532"));
        Mode nonDetKind = Mode.valueOf(props.getProperty("nondexMode", "FULL"));
        Pattern filter = Pattern.compile(props.getProperty("nondexFilter", ".*"));
        long start = Long.parseLong(props.getProperty("nondexStart", "0"));
        long end = Long.parseLong(props.getProperty("nondexEnd", "9223372036854775807"));
        boolean shouldPrintStacktrace = Boolean.parseBoolean(props.getProperty("nondexPrintstack", "false"));
        String nondexDir = props.getProperty("nondexDir", ".nondex");
        String nondexJarDir = props.getProperty("nondexJarDir", ".nondex");
        Level level = Level.parse(props.getProperty("nondexLogging", "CONFIG"));
        Logger.getGlobal().setLoggineLevel(level);
        String testName = props.getProperty("test", null);
        return new Configuration(nonDetKind, seed, filter, start, end, nondexDir, nondexJarDir, testName, executionId, shouldPrintStacktrace);
    }

    public void createExecutionDirIfNeeded() {
        Paths.get(this.nondexDir, this.executionId).toFile().mkdirs();
    }

    public Path getNondexDir() {
        return Paths.get(this.nondexDir, this.executionId);
    }

    public Path getExecutionDir() {
        return Paths.get(this.nondexDir, this.executionId);
    }

    public Path getFailuresPath() {
        return Paths.get(this.nondexDir, this.executionId, "failures");
    }

    public Path getInvocationsPath() {
        return Paths.get(this.nondexDir, this.executionId, "invocations");
    }

    public Path getDebugPath() {
        return Paths.get(this.nondexDir, this.executionId, "debug");
    }

    public Path getConfigPath() {
        return Paths.get(this.nondexDir, this.executionId, "config");
    }

    public Path getRunFilePath() {
        return Paths.get(this.nondexDir, this.executionId + ".run");
    }

    public Path getLatestRunFilePath() {
        return Paths.get(this.nondexDir, "LATEST");
    }

    public Path getPathToJar() {
        return Paths.get(this.nondexJarDir, "nondex-instr.jar");
    }

    public int getInvocationCount() {
        if (this.invoCount == null) {
            File failed = Paths.get(this.nondexDir, this.executionId, "invocations").toFile();
            try (BufferedReader br = new BufferedReader(new FileReader(failed));){
                String line;
                while ((line = br.readLine()) != null) {
                    if (!line.startsWith("SHUFFLES:")) continue;
                    this.invoCount = new Integer(line.substring("SHUFFLES: ".length() - 1));
                }
            }
            catch (FileNotFoundException fne) {
                Logger.getGlobal().log(Level.FINEST, "File Not Found. Probably no test failed in this run.");
            }
            catch (IOException ioe) {
                Logger.getGlobal().log(Level.WARNING, "Exception reading failures file.", ioe);
            }
            catch (Throwable thr) {
                Logger.getGlobal().log(Level.SEVERE, "Some big error", thr);
            }
        }
        return this.invoCount;
    }

    public void filterTests(Collection<String> failedInClean) {
        Collection<String> failedTestsInExecution = this.getFailedTests();
        failedTestsInExecution = new LinkedHashSet<String>(failedTestsInExecution);
        failedTestsInExecution.removeAll(failedInClean);
        this.printFailuresToFile(failedTestsInExecution);
        this.failedTests = null;
    }

    private void printFailuresToFile(Collection<String> failedTestsInExecution) {
        File failed = Paths.get(this.nondexDir, this.executionId, "failures").toFile();
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(failed));){
            for (String test : failedTestsInExecution) {
                bw.write(test + "\n");
            }
        }
        catch (FileNotFoundException fne) {
            Logger.getGlobal().log(Level.FINEST, "File Not Found. Probably no test failed in this run.");
        }
        catch (IOException ioe) {
            Logger.getGlobal().log(Level.WARNING, "Exception reading failures file.", ioe);
        }
    }

    public Collection<String> getFailedTests() {
        if (this.failedTests == null) {
            this.failedTests = new LinkedHashSet<String>();
            File failed = Paths.get(this.nondexDir, this.executionId, "failures").toFile();
            try (BufferedReader br = new BufferedReader(new FileReader(failed));){
                String line;
                while ((line = br.readLine()) != null) {
                    this.failedTests.add(line.trim());
                }
            }
            catch (FileNotFoundException fne) {
                Logger.getGlobal().log(Level.FINEST, "File Not Found. Probably no test failed in this run.");
            }
            catch (IOException ioe) {
                Logger.getGlobal().log(Level.WARNING, "Exception reading failures file.", ioe);
            }
        }
        return Collections.unmodifiableCollection(this.failedTests);
    }

    public long numChoices() {
        assert (this.end >= this.start);
        return this.end - this.start;
    }

    public boolean hasFewerChoicePoints(Configuration debConfig) {
        return this.numChoices() < debConfig.numChoices();
    }

    public void setFailures(Set<String> failingTests) {
        this.printFailuresToFile(failingTests);
    }
}

