/*
 * Decompiled with CFR 0.152.
 */
package zio.logging;

import java.io.Serializable;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import scala.Function0;
import scala.Function1;
import scala.Function9;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import zio.Cause;
import zio.FiberId;
import zio.FiberRefs;
import zio.LogLevel;
import zio.LogSpan;
import zio.Trace$;
import zio.ZLogger;
import zio.Zippable;
import zio.logging.LogAnnotation;
import zio.logging.LogColor;
import zio.logging.LogColor$;
import zio.logging.LogContext;
import zio.logging.LogFormat;
import zio.logging.internal.LogAppender;
import zio.logging.package$;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class LogFormat$ {
    public static LogFormat$ MODULE$;
    private final String NL;
    private final LogFormat bracketStart;
    private final LogFormat bracketEnd;
    private final LogFormat enclosingClass;
    private final LogFormat fiberId;
    private final LogFormat level;
    private final LogFormat levelSyslog;
    private final LogFormat line;
    private final LogFormat traceLine;
    private final LogFormat cause;
    private final LogFormat newLine;
    private final LogFormat space;
    private final LogFormat quote;
    private final LogFormat timestamp;
    private final LogFormat default;
    private final LogFormat colored;

    static {
        new LogFormat$();
    }

    private String NL() {
        return this.NL;
    }

    public LogFormat make(Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object> format) {
        return new LogFormat(format){
            private final Function9 format$1;

            public final LogFormat $plus(LogFormat other) {
                return LogFormat.$plus$(this, other);
            }

            public final LogFormat $bar$minus$bar(LogFormat other) {
                return LogFormat.$bar$minus$bar$(this, other);
            }

            public final LogFormat color(String color) {
                return LogFormat.color$(this, color);
            }

            public final LogFormat concat(LogFormat other) {
                return LogFormat.concat$(this, other);
            }

            public final LogFormat fixed(int size) {
                return LogFormat.fixed$(this, size);
            }

            public final LogFormat highlight(Function1<LogLevel, LogColor> fn) {
                return LogFormat.highlight$(this, fn);
            }

            public final LogFormat highlight() {
                return LogFormat.highlight$(this);
            }

            public final LogFormat spaced(LogFormat other) {
                return LogFormat.spaced$(this, other);
            }

            public final ZLogger<String, String> toJsonLogger() {
                return LogFormat.toJsonLogger$(this);
            }

            public final ZLogger<String, String> toLogger() {
                return LogFormat.toLogger$(this);
            }

            public final ZLogger<String, BoxedUnit> unsafeFormat(LogAppender builder) {
                return LogFormat$.zio$logging$LogFormat$$$anonfun$make$1(builder, this.format$1);
            }
            {
                this.format$1 = format$1;
                LogFormat.$init$(this);
            }
        };
    }

    public LogFormat annotation(String name) {
        return this.make((Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object>)(Function9 & Serializable & scala.Serializable)(builder, x$4, x$5, x$6, x$7, x$8, x$9, x$10, annotations) -> {
            LogFormat$.$anonfun$annotation$1(name, builder, x$4, x$5, x$6, x$7, x$8, x$9, x$10, annotations);
            return BoxedUnit.UNIT;
        });
    }

    public <A> LogFormat logAnnotation(LogAnnotation<A> ann) {
        return this.make((Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object>)(Function9 & Serializable & scala.Serializable)(builder, x$11, x$12, x$13, x$14, x$15, fiberRefs, x$16, x$17) -> {
            LogFormat$.$anonfun$logAnnotation$1(ann, builder, x$11, x$12, x$13, x$14, x$15, fiberRefs, x$16, x$17);
            return BoxedUnit.UNIT;
        });
    }

    public <A> LogFormat annotation(LogAnnotation<A> ann) {
        return this.logAnnotation(ann);
    }

    public LogFormat annotations() {
        return this.annotations((Set<String>)Predef$.MODULE$.Set().empty());
    }

    public LogFormat annotations(Set<String> excludeKeys) {
        return this.make((Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object>)(Function9 & Serializable & scala.Serializable)(builder, x$18, x$19, x$20, x$21, x$22, x$23, x$24, annotations) -> {
            annotations.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                LogFormat$.$anonfun$annotations$2(excludeKeys$1, builder, x0$1);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
    }

    public LogFormat logAnnotations() {
        return this.logAnnotations((Set<String>)Predef$.MODULE$.Set().empty());
    }

    public LogFormat logAnnotations(Set<String> excludeKeys) {
        return this.make((Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object>)(Function9 & Serializable & scala.Serializable)(builder, x$25, x$26, x$27, x$28, x$29, fiberRefs, x$30, x$31) -> {
            LogFormat$.$anonfun$logAnnotations$1(excludeKeys, builder, x$25, x$26, x$27, x$28, x$29, fiberRefs, x$30, x$31);
            return BoxedUnit.UNIT;
        });
    }

    public LogFormat allAnnotations() {
        return this.allAnnotations((Set<String>)Predef$.MODULE$.Set().empty());
    }

    public LogFormat allAnnotations(Set<String> excludeKeys) {
        return this.annotations(excludeKeys).$plus(this.logAnnotations(excludeKeys));
    }

    public LogFormat bracketed(LogFormat inner) {
        return this.bracketStart().$plus(inner).$plus(this.bracketEnd());
    }

    public LogFormat bracketStart() {
        return this.bracketStart;
    }

    public LogFormat bracketEnd() {
        return this.bracketEnd;
    }

    public LogFormat enclosingClass() {
        return this.enclosingClass;
    }

    public LogFormat fiberId() {
        return this.fiberId;
    }

    public LogFormat level() {
        return this.level;
    }

    public LogFormat levelSyslog() {
        return this.levelSyslog;
    }

    public LogFormat line() {
        return this.line;
    }

    public LogFormat traceLine() {
        return this.traceLine;
    }

    public LogFormat cause() {
        return this.cause;
    }

    public LogFormat ifCauseNonEmpty(LogFormat format) {
        return this.make((Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object>)(Function9 & Serializable & scala.Serializable)(builder, trace, fiberId, logLevel, message, cause, spans, location, annotations) -> {
            if (!cause.isEmpty()) {
                return format.unsafeFormat((LogAppender)builder).apply(trace, fiberId, logLevel, message, cause, spans, location, annotations);
            }
            return BoxedUnit.UNIT;
        });
    }

    public LogFormat label(Function0<String> label, LogFormat value) {
        return this.make((Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object>)(Function9 & Serializable & scala.Serializable)(builder, trace, fiberId, logLevel, message, context, spans, location, annotations) -> {
            Object object;
            builder.openKey();
            try {
                builder.appendText((String)label.apply());
            }
            finally {
                builder.closeKeyOpenValue();
            }
            try {
                object = value.unsafeFormat((LogAppender)builder).apply(trace, fiberId, logLevel, message, context, spans, location, annotations);
            }
            finally {
                builder.closeValue();
            }
            return object;
        });
    }

    public LogFormat newLine() {
        return this.newLine;
    }

    public LogFormat space() {
        return this.space;
    }

    public LogFormat quote() {
        return this.quote;
    }

    public LogFormat quoted(LogFormat inner) {
        return this.quote().$plus(inner).$plus(this.quote());
    }

    public LogFormat span(String name) {
        return this.make((Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object>)(Function9 & Serializable & scala.Serializable)(builder, x$81, x$82, x$83, x$84, x$85, x$86, spans, x$87) -> {
            LogFormat$.$anonfun$span$1(name, builder, x$81, x$82, x$83, x$84, x$85, x$86, spans, x$87);
            return BoxedUnit.UNIT;
        });
    }

    public LogFormat spans() {
        return this.make((Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object>)(Function9 & Serializable & scala.Serializable)(builder, x$89, x$90, x$91, x$92, x$93, x$94, spans, x$95) -> {
            spans.foreach((Function1 & Serializable & scala.Serializable)span -> {
                LogFormat$.$anonfun$spans$2(builder, span);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
    }

    public LogFormat text(Function0<String> value) {
        return this.make((Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object>)(Function9 & Serializable & scala.Serializable)(builder, x$96, x$97, x$98, x$99, x$100, x$101, x$102, x$103) -> {
            builder.appendText((String)value.apply());
            return BoxedUnit.UNIT;
        });
    }

    public LogFormat timestamp() {
        return this.timestamp;
    }

    public LogFormat timestamp(Function0<DateTimeFormatter> formatter) {
        return this.text((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> {
            ZonedDateTime now = ZonedDateTime.now();
            return ((DateTimeFormatter)formatter.apply()).format(now);
        });
    }

    public LogFormat default() {
        return this.default;
    }

    public LogFormat colored() {
        return this.colored;
    }

    public static final /* synthetic */ ZLogger zio$logging$LogFormat$$$anonfun$make$1(LogAppender builder, Function9 format$1) {
        return new ZLogger<String, BoxedUnit>(format$1, builder){
            private final Function9 format$1;
            private final LogAppender builder$3;

            public <M extends String, O> ZLogger<M, Object> $plus$plus(ZLogger<M, O> that, Zippable<BoxedUnit, O> zippable) {
                return ZLogger.$plus$plus$((ZLogger)this, that, zippable);
            }

            public <M extends String, O> ZLogger<M, O> $plus$greater(ZLogger<M, O> that) {
                return ZLogger.$plus$greater$((ZLogger)this, that);
            }

            public <M extends String> ZLogger<M, BoxedUnit> $less$plus(ZLogger<M, Object> that) {
                return ZLogger.$less$plus$((ZLogger)this, that);
            }

            public final <Message1> ZLogger<Message1, BoxedUnit> contramap(Function1<Message1, String> f) {
                return ZLogger.contramap$((ZLogger)this, f);
            }

            public final ZLogger<String, Option<BoxedUnit>> filterLogLevel(Function1<LogLevel, Object> f) {
                return ZLogger.filterLogLevel$((ZLogger)this, f);
            }

            public final <B> ZLogger<String, B> map(Function1<BoxedUnit, B> f) {
                return ZLogger.map$((ZLogger)this, f);
            }

            public final Object test(Function0 input) {
                return ZLogger.test$((ZLogger)this, (Function0)input);
            }

            public void apply(Object trace, FiberId fiberId, LogLevel logLevel, Function0<String> message, Cause<Object> cause, FiberRefs context, List<LogSpan> spans, Map<String, String> annotations) {
                this.format$1.apply((Object)this.builder$3, trace, (Object)fiberId, (Object)logLevel, message, cause, (Object)context, spans, annotations);
            }
            {
                this.format$1 = format$1;
                this.builder$3 = builder$3;
                ZLogger.$init$((ZLogger)this);
            }
        };
    }

    public static final /* synthetic */ void $anonfun$annotation$1(String name$1, LogAppender builder, Object x$4, FiberId x$5, LogLevel x$6, Function0 x$7, Cause x$8, FiberRefs x$9, List x$10, Map annotations) {
        annotations.get((Object)name$1).foreach((Function1 & Serializable & scala.Serializable)value -> {
            builder.appendKeyValue(name$1, value);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$logAnnotation$2(LogAnnotation ann$1, LogAppender builder$5, LogContext context) {
        context.get(ann$1).foreach((Function1 & Serializable & scala.Serializable)value -> {
            builder$5.appendKeyValue(ann$1.name(), (String)ann$1.render().apply(value));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$logAnnotation$1(LogAnnotation ann$1, LogAppender builder, Object x$11, FiberId x$12, LogLevel x$13, Function0 x$14, Cause x$15, FiberRefs fiberRefs, List x$16, Map x$17) {
        fiberRefs.get(package$.MODULE$.logContext()).foreach((Function1 & Serializable & scala.Serializable)context -> {
            LogFormat$.$anonfun$logAnnotation$2(ann$1, builder, context);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$annotations$2(Set excludeKeys$1, LogAppender builder$6, Tuple2 x0$1) {
        if (x0$1 != null) {
            String key = (String)x0$1._1();
            String value = (String)x0$1._2();
            if (!excludeKeys$1.contains((Object)key)) {
                builder$6.appendKeyValue(key, value);
                return;
            }
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$logAnnotations$3(Set excludeKeys$2, LogAppender builder$7, Tuple2 x0$1) {
        if (x0$1 != null) {
            String key = (String)x0$1._1();
            String value = (String)x0$1._2();
            if (!excludeKeys$2.contains((Object)key)) {
                builder$7.appendKeyValue(key, value);
                return;
            }
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$logAnnotations$2(Set excludeKeys$2, LogAppender builder$7, LogContext context) {
        context.asMap().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            LogFormat$.$anonfun$logAnnotations$3(excludeKeys$2, builder$7, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$logAnnotations$1(Set excludeKeys$2, LogAppender builder, Object x$25, FiberId x$26, LogLevel x$27, Function0 x$28, Cause x$29, FiberRefs fiberRefs, List x$30, Map x$31) {
        fiberRefs.get(package$.MODULE$.logContext()).foreach((Function1 & Serializable & scala.Serializable)context -> {
            LogFormat$.$anonfun$logAnnotations$2(excludeKeys$2, builder, context);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$span$2(String name$2, LogSpan x$88) {
        String string = x$88.label();
        return !(string != null ? !string.equals(name$2) : name$2 != null);
    }

    public static final /* synthetic */ void $anonfun$span$3(LogAppender builder$8, String name$2, LogSpan span) {
        String duration = Long.toString(System.currentTimeMillis() - span.startTime());
        builder$8.appendKeyValue(name$2, duration);
    }

    public static final /* synthetic */ void $anonfun$span$1(String name$2, LogAppender builder, Object x$81, FiberId x$82, LogLevel x$83, Function0 x$84, Cause x$85, FiberRefs x$86, List spans, Map x$87) {
        spans.find((Function1 & Serializable & scala.Serializable)x$88 -> BoxesRunTime.boxToBoolean((boolean)LogFormat$.$anonfun$span$2(name$2, x$88))).foreach((Function1 & Serializable & scala.Serializable)span -> {
            LogFormat$.$anonfun$span$3(builder, name$2, span);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$spans$2(LogAppender builder$9, LogSpan span) {
        String duration = Long.toString(System.currentTimeMillis() - span.startTime());
        builder$9.appendKeyValue(span.label(), new StringBuilder(2).append(duration).append("ms").toString());
    }

    private LogFormat$() {
        MODULE$ = this;
        this.NL = System.lineSeparator();
        this.bracketStart = this.text((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "[");
        this.bracketEnd = this.text((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "]");
        this.enclosingClass = this.make((Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object>)(Function9 & Serializable & scala.Serializable)(builder, trace, x$32, x$33, x$34, x$35, x$36, x$37, x$38) -> {
            Object object;
            Option option;
            Option option2 = ClassTag$.MODULE$.apply(Object.class).unapply(trace);
            if (!option2.isEmpty() && !(option = Trace$.MODULE$.unapply(object = option2.get())).isEmpty()) {
                String file = (String)((Tuple3)option.get())._2();
                builder.appendText(file);
                return BoxedUnit.UNIT;
            }
            builder.appendText("not-available");
            return BoxedUnit.UNIT;
        });
        this.fiberId = this.make((Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object>)(Function9 & Serializable & scala.Serializable)(builder, x$39, fiberId, x$40, x$41, x$42, x$43, x$44, x$45) -> {
            builder.appendText(fiberId.threadName());
            return BoxedUnit.UNIT;
        });
        this.level = this.make((Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object>)(Function9 & Serializable & scala.Serializable)(builder, x$46, x$47, level, x$48, x$49, x$50, x$51, x$52) -> {
            builder.appendText(level.label());
            return BoxedUnit.UNIT;
        });
        this.levelSyslog = this.make((Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object>)(Function9 & Serializable & scala.Serializable)(builder, x$53, x$54, level, x$55, x$56, x$57, x$58, x$59) -> {
            builder.appendText(Integer.toString(level.syslog()));
            return BoxedUnit.UNIT;
        });
        this.line = this.make((Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object>)(Function9 & Serializable & scala.Serializable)(builder, x$60, x$61, x$62, line, x$63, x$64, x$65, x$66) -> {
            builder.appendText((String)line.apply());
            return BoxedUnit.UNIT;
        });
        this.traceLine = this.make((Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object>)(Function9 & Serializable & scala.Serializable)(builder, trace, x$67, x$68, x$69, x$70, x$71, x$72, x$73) -> {
            Object object;
            Option option;
            Option option2 = ClassTag$.MODULE$.apply(Object.class).unapply(trace);
            if (!option2.isEmpty() && !(option = Trace$.MODULE$.unapply(object = option2.get())).isEmpty()) {
                int line = BoxesRunTime.unboxToInt((Object)((Tuple3)option.get())._3());
                builder.appendNumeric(BoxesRunTime.boxToInteger((int)line));
                return BoxedUnit.UNIT;
            }
            return BoxedUnit.UNIT;
        });
        this.cause = this.make((Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object>)(Function9 & Serializable & scala.Serializable)(builder, x$74, x$75, x$76, x$77, cause, x$78, x$79, x$80) -> {
            if (!cause.isEmpty()) {
                builder.appendCause((Cause<Object>)cause);
                return BoxedUnit.UNIT;
            }
            return BoxedUnit.UNIT;
        });
        this.newLine = this.text((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> MODULE$.NL());
        this.space = this.text((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> " ");
        this.quote = this.text((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "\"");
        this.timestamp = this.timestamp((Function0<DateTimeFormatter>)(Function0 & Serializable & scala.Serializable)() -> DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        this.default = this.label((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "timestamp", this.timestamp().fixed(32)).$bar$minus$bar(this.label((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "level", this.level())).$bar$minus$bar(this.label((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "thread", this.fiberId())).$bar$minus$bar(this.label((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "message", this.quoted(this.line())).$plus(this.ifCauseNonEmpty(this.space().$plus(this.label((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "cause", this.cause())))));
        this.colored = this.label((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "timestamp", this.timestamp().fixed(32)).color(LogColor$.MODULE$.BLUE()).$bar$minus$bar(this.label((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "level", this.level()).highlight()).$bar$minus$bar(this.label((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "thread", this.fiberId()).color(LogColor$.MODULE$.WHITE())).$bar$minus$bar(this.label((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "message", this.quoted(this.line())).highlight().$plus(this.ifCauseNonEmpty(this.space().$plus(this.label((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "cause", this.cause()).highlight()))));
    }
}

