/*
 * Decompiled with CFR 0.152.
 */
package zio.internal.stacktracer;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.StringOps;
import scala.util.matching.Regex;
import zio.internal.stacktracer.AkkaLineNumbers;
import zio.internal.stacktracer.AkkaLineNumbers$;
import zio.internal.stacktracer.AkkaLineNumbers$NoSourceInfo$;
import zio.internal.stacktracer.Tracer$;

public final class InteropTracer$ {
    public static InteropTracer$ MODULE$;
    private final ConcurrentMap<Class<?>, Object> cache;
    private final Regex lambdaNamePattern;

    static {
        new InteropTracer$();
    }

    public final Object newTrace(Object f) {
        Class<?> clazz = f.getClass();
        Object cachedTrace = this.cache().get(clazz);
        if (cachedTrace == null) {
            Object object;
            AkkaLineNumbers.Result result = AkkaLineNumbers$.MODULE$.apply(f);
            if (AkkaLineNumbers$NoSourceInfo$.MODULE$.equals(result)) {
                object = Tracer$.MODULE$.instance().empty();
            } else if (result instanceof AkkaLineNumbers.UnknownSourceFormat) {
                object = Tracer$.MODULE$.instance().empty();
            } else if (result instanceof AkkaLineNumbers.SourceFile) {
                String filename = ((AkkaLineNumbers.SourceFile)result).filename();
                object = this.createTrace("<unknown>", filename, 0);
            } else if (result instanceof AkkaLineNumbers.SourceFileLines) {
                AkkaLineNumbers.SourceFileLines sourceFileLines = (AkkaLineNumbers.SourceFileLines)result;
                String filename = sourceFileLines.filename();
                int from = sourceFileLines.from();
                String classNameSlashes = sourceFileLines.className();
                String methodAnonfun = sourceFileLines.methodName();
                String className = classNameSlashes.replace('/', '.');
                String methodName = (String)this.lambdaNamePattern().findFirstMatchIn((CharSequence)methodAnonfun).flatMap((Function1 & java.io.Serializable & Serializable)x$1 -> Option$.MODULE$.apply((Object)x$1.group(1))).getOrElse((Function0 & java.io.Serializable & Serializable)() -> methodAnonfun);
                object = this.createTrace(new StringBuilder(1).append(className).append(".").append(methodName).toString(), filename, from);
            } else {
                throw new MatchError((Object)result);
            }
            Object computedTrace = object;
            this.cache().put(clazz, computedTrace);
            return computedTrace;
        }
        return cachedTrace;
    }

    private ConcurrentMap<Class<?>, Object> cache() {
        return this.cache;
    }

    private String createTrace(String location, String file, int line) {
        return new StringBuilder(3).append(location).append("(").append(file).append(":").append(line).append(")").toString().intern();
    }

    private final Regex lambdaNamePattern() {
        return this.lambdaNamePattern;
    }

    private InteropTracer$() {
        MODULE$ = this;
        this.cache = new ConcurrentHashMap(10000);
        this.lambdaNamePattern = new StringOps(Predef$.MODULE$.augmentString("\\$anonfun\\$(.+?)\\$\\d")).r();
    }
}

