/*
 * Decompiled with CFR 0.152.
 */
package zio.internal.stacktracer;

import java.io.DataInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Method;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.util.control.NonFatal$;
import zio.internal.stacktracer.AkkaLineNumbers;
import zio.internal.stacktracer.AkkaLineNumbers$NoSourceInfo$;

public final class AkkaLineNumbers$ {
    public static AkkaLineNumbers$ MODULE$;

    static {
        new AkkaLineNumbers$();
    }

    public final AkkaLineNumbers.Result apply(Object obj) {
        Tuple3 tuple3;
        Option option = this.getStreamForLambda(obj).orElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.getStreamForClass(obj.getClass()));
        if (option instanceof Some && (tuple3 = (Tuple3)((Some)option).value()) != null) {
            InputStream stream = (InputStream)tuple3._1();
            String className = (String)tuple3._2();
            Option methodName = (Option)tuple3._3();
            return this.getInfo(stream, className, (Option<String>)methodName);
        }
        if (None$.MODULE$.equals(option)) {
            return AkkaLineNumbers$NoSourceInfo$.MODULE$;
        }
        throw new MatchError((Object)option);
    }

    private AkkaLineNumbers.Result getInfo(InputStream stream, String className, Option<String> methodName) {
        AkkaLineNumbers.UnknownSourceFormat unknownSourceFormat;
        block16: {
            AkkaLineNumbers.Result result;
            DataInputStream dis;
            block14: {
                dis = new DataInputStream(stream);
                try {
                    try {
                        Tuple2 tuple2;
                        this.skipID(dis);
                        this.skipVersion(dis);
                        AkkaLineNumbers.Constants constants = this.getConstants(dis);
                        this.skipClassInfo(dis, constants);
                        this.skipInterfaceInfo(dis, constants);
                        this.skipFields(dis, constants);
                        Option<Tuple2<Object, Object>> lines = this.readMethods(dis, methodName, constants);
                        Option<String> source = this.readAttributes(dis, constants);
                        if (source.isEmpty()) {
                            result = AkkaLineNumbers$NoSourceInfo$.MODULE$;
                            break block14;
                        }
                        if (None$.MODULE$.equals(lines)) {
                            result = new AkkaLineNumbers.SourceFile((String)source.get());
                            break block14;
                        }
                        if (lines instanceof Some && (tuple2 = (Tuple2)((Some)lines).value()) != null) {
                            int from = tuple2._1$mcI$sp();
                            int to = tuple2._2$mcI$sp();
                            result = new AkkaLineNumbers.SourceFileLines((String)source.get(), from, to, className, (String)methodName.getOrElse((Function0 & Serializable & scala.Serializable)() -> "apply"));
                            break block14;
                        }
                        throw new MatchError(lines);
                    }
                    catch (Throwable throwable) {
                        if (NonFatal$.MODULE$.apply(throwable)) {
                            result = new AkkaLineNumbers.UnknownSourceFormat(new StringBuilder(13).append("parse error: ").append(throwable.getMessage()).toString());
                            break block14;
                        }
                        throw throwable;
                    }
                }
                catch (Throwable throwable) {
                    block15: {
                        try {
                            dis.close();
                        }
                        catch (Throwable throwable2) {
                            if (throwable2 instanceof InterruptedException) {
                                throw (InterruptedException)throwable2;
                            }
                            if (!NonFatal$.MODULE$.unapply(throwable2).isEmpty()) break block15;
                            throw throwable2;
                        }
                    }
                    throw throwable;
                }
            }
            unknownSourceFormat = result;
            try {
                dis.close();
            }
            catch (Throwable throwable) {
                if (throwable instanceof InterruptedException) {
                    throw (InterruptedException)throwable;
                }
                if (!NonFatal$.MODULE$.unapply(throwable).isEmpty()) break block16;
                throw throwable;
            }
        }
        return unknownSourceFormat;
    }

    private Option<Tuple3<InputStream, String, None$>> getStreamForClass(Class<?> c) {
        Some some;
        try {
            InputStream r;
            String name = c.getName();
            String resource = new StringBuilder(6).append(name.replace('.', '/')).append(".class").toString();
            ClassLoader cl = c.getClassLoader();
            InputStream inputStream = r = cl != null ? cl.getResourceAsStream(resource) : null;
            if (r == null) {
                return None$.MODULE$;
            }
            some = new Some((Object)new Tuple3((Object)r, (Object)name, (Object)None$.MODULE$));
        }
        catch (Throwable throwable) {
            if (NonFatal$.MODULE$.apply(throwable)) {
                return None$.MODULE$;
            }
            throw throwable;
        }
        return some;
    }

    private Option<Tuple3<InputStream, String, Some<String>>> getStreamForLambda(Object l) {
        Object object;
        try {
            Class<?> c = l.getClass();
            Method writeReplace = c.getDeclaredMethod("writeReplace", new Class[0]);
            writeReplace.setAccessible(true);
            Object object2 = writeReplace.invoke(l, new Object[0]);
            if (object2 instanceof SerializedLambda) {
                SerializedLambda serializedLambda = (SerializedLambda)object2;
                InputStream r = c.getClassLoader().getResourceAsStream(new StringBuilder(6).append(serializedLambda.getImplClass()).append(".class").toString());
                object = r != null ? new Some((Object)new Tuple3((Object)r, (Object)serializedLambda.getImplClass(), (Object)new Some((Object)serializedLambda.getImplMethodName()))) : None$.MODULE$;
            } else {
                object = None$.MODULE$;
            }
        }
        catch (Throwable throwable) {
            if (NonFatal$.MODULE$.apply(throwable)) {
                return None$.MODULE$;
            }
            throw throwable;
        }
        return object;
    }

    private void skipID(DataInputStream d) {
        if (d.readInt() != -889275714) {
            throw new IllegalArgumentException("not a Java class file");
        }
    }

    private void skipVersion(DataInputStream d) {
        d.readShort();
        d.readShort();
    }

    private AkkaLineNumbers.Constants getConstants(DataInputStream d) {
        int count = d.readUnsignedShort();
        AkkaLineNumbers.Constants c = new AkkaLineNumbers.Constants(count);
        while (!c.isDone()) {
            c.readOne(d);
        }
        c.resolve();
        return c;
    }

    private void skipClassInfo(DataInputStream d, AkkaLineNumbers.Constants c) {
        this.zio$internal$stacktracer$AkkaLineNumbers$$skip(d, 2);
        d.readUnsignedShort();
        this.zio$internal$stacktracer$AkkaLineNumbers$$skip(d, 2);
    }

    private void skipInterfaceInfo(DataInputStream d, AkkaLineNumbers.Constants c) {
        int count = d.readUnsignedShort();
        for (int i = 1; i <= count; ++i) {
            d.readUnsignedShort();
        }
    }

    private void skipFields(DataInputStream d, AkkaLineNumbers.Constants c) {
        int count = d.readUnsignedShort();
        for (int i = 1; i <= count; ++i) {
            this.skipMethodOrField(d, c);
        }
    }

    private void skipMethodOrField(DataInputStream d, AkkaLineNumbers.Constants c) {
        this.zio$internal$stacktracer$AkkaLineNumbers$$skip(d, 2);
        d.readUnsignedShort();
        this.zio$internal$stacktracer$AkkaLineNumbers$$skip(d, 2);
        int attributes = d.readUnsignedShort();
        for (int i = 1; i <= attributes; ++i) {
            this.skipAttribute(d);
        }
    }

    private void skipAttribute(DataInputStream d) {
        this.zio$internal$stacktracer$AkkaLineNumbers$$skip(d, 2);
        int length = d.readInt();
        this.zio$internal$stacktracer$AkkaLineNumbers$$skip(d, length);
    }

    private Option<Tuple2<Object, Object>> readMethods(DataInputStream d, Option<String> methodName, AkkaLineNumbers.Constants c) {
        int count = d.readUnsignedShort();
        if (c.contains("Code") && c.contains("LineNumberTable")) {
            Tuple2 tuple2 = (Tuple2)((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), count).flatMap((Function1 & Serializable & scala.Serializable)x$1 -> AkkaLineNumbers$.$anonfun$readMethods$1(d, c, methodName, BoxesRunTime.unboxToInt((Object)x$1)), IndexedSeq$.MODULE$.canBuildFrom())).foldLeft((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE)), (Object)BoxesRunTime.boxToInteger((int)0)), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
                Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                Tuple2 tuple22 = x0$1;
                Tuple2 tuple23 = x1$1;
                if (tuple22 != null) {
                    int low = tuple22._1$mcI$sp();
                    int high = tuple22._2$mcI$sp();
                    if (tuple23 != null) {
                        int start = tuple23._1$mcI$sp();
                        int end = tuple23._2$mcI$sp();
                        return new Tuple2.mcII.sp(Math.min(low, start), Math.max(high, end));
                    }
                }
                throw new MatchError((Object)tuple2);
            });
            if (tuple2 != null) {
                int n = tuple2._1$mcI$sp();
                int n2 = tuple2._2$mcI$sp();
                if (Integer.MAX_VALUE == n && 0 == n2) {
                    return None$.MODULE$;
                }
            }
            return new Some((Object)tuple2);
        }
        for (int i = 1; i <= count; ++i) {
            this.skipMethodOrField(d, c);
        }
        return None$.MODULE$;
    }

    private Option<Tuple2<Object, Object>> readMethod(DataInputStream d, int codeTag, int lineNumberTableTag, Option<String> methodName, AkkaLineNumbers.Constants c) {
        this.zio$internal$stacktracer$AkkaLineNumbers$$skip(d, 2);
        int name = d.readUnsignedShort();
        this.zio$internal$stacktracer$AkkaLineNumbers$$skip(d, 2);
        return ((IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), d.readUnsignedShort()).map((Function1 & Serializable & scala.Serializable)_ -> AkkaLineNumbers$.$anonfun$readMethod$1(d, codeTag, methodName, c, name, lineNumberTableTag, BoxesRunTime.unboxToInt((Object)_)), IndexedSeq$.MODULE$.canBuildFrom())).find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isDefined())).flatten(Predef$.MODULE$.$conforms());
    }

    private Option<String> readAttributes(DataInputStream d, AkkaLineNumbers.Constants c) {
        int count = d.readUnsignedShort();
        if (c.contains("SourceFile")) {
            int s = c.apply("SourceFile");
            return ((TraversableLike)((IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), count).map((Function1 & Serializable & scala.Serializable)_ -> AkkaLineNumbers$.$anonfun$readAttributes$1(d, s, c, BoxesRunTime.unboxToInt((Object)_)), IndexedSeq$.MODULE$.canBuildFrom())).flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo))).headOption();
        }
        return None$.MODULE$;
    }

    public void zio$internal$stacktracer$AkkaLineNumbers$$skip(DataInputStream d, int length) {
        if (d.skipBytes(length) != length) {
            throw new IllegalArgumentException("class file ends prematurely");
        }
    }

    public static final /* synthetic */ List $anonfun$readMethods$1(DataInputStream d$1, AkkaLineNumbers.Constants c$1, Option methodName$1, int x$1) {
        return MODULE$.readMethod(d$1, c$1.apply("Code"), c$1.apply("LineNumberTable"), (Option<String>)methodName$1, c$1).toList();
    }

    public static final /* synthetic */ Option $anonfun$readMethod$2(DataInputStream d$2, int lineNumberTableTag$1, int _2) {
        int tag = d$2.readUnsignedShort();
        int length = d$2.readInt();
        if (tag != lineNumberTableTag$1) {
            MODULE$.zio$internal$stacktracer$AkkaLineNumbers$$skip(d$2, length);
            return None$.MODULE$;
        }
        IndexedSeq lines = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), d$2.readUnsignedShort()).map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)_ -> {
            MODULE$.zio$internal$stacktracer$AkkaLineNumbers$$skip(d$2, 2);
            return d$2.readUnsignedShort();
        }, IndexedSeq$.MODULE$.canBuildFrom());
        return new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(lines.min((Ordering)Ordering.Int$.MODULE$)), lines.max((Ordering)Ordering.Int$.MODULE$)));
    }

    public static final /* synthetic */ Option $anonfun$readMethod$1(DataInputStream d$2, int codeTag$1, Option methodName$2, AkkaLineNumbers.Constants c$2, int name$1, int lineNumberTableTag$1, int _2) {
        block3: {
            int length;
            block2: {
                int tag = d$2.readUnsignedShort();
                length = d$2.readInt();
                if (tag != codeTag$1) break block2;
                if (!methodName$2.isDefined()) break block3;
                String string = c$2.apply(name$1);
                Object object = methodName$2.get();
                if (!(string == null ? object != null : !string.equals(object))) break block3;
            }
            MODULE$.zio$internal$stacktracer$AkkaLineNumbers$$skip(d$2, length);
            return None$.MODULE$;
        }
        MODULE$.zio$internal$stacktracer$AkkaLineNumbers$$skip(d$2, 4);
        MODULE$.zio$internal$stacktracer$AkkaLineNumbers$$skip(d$2, d$2.readInt());
        MODULE$.zio$internal$stacktracer$AkkaLineNumbers$$skip(d$2, 8 * d$2.readUnsignedShort());
        return ((TraversableLike)((IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), d$2.readUnsignedShort()).map((Function1 & Serializable & scala.Serializable)_ -> AkkaLineNumbers$.$anonfun$readMethod$2(d$2, lineNumberTableTag$1, BoxesRunTime.unboxToInt((Object)_)), IndexedSeq$.MODULE$.canBuildFrom())).flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo))).headOption();
    }

    public static final /* synthetic */ Option $anonfun$readAttributes$1(DataInputStream d$3, int s$1, AkkaLineNumbers.Constants c$3, int _) {
        int tag = d$3.readUnsignedShort();
        int length = d$3.readInt();
        if (tag != s$1) {
            MODULE$.zio$internal$stacktracer$AkkaLineNumbers$$skip(d$3, length);
            return None$.MODULE$;
        }
        int name = d$3.readUnsignedShort();
        return new Some((Object)c$3.apply(name));
    }

    private AkkaLineNumbers$() {
        MODULE$ = this;
    }
}

