/*
 * Decompiled with CFR 0.152.
 */
package zio.cli.oauth2;

import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import zio.CanFail$;
import zio.ZIO;
import zio.cli.CliConfig;
import zio.cli.HelpDoc;
import zio.cli.HelpDoc$;
import zio.cli.Options;
import zio.cli.Options$Empty$;
import zio.cli.ValidationError;
import zio.cli.ValidationErrorType$InvalidValue$;
import zio.cli.oauth2.OAuth2;
import zio.cli.oauth2.OAuth2AuxiliaryOptions;
import zio.cli.oauth2.OAuth2Provider;
import zio.cli.oauth2.OAuth2Token;

public final class OAuth2PlatformSpecific$ {
    public static final OAuth2PlatformSpecific$ MODULE$ = new OAuth2PlatformSpecific$();

    public ZIO<Object, ValidationError, OAuth2Token> validate(OAuth2Provider provider, List<String> scope, Options<OAuth2AuxiliaryOptions> auxiliaryOptions, Map<String, List<String>> args, CliConfig conf) {
        return auxiliaryOptions.validate(args, conf).flatMap((Function1 & Serializable)x0$1 -> new OAuth2(provider, x0$1.file(), scope).loadOrAuthorize().mapError((Function1 & Serializable)ex -> new ValidationError(ValidationErrorType$InvalidValue$.MODULE$, HelpDoc$.MODULE$.p(ex.getMessage())), CanFail$.MODULE$.canFail(), (Object)"zio.cli.oauth2.OAuth2PlatformSpecific.validate(OAuth2PlatformSpecific.scala:18)"), (Object)"zio.cli.oauth2.OAuth2PlatformSpecific.validate(OAuth2PlatformSpecific.scala:16)");
    }

    public Option<OAuth2Provider> findProvider(Options<Object> opt) {
        while (true) {
            if (opt instanceof Options.Both) {
                Options.Both both = (Options.Both)opt;
                Options<Object> left = both.left();
                Options right = both.right();
                return this.findProvider(left).orElse((Function0 & Serializable)() -> MODULE$.findProvider(right));
            }
            if (opt instanceof Options.Map) {
                opt = ((Options.Map)opt).value();
                continue;
            }
            if (opt instanceof Options.KeyValueMap) {
                return None$.MODULE$;
            }
            if (Options$Empty$.MODULE$.equals(opt)) {
                return None$.MODULE$;
            }
            if (opt instanceof Options.OrElse) {
                Options.OrElse orElse = (Options.OrElse)opt;
                Options<Object> left = orElse.left();
                Options right = orElse.right();
                return this.findProvider(left).orElse((Function0 & Serializable)() -> MODULE$.findProvider(right));
            }
            if (opt instanceof Options.Single) {
                return None$.MODULE$;
            }
            if (opt instanceof Options.OAuth2Options) {
                OAuth2Provider provider = ((Options.OAuth2Options)opt).provider();
                return new Some((Object)provider);
            }
            if (!(opt instanceof Options.WithDefault)) break;
            opt = ((Options.WithDefault)opt).options();
        }
        throw new MatchError(opt);
    }

    public HelpDoc oauth2HelpSection(Options<Object> options) {
        return (HelpDoc)this.findProvider(options).fold((Function0 & Serializable)() -> HelpDoc$.MODULE$.empty(), (Function1 & Serializable)provider -> HelpDoc$.MODULE$.h1("3rd party authorization").$plus(HelpDoc$.MODULE$.p(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(440).append("|This application requires 3rd party authorization (using OAuth2 protocol)\n            |provided by ").append(provider.name()).append(". When the application is launched for the first time,\n            |instructions to perform the authorization will be displayed. Subsequent launches\n            |do not require any action unless the access has been revoked.\n            |\n            |Behavior of 3rd party authorization can be modified by options starting with '--oauth2-'.").toString())))));
    }

    private OAuth2PlatformSpecific$() {
    }
}

