/*
 * Decompiled with CFR 0.152.
 */
package zio.cli.oauth2;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Path;
import java.time.Duration;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.temporal.TemporalAmount;
import scala.;
import scala.$less$colon$less$;
import scala.DummyImplicit$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import zio.CanFail$;
import zio.Clock$;
import zio.Console$;
import zio.Duration$;
import zio.DurationOps$;
import zio.DurationSyntax$;
import zio.IsSubtypeOfError$;
import zio.Ref;
import zio.Schedule;
import zio.Schedule$;
import zio.ZIO;
import zio.ZIO$;
import zio.cli.oauth2.AccessToken;
import zio.cli.oauth2.AccessToken$;
import zio.cli.oauth2.AccessTokenResponse;
import zio.cli.oauth2.AccessTokenResponse$Error$Kind$AuthorizationPending$;
import zio.cli.oauth2.AccessTokenResponse$Error$Kind$SlowDown$;
import zio.cli.oauth2.AuthorizationResponse;
import zio.cli.oauth2.OAuth2$;
import zio.cli.oauth2.OAuth2Provider;
import zio.cli.oauth2.OAuth2Token;
import zio.json.JsonDecoder$;
import zio.json.JsonEncoder$;
import zio.json.package;
import zio.package$;

@ScalaSignature(bytes="\u0006\u0005\u0005=c!\u0002\n\u0014\u0001UI\u0002\u0002\u0003\u0011\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0012\t\u0011\u0019\u0002!\u0011!Q\u0001\n\u001dB\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!\r\u0005\u0006\u000b\u0002!\tA\u0012\u0005\b\u0017\u0002\u0011\r\u0011\"\u0001M\u0011\u0019)\u0006\u0001)A\u0005\u001b\")a\u000b\u0001C\u0001/\")!\r\u0001C\u0001G\")\u0001\u000e\u0001C\u0001S\")a\u000e\u0001C\u0001_\")Q\u000f\u0001C\u0001m\")\u0011\u0010\u0001C\u0001u\"1q\u0010\u0001C\u0001\u0003\u0003Aq!a\u0002\u0001\t\u0003\tI\u0001C\u0004\u00020\u0001!\t!!\r\t\u000f\u0005]\u0002\u0001\"\u0001\u0002:!9\u0011\u0011\t\u0001\u0005\u0002\u0005\r#AB(BkRD'G\u0003\u0002\u0015+\u00051q.Y;uQJR!AF\f\u0002\u0007\rd\u0017NC\u0001\u0019\u0003\rQ\u0018n\\\n\u0003\u0001i\u0001\"a\u0007\u0010\u000e\u0003qQ\u0011!H\u0001\u0006g\u000e\fG.Y\u0005\u0003?q\u0011a!\u00118z%\u00164\u0017\u0001\u00039s_ZLG-\u001a:\u0004\u0001A\u00111\u0005J\u0007\u0002'%\u0011Qe\u0005\u0002\u000f\u001f\u0006+H\u000f\u001b\u001aQe>4\u0018\u000eZ3s\u0003\u00111\u0017\u000e\\3\u0011\u0005!rS\"A\u0015\u000b\u0005\u0019R#BA\u0016-\u0003\rq\u0017n\u001c\u0006\u0002[\u0005!!.\u0019<b\u0013\ty\u0013F\u0001\u0003QCRD\u0017!B:d_B,\u0007c\u0001\u001a;{9\u00111\u0007\u000f\b\u0003i]j\u0011!\u000e\u0006\u0003m\u0005\na\u0001\u0010:p_Rt\u0014\"A\u000f\n\u0005eb\u0012a\u00029bG.\fw-Z\u0005\u0003wq\u0012A\u0001T5ti*\u0011\u0011\b\b\t\u0003}\ts!a\u0010!\u0011\u0005Qb\u0012BA!\u001d\u0003\u0019\u0001&/\u001a3fM&\u00111\t\u0012\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0005c\u0012A\u0002\u001fj]&$h\b\u0006\u0003H\u0011&S\u0005CA\u0012\u0001\u0011\u0015\u0001C\u00011\u0001#\u0011\u00151C\u00011\u0001(\u0011\u0015\u0001D\u00011\u00012\u0003\u0019\u0019G.[3oiV\tQ\n\u0005\u0002O'6\tqJ\u0003\u0002Q#\u0006!\u0001\u000e\u001e;q\u0015\t\u0011F&A\u0002oKRL!\u0001V(\u0003\u0015!#H\u000f]\"mS\u0016tG/A\u0004dY&,g\u000e\u001e\u0011\u0002\u001f1|\u0017\rZ(s\u0003V$\bn\u001c:ju\u0016,\u0012\u0001\u0017\t\u00043r{fB\u0001.\\\u001b\u00059\u0012BA\u001d\u0018\u0013\tifL\u0001\u0003UCN\\'BA\u001d\u0018!\t\u0019\u0003-\u0003\u0002b'\tYq*Q;uQJ\"vn[3o\u0003%\tW\u000f\u001e5pe&TX-F\u0001e!\rIF,\u001a\t\u0003G\u0019L!aZ\n\u0003\u0017\u0005\u001b7-Z:t)>\\WM\\\u0001\rY>\fGM\u0012:p[\u001aKG.Z\u000b\u0002UB\u0019\u0011\fX6\u0011\u0007maW-\u0003\u0002n9\t1q\n\u001d;j_:\fq\"\\1lK>\u000bU\u000f\u001e53)>\\WM\u001c\u000b\u0003aN\u00042!W9`\u0013\t\u0011hLA\u0002V\u0013>CQ\u0001\u001e\u0006A\u0002\u0015\fA\"\u001b8ji&\fG\u000eV8lK:\f!C]3ge\u0016\u001c\b.Q2dKN\u001cHk\\6f]R\u0011Am\u001e\u0005\u0006q.\u0001\r!Z\u0001\fC\u000e\u001cWm]:U_.,g.\u0001\u000bsKF,Xm\u001d;BkRDwN]5{CRLwN\\\u000b\u0002wB\u0019\u0011\f\u0018?\u0011\u0005\rj\u0018B\u0001@\u0014\u0005U\tU\u000f\u001e5pe&T\u0018\r^5p]J+7\u000f]8og\u0016\f!c^1ji\u001a{'/Q2dKN\u001cHk\\6f]R\u0019A-a\u0001\t\r\u0005\u0015Q\u00021\u0001}\u0003!\u0011Xm\u001d9p]N,\u0017a\u00049pY2LgnZ*dQ\u0016$W\u000f\\3\u0015\r\u0005-\u0011QDA\u0016!%Q\u0016QBA\t\u0003/\t9\"C\u0002\u0002\u0010]\u0011\u0001bU2iK\u0012,H.\u001a\t\u00047\u0005M\u0011bAA\u000b9\t\u0019\u0011I\\=\u0011\u0007\r\nI\"C\u0002\u0002\u001cM\u00111#Q2dKN\u001cHk\\6f]J+7\u000f]8og\u0016Dq!a\b\u000f\u0001\u0004\t\t#\u0001\u0005j]R,'O^1m!\rI\u00161E\u0005\u0005\u0003K\t9C\u0001\u0005EkJ\fG/[8o\u0013\r\tIc\u0006\u0002\u000f\tV\u0014\u0018\r^5p]6{G-\u001e7f\u0011\u001d\tiC\u0004a\u0001\u0003C\t\u0011\"\u001a=qSJ,7/\u00138\u0002'I,\u0017/^3tiJ+gM]3tQR{7.\u001a8\u0015\u0007\u0011\f\u0019\u0004\u0003\u0004\u00026=\u0001\r!P\u0001\re\u00164'/Z:i)>\\WM\\\u0001\u0010aJ|7-Z:t%\u0016\u001c\bo\u001c8tKR)A-a\u000f\u0002>!9\u0011Q\u0001\tA\u0002\u0005]\u0001bBA\u001b!\u0001\u0007\u0011q\b\t\u000471l\u0014AC5oM>\u0014X.V:feR!\u0011QIA'!\u0011I\u0016/a\u0012\u0011\u0007m\tI%C\u0002\u0002Lq\u0011A!\u00168ji\"1\u0011QA\tA\u0002q\u0004")
public class OAuth2 {
    private final OAuth2Provider provider;
    private final Path file;
    private final List<String> scope;
    private final HttpClient client;

    public HttpClient client() {
        return this.client;
    }

    public ZIO<Object, Throwable, OAuth2Token> loadOrAuthorize() {
        return Clock$.MODULE$.currentDateTime((Object)"zio.cli.oauth2.OAuth2.loadOrAuthorize(OAuth2.scala:17)").flatMap((Function1 & Serializable)time -> this.loadFromFile().flatMap((Function1 & Serializable)x0$1 -> {
            boolean bl = false;
            Some some = null;
            if (x0$1 instanceof Some) {
                bl = true;
                some = (Some)x0$1;
                AccessToken accessToken = (AccessToken)some.value();
                if (accessToken.expiresAt().forall((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isAfter(time)))) {
                    return ZIO$.MODULE$.succeed((Function0 & Serializable)() -> accessToken, (Object)"zio.cli.oauth2.OAuth2.loadOrAuthorize(OAuth2.scala:20)");
                }
            }
            if (bl) {
                AccessToken accessToken = (AccessToken)some.value();
                return this.refreshAccessToken(accessToken);
            }
            return this.authorize();
        }, (Object)"zio.cli.oauth2.OAuth2.loadOrAuthorize(OAuth2.scala:18)").flatMap((Function1 & Serializable)initialToken -> this.makeOAuth2Token((AccessToken)initialToken), (Object)"zio.cli.oauth2.OAuth2.loadOrAuthorize(OAuth2.scala:25)"), (Object)"zio.cli.oauth2.OAuth2.loadOrAuthorize(OAuth2.scala:17)");
    }

    public ZIO<Object, Throwable, AccessToken> authorize() {
        return this.requestAuthorization().tap((Function1 & Serializable)response -> this.informUser((AuthorizationResponse)response), (Object)"zio.cli.oauth2.OAuth2.authorize(OAuth2.scala:32)").flatMap((Function1 & Serializable)response -> this.waitForAccessToken((AuthorizationResponse)response), (Object)"zio.cli.oauth2.OAuth2.authorize(OAuth2.scala:32)");
    }

    public ZIO<Object, Throwable, Option<AccessToken>> loadFromFile() {
        return ZIO$.MODULE$.readFile((Function0 & Serializable)() -> $this.file, (Object)"zio.cli.oauth2.OAuth2.loadFromFile(OAuth2.scala:39)", DummyImplicit$.MODULE$.dummyImplicit()).option(CanFail$.MODULE$.canFail(), (Object)"zio.cli.oauth2.OAuth2.loadFromFile(OAuth2.scala:39)").map((Function1 & Serializable)x$2 -> x$2.flatMap((Function1 & Serializable)x$3 -> package.DecoderOps$.MODULE$.fromJson$extension(zio.json.package$.MODULE$.DecoderOps((CharSequence)x$3), JsonDecoder$.MODULE$.fromCodec(AccessToken$.MODULE$.stateJsonCodec())).toOption()), (Object)"zio.cli.oauth2.OAuth2.loadFromFile(OAuth2.scala:39)");
    }

    public ZIO<Object, Nothing$, OAuth2Token> makeOAuth2Token(AccessToken initialToken) {
        return Ref.Synchronized$.MODULE$.make((Function0 & Serializable)() -> initialToken, (Object)"zio.cli.oauth2.OAuth2.makeOAuth2Token(OAuth2.scala:50)").map((Function1 & Serializable)ref -> new OAuth2Token(this, (Ref.Synchronized)ref){
            private final ZIO<Object, Throwable, BoxedUnit> refreshTokenNow;
            private final ZIO<Object, Throwable, AccessToken> accessToken;
            private final /* synthetic */ OAuth2 $outer;

            public ZIO<Object, Throwable, BoxedUnit> refreshTokenNow() {
                return this.refreshTokenNow;
            }

            public ZIO<Object, Throwable, AccessToken> accessToken() {
                return this.accessToken;
            }

            public static final /* synthetic */ boolean $anonfun$accessToken$3(OffsetDateTime time$2, OffsetDateTime x$4) {
                return x$4.isBefore(time$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.refreshTokenNow = ref$1.updateZIO((Function1 & Serializable)accessToken -> $this.$outer.refreshAccessToken((AccessToken)accessToken), (Object)"zio.cli.oauth2.OAuth2.makeOAuth2Token.$anon.refreshTokenNow(OAuth2.scala:53)");
                this.accessToken = ref$1.updateAndGetZIO((Function1 & Serializable)acc -> Clock$.MODULE$.currentDateTime((Object)"zio.cli.oauth2.OAuth2.makeOAuth2Token.$anon.accessToken(OAuth2.scala:56)").flatMap((Function1 & Serializable)time -> {
                    boolean bl;
                    Option option = acc.expiresAt().map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)$anon$1.$anonfun$accessToken$3(time, x$4)));
                    if (option instanceof Some && (bl = BoxesRunTime.unboxToBoolean((Object)((Some)option).value()))) {
                        return $this.$outer.refreshAccessToken((AccessToken)acc);
                    }
                    return ZIO$.MODULE$.succeed((Function0 & Serializable)() -> acc, (Object)"zio.cli.oauth2.OAuth2.makeOAuth2Token.$anon.accessToken(OAuth2.scala:61)");
                }, (Object)"zio.cli.oauth2.OAuth2.makeOAuth2Token.$anon.accessToken(OAuth2.scala:56)"), (Object)"zio.cli.oauth2.OAuth2.makeOAuth2Token.$anon.accessToken(OAuth2.scala:55)");
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$accessToken$1(zio.cli.oauth2.OAuth2$$anon$1 zio.cli.oauth2.AccessToken ), $anonfun$accessToken$2(zio.cli.oauth2.OAuth2$$anon$1 zio.cli.oauth2.AccessToken java.time.OffsetDateTime ), $anonfun$accessToken$3$adapted(java.time.OffsetDateTime java.time.OffsetDateTime ), $anonfun$accessToken$4(zio.cli.oauth2.AccessToken ), $anonfun$refreshTokenNow$1(zio.cli.oauth2.OAuth2$$anon$1 zio.cli.oauth2.AccessToken )}, serializedLambda);
            }
        }, (Object)"zio.cli.oauth2.OAuth2.makeOAuth2Token(OAuth2.scala:51)");
    }

    public ZIO<Object, Throwable, AccessToken> refreshAccessToken(AccessToken accessToken) {
        return (ZIO)accessToken.refreshToken().fold((Function0 & Serializable)() -> this.authorize(), (Function1 & Serializable)refreshToken -> this.requestRefreshToken((String)refreshToken));
    }

    public ZIO<Object, Throwable, AuthorizationResponse> requestAuthorization() {
        return ZIO$.MODULE$.fromCompletableFuture((Function0 & Serializable)() -> this.client().sendAsync($this.provider.authorizationRequest($this.scope), HttpResponse.BodyHandlers.ofString()), (Object)"zio.cli.oauth2.OAuth2.requestAuthorization(OAuth2.scala:82)").flatMap((Function1 & Serializable)response -> {
            if (response.statusCode() == 200) {
                return ZIO$.MODULE$.fromEither((Function0 & Serializable)() -> $this.provider.decodeAuthorizationResponse((String)response.body()), (Object)"zio.cli.oauth2.OAuth2.requestAuthorization(OAuth2.scala:91)").mapError((Function1 & Serializable)e -> new Exception(new StringBuilder(56).append("Response of authorization request could not be decoded: ").append((String)e).toString()), CanFail$.MODULE$.canFail(), (Object)"zio.cli.oauth2.OAuth2.requestAuthorization(OAuth2.scala:92)");
            }
            return ZIO$.MODULE$.fail((Function0 & Serializable)() -> new Exception(new StringBuilder(65).append("Authorization server returned error after authorization request: ").append(response.body()).toString()), (Object)"zio.cli.oauth2.OAuth2.requestAuthorization(OAuth2.scala:94)");
        }, (Object)"zio.cli.oauth2.OAuth2.requestAuthorization(OAuth2.scala:88)");
    }

    public ZIO<Object, Throwable, AccessToken> waitForAccessToken(AuthorizationResponse response2) {
        return ZIO$.MODULE$.fromCompletableFuture((Function0 & Serializable)() -> this.client().sendAsync($this.provider.accessTokenRequest(response2), HttpResponse.BodyHandlers.ofString()), (Object)"zio.cli.oauth2.OAuth2.waitForAccessToken(OAuth2.scala:102)").flatMap((Function1 & Serializable)response -> ZIO$.MODULE$.fromEither((Function0 & Serializable)() -> $this.provider.decodeAccessTokenResponse((String)response.body()).left().map((Function1 & Serializable)e -> new Exception(new StringBuilder(55).append("Response of access token request could not be decoded: ").append((String)e).toString())), (Object)"zio.cli.oauth2.OAuth2.waitForAccessToken(OAuth2.scala:109)"), (Object)"zio.cli.oauth2.OAuth2.waitForAccessToken(OAuth2.scala:108)").repeat((Function0 & Serializable)() -> this.pollingSchedule(response2.interval(), response2.expiresIn()), (Object)"zio.cli.oauth2.OAuth2.waitForAccessToken(OAuth2.scala:116)").flatMap((Function1 & Serializable)res -> this.processResponse((AccessTokenResponse)res, (Option<String>)None$.MODULE$), (Object)"zio.cli.oauth2.OAuth2.waitForAccessToken(OAuth2.scala:117)");
    }

    public Schedule<Object, AccessTokenResponse, AccessTokenResponse> pollingSchedule(Duration interval, Duration expiresIn) {
        Schedule delays = Schedule$.MODULE$.identity().map((Function1 & Serializable)x0$1 -> {
            if (x0$1 instanceof AccessTokenResponse.Error) {
                AccessTokenResponse.Error error = (AccessTokenResponse.Error)x0$1;
                AccessTokenResponse.Error.Kind kind = error.error();
                AccessTokenResponse$Error$Kind$SlowDown$ accessTokenResponse$Error$Kind$SlowDown$ = AccessTokenResponse$Error$Kind$SlowDown$.MODULE$;
                if (kind != null && kind.equals(accessTokenResponse$Error$Kind$SlowDown$)) {
                    return error.interval().orElse((Function0 & Serializable)() -> new Some((Object)DurationSyntax$.MODULE$.seconds$extension(package$.MODULE$.durationInt(5))));
                }
            }
            return None$.MODULE$;
        }, (Object)"zio.cli.oauth2.OAuth2.pollingSchedule.delays(OAuth2.scala:151)").addDelay((Function1 & Serializable)x$5 -> (Duration)x$5.getOrElse((Function0 & Serializable)() -> Duration$.MODULE$.Zero()), (Object)"zio.cli.oauth2.OAuth2.pollingSchedule.delays(OAuth2.scala:158)").fold((Object)interval, (Function2 & Serializable)(x0$2, x1$1) -> {
            if (x1$1 instanceof Some) {
                Duration interval = (Duration)((Some)x1$1).value();
                return DurationOps$.MODULE$.$plus$extension(package$.MODULE$.duration2DurationOps(x0$2), interval);
            }
            return x0$2;
        }, (Object)"zio.cli.oauth2.OAuth2.pollingSchedule.delays(OAuth2.scala:160)");
        return Schedule$.MODULE$.delayed(delays, (Object)"zio.cli.oauth2.OAuth2.pollingSchedule(OAuth2.scala:165)").$times$greater(Schedule$.MODULE$.recurWhile((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)OAuth2.$anonfun$pollingSchedule$6(x$6)), (Object)"zio.cli.oauth2.OAuth2.pollingSchedule(OAuth2.scala:167)").upTo(expiresIn, (Object)"zio.cli.oauth2.OAuth2.pollingSchedule(OAuth2.scala:172)"), (Object)"zio.cli.oauth2.OAuth2.pollingSchedule(OAuth2.scala:165)");
    }

    public ZIO<Object, Throwable, AccessToken> requestRefreshToken(String refreshToken) {
        return ZIO$.MODULE$.fromEither((Function0 & Serializable)() -> $this.provider.refreshTokenRequest(refreshToken).toRight((Function0 & Serializable)() -> new Exception("Authorization server does not support refresh tokens.")), (Object)"zio.cli.oauth2.OAuth2.requestRefreshToken(OAuth2.scala:180)").flatMap((Function1 & Serializable)request -> ZIO$.MODULE$.fromCompletableFuture((Function0 & Serializable)() -> this.client().sendAsync((HttpRequest)request, HttpResponse.BodyHandlers.ofString()), (Object)"zio.cli.oauth2.OAuth2.requestRefreshToken(OAuth2.scala:185)"), (Object)"zio.cli.oauth2.OAuth2.requestRefreshToken(OAuth2.scala:185)").flatMap((Function1 & Serializable)response -> {
            if (response.statusCode() == 200) {
                return ZIO$.MODULE$.fromEither((Function0 & Serializable)() -> $this.provider.decodeAccessTokenResponse((String)response.body()).left().map((Function1 & Serializable)e -> new Exception(new StringBuilder(56).append("Response of refresh token request could not be decoded: ").append((String)e).toString())), (Object)"zio.cli.oauth2.OAuth2.requestRefreshToken(OAuth2.scala:189)");
            }
            return ZIO$.MODULE$.fail((Function0 & Serializable)() -> new Exception(new StringBuilder(65).append("Authorization server returned error after refresh token request: ").append(response.body()).toString()), (Object)"zio.cli.oauth2.OAuth2.requestRefreshToken(OAuth2.scala:196)");
        }, (Object)"zio.cli.oauth2.OAuth2.requestRefreshToken(OAuth2.scala:186)").flatMap((Function1 & Serializable)res -> this.processResponse((AccessTokenResponse)res, (Option<String>)new Some((Object)refreshToken)), (Object)"zio.cli.oauth2.OAuth2.requestRefreshToken(OAuth2.scala:201)");
    }

    public ZIO<Object, Throwable, AccessToken> processResponse(AccessTokenResponse response, Option<String> refreshToken) {
        if (response instanceof AccessTokenResponse.Error) {
            AccessTokenResponse.Error error = (AccessTokenResponse.Error)response;
            String description = (String)error.errorDescription().map((Function1 & Serializable)d -> new StringBuilder(21).append(" and with message: '").append((String)d).append("'").toString()).getOrElse((Function0 & Serializable)() -> "");
            String uri2 = (String)error.errorUri().map((Function1 & Serializable)uri -> new StringBuilder(29).append(" For more information visit: ").append((String)uri).toString()).getOrElse((Function0 & Serializable)() -> "");
            return ZIO$.MODULE$.fail((Function0 & Serializable)() -> new Exception(new StringBuilder(45).append("Authorization server returned error of type ").append(error.error()).append(description).append(".").append(uri2).toString()), (Object)"zio.cli.oauth2.OAuth2.processResponse(OAuth2.scala:213)");
        }
        if (response instanceof AccessTokenResponse.AccessToken) {
            AccessTokenResponse.AccessToken accessToken = (AccessTokenResponse.AccessToken)response;
            return Clock$.MODULE$.currentDateTime((Object)"zio.cli.oauth2.OAuth2.processResponse(OAuth2.scala:215)").map((Function1 & Serializable)time -> new AccessToken(accessToken.accessToken(), accessToken.tokenType(), (Option<OffsetDateTime>)accessToken.expiresIn().map((Function1 & Serializable)exp -> time.plus((TemporalAmount)exp)), (Option<String>)accessToken.refreshToken().orElse((Function0 & Serializable)() -> refreshToken), accessToken.scope()), (Object)"zio.cli.oauth2.OAuth2.processResponse(OAuth2.scala:216)").tap((Function1 & Serializable)token -> ZIO$.MODULE$.writeFile((Function0 & Serializable)() -> $this.file, (Function0 & Serializable)() -> package.EncoderOps$.MODULE$.toJson$extension(zio.json.package$.MODULE$.EncoderOps(token), JsonEncoder$.MODULE$.fromCodec(AccessToken$.MODULE$.stateJsonCodec())), (Object)"zio.cli.oauth2.OAuth2.processResponse(OAuth2.scala:225)", DummyImplicit$.MODULE$.dummyImplicit()), (Object)"zio.cli.oauth2.OAuth2.processResponse(OAuth2.scala:225)");
        }
        throw new MatchError((Object)response);
    }

    public ZIO<Object, Nothing$, BoxedUnit> informUser(AuthorizationResponse response) {
        return Clock$.MODULE$.localDateTime((Object)"zio.cli.oauth2.OAuth2.informUser(OAuth2.scala:232)").map((Function1 & Serializable)time -> {
            int boxUrlLength = response.verificationUri().length() + 2;
            int boxCodeLength = response.userCode().length() + 2;
            long expiresIn = response.expiresIn().toMinutes();
            LocalTime expiresAt = time.plus(response.expiresIn()).withNano(0).toLocalTime();
            return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(447).append("| >>\n          | >>  Application requests to perform OAuth2\n          | >>  authorization.\n          | >>\n          | >>  Visit following URL in a browser:\n          | >>\n          | >>   \u250f").append(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("\u2501"), boxUrlLength)).append("\u2513\n          | >>   \u2503 ").append(response.verificationUri()).append(" \u2503\n          | >>   \u2517").append(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("\u2501"), boxUrlLength)).append("\u251b\n          | >>\n          | >>  And enter following code:\n          | >>\n          | >>   \u250f").append(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("\u2501"), boxCodeLength)).append("\u2513\n          | >>   \u2503 ").append(response.userCode()).append(" \u2503\n          | >>   \u2517").append(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("\u2501"), boxCodeLength)).append("\u251b\n          | >>\n          | >>  Code will expire in ").append(expiresIn).append(" minutes at ").append(expiresAt).append(".\n          | >>\n").toString()));
        }, (Object)"zio.cli.oauth2.OAuth2.informUser(OAuth2.scala:232)").flatMap((Function1 & Serializable)text -> Console$.MODULE$.printLine((Function0 & Serializable)() -> new StringBuilder(11).append((String)text).append("\nWaiting...").toString(), (Object)"zio.cli.oauth2.OAuth2.informUser(OAuth2.scala:258)").orDie(IsSubtypeOfError$.MODULE$.impl((.less.colon.less)$less$colon$less$.MODULE$.refl()), CanFail$.MODULE$.canFail(), (Object)"zio.cli.oauth2.OAuth2.informUser(OAuth2.scala:258)"), (Object)"zio.cli.oauth2.OAuth2.informUser(OAuth2.scala:258)");
    }

    public static final /* synthetic */ boolean $anonfun$pollingSchedule$6(AccessTokenResponse x$6) {
        block2: {
            block4: {
                block3: {
                    if (!(x$6 instanceof AccessTokenResponse.Error)) break block2;
                    AccessTokenResponse.Error error = (AccessTokenResponse.Error)x$6;
                    AccessTokenResponse.Error.Kind kind = error.error();
                    AccessTokenResponse$Error$Kind$AuthorizationPending$ accessTokenResponse$Error$Kind$AuthorizationPending$ = AccessTokenResponse$Error$Kind$AuthorizationPending$.MODULE$;
                    if (kind != null && kind.equals(accessTokenResponse$Error$Kind$AuthorizationPending$)) break block3;
                    AccessTokenResponse.Error.Kind kind2 = error.error();
                    AccessTokenResponse$Error$Kind$SlowDown$ accessTokenResponse$Error$Kind$SlowDown$ = AccessTokenResponse$Error$Kind$SlowDown$.MODULE$;
                    if (kind2 == null || !kind2.equals(accessTokenResponse$Error$Kind$SlowDown$)) break block4;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public OAuth2(OAuth2Provider provider, Path file, List<String> scope) {
        this.provider = provider;
        this.file = file;
        this.scope = scope;
        this.client = HttpClient.newBuilder().build();
    }
}

