/*
 * Decompiled with CFR 0.152.
 */
package izumi.reflect.thirdparty.internal.boopickle;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001Q3a\u0001C\u0005\u0002\u0002=\u0019\u0002\"\u0002\u000e\u0001\t\u0003a\u0002\"B\u0010\u0001\t\u0003\u0001\u0003\"B\u001e\u0001\t\u0003a\u0004\"\u0002#\u0001\t\u0003)\u0005\"\u0002%\u0001\t\u0003I\u0005\"\u0002'\u0001\t#i\u0005\"\u0002)\u0001\t#\t&aD*ue&twmQ8eK\u000e4\u0015m\u001d;\u000b\u0005)Y\u0011!\u00032p_BL7m\u001b7f\u0015\taQ\"\u0001\u0005j]R,'O\\1m\u0015\tqq\"\u0001\u0006uQ&\u0014H\r]1sifT!\u0001E\t\u0002\u000fI,g\r\\3di*\t!#A\u0003juVl\u0017n\u0005\u0002\u0001)A\u0011Q\u0003G\u0007\u0002-)\tq#A\u0003tG\u0006d\u0017-\u0003\u0002\u001a-\t1\u0011I\\=SK\u001a\fa\u0001P5oSRt4\u0001\u0001\u000b\u0002;A\u0011a\u0004A\u0007\u0002\u0013\u0005QA-Z2pI\u00164\u0015m\u001d;\u0015\u0007\u0005b\u0013\u0007\u0005\u0002#S9\u00111e\n\t\u0003IYi\u0011!\n\u0006\u0003Mm\ta\u0001\u0010:p_Rt\u0014B\u0001\u0015\u0017\u0003\u0019\u0001&/\u001a3fM&\u0011!f\u000b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005!2\u0002\"B\u0017\u0003\u0001\u0004q\u0013a\u00017f]B\u0011QcL\u0005\u0003aY\u00111!\u00138u\u0011\u0015\u0011$\u00011\u00014\u0003\r\u0011WO\u001a\t\u0003iej\u0011!\u000e\u0006\u0003m]\n1A\\5p\u0015\u0005A\u0014\u0001\u00026bm\u0006L!AO\u001b\u0003\u0015\tKH/\u001a\"vM\u001a,'/\u0001\u0006f]\u000e|G-\u001a$bgR$2!\u0010!C!\t)b(\u0003\u0002@-\t!QK\\5u\u0011\u0015\t5\u00011\u0001\"\u0003\u0005\u0019\b\"B\"\u0004\u0001\u0004\u0019\u0014A\u00012c\u0003=)gnY8eK\u001a\u000b7\u000f^!se\u0006LHcA\u001fG\u000f\")\u0011\t\u0002a\u0001C!)1\t\u0002a\u0001g\u0005iQM\\2pI\u00164\u0015m\u001d;Ck\u001a$2!\u0010&L\u0011\u0015\tU\u00011\u0001\"\u0011\u0015\u0019U\u00011\u00014\u0003=!WmY8eK\u001a\u000b7\u000f^!se\u0006LHcA\u0011O\u001f\")QF\u0002a\u0001]!)!G\u0002a\u0001g\u0005iA-Z2pI\u00164\u0015m\u001d;Ck\u001a$2!\t*T\u0011\u0015is\u00011\u0001/\u0011\u0015\u0011t\u00011\u00014\u0001")
public abstract class StringCodecFast {
    public String decodeFast(int len, ByteBuffer buf) {
        if (buf.hasArray()) {
            return this.decodeFastArray(len, buf);
        }
        return this.decodeFastBuf(len, buf);
    }

    public void encodeFast(String s, ByteBuffer bb) {
        if (bb.hasArray()) {
            this.encodeFastArray(s, bb);
            return;
        }
        this.encodeFastBuf(s, bb);
    }

    public void encodeFastArray(String s, ByteBuffer bb) {
        char c;
        int len = s.length();
        byte[] buf = bb.array();
        int dst = bb.arrayOffset() + bb.position();
        int src = 0;
        while (src < len && (c = s.charAt(src)) < '\u0080') {
            buf[dst] = (byte)c;
            ++src;
            ++dst;
        }
        while (src < len) {
            c = s.charAt(src);
            if (c < '\u0080') {
                buf[dst] = (byte)c;
                ++dst;
            } else if (c < '\u4000') {
                buf[dst] = (byte)(0x80 | c & 0x3F);
                buf[dst + 1] = (byte)(c >> 6 & 0xFF);
                dst += 2;
            } else {
                buf[dst] = (byte)(0xC0 | c & 0x3F);
                buf[dst + 1] = (byte)(c >> 6 & 0xFF);
                buf[dst + 2] = (byte)(c >> 14);
                dst += 3;
            }
            ++src;
        }
        ((Buffer)bb).position(dst - bb.arrayOffset());
    }

    public void encodeFastBuf(String s, ByteBuffer bb) {
        char c;
        int src;
        int len = s.length();
        for (src = 0; src < len && (c = s.charAt(src)) < '\u0080'; ++src) {
            bb.put((byte)c);
        }
        while (src < len) {
            c = s.charAt(src);
            if (c < '\u0080') {
                bb.put((byte)c);
            } else if (c < '\u4000') {
                bb.put((byte)(0x80 | c & 0x3F));
                bb.put((byte)(c >> 6 & 0xFF));
            } else {
                bb.put((byte)(0xC0 | c & 0x3F));
                bb.put((byte)(c >> 6 & 0xFF));
                bb.put((byte)(c >> 14));
            }
            ++src;
        }
    }

    public String decodeFastArray(int len, ByteBuffer buf) {
        char[] cp = new char[len];
        byte[] src = buf.array();
        int offset = buf.arrayOffset() + buf.position();
        for (int dst = 0; dst < len; ++dst) {
            byte b = src[offset];
            ++offset;
            if ((b & 0x80) == 0) {
                cp[dst] = (char)(b & 0x7F);
                continue;
            }
            if ((b & 0xC0) == 128) {
                byte b1 = src[offset];
                ++offset;
                cp[dst] = (char)(b & 0x3F | (b1 & 0xFF) << 6);
                continue;
            }
            byte b1 = src[offset];
            byte b2 = src[offset + 1];
            offset += 2;
            cp[dst] = (char)(b & 0x3F | (b1 & 0xFF) << 6 | b2 << 14);
        }
        ((Buffer)buf).position(offset - buf.arrayOffset());
        return new String(cp);
    }

    public String decodeFastBuf(int len, ByteBuffer buf) {
        char[] cp = new char[len];
        int i = 0;
        for (int dst = 0; dst < len; ++dst) {
            byte b = buf.get();
            if ((b & 0x80) == 0) {
                cp[dst] = (char)(b & 0x7F);
            } else if ((b & 0xC0) == 128) {
                byte b1 = buf.get();
                ++i;
                cp[dst] = (char)(b & 0x3F | (b1 & 0xFF) << 6);
            } else {
                byte b1 = buf.get();
                byte b2 = buf.get();
                i += 2;
                cp[dst] = (char)(b & 0x3F | (b1 & 0xFF) << 6 | b2 << 14);
            }
            ++i;
        }
        return new String(cp);
    }
}

