/*
 * Decompiled with CFR 0.152.
 */
package dev.lydtech.component.framework.client.kafka;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.header.internals.RecordHeader;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.awaitility.Awaitility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KafkaClient {
    private static final Logger log = LoggerFactory.getLogger(KafkaClient.class);
    private static String brokerUrl;
    private static KafkaClient instance;

    private KafkaClient() {
        String kafkaHost = Optional.ofNullable(System.getProperty("docker.host")).orElse("localhost");
        String kafkaPort = Optional.ofNullable(System.getProperty("kafka.mapped.port")).orElseThrow(() -> new RuntimeException("kafka.mapped.port property not found"));
        brokerUrl = "http://" + kafkaHost + ":" + kafkaPort;
        log.info("Kafka broker URL is: " + brokerUrl);
    }

    public static synchronized KafkaClient getInstance() {
        if (instance == null) {
            instance = new KafkaClient();
        }
        return instance;
    }

    public Consumer createConsumer(String groupId, String topic) {
        Properties config = new Properties();
        config.put("bootstrap.servers", brokerUrl);
        config.put("group.id", groupId + "-" + topic);
        config.put("key.deserializer", StringDeserializer.class);
        config.put("value.deserializer", StringDeserializer.class);
        config.put("auto.offset.reset", "latest");
        config.put("metadata.max.age.ms", (Object)1000);
        KafkaConsumer consumer = new KafkaConsumer(config);
        consumer.subscribe(Collections.singletonList(topic));
        return consumer;
    }

    public Producer<Long, String> createProducer() {
        Properties config = new Properties();
        config.put("bootstrap.servers", brokerUrl);
        config.put("key.serializer", StringSerializer.class);
        config.put("value.serializer", StringSerializer.class);
        return new KafkaProducer(config);
    }

    public void sendMessage(String topic, String key, String payload) throws Exception {
        this.sendMessage(topic, key, payload, null);
    }

    public void sendMessage(String topic, String key, String payload, Map<String, String> headers) throws Exception {
        ArrayList recordHeaders = new ArrayList();
        if (headers != null && headers.size() > 0) {
            headers.forEach((headerKey, headerValue) -> recordHeaders.add(new RecordHeader(headerKey, headerValue != null ? headerValue.getBytes() : null)));
        }
        ProducerRecord record = new ProducerRecord(topic, null, (Object)key, (Object)payload, recordHeaders);
        RecordMetadata metadata = (RecordMetadata)this.createProducer().send(record).get();
        log.debug(String.format("Sent record(key=%s value=%s) meta(topic=%s, partition=%d, offset=%d)", record.key(), record.value(), metadata.topic(), metadata.partition(), metadata.offset()));
    }

    public List<ConsumerRecord<String, String>> consumeAndAssert(String testName, Consumer consumer, int expectedEventCount, int furtherPolls) throws Exception {
        AtomicInteger totalReceivedEvents = new AtomicInteger();
        AtomicInteger totalExtraPolls = new AtomicInteger(-1);
        AtomicInteger pollCount = new AtomicInteger();
        ArrayList<ConsumerRecord<String, String>> events = new ArrayList<ConsumerRecord<String, String>>();
        Awaitility.await().atMost(30L, TimeUnit.SECONDS).pollInterval(1L, TimeUnit.SECONDS).until(() -> {
            ConsumerRecords consumerRecords = consumer.poll(Duration.ofMillis(100L));
            consumerRecords.forEach(record -> {
                log.info(testName + " - received: " + (String)record.value());
                totalReceivedEvents.incrementAndGet();
                events.add((ConsumerRecord<String, String>)record);
            });
            if (totalReceivedEvents.get() == expectedEventCount) {
                totalExtraPolls.incrementAndGet();
            }
            pollCount.getAndIncrement();
            log.info(testName + " - poll count: " + pollCount.get() + " - received count: " + totalReceivedEvents.get());
            return totalReceivedEvents.get() == expectedEventCount && totalExtraPolls.get() == furtherPolls;
        });
        return events;
    }
}

