/*
 * Decompiled with CFR 0.152.
 */
package dev.lydtech.component.framework.extension;

import dev.lydtech.component.framework.extension.TestContainersConfiguration;
import io.debezium.testing.testcontainers.DebeziumContainer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.NewTopic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.KafkaContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.PostgreSQLContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.lifecycle.Startable;
import org.testcontainers.utility.DockerImageName;

public final class TestContainersManager {
    private static final Logger log = LoggerFactory.getLogger(TestContainersManager.class);
    private Network network;
    private List<GenericContainer> serviceContainers;
    private GenericContainer postgresContainer;
    private KafkaContainer kafkaContainer;
    private DebeziumContainer debeziumContainer;
    private GenericContainer wiremockContainer;

    private TestContainersManager() {
    }

    protected static void initialise() {
        TestContainersManager manager = new TestContainersManager();
        log.info("Creating test containers...");
        manager.createContainers();
        log.info("Starting test containers...");
        manager.startContainers();
        log.info("Started test containers.");
    }

    private void createContainers() {
        if (TestContainersConfiguration.SERVICE_INSTANCE_COUNT < 1) {
            throw new RuntimeException("At least one service container should be started");
        }
        this.network = Network.newNetwork();
        if (TestContainersConfiguration.POSTGRES_ENABLED) {
            this.postgresContainer = this.createPostgresContainer();
        }
        if (TestContainersConfiguration.KAFKA_ENABLED) {
            this.kafkaContainer = this.createKafkaContainer();
        }
        if (TestContainersConfiguration.DEBEZIUM_ENABLED) {
            if (!TestContainersConfiguration.KAFKA_ENABLED || !TestContainersConfiguration.POSTGRES_ENABLED) {
                throw new RuntimeException("Kafka and Postgres must be enabled in order to use Debezium.");
            }
            this.debeziumContainer = this.createDebeziumContainer();
        }
        if (TestContainersConfiguration.WIREMOCK_ENABLED) {
            this.wiremockContainer = this.createWiremockContainer();
        }
        this.serviceContainers = IntStream.range(1, TestContainersConfiguration.SERVICE_INSTANCE_COUNT + 1).mapToObj(this::createServiceContainer).collect(Collectors.toList());
    }

    private void startContainers() {
        try {
            if (TestContainersConfiguration.POSTGRES_ENABLED) {
                this.postgresContainer.start();
            }
            if (TestContainersConfiguration.KAFKA_ENABLED) {
                this.kafkaContainer.start();
                this.createTopics();
            }
            if (TestContainersConfiguration.DEBEZIUM_ENABLED) {
                this.debeziumContainer.start();
            }
            if (TestContainersConfiguration.WIREMOCK_ENABLED) {
                this.wiremockContainer.start();
            }
            this.serviceContainers.stream().forEach(container -> container.start());
        }
        catch (Exception e) {
            log.error("Component test containers failed to start", (Throwable)e);
            throw e;
        }
    }

    private GenericContainer createServiceContainer(int instance) {
        String containerName = TestContainersConfiguration.SERVICE_NAME + "-" + instance;
        String configFileName = "/application.yml";
        String javaOpts = "-agentlib:jdwp=transport=dt_socket,server=y,suspend=n,address=*:" + TestContainersConfiguration.SERVICE_DEBUG_PORT + " -Xms512m -Xmx512m -Djava.security.egd=file:/dev/./urandom -Dspring.config.additional-location=file:" + configFileName;
        GenericContainer container = new GenericContainer(TestContainersConfiguration.CONTAINER_NAME_PREFIX + "/" + TestContainersConfiguration.SERVICE_NAME + ":" + TestContainersConfiguration.SERVICE_IMAGE_TAG).withEnv("JAVA_OPTS", javaOpts).withLabel("dev.lydtech.main-container-label", TestContainersConfiguration.CONTAINER_MAIN_LABEL).withFileSystemBind("./target/test-classes/application-component-test.yml", "/application.yml", BindMode.READ_ONLY).withExposedPorts(new Integer[]{TestContainersConfiguration.SERVICE_PORT, TestContainersConfiguration.SERVICE_DEBUG_PORT}).withNetwork(this.network).withNetworkAliases(new String[]{containerName}).withCreateContainerCmdModifier(cmd -> cmd.withName(TestContainersConfiguration.CONTAINER_NAME_PREFIX + "-" + containerName)).waitingFor(Wait.forHttp((String)"/actuator/health").forPort(TestContainersConfiguration.SERVICE_PORT).forStatusCode(200).withStartupTimeout(Duration.ofSeconds(TestContainersConfiguration.SERVICE_STARTUP_TIMEOUT_SECONDS)));
        if (TestContainersConfiguration.SERVICE_CONTAINER_LOGGING_ENABLED) {
            container.withLogConsumer((Consumer)this.getLogConsumer(containerName));
        }
        return container;
    }

    private GenericContainer createPostgresContainer() {
        String containerName = "postgres";
        GenericContainer container = ((PostgreSQLContainer)((PostgreSQLContainer)((PostgreSQLContainer)new PostgreSQLContainer(DockerImageName.parse((String)"debezium/postgres").asCompatibleSubstituteFor("postgres").withTag(TestContainersConfiguration.POSTGRES_IMAGE_TAG)).withDatabaseName(TestContainersConfiguration.POSTGRES_DATABASE_NAME).withUsername(TestContainersConfiguration.POSTGRES_USERNAME).withPassword(TestContainersConfiguration.POSTGRES_PASSWORD).withNetwork(this.network)).withNetworkAliases(new String[]{TestContainersConfiguration.POSTGRES_HOST_NAME})).withCreateContainerCmdModifier(cmd -> cmd.withName(TestContainersConfiguration.CONTAINER_NAME_PREFIX + "-" + containerName))).withExposedPorts(new Integer[]{TestContainersConfiguration.POSTGRES_PORT});
        if (TestContainersConfiguration.POSTGRES_CONTAINER_LOGGING_ENABLED) {
            container.withLogConsumer((Consumer)this.getLogConsumer(containerName));
        }
        return container;
    }

    private KafkaContainer createKafkaContainer() {
        String containerName = "kafka";
        KafkaContainer container = (KafkaContainer)((KafkaContainer)((KafkaContainer)new KafkaContainer(DockerImageName.parse((String)"confluentinc/cp-kafka").withTag(TestContainersConfiguration.KAFKA_CONFLUENT_IMAGE_TAG)).withNetwork(this.network)).withNetworkAliases(new String[]{containerName})).withCreateContainerCmdModifier(cmd -> cmd.withName(TestContainersConfiguration.CONTAINER_NAME_PREFIX + "-" + containerName));
        if (TestContainersConfiguration.KAFKA_CONTAINER_LOGGING_ENABLED) {
            container.withLogConsumer((Consumer)this.getLogConsumer(containerName));
        }
        return container;
    }

    private DebeziumContainer createDebeziumContainer() {
        String containerName = "debezium";
        DebeziumContainer container = (DebeziumContainer)((DebeziumContainer)((DebeziumContainer)((DebeziumContainer)((DebeziumContainer)new DebeziumContainer(DockerImageName.parse((String)"debezium/connect").withTag(TestContainersConfiguration.DEBEZIUM_IMAGE_TAG)).withNetwork(this.network)).withNetworkAliases(new String[]{containerName})).withKafka(this.kafkaContainer).withExposedPorts(new Integer[]{TestContainersConfiguration.DEBEZIUM_PORT})).dependsOn(new Startable[]{this.kafkaContainer})).withCreateContainerCmdModifier(cmd -> cmd.withName(TestContainersConfiguration.CONTAINER_NAME_PREFIX + "-" + containerName));
        if (TestContainersConfiguration.DEBEZIUM_CONTAINER_LOGGING_ENABLED) {
            container.withLogConsumer((Consumer)this.getLogConsumer(containerName));
        }
        return container;
    }

    private GenericContainer createWiremockContainer() {
        String containerName = "wiremock";
        GenericContainer container = new GenericContainer("wiremock/wiremock:" + TestContainersConfiguration.WIREMOCK_IMAGE_TAG).withNetwork(this.network).withNetworkAliases(new String[]{containerName}).withCreateContainerCmdModifier(cmd -> cmd.withName(TestContainersConfiguration.CONTAINER_NAME_PREFIX + "-" + containerName)).withClasspathResourceMapping("/wiremock", "/home/wiremock/mappings", BindMode.READ_WRITE).withExposedPorts(new Integer[]{TestContainersConfiguration.WIREMOCK_PORT}).waitingFor((WaitStrategy)Wait.forHttp((String)"/health").forStatusCode(204));
        if (TestContainersConfiguration.WIREMOCK_CONTAINER_LOGGING_ENABLED) {
            container.withLogConsumer((Consumer)this.getLogConsumer(containerName));
        }
        return container;
    }

    private void createTopics() {
        if (!TestContainersConfiguration.KAFKA_TOPICS.isEmpty()) {
            Properties properties = new Properties();
            properties.put("bootstrap.servers", this.kafkaContainer.getBootstrapServers());
            Admin admin = Admin.create((Properties)properties);
            ArrayList<NewTopic> newTopics = new ArrayList<NewTopic>(TestContainersConfiguration.KAFKA_TOPICS.size());
            int partitions = TestContainersConfiguration.KAFKA_TOPIC_PARTITION_COUNT;
            short replicationFactor = 1;
            for (String topicName : TestContainersConfiguration.KAFKA_TOPICS) {
                NewTopic newTopic = new NewTopic(topicName, partitions, replicationFactor);
                newTopics.add(newTopic);
            }
            CreateTopicsResult result = admin.createTopics(newTopics);
            try {
                result.all().get();
            }
            catch (InterruptedException | ExecutionException e) {
                log.error("Topic creation failed.", (Throwable)e);
                throw new RuntimeException("Topic creation failed: " + e.getMessage(), e);
            }
            log.info("Created topics: " + TestContainersConfiguration.KAFKA_TOPICS);
        }
    }

    private Slf4jLogConsumer getLogConsumer(String containerName) {
        return (Slf4jLogConsumer)new Slf4jLogConsumer(LoggerFactory.getLogger((String)("container." + containerName))).withRemoveAnsiCodes(false);
    }
}

