/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.openai;

import dev.ai4j.openai4j.chat.ChatCompletionChoice;
import dev.ai4j.openai4j.chat.ChatCompletionResponse;
import dev.ai4j.openai4j.chat.Delta;
import dev.ai4j.openai4j.chat.FunctionCall;
import dev.ai4j.openai4j.chat.ToolCall;
import dev.ai4j.openai4j.completion.CompletionChoice;
import dev.ai4j.openai4j.completion.CompletionResponse;
import dev.ai4j.openai4j.shared.Usage;
import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.openai.InternalOpenAiHelper;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class OpenAiStreamingResponseBuilder {
    private final StringBuffer contentBuilder = new StringBuffer();
    private final StringBuffer toolNameBuilder = new StringBuffer();
    private final StringBuffer toolArgumentsBuilder = new StringBuffer();
    private final Map<Integer, ToolExecutionRequestBuilder> indexToToolExecutionRequestBuilder = new ConcurrentHashMap<Integer, ToolExecutionRequestBuilder>();
    private volatile TokenUsage tokenUsage;
    private volatile FinishReason finishReason;

    public void append(ChatCompletionResponse partialResponse) {
        Delta delta;
        List choices;
        if (partialResponse == null) {
            return;
        }
        Usage usage = partialResponse.usage();
        if (usage != null) {
            this.tokenUsage = InternalOpenAiHelper.tokenUsageFrom(usage);
        }
        if ((choices = partialResponse.choices()) == null || choices.isEmpty()) {
            return;
        }
        ChatCompletionChoice chatCompletionChoice = (ChatCompletionChoice)choices.get(0);
        if (chatCompletionChoice == null) {
            return;
        }
        String finishReason = chatCompletionChoice.finishReason();
        if (finishReason != null) {
            this.finishReason = InternalOpenAiHelper.finishReasonFrom(finishReason);
        }
        if ((delta = chatCompletionChoice.delta()) == null) {
            return;
        }
        String content = delta.content();
        if (content != null) {
            this.contentBuilder.append(content);
            return;
        }
        if (delta.functionCall() != null) {
            FunctionCall functionCall = delta.functionCall();
            if (functionCall.name() != null) {
                this.toolNameBuilder.append(functionCall.name());
            }
            if (functionCall.arguments() != null) {
                this.toolArgumentsBuilder.append(functionCall.arguments());
            }
        }
        if (delta.toolCalls() != null && !delta.toolCalls().isEmpty()) {
            FunctionCall functionCall;
            ToolCall toolCall = (ToolCall)delta.toolCalls().get(0);
            ToolExecutionRequestBuilder toolExecutionRequestBuilder = this.indexToToolExecutionRequestBuilder.computeIfAbsent(toolCall.index(), idx -> new ToolExecutionRequestBuilder());
            if (toolCall.id() != null) {
                toolExecutionRequestBuilder.idBuilder.append(toolCall.id());
            }
            if ((functionCall = toolCall.function()).name() != null) {
                toolExecutionRequestBuilder.nameBuilder.append(functionCall.name());
            }
            if (functionCall.arguments() != null) {
                toolExecutionRequestBuilder.argumentsBuilder.append(functionCall.arguments());
            }
        }
    }

    public void append(CompletionResponse partialResponse) {
        String token;
        List choices;
        if (partialResponse == null) {
            return;
        }
        Usage usage = partialResponse.usage();
        if (usage != null) {
            this.tokenUsage = InternalOpenAiHelper.tokenUsageFrom(usage);
        }
        if ((choices = partialResponse.choices()) == null || choices.isEmpty()) {
            return;
        }
        CompletionChoice completionChoice = (CompletionChoice)choices.get(0);
        if (completionChoice == null) {
            return;
        }
        String finishReason = completionChoice.finishReason();
        if (finishReason != null) {
            this.finishReason = InternalOpenAiHelper.finishReasonFrom(finishReason);
        }
        if ((token = completionChoice.text()) != null) {
            this.contentBuilder.append(token);
        }
    }

    public Response<AiMessage> build() {
        String text = this.contentBuilder.toString();
        String toolName = this.toolNameBuilder.toString();
        if (!toolName.isEmpty()) {
            ToolExecutionRequest toolExecutionRequest = ToolExecutionRequest.builder().name(toolName).arguments(this.toolArgumentsBuilder.toString()).build();
            AiMessage aiMessage = Utils.isNullOrBlank((String)text) ? AiMessage.from((ToolExecutionRequest[])new ToolExecutionRequest[]{toolExecutionRequest}) : AiMessage.from((String)text, Collections.singletonList(toolExecutionRequest));
            return Response.from((Object)aiMessage, (TokenUsage)this.tokenUsage, (FinishReason)this.finishReason);
        }
        if (!this.indexToToolExecutionRequestBuilder.isEmpty()) {
            List toolExecutionRequests = this.indexToToolExecutionRequestBuilder.values().stream().map(it -> ToolExecutionRequest.builder().id(it.idBuilder.toString()).name(it.nameBuilder.toString()).arguments(it.argumentsBuilder.toString()).build()).collect(Collectors.toList());
            AiMessage aiMessage = Utils.isNullOrBlank((String)text) ? AiMessage.from(toolExecutionRequests) : AiMessage.from((String)text, toolExecutionRequests);
            return Response.from((Object)aiMessage, (TokenUsage)this.tokenUsage, (FinishReason)this.finishReason);
        }
        if (!Utils.isNullOrBlank((String)text)) {
            return Response.from((Object)AiMessage.from((String)text), (TokenUsage)this.tokenUsage, (FinishReason)this.finishReason);
        }
        return null;
    }

    private static class ToolExecutionRequestBuilder {
        private final StringBuffer idBuilder = new StringBuffer();
        private final StringBuffer nameBuilder = new StringBuffer();
        private final StringBuffer argumentsBuilder = new StringBuffer();

        private ToolExecutionRequestBuilder() {
        }
    }
}

