/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.mistralai.internal.client;

import dev.langchain4j.Internal;
import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.http.client.sse.ServerSentEvent;
import dev.langchain4j.http.client.sse.ServerSentEventListener;
import dev.langchain4j.internal.ExceptionMapper;
import dev.langchain4j.internal.InternalStreamingChatResponseHandlerUtils;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.chat.response.ChatResponseMetadata;
import dev.langchain4j.model.chat.response.CompleteToolCall;
import dev.langchain4j.model.chat.response.StreamingChatResponseHandler;
import dev.langchain4j.model.mistralai.internal.api.MistralAiChatCompletionChoice;
import dev.langchain4j.model.mistralai.internal.api.MistralAiChatCompletionResponse;
import dev.langchain4j.model.mistralai.internal.api.MistralAiToolCall;
import dev.langchain4j.model.mistralai.internal.api.MistralAiUsage;
import dev.langchain4j.model.mistralai.internal.client.MistralAiJsonUtils;
import dev.langchain4j.model.mistralai.internal.mapper.MistralAiMapper;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.TokenUsage;
import java.util.List;
import java.util.function.BiFunction;

@Internal
class MistralAiServerSentEventListener
implements ServerSentEventListener {
    private final StringBuffer contentBuilder = new StringBuffer();
    private final StreamingChatResponseHandler handler;
    private final BiFunction<String, List<ToolExecutionRequest>, AiMessage> toResponse;
    private List<ToolExecutionRequest> toolExecutionRequests;
    private TokenUsage tokenUsage;
    private FinishReason finishReason;
    private String modelName;
    private String id;

    public MistralAiServerSentEventListener(StreamingChatResponseHandler handler, BiFunction<String, List<ToolExecutionRequest>, AiMessage> toResponse) {
        this.handler = handler;
        this.toResponse = toResponse;
    }

    public void onEvent(ServerSentEvent event) {
        String data = event.data();
        if ("[DONE]".equals(data)) {
            AiMessage responseContent = this.toResponse.apply(this.contentBuilder.toString(), this.toolExecutionRequests);
            ChatResponse response = ChatResponse.builder().aiMessage(responseContent).metadata(ChatResponseMetadata.builder().tokenUsage(this.tokenUsage).finishReason(this.finishReason).modelName(this.modelName).id(this.id).build()).build();
            try {
                this.handler.onCompleteResponse(response);
            }
            catch (Exception e) {
                InternalStreamingChatResponseHandlerUtils.withLoggingExceptions(() -> this.handler.onError((Throwable)e));
            }
        } else {
            String finishReasonString;
            MistralAiUsage usageInfo;
            List<MistralAiToolCall> toolCalls;
            MistralAiChatCompletionResponse chatCompletionResponse = MistralAiJsonUtils.fromJson(data, MistralAiChatCompletionResponse.class);
            MistralAiChatCompletionChoice choice = chatCompletionResponse.getChoices().get(0);
            this.modelName = chatCompletionResponse.getModel();
            this.id = chatCompletionResponse.getId();
            String chunk = choice.getDelta().getContent();
            if (Utils.isNotNullOrEmpty((String)chunk)) {
                this.contentBuilder.append(chunk);
                try {
                    this.handler.onPartialResponse(chunk);
                }
                catch (Exception e) {
                    InternalStreamingChatResponseHandlerUtils.withLoggingExceptions(() -> this.handler.onError((Throwable)e));
                }
            }
            if (!Utils.isNullOrEmpty(toolCalls = choice.getDelta().getToolCalls())) {
                this.toolExecutionRequests = MistralAiMapper.toToolExecutionRequests(toolCalls);
                for (int i = 0; i < this.toolExecutionRequests.size(); ++i) {
                    CompleteToolCall completeToolCall = new CompleteToolCall(i, this.toolExecutionRequests.get(i));
                    InternalStreamingChatResponseHandlerUtils.onCompleteToolCall((StreamingChatResponseHandler)this.handler, (CompleteToolCall)completeToolCall);
                }
            }
            if ((usageInfo = chatCompletionResponse.getUsage()) != null) {
                this.tokenUsage = MistralAiMapper.tokenUsageFrom(usageInfo);
            }
            if ((finishReasonString = choice.getFinishReason()) != null) {
                this.finishReason = MistralAiMapper.finishReasonFrom(finishReasonString);
            }
        }
    }

    public void onError(Throwable error) {
        RuntimeException mappedError = ExceptionMapper.DEFAULT.mapException(error);
        InternalStreamingChatResponseHandlerUtils.withLoggingExceptions(() -> this.handler.onError((Throwable)mappedError));
    }
}

