/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.mistralai.internal.mapper;

import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.SystemMessage;
import dev.langchain4j.data.message.ToolExecutionResultMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.chat.request.ResponseFormat;
import dev.langchain4j.model.chat.request.ResponseFormatType;
import dev.langchain4j.model.chat.request.json.JsonObjectSchema;
import dev.langchain4j.model.chat.request.json.JsonSchemaElementHelper;
import dev.langchain4j.model.mistralai.internal.api.MistralAiChatCompletionResponse;
import dev.langchain4j.model.mistralai.internal.api.MistralAiChatMessage;
import dev.langchain4j.model.mistralai.internal.api.MistralAiFunction;
import dev.langchain4j.model.mistralai.internal.api.MistralAiFunctionCall;
import dev.langchain4j.model.mistralai.internal.api.MistralAiParameters;
import dev.langchain4j.model.mistralai.internal.api.MistralAiResponseFormat;
import dev.langchain4j.model.mistralai.internal.api.MistralAiResponseFormatType;
import dev.langchain4j.model.mistralai.internal.api.MistralAiRole;
import dev.langchain4j.model.mistralai.internal.api.MistralAiTool;
import dev.langchain4j.model.mistralai.internal.api.MistralAiToolCall;
import dev.langchain4j.model.mistralai.internal.api.MistralAiToolType;
import dev.langchain4j.model.mistralai.internal.api.MistralAiUsage;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.TokenUsage;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class MistralAiMapper {
    public static List<MistralAiChatMessage> toMistralAiMessages(List<ChatMessage> messages) {
        return messages.stream().map(MistralAiMapper::toMistralAiMessage).collect(Collectors.toList());
    }

    static MistralAiChatMessage toMistralAiMessage(ChatMessage message) {
        if (message instanceof SystemMessage) {
            return MistralAiChatMessage.builder().role(MistralAiRole.SYSTEM).content(((SystemMessage)message).text()).build();
        }
        if (message instanceof AiMessage) {
            AiMessage aiMessage = (AiMessage)message;
            if (!aiMessage.hasToolExecutionRequests()) {
                return MistralAiChatMessage.builder().role(MistralAiRole.ASSISTANT).content(aiMessage.text()).build();
            }
            List<MistralAiToolCall> toolCalls = aiMessage.toolExecutionRequests().stream().map(MistralAiMapper::toMistralAiToolCall).collect(Collectors.toList());
            if (Utils.isNullOrBlank((String)aiMessage.text())) {
                return MistralAiChatMessage.builder().role(MistralAiRole.ASSISTANT).content(null).toolCalls(toolCalls).build();
            }
            return MistralAiChatMessage.builder().role(MistralAiRole.ASSISTANT).content(aiMessage.text()).toolCalls(toolCalls).build();
        }
        if (message instanceof UserMessage) {
            UserMessage userMessage = (UserMessage)message;
            return MistralAiChatMessage.builder().role(MistralAiRole.USER).content(userMessage.singleText()).build();
        }
        if (message instanceof ToolExecutionResultMessage) {
            return MistralAiChatMessage.builder().role(MistralAiRole.TOOL).toolCallId(((ToolExecutionResultMessage)message).id()).name(((ToolExecutionResultMessage)message).toolName()).content(((ToolExecutionResultMessage)message).text()).build();
        }
        throw new IllegalArgumentException("Unknown message type: " + String.valueOf(message.type()));
    }

    static MistralAiToolCall toMistralAiToolCall(ToolExecutionRequest toolExecutionRequest) {
        return MistralAiToolCall.builder().id(toolExecutionRequest.id()).function(MistralAiFunctionCall.builder().name(toolExecutionRequest.name()).arguments(toolExecutionRequest.arguments()).build()).build();
    }

    public static TokenUsage tokenUsageFrom(MistralAiUsage mistralAiUsage) {
        if (mistralAiUsage == null) {
            return null;
        }
        return new TokenUsage(mistralAiUsage.getPromptTokens(), mistralAiUsage.getCompletionTokens(), mistralAiUsage.getTotalTokens());
    }

    public static FinishReason finishReasonFrom(String mistralAiFinishReason) {
        if (mistralAiFinishReason == null) {
            return null;
        }
        switch (mistralAiFinishReason) {
            case "stop": {
                return FinishReason.STOP;
            }
            case "length": {
                return FinishReason.LENGTH;
            }
            case "tool_calls": {
                return FinishReason.TOOL_EXECUTION;
            }
            case "content_filter": {
                return FinishReason.CONTENT_FILTER;
            }
        }
        return null;
    }

    public static AiMessage aiMessageFrom(MistralAiChatCompletionResponse response) {
        MistralAiChatMessage aiMistralMessage = response.getChoices().get(0).getMessage();
        List<MistralAiToolCall> toolCalls = aiMistralMessage.getToolCalls();
        if (!Utils.isNullOrEmpty(toolCalls)) {
            return AiMessage.from(MistralAiMapper.toToolExecutionRequests(toolCalls));
        }
        return AiMessage.from((String)aiMistralMessage.getContent());
    }

    public static List<ToolExecutionRequest> toToolExecutionRequests(List<MistralAiToolCall> mistralAiToolCalls) {
        return mistralAiToolCalls.stream().filter(toolCall -> toolCall.getType() == MistralAiToolType.FUNCTION).map(MistralAiMapper::toToolExecutionRequest).collect(Collectors.toList());
    }

    public static ToolExecutionRequest toToolExecutionRequest(MistralAiToolCall mistralAiToolCall) {
        return ToolExecutionRequest.builder().id(mistralAiToolCall.getId()).name(mistralAiToolCall.getFunction().getName()).arguments(mistralAiToolCall.getFunction().getArguments()).build();
    }

    public static List<MistralAiTool> toMistralAiTools(List<ToolSpecification> toolSpecifications) {
        return toolSpecifications.stream().map(MistralAiMapper::toMistralAiTool).collect(Collectors.toList());
    }

    static MistralAiTool toMistralAiTool(ToolSpecification toolSpecification) {
        MistralAiFunction function = MistralAiFunction.builder().name(toolSpecification.name()).description(toolSpecification.description()).parameters(MistralAiMapper.toMistralAiParameters(toolSpecification)).build();
        return MistralAiTool.from(function);
    }

    static MistralAiParameters toMistralAiParameters(ToolSpecification toolSpecification) {
        if (toolSpecification.parameters() != null) {
            JsonObjectSchema parameters = toolSpecification.parameters();
            return MistralAiParameters.builder().properties(JsonSchemaElementHelper.toMap((Map)parameters.properties())).required(parameters.required()).build();
        }
        return MistralAiParameters.builder().build();
    }

    public static MistralAiResponseFormat toMistralAiResponseFormat(ResponseFormat responseFormat, ResponseFormat fallbackFormat) {
        if (responseFormat == null) {
            if (fallbackFormat == null) {
                return null;
            }
            responseFormat = fallbackFormat;
        }
        return switch (responseFormat.type()) {
            default -> throw new IncompatibleClassChangeError();
            case ResponseFormatType.TEXT -> MistralAiResponseFormat.fromType(MistralAiResponseFormatType.TEXT);
            case ResponseFormatType.JSON -> responseFormat.jsonSchema() != null ? MistralAiResponseFormat.fromSchema(responseFormat.jsonSchema()) : MistralAiResponseFormat.fromType(MistralAiResponseFormatType.JSON_OBJECT);
        };
    }
}

