/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.web.search;

import dev.langchain4j.web.search.WebSearchInformationResult;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.AssertionsForClassTypes;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;

class WebSearchInformationResultTest {
    WebSearchInformationResultTest() {
    }

    @Test
    void should_return_webSearchInformationResult_with_default_values() {
        WebSearchInformationResult webSearchInformationResult = new WebSearchInformationResult(Long.valueOf(1L));
        Assertions.assertThat((Long)webSearchInformationResult.totalResults()).isEqualTo(1L);
        Assertions.assertThat((Integer)webSearchInformationResult.pageNumber()).isNull();
        Assertions.assertThat((Map)webSearchInformationResult.metadata()).isEmpty();
        Assertions.assertThat((Object)webSearchInformationResult).hasToString("WebSearchInformationResult{totalResults=1, pageNumber=null, metadata={}}");
    }

    @Test
    void should_return_webSearchInformationResult_with_informationResult() {
        WebSearchInformationResult webSearchInformationResult = WebSearchInformationResult.from((Long)1L);
        Assertions.assertThat((Long)webSearchInformationResult.totalResults()).isEqualTo(1L);
        Assertions.assertThat((Integer)webSearchInformationResult.pageNumber()).isNull();
        Assertions.assertThat((Map)webSearchInformationResult.metadata()).isEmpty();
        Assertions.assertThat((Object)webSearchInformationResult).hasToString("WebSearchInformationResult{totalResults=1, pageNumber=null, metadata={}}");
    }

    @Test
    void equals_and_hash() {
        WebSearchInformationResult wsi1 = WebSearchInformationResult.from((Long)1L);
        WebSearchInformationResult wsi2 = WebSearchInformationResult.from((Long)1L);
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)wsi1).isEqualTo((Object)wsi1)).isNotEqualTo(null)).isNotEqualTo(new Object())).isEqualTo((Object)wsi2)).hasSameHashCodeAs((Object)wsi2);
        Assertions.assertThat((Object)WebSearchInformationResult.from((Long)2L)).isNotEqualTo((Object)wsi1);
    }

    @Test
    void should_throw_illegalArgumentException() {
        IllegalArgumentException exception = (IllegalArgumentException)AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> WebSearchInformationResult.from(null)).actual();
        Assertions.assertThat((String)exception.getMessage()).isEqualTo("totalResults cannot be null");
    }
}

