/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.store.embedding.filter.comparison;

import dev.langchain4j.data.document.Metadata;
import dev.langchain4j.store.embedding.filter.comparison.IsEqualTo;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class IsEqualToTest {
    IsEqualToTest() {
    }

    @Test
    void shouldReturnFalseWhenNotMetadata() {
        IsEqualTo isEqualTo = new IsEqualTo("key", (Object)"value");
        Assertions.assertThat((boolean)isEqualTo.test((Object)"notMetadata")).isFalse();
    }

    @Test
    void shouldReturnFalseWhenKeyNotFound() {
        IsEqualTo isEqualTo = new IsEqualTo("key", (Object)"value");
        Metadata metadata = new Metadata(Map.of());
        Assertions.assertThat((boolean)isEqualTo.test((Object)metadata)).isFalse();
    }

    @Test
    void shouldReturnTrueWhenValuesAreNumbers() {
        IsEqualTo isEqualTo = new IsEqualTo("key", (Object)2);
        Metadata metadata = new Metadata(Map.of("key", 2));
        Assertions.assertThat((boolean)isEqualTo.test((Object)metadata)).isTrue();
    }

    @Test
    void shouldReturnTrueWhenValuesAreStrings() {
        IsEqualTo isEqualTo = new IsEqualTo("key", (Object)"value");
        Metadata metadata = new Metadata((Map)new HashMap<String, Object>(){
            {
                this.put("key", "value");
            }
        });
        Assertions.assertThat((boolean)isEqualTo.test((Object)metadata)).isTrue();
    }

    @Test
    void shouldReturnTrueWhenActualValueIsUUIDAsString() {
        final UUID uuid = UUID.randomUUID();
        IsEqualTo isEqualTo = new IsEqualTo("key", (Object)uuid);
        Metadata metadata = new Metadata((Map)new HashMap<String, Object>(this){
            final /* synthetic */ IsEqualToTest this$0;
            {
                this.this$0 = this$0;
                this.put("key", uuid.toString());
            }
        });
        Assertions.assertThat((boolean)isEqualTo.test((Object)metadata)).isTrue();
    }
}

