/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.rag.query.transformer;

import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.SystemMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.model.chat.ChatModel;
import dev.langchain4j.model.chat.mock.ChatModelMock;
import dev.langchain4j.model.input.PromptTemplate;
import dev.langchain4j.rag.query.Metadata;
import dev.langchain4j.rag.query.Query;
import dev.langchain4j.rag.query.transformer.CompressingQueryTransformer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class CompressingQueryTransformerTest {
    CompressingQueryTransformerTest() {
    }

    @Test
    void should_compress_query_and_chat_memory_into_single_query() {
        List<ChatMessage> chatMemory = Arrays.asList(SystemMessage.from((String)"Be polite"), UserMessage.from((String)"Tell me about Klaus Heisler"), AiMessage.from((String)"He is a cool guy"), AiMessage.from((ToolExecutionRequest[])new ToolExecutionRequest[]{ToolExecutionRequest.builder().id("12345").name("current_time").arguments("{}").build()}));
        UserMessage userMessage = UserMessage.from((String)"How old is he?");
        Metadata metadata = Metadata.from((ChatMessage)userMessage, (Object)"default", chatMemory);
        Query query = Query.from((String)userMessage.singleText(), (Metadata)metadata);
        String expectedCompressedQuery = "How old is Klaus Heisler?";
        ChatModelMock model = ChatModelMock.thatAlwaysResponds(expectedCompressedQuery);
        CompressingQueryTransformer transformer = new CompressingQueryTransformer((ChatModel)model);
        Collection queries = transformer.transform(query);
        Assertions.assertThat((Collection)queries).containsExactly((Object[])new Query[]{Query.from((String)expectedCompressedQuery, (Metadata)metadata)});
        Assertions.assertThat((String)model.userMessageText()).isEqualTo("Read and understand the conversation between the User and the AI. Then, analyze the new query from the User. Identify all relevant details, terms, and context from both the conversation and the new query. Reformulate this query into a clear, concise, and self-contained format suitable for information retrieval.\n\nConversation:\nUser: Tell me about Klaus Heisler\nAI: He is a cool guy\n\nUser query: How old is he?\n\nIt is very important that you provide only reformulated query and nothing else! Do not prepend a query with anything!");
    }

    @Test
    void should_not_compress_when_empty_chat_memory() {
        List chatMemory = Collections.emptyList();
        UserMessage userMessage = UserMessage.from((String)"Hello");
        Metadata metadata = Metadata.from((ChatMessage)userMessage, (Object)"default", chatMemory);
        Query query = Query.from((String)userMessage.singleText(), (Metadata)metadata);
        ChatModel model = (ChatModel)Mockito.mock(ChatModel.class);
        CompressingQueryTransformer transformer = new CompressingQueryTransformer(model);
        Collection queries = transformer.transform(query);
        Assertions.assertThat((Collection)queries).containsExactly((Object[])new Query[]{query});
        Mockito.verifyNoInteractions((Object[])new Object[]{model});
    }

    @Test
    void should_compress_query_and_chat_memory_into_single_query_using_custom_prompt_template() {
        PromptTemplate promptTemplate = PromptTemplate.from((String)"Given the following conversation: {{chatMemory}} reformulate the following query: {{query}}");
        List<ChatMessage> chatMemory = Arrays.asList(UserMessage.from((String)"Tell me about Klaus Heisler"), AiMessage.from((String)"He is a cool guy"));
        UserMessage userMessage = UserMessage.from((String)"How old is he?");
        Metadata metadata = Metadata.from((ChatMessage)userMessage, (Object)"default", chatMemory);
        Query query = Query.from((String)userMessage.singleText(), (Metadata)metadata);
        String expectedCompressedQuery = "How old is Klaus Heisler?";
        ChatModelMock model = ChatModelMock.thatAlwaysResponds(expectedCompressedQuery);
        CompressingQueryTransformer transformer = new CompressingQueryTransformer((ChatModel)model, promptTemplate);
        Collection queries = transformer.transform(query);
        Assertions.assertThat((Collection)queries).containsExactly((Object[])new Query[]{Query.from((String)expectedCompressedQuery, (Metadata)metadata)});
        Assertions.assertThat((String)model.userMessageText()).isEqualTo("Given the following conversation: User: Tell me about Klaus Heisler\nAI: He is a cool guy reformulate the following query: How old is he?");
    }

    @Test
    void should_compress_query_and_chat_memory_into_single_query_using_custom_prompt_template_builder() {
        PromptTemplate promptTemplate = PromptTemplate.from((String)"Given the following conversation: {{chatMemory}} reformulate the following query: {{query}}");
        List<ChatMessage> chatMemory = Arrays.asList(UserMessage.from((String)"Tell me about Klaus Heisler"), AiMessage.from((String)"He is a cool guy"));
        UserMessage userMessage = UserMessage.from((String)"How old is he?");
        Metadata metadata = Metadata.from((ChatMessage)userMessage, (Object)"default", chatMemory);
        Query query = Query.from((String)userMessage.singleText(), (Metadata)metadata);
        String expectedCompressedQuery = "How old is Klaus Heisler?";
        ChatModelMock model = ChatModelMock.thatAlwaysResponds(expectedCompressedQuery);
        CompressingQueryTransformer transformer = CompressingQueryTransformer.builder().chatModel((ChatModel)model).promptTemplate(promptTemplate).build();
        Collection queries = transformer.transform(query);
        Assertions.assertThat((Collection)queries).containsExactly((Object[])new Query[]{Query.from((String)expectedCompressedQuery, (Metadata)metadata)});
        Assertions.assertThat((String)model.userMessageText()).isEqualTo("Given the following conversation: User: Tell me about Klaus Heisler\nAI: He is a cool guy reformulate the following query: How old is he?");
    }
}

