/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.rag.content;

import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.rag.content.Content;
import dev.langchain4j.rag.content.ContentMetadata;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;

class ContentTest {
    ContentTest() {
    }

    @Test
    void create_from_string() {
        String contentText = "content";
        Content content = Content.from((String)contentText);
        Assertions.assertThat((String)content.textSegment().text()).isEqualTo(contentText);
    }

    @Test
    void create_from_text_segment() {
        TextSegment segment = TextSegment.from((String)"text");
        Content content = Content.from((TextSegment)segment);
        Assertions.assertThat((Object)content.textSegment()).isSameAs((Object)segment);
    }

    @Test
    void create_from_embedding_match() {
        TextSegment segment = TextSegment.from((String)"text");
        Map<ContentMetadata, String> metadata = Map.of(ContentMetadata.SCORE, 0.2, ContentMetadata.EMBEDDING_ID, "test-eid");
        Content content = Content.from((TextSegment)segment, metadata);
        Assertions.assertThat((Object)content.textSegment()).isSameAs((Object)segment);
        Assertions.assertThat((Map)content.metadata()).isNotEmpty();
        Assertions.assertThat((Map)content.metadata()).containsExactlyEntriesOf(Map.of(ContentMetadata.SCORE, 0.2, ContentMetadata.EMBEDDING_ID, "test-eid"));
    }

    @Test
    void equals_hash_code() {
        Content content1 = Content.from((TextSegment)TextSegment.from((String)"content"), Map.of(ContentMetadata.SCORE, 1.0));
        Content content2 = Content.from((String)"content 2");
        Content content3 = Content.from((String)"content");
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)content1).isNotEqualTo((Object)content2)).doesNotHaveSameHashCodeAs((Object)content2)).isEqualTo((Object)content3)).hasSameHashCodeAs((Object)content3);
    }

    @Test
    void to_string() {
        Content content = Content.from((String)"content");
        Assertions.assertThat((Object)content).hasToString("DefaultContent { textSegment = TextSegment { text = \"content\" metadata = {} }, metadata = {} }");
    }

    @Test
    void create_from_text_segment_with_null_metadata() {
        TextSegment segment = TextSegment.from((String)"text");
        Content content = Content.from((TextSegment)segment, null);
        Assertions.assertThat((Object)content.textSegment()).isSameAs((Object)segment);
        Assertions.assertThat((Map)content.metadata()).isEmpty();
    }

    @Test
    void create_from_text_segment_with_empty_metadata() {
        TextSegment segment = TextSegment.from((String)"text");
        Map emptyMetadata = Collections.emptyMap();
        Content content = Content.from((TextSegment)segment, emptyMetadata);
        Assertions.assertThat((Object)content.textSegment()).isSameAs((Object)segment);
        Assertions.assertThat((Map)content.metadata()).isEmpty();
    }

    @Test
    void metadata_returned_is_defensive_copy() {
        TextSegment segment = TextSegment.from((String)"text");
        Map<ContentMetadata, Double> metadata = Map.of(ContentMetadata.SCORE, 0.5);
        Content content = Content.from((TextSegment)segment, metadata);
        Assertions.assertThatThrownBy(() -> content.metadata().put(ContentMetadata.EMBEDDING_ID, "test")).isInstanceOf(UnsupportedOperationException.class);
    }

    @Test
    void should_handle_null_string_input() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Content.from((String)null)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("text cannot be null");
    }

    @Test
    void should_handle_null_text_segment_input() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Content.from((TextSegment)null)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("textSegment cannot be null");
    }

    @Test
    void should_handle_special_characters() {
        String specialText = "!@#$%^&*()_+-=[]{}|;:'\",.<>?/~`";
        Content content = Content.from((String)specialText);
        Assertions.assertThat((String)content.textSegment().text()).isEqualTo(specialText);
    }

    @Test
    void should_handle_multiline_text() {
        String multilineText = "Line 1\nLine 2\nLine 3\n\nLine 5";
        Content content = Content.from((String)multilineText);
        Assertions.assertThat((String)content.textSegment().text()).isEqualTo(multilineText);
    }

    @Test
    void should_handle_metadata_with_null_values() {
        TextSegment segment = TextSegment.from((String)"text");
        HashMap<ContentMetadata, Double> metadata = new HashMap<ContentMetadata, Double>();
        metadata.put(ContentMetadata.SCORE, 0.1);
        metadata.put(ContentMetadata.EMBEDDING_ID, null);
        Content content = Content.from((TextSegment)segment, metadata);
        Assertions.assertThat((Map)content.metadata()).hasSize(2);
        Assertions.assertThat(content.metadata().get(ContentMetadata.SCORE)).isEqualTo((Object)0.1);
        Assertions.assertThat(content.metadata().get(ContentMetadata.EMBEDDING_ID)).isNull();
    }

    @Test
    void should_handle_different_score_types() {
        TextSegment segment = TextSegment.from((String)"text");
        Content contentWithDouble = Content.from((TextSegment)segment, Map.of(ContentMetadata.SCORE, 0.1));
        Content contentWithFloat = Content.from((TextSegment)segment, Map.of(ContentMetadata.SCORE, Float.valueOf(0.1f)));
        Content contentWithInteger = Content.from((TextSegment)segment, Map.of(ContentMetadata.SCORE, 1));
        Assertions.assertThat(contentWithDouble.metadata().get(ContentMetadata.SCORE)).isEqualTo((Object)0.1);
        Assertions.assertThat(contentWithFloat.metadata().get(ContentMetadata.SCORE)).isEqualTo((Object)Float.valueOf(0.1f));
        Assertions.assertThat(contentWithInteger.metadata().get(ContentMetadata.SCORE)).isEqualTo((Object)1);
    }

    @Test
    void should_ignore_metadata_in_equality_with_different_metadata() {
        TextSegment segment = TextSegment.from((String)"test");
        Content content1 = Content.from((TextSegment)segment, Map.of(ContentMetadata.SCORE, 0.1));
        Content content2 = Content.from((TextSegment)segment, Map.of(ContentMetadata.SCORE, 0.1));
        Content content3 = Content.from((TextSegment)segment, Map.of(ContentMetadata.EMBEDDING_ID, "test"));
        Assertions.assertThat((Object)content1).isEqualTo((Object)content2);
        Assertions.assertThat((Object)content1).isEqualTo((Object)content3);
        Assertions.assertThat((Object)content2).isEqualTo((Object)content3);
    }

    @Test
    void should_differentiate_based_on_text_content() {
        Content content1 = Content.from((String)"text1");
        Content content2 = Content.from((String)"text2");
        Assertions.assertThat((Object)content1).isNotEqualTo((Object)content2);
        Assertions.assertThat((int)content1.hashCode()).isNotEqualTo(content2.hashCode());
    }

    @Test
    void toString_should_handle_different_content_types() {
        Content simpleContent = Content.from((String)"simple");
        Content contentWithMetadata = Content.from((TextSegment)TextSegment.from((String)"with metadata"), Map.of(ContentMetadata.SCORE, 0.1));
        Assertions.assertThat((String)simpleContent.toString()).contains(new CharSequence[]{"simple"});
        Assertions.assertThat((String)contentWithMetadata.toString()).contains(new CharSequence[]{"with metadata"});
        Assertions.assertThat((String)contentWithMetadata.toString()).contains(new CharSequence[]{"0.1"});
    }

    @Test
    void toString_should_handle_special_characters() {
        Content content = Content.from((String)"text with \"quotes\" and \n newlines");
        String toString = content.toString();
        Assertions.assertThat((String)toString).contains(new CharSequence[]{"text with"});
        Assertions.assertThat((String)toString).contains(new CharSequence[]{"quotes"});
    }

    @Test
    void should_handle_concurrent_access_to_metadata() throws Exception {
        TextSegment segment = TextSegment.from((String)"text");
        Map<ContentMetadata, Double> metadata = Map.of(ContentMetadata.SCORE, 0.1);
        Content content = Content.from((TextSegment)segment, metadata);
        Assertions.assertThatThrownBy(() -> content.metadata().put(ContentMetadata.EMBEDDING_ID, "test")).isInstanceOf(UnsupportedOperationException.class);
        Assertions.assertThat((Map)content.metadata()).hasSize(1);
        Assertions.assertThat(content.metadata().get(ContentMetadata.SCORE)).isEqualTo((Object)0.1);
    }
}

