/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.output;

import dev.langchain4j.model.output.TokenUsage;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.WithAssertions;
import org.junit.jupiter.api.Test;

class TokenUsageTest
implements WithAssertions {
    TokenUsageTest() {
    }

    @Test
    void constructors() {
        this.assertThat(new TokenUsage()).isEqualTo((Object)new TokenUsage(null, null, null));
        this.assertThat(new TokenUsage(Integer.valueOf(1))).isEqualTo((Object)new TokenUsage(Integer.valueOf(1), null, Integer.valueOf(1)));
        this.assertThat(new TokenUsage(Integer.valueOf(1), Integer.valueOf(2))).isEqualTo((Object)new TokenUsage(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3)));
        this.assertThat(new TokenUsage(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3))).isEqualTo((Object)new TokenUsage(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3)));
    }

    @Test
    void accessors() {
        TokenUsage tu = new TokenUsage(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3));
        this.assertThat(tu.inputTokenCount()).isEqualTo(1);
        this.assertThat(tu.outputTokenCount()).isEqualTo(2);
        this.assertThat(tu.totalTokenCount()).isEqualTo(3);
        tu = new TokenUsage(null, null, null);
        this.assertThat(tu.inputTokenCount()).isNull();
        this.assertThat(tu.outputTokenCount()).isNull();
        this.assertThat(tu.totalTokenCount()).isNull();
    }

    @Test
    void equals_hash() {
        TokenUsage tu1 = new TokenUsage(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3));
        TokenUsage tu2 = new TokenUsage(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3));
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)this.assertThat(tu1).isEqualTo((Object)tu1)).isNotEqualTo(null)).isNotEqualTo(new Object())).isEqualTo((Object)tu2)).hasSameHashCodeAs((Object)tu2);
        ((ObjectAssert)this.assertThat(new TokenUsage(null, Integer.valueOf(2), Integer.valueOf(3))).isNotEqualTo((Object)tu1)).doesNotHaveSameHashCodeAs((Object)tu1);
        ((ObjectAssert)this.assertThat(new TokenUsage(Integer.valueOf(1), null, Integer.valueOf(3))).isNotEqualTo((Object)tu1)).doesNotHaveSameHashCodeAs((Object)tu1);
        ((ObjectAssert)this.assertThat(new TokenUsage(Integer.valueOf(1), Integer.valueOf(2), null)).isNotEqualTo((Object)tu1)).doesNotHaveSameHashCodeAs((Object)tu1);
    }

    @Test
    void to_string() {
        this.assertThat(new TokenUsage(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3))).hasToString("TokenUsage { inputTokenCount = 1, outputTokenCount = 2, totalTokenCount = 3 }");
        this.assertThat(new TokenUsage(null, null, null)).hasToString("TokenUsage { inputTokenCount = null, outputTokenCount = null, totalTokenCount = null }");
    }

    @Test
    void test_sum() {
        this.assertThat(TokenUsage.sum((TokenUsage)new TokenUsage(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3)), (TokenUsage)new TokenUsage(Integer.valueOf(4), Integer.valueOf(5), Integer.valueOf(6)))).isEqualTo((Object)new TokenUsage(Integer.valueOf(5), Integer.valueOf(7), Integer.valueOf(9)));
        this.assertThat(TokenUsage.sum((TokenUsage)new TokenUsage(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3)), (TokenUsage)new TokenUsage(null, null, null))).isEqualTo((Object)new TokenUsage(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3)));
        this.assertThat(TokenUsage.sum((TokenUsage)new TokenUsage(null, null, null), (TokenUsage)new TokenUsage(Integer.valueOf(4), Integer.valueOf(5), Integer.valueOf(6)))).isEqualTo((Object)new TokenUsage(Integer.valueOf(4), Integer.valueOf(5), Integer.valueOf(6)));
        this.assertThat(TokenUsage.sum((TokenUsage)new TokenUsage(null, null, null), (TokenUsage)new TokenUsage(null, null, null))).isEqualTo((Object)new TokenUsage(null, null, null));
        this.assertThat(TokenUsage.sum((TokenUsage)new TokenUsage(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3)), null)).isEqualTo((Object)new TokenUsage(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3)));
        this.assertThat(TokenUsage.sum(null, (TokenUsage)new TokenUsage(Integer.valueOf(4), Integer.valueOf(5), Integer.valueOf(6)))).isEqualTo((Object)new TokenUsage(Integer.valueOf(4), Integer.valueOf(5), Integer.valueOf(6)));
    }
}

