/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.chat.mock;

import dev.langchain4j.Experimental;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.internal.ExceptionMapper;
import dev.langchain4j.internal.Exceptions;
import dev.langchain4j.internal.RetryUtils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.chat.ChatModel;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.chat.response.ChatResponseMetadata;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Function;

@Experimental
public class ChatModelMock
implements ChatModel {
    private final String staticResponse;
    private final RuntimeException exception;
    private final Function<ChatRequest, AiMessage> aiMessageGenerator;
    private final List<List<ChatMessage>> requests = Collections.synchronizedList(new ArrayList());
    private static final RetryUtils.RetryPolicy DEFAULT_NO_RETRY_POLICY = RetryUtils.retryPolicyBuilder().maxRetries(0).build();
    private RetryUtils.RetryPolicy retryPolicy = DEFAULT_NO_RETRY_POLICY;

    public ChatModelMock(String staticResponse) {
        this.staticResponse = ValidationUtils.ensureNotBlank((String)staticResponse, (String)"staticResponse");
        this.exception = null;
        this.aiMessageGenerator = null;
    }

    public ChatModelMock(RuntimeException exception) {
        this.staticResponse = null;
        this.exception = (RuntimeException)ValidationUtils.ensureNotNull((Object)exception, (String)"exception");
        this.aiMessageGenerator = null;
    }

    public ChatModelMock(Function<ChatRequest, AiMessage> aiMessageGenerator) {
        this.staticResponse = null;
        this.exception = null;
        this.aiMessageGenerator = (Function)ValidationUtils.ensureNotNull(aiMessageGenerator, (String)"aiMessageGenerator");
    }

    public ChatModelMock withRetryPolicy(RetryUtils.RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    public ChatResponse doChat(ChatRequest chatRequest) {
        this.requests.add(new ArrayList(chatRequest.messages()));
        if (this.exception != null) {
            throw this.exception;
        }
        AiMessage aiMessage = (AiMessage)this.retryPolicy.withRetry(() -> (AiMessage)ExceptionMapper.mappingException(() -> this.getAiMessage(chatRequest)));
        return ChatResponse.builder().aiMessage(aiMessage).metadata(ChatResponseMetadata.builder().build()).build();
    }

    private AiMessage getAiMessage(ChatRequest chatRequest) {
        return this.aiMessageGenerator != null ? this.aiMessageGenerator.apply(chatRequest) : AiMessage.from((String)this.staticResponse);
    }

    public String userMessageText() {
        if (this.requests.size() != 1) {
            throw Exceptions.runtime((String)("Expected exactly 1 request, got: " + this.requests.size()), (Object[])new Object[0]);
        }
        List<ChatMessage> messages = this.requests.get(0);
        if (messages.size() != 1) {
            throw Exceptions.runtime((String)("Expected exactly 1 message, got: " + messages.size()), (Object[])new Object[0]);
        }
        ChatMessage message = messages.get(0);
        if (message instanceof UserMessage) {
            UserMessage userMessage = (UserMessage)message;
            return userMessage.singleText();
        }
        throw Exceptions.runtime((String)("Expected UserMessage, got: " + String.valueOf(message)), (Object[])new Object[0]);
    }

    public static ChatModelMock thatAlwaysResponds(String response) {
        return new ChatModelMock(response);
    }

    public static ChatModelMock thatAlwaysResponds(AiMessage aiMessage) {
        return new ChatModelMock(ignored -> aiMessage);
    }

    public static ChatModelMock thatAlwaysResponds(AiMessage ... aiMessages) {
        ConcurrentLinkedQueue<AiMessage> queue = new ConcurrentLinkedQueue<AiMessage>(Arrays.asList(aiMessages));
        return new ChatModelMock(ignored -> (AiMessage)queue.poll());
    }

    public static ChatModelMock thatAlwaysThrowsException() {
        return ChatModelMock.thatAlwaysThrowsExceptionWithMessage("Something went wrong, but this is an expected exception");
    }

    public static ChatModelMock thatAlwaysThrowsExceptionWithMessage(String message) {
        return new ChatModelMock(new RuntimeException(message));
    }
}

