/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.chat.common;

import dev.langchain4j.model.chat.StreamingChatModel;
import dev.langchain4j.model.chat.common.AbstractBaseChatModelIT;
import dev.langchain4j.model.chat.common.ChatResponseAndStreamingMetadata;
import dev.langchain4j.model.chat.common.StreamingMetadata;
import dev.langchain4j.model.chat.listener.ChatModelErrorContext;
import dev.langchain4j.model.chat.listener.ChatModelListener;
import dev.langchain4j.model.chat.listener.ChatModelRequestContext;
import dev.langchain4j.model.chat.listener.ChatModelResponseContext;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.chat.response.CompleteToolCall;
import dev.langchain4j.model.chat.response.PartialToolCall;
import dev.langchain4j.model.chat.response.StreamingChatResponseHandler;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public abstract class AbstractStreamingChatModelIT
extends AbstractBaseChatModelIT<StreamingChatModel> {
    public abstract StreamingChatModel createModelWith(ChatModelListener var1);

    @Test
    void should_propagate_user_exceptions_thrown_from_onPartialResponse() throws Exception {
        final AtomicInteger onPartialResponseCalled = new AtomicInteger(0);
        final CompletableFuture futureResponse = new CompletableFuture();
        final ArrayList errors = new ArrayList();
        final CompletableFuture futureErrors = new CompletableFuture();
        final RuntimeException userCodeException = new RuntimeException("something wrong happened in user code");
        StreamingChatResponseHandler handler = new StreamingChatResponseHandler(){
            final /* synthetic */ AbstractStreamingChatModelIT this$0;
            {
                this.this$0 = this$0;
            }

            public void onPartialResponse(String partialResponse) {
                onPartialResponseCalled.incrementAndGet();
                throw userCodeException;
            }

            public void onCompleteResponse(ChatResponse completeResponse) {
                futureResponse.complete(completeResponse);
            }

            public void onError(Throwable error) {
                errors.add(error);
                futureErrors.complete(null);
            }
        };
        ChatModelListener listener = (ChatModelListener)Mockito.mock(ChatModelListener.class);
        StreamingChatModel model = this.createModelWith(listener);
        if (model == null) {
            return;
        }
        model.chat("What is the capital of Germany?", handler);
        ChatResponse response = (ChatResponse)futureResponse.get(30L, TimeUnit.SECONDS);
        Assertions.assertThat((String)response.aiMessage().text()).containsIgnoringCase((CharSequence)"Berlin");
        Assertions.assertThat((int)onPartialResponseCalled.get()).isGreaterThan(1);
        futureErrors.get(30L, TimeUnit.SECONDS);
        Assertions.assertThat(errors).hasSize(onPartialResponseCalled.get());
        for (Throwable error : errors) {
            Assertions.assertThat((Throwable)error).isEqualTo((Object)userCodeException);
        }
        ((ChatModelListener)Mockito.verify((Object)listener)).onRequest((ChatModelRequestContext)ArgumentMatchers.any());
        ((ChatModelListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)onPartialResponseCalled.get()))).onError((ChatModelErrorContext)ArgumentMatchers.any());
        ((ChatModelListener)Mockito.verify((Object)listener)).onResponse((ChatModelResponseContext)ArgumentMatchers.any());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{listener});
    }

    @Test
    void should_propagate_user_exceptions_thrown_from_onCompleteResponse() throws Exception {
        final CompletableFuture futureResponse = new CompletableFuture();
        final ArrayList errors = new ArrayList();
        final CompletableFuture futureErrors = new CompletableFuture();
        final RuntimeException userCodeException = new RuntimeException("something wrong happened in user code");
        StreamingChatResponseHandler handler = new StreamingChatResponseHandler(){
            final /* synthetic */ AbstractStreamingChatModelIT this$0;
            {
                this.this$0 = this$0;
            }

            public void onPartialResponse(String partialResponse) {
            }

            public void onCompleteResponse(ChatResponse completeResponse) {
                futureResponse.complete(completeResponse);
                throw userCodeException;
            }

            public void onError(Throwable error) {
                errors.add(error);
                futureErrors.complete(null);
            }
        };
        ChatModelListener listener = (ChatModelListener)Mockito.mock(ChatModelListener.class);
        StreamingChatModel model = this.createModelWith(listener);
        if (model == null) {
            return;
        }
        model.chat("What is the capital of Germany?", handler);
        ChatResponse response = (ChatResponse)futureResponse.get(30L, TimeUnit.SECONDS);
        Assertions.assertThat((String)response.aiMessage().text()).containsIgnoringCase((CharSequence)"Berlin");
        futureErrors.get(30L, TimeUnit.SECONDS);
        Assertions.assertThat(errors).hasSize(1);
        Assertions.assertThat((Throwable)((Throwable)errors.get(0))).isEqualTo((Object)userCodeException);
        ((ChatModelListener)Mockito.verify((Object)listener)).onRequest((ChatModelRequestContext)ArgumentMatchers.any());
        ((ChatModelListener)Mockito.verify((Object)listener)).onError((ChatModelErrorContext)ArgumentMatchers.any());
        ((ChatModelListener)Mockito.verify((Object)listener)).onResponse((ChatModelResponseContext)ArgumentMatchers.any());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{listener});
    }

    @Test
    void should_ignore_user_exceptions_thrown_from_onError() throws Exception {
        final CompletableFuture futureResponse = new CompletableFuture();
        final ArrayList errors = new ArrayList();
        final CompletableFuture futureErrors = new CompletableFuture();
        final RuntimeException userCodeException = new RuntimeException("something wrong happened in user code");
        StreamingChatResponseHandler handler = new StreamingChatResponseHandler(){
            final /* synthetic */ AbstractStreamingChatModelIT this$0;
            {
                this.this$0 = this$0;
            }

            public void onPartialResponse(String partialResponse) {
            }

            public void onCompleteResponse(ChatResponse completeResponse) {
                futureResponse.complete(completeResponse);
                throw userCodeException;
            }

            public void onError(Throwable error) {
                errors.add(error);
                futureErrors.complete(null);
                throw new RuntimeException("something unexpected happened, but it should be ignored");
            }
        };
        ChatModelListener listener = (ChatModelListener)Mockito.mock(ChatModelListener.class);
        StreamingChatModel model = this.createModelWith(listener);
        if (model == null) {
            return;
        }
        model.chat("What is the capital of Germany?", handler);
        ChatResponse response = (ChatResponse)futureResponse.get(30L, TimeUnit.SECONDS);
        Assertions.assertThat((String)response.aiMessage().text()).containsIgnoringCase((CharSequence)"Berlin");
        futureErrors.get(30L, TimeUnit.SECONDS);
        Assertions.assertThat(errors).hasSize(1);
        Assertions.assertThat((Throwable)((Throwable)errors.get(0))).isEqualTo((Object)userCodeException);
        ((ChatModelListener)Mockito.verify((Object)listener)).onRequest((ChatModelRequestContext)ArgumentMatchers.any());
        ((ChatModelListener)Mockito.verify((Object)listener)).onError((ChatModelErrorContext)ArgumentMatchers.any());
        ((ChatModelListener)Mockito.verify((Object)listener)).onResponse((ChatModelResponseContext)ArgumentMatchers.any());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{listener});
    }

    @Override
    protected ChatResponseAndStreamingMetadata chat(StreamingChatModel chatModel, ChatRequest chatRequest) {
        final CompletableFuture futureChatResponse = new CompletableFuture();
        final StringBuffer concatenatedPartialResponsesBuilder = new StringBuffer();
        final ConcurrentLinkedQueue partialToolCalls = new ConcurrentLinkedQueue();
        final ConcurrentLinkedQueue completeToolCalls = new ConcurrentLinkedQueue();
        final AtomicInteger timesOnPartialResponseWasCalled = new AtomicInteger();
        final AtomicInteger timesOnCompleteResponseWasCalled = new AtomicInteger();
        final CopyOnWriteArraySet<Thread> threads = new CopyOnWriteArraySet<Thread>();
        StreamingChatResponseHandler handler = new StreamingChatResponseHandler(){
            final /* synthetic */ AbstractStreamingChatModelIT this$0;
            {
                this.this$0 = this$0;
            }

            public void onPartialResponse(String partialResponse) {
                concatenatedPartialResponsesBuilder.append(partialResponse);
                timesOnPartialResponseWasCalled.incrementAndGet();
                threads.add(Thread.currentThread());
            }

            public void onPartialToolCall(PartialToolCall partialToolCall) {
                partialToolCalls.add(partialToolCall);
                threads.add(Thread.currentThread());
            }

            public void onCompleteToolCall(CompleteToolCall completeToolCall) {
                completeToolCalls.add(completeToolCall);
                threads.add(Thread.currentThread());
            }

            public void onCompleteResponse(ChatResponse completeResponse) {
                timesOnCompleteResponseWasCalled.incrementAndGet();
                threads.add(Thread.currentThread());
                futureChatResponse.complete(completeResponse);
            }

            public void onError(Throwable error) {
                threads.add(Thread.currentThread());
                futureChatResponse.completeExceptionally(error);
            }
        };
        StreamingChatResponseHandler spyHandler = (StreamingChatResponseHandler)Mockito.spy((Object)handler);
        chatModel.chat(chatRequest, spyHandler);
        try {
            ChatResponse chatResponse = (ChatResponse)futureChatResponse.get(120L, TimeUnit.SECONDS);
            String concatenatedPartialResponses = concatenatedPartialResponsesBuilder.toString();
            StreamingMetadata metadata = new StreamingMetadata(concatenatedPartialResponses.isEmpty() ? null : concatenatedPartialResponses, timesOnPartialResponseWasCalled.get(), new ArrayList<PartialToolCall>(partialToolCalls), new ArrayList<CompleteToolCall>(completeToolCalls), timesOnCompleteResponseWasCalled.get(), threads, spyHandler);
            return new ChatResponseAndStreamingMetadata(chatResponse, metadata);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

