/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.chat;

import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.chat.response.PartialThinking;
import dev.langchain4j.model.chat.response.StreamingChatResponseHandler;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.assertj.core.api.Assertions;

public class TestStreamingChatResponseHandler
implements StreamingChatResponseHandler {
    private final StringBuffer responseBuilder = new StringBuffer();
    private final StringBuffer thinkingBuilder = new StringBuffer();
    private final CompletableFuture<ChatResponse> futureResponse = new CompletableFuture();

    public void onPartialResponse(String partialResponse) {
        this.responseBuilder.append(partialResponse);
    }

    public void onPartialThinking(PartialThinking partialThinking) {
        this.thinkingBuilder.append(partialThinking.text());
    }

    public void onCompleteResponse(ChatResponse completeResponse) {
        AiMessage aiMessage = completeResponse.aiMessage();
        if (!aiMessage.hasToolExecutionRequests()) {
            Assertions.assertThat((String)aiMessage.text()).isEqualTo(this.responseBuilder.toString());
        }
        this.futureResponse.complete(completeResponse);
    }

    public void onError(Throwable error) {
        this.futureResponse.completeExceptionally(error);
    }

    public ChatResponse get() {
        try {
            return this.futureResponse.get(60L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException | TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    public String getThinking() {
        return this.thinkingBuilder.toString();
    }
}

