/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.audio;

import dev.langchain4j.model.audio.AudioTranscriptionResponse;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class AudioTranscriptionResponseTest {
    AudioTranscriptionResponseTest() {
    }

    @Test
    void should_create_response_with_text() {
        String text = "This is the transcribed text.";
        AudioTranscriptionResponse response = new AudioTranscriptionResponse(text);
        Assertions.assertThat((String)response.text()).isEqualTo(text);
    }

    @Test
    void should_create_response_with_from_method() {
        String text = "This is the transcribed text.";
        AudioTranscriptionResponse response = AudioTranscriptionResponse.from((String)text);
        Assertions.assertThat((String)response.text()).isEqualTo(text);
    }

    @Test
    void should_handle_null_text() {
        AudioTranscriptionResponse response = new AudioTranscriptionResponse(null);
        Assertions.assertThat((String)response.text()).isNull();
    }

    @Test
    void should_handle_empty_text() {
        String text = "";
        AudioTranscriptionResponse response = new AudioTranscriptionResponse(text);
        Assertions.assertThat((String)response.text()).isEqualTo("");
    }

    @Test
    void should_handle_multiline_text() {
        String text = "Line 1\nLine 2\nLine 3";
        AudioTranscriptionResponse response = new AudioTranscriptionResponse(text);
        Assertions.assertThat((String)response.text()).isEqualTo(text);
        Assertions.assertThat((String)response.text()).contains(new CharSequence[]{"Line 1"});
        Assertions.assertThat((String)response.text()).contains(new CharSequence[]{"Line 2"});
        Assertions.assertThat((String)response.text()).contains(new CharSequence[]{"Line 3"});
    }

    @Test
    void should_handle_text_with_special_characters() {
        String text = "Hello! This is a test with special characters: \u00e4\u00f6\u00fc, \u00e9\u00e8\u00ea, \u00f1, and emojis \ud83c\udfb5\ud83c\udfa4";
        AudioTranscriptionResponse response = new AudioTranscriptionResponse(text);
        Assertions.assertThat((String)response.text()).isEqualTo(text);
    }

    @Test
    void should_handle_very_long_text() {
        StringBuilder longText = new StringBuilder();
        for (int i = 0; i < 1000; ++i) {
            longText.append("This is sentence number ").append(i).append(". ");
        }
        AudioTranscriptionResponse response = new AudioTranscriptionResponse(longText.toString());
        Assertions.assertThat((String)response.text()).isEqualTo(longText.toString());
        Assertions.assertThat((int)response.text().length()).isGreaterThan(10000);
    }

    @Test
    void should_handle_text_with_whitespace() {
        String text = "  Text with leading and trailing spaces  ";
        AudioTranscriptionResponse response = new AudioTranscriptionResponse(text);
        Assertions.assertThat((String)response.text()).isEqualTo(text);
    }

    @Test
    void should_handle_text_with_numbers_and_punctuation() {
        String text = "The year was 2023, and the temperature was 25.5\u00b0C. What a day!";
        AudioTranscriptionResponse response = new AudioTranscriptionResponse(text);
        Assertions.assertThat((String)response.text()).isEqualTo(text);
    }

    @Test
    void should_create_equal_responses_for_same_text() {
        String text = "Same text";
        AudioTranscriptionResponse response1 = new AudioTranscriptionResponse(text);
        AudioTranscriptionResponse response2 = AudioTranscriptionResponse.from((String)text);
        Assertions.assertThat((String)response1.text()).isEqualTo(response2.text());
    }

    @Test
    void should_handle_json_like_text() {
        String text = "{\"transcription\": \"This is a test\", \"confidence\": 0.95}";
        AudioTranscriptionResponse response = new AudioTranscriptionResponse(text);
        Assertions.assertThat((String)response.text()).isEqualTo(text);
    }
}

