/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.internal;

import com.sun.net.httpserver.HttpServer;
import dev.langchain4j.internal.Utils;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class UtilsTest {
    UtilsTest() {
    }

    @Test
    void get_or_default() {
        Assertions.assertThat((String)((String)Utils.getOrDefault((Object)"foo", (Object)"bar"))).isEqualTo("foo");
        Assertions.assertThat((String)((String)Utils.getOrDefault(null, (Object)"bar"))).isEqualTo("bar");
        Assertions.assertThat((String)((String)Utils.getOrDefault((Object)"foo", () -> "bar"))).isEqualTo("foo");
        Assertions.assertThat((String)((String)Utils.getOrDefault(null, () -> "bar"))).isEqualTo("bar");
    }

    @Test
    void get_or_default_list() {
        List nullList = null;
        List emptyList = List.of();
        List<Integer> list1 = List.of(Integer.valueOf(1));
        List<Integer> list2 = List.of(Integer.valueOf(2));
        Assertions.assertThat((List)Utils.getOrDefault(nullList, nullList)).isSameAs(nullList);
        Assertions.assertThat((List)Utils.getOrDefault(nullList, emptyList)).isSameAs(emptyList);
        Assertions.assertThat((List)Utils.getOrDefault(emptyList, nullList)).isSameAs(nullList);
        Assertions.assertThat((List)Utils.getOrDefault(emptyList, emptyList)).isSameAs(emptyList);
        Assertions.assertThat((List)Utils.getOrDefault(nullList, list1)).isSameAs(list1);
        Assertions.assertThat((List)Utils.getOrDefault(emptyList, list1)).isSameAs(list1);
        Assertions.assertThat((List)Utils.getOrDefault(list1, list2)).isSameAs(list1).isNotSameAs(list2);
    }

    @Test
    void get_or_default_map() {
        Map nullMap = null;
        Map emptyMap = Map.of();
        Map<String, String> map1 = Map.of("one", "1");
        Map<String, String> map2 = Map.of("two", "2");
        Assertions.assertThat((Map)Utils.getOrDefault(nullMap, nullMap)).isSameAs(nullMap);
        Assertions.assertThat((Map)Utils.getOrDefault(nullMap, emptyMap)).isSameAs(emptyMap);
        Assertions.assertThat((Map)Utils.getOrDefault(emptyMap, nullMap)).isSameAs(nullMap);
        Assertions.assertThat((Map)Utils.getOrDefault(emptyMap, emptyMap)).isSameAs(emptyMap);
        Assertions.assertThat((Map)Utils.getOrDefault(nullMap, map1)).isSameAs(map1);
        Assertions.assertThat((Map)Utils.getOrDefault(emptyMap, map1)).isSameAs(map1);
        ((MapAssert)Assertions.assertThat((Map)Utils.getOrDefault(map1, map2)).isSameAs(map1)).isNotSameAs(map2);
    }

    @Test
    void is_null_or_blank() {
        Assertions.assertThat((boolean)Utils.isNullOrBlank(null)).isTrue();
        Assertions.assertThat((boolean)Utils.isNullOrBlank((String)"")).isTrue();
        Assertions.assertThat((boolean)Utils.isNullOrBlank((String)" ")).isTrue();
        Assertions.assertThat((boolean)Utils.isNullOrBlank((String)"foo")).isFalse();
        Assertions.assertThat((boolean)Utils.isNotNullOrBlank(null)).isFalse();
        Assertions.assertThat((boolean)Utils.isNotNullOrBlank((String)"")).isFalse();
        Assertions.assertThat((boolean)Utils.isNotNullOrBlank((String)" ")).isFalse();
        Assertions.assertThat((boolean)Utils.isNotNullOrBlank((String)"foo")).isTrue();
    }

    @Test
    void string_is_null_or_empty() {
        Assertions.assertThat((boolean)Utils.isNullOrEmpty((String)null)).isTrue();
        Assertions.assertThat((boolean)Utils.isNullOrEmpty((String)"")).isTrue();
        Assertions.assertThat((boolean)Utils.isNullOrEmpty((String)" ")).isFalse();
        Assertions.assertThat((boolean)Utils.isNullOrEmpty((String)"\n")).isFalse();
        Assertions.assertThat((boolean)Utils.isNullOrEmpty((String)"foo")).isFalse();
    }

    @Test
    void string_is_not_null_or_empty() {
        Assertions.assertThat((boolean)Utils.isNotNullOrEmpty(null)).isFalse();
        Assertions.assertThat((boolean)Utils.isNotNullOrEmpty((String)"")).isFalse();
        Assertions.assertThat((boolean)Utils.isNotNullOrEmpty((String)" ")).isTrue();
        Assertions.assertThat((boolean)Utils.isNotNullOrEmpty((String)"\n")).isTrue();
        Assertions.assertThat((boolean)Utils.isNotNullOrEmpty((String)"foo")).isTrue();
    }

    @Test
    void are_not_null_or_blank() {
        Assertions.assertThat((boolean)Utils.areNotNullOrBlank((String[])new String[0])).isFalse();
        Assertions.assertThat((boolean)Utils.areNotNullOrBlank((String[])new String[]{null})).isFalse();
        Assertions.assertThat((boolean)Utils.areNotNullOrBlank((String[])new String[]{""})).isFalse();
        Assertions.assertThat((boolean)Utils.areNotNullOrBlank((String[])new String[]{" "})).isFalse();
        Assertions.assertThat((boolean)Utils.areNotNullOrBlank((String[])new String[]{"foo"})).isTrue();
        Assertions.assertThat((boolean)Utils.areNotNullOrBlank((String[])new String[]{"foo", "bar"})).isTrue();
        Assertions.assertThat((boolean)Utils.areNotNullOrBlank((String[])new String[]{"foo", null})).isFalse();
        Assertions.assertThat((boolean)Utils.areNotNullOrBlank((String[])new String[]{null, "bar"})).isFalse();
        Assertions.assertThat((boolean)Utils.areNotNullOrBlank((String[])new String[]{null, null})).isFalse();
    }

    @Test
    void collection_is_null_or_empty() {
        Assertions.assertThat((boolean)Utils.isNullOrEmpty((Collection)null)).isTrue();
        Assertions.assertThat((boolean)Utils.isNullOrEmpty(Collections.emptyList())).isTrue();
        Assertions.assertThat((boolean)Utils.isNullOrEmpty(Collections.singletonList("abc"))).isFalse();
    }

    @Test
    void iterable_is_null_or_empty() {
        Assertions.assertThat((boolean)Utils.isNullOrEmpty((Iterable)null)).isTrue();
        Assertions.assertThat((boolean)Utils.isNullOrEmpty(Collections.emptyList())).isTrue();
        Assertions.assertThat((boolean)Utils.isNullOrEmpty(Collections.singletonList("abc"))).isFalse();
    }

    @Test
    void array_is_null_or_empty() {
        Assertions.assertThat((boolean)Utils.isNullOrEmpty((Object[])null)).isTrue();
        Assertions.assertThat((boolean)Utils.isNullOrEmpty((Object[])new Object[0])).isTrue();
        Assertions.assertThat((boolean)Utils.isNullOrEmpty((Object[])new Object[]{"abc"})).isFalse();
        Assertions.assertThat((boolean)Utils.isNullOrEmpty((Object[])new Object[]{"a", "b", "c"})).isFalse();
        Assertions.assertThat((boolean)Utils.isNullOrEmpty((Object[])new Object[]{null})).isFalse();
        Assertions.assertThat((boolean)Utils.isNullOrEmpty((Object[])new Object[]{null, "xyz"})).isFalse();
    }

    @Test
    void repeat() {
        Assertions.assertThat((String)Utils.repeat((String)"foo", (int)0)).isEmpty();
        Assertions.assertThat((String)Utils.repeat((String)"foo", (int)1)).isEqualTo("foo");
        Assertions.assertThat((String)Utils.repeat((String)"foo", (int)2)).isEqualTo("foofoo");
        Assertions.assertThat((String)Utils.repeat((String)"foo", (int)3)).isEqualTo("foofoofoo");
    }

    @Test
    void randomUUIDWorks() {
        String uuid1 = Utils.randomUUID();
        String uuid2 = Utils.randomUUID();
        ((AbstractStringAssert)Assertions.assertThat((String)uuid1).isNotNull()).isNotEmpty();
        ((AbstractStringAssert)Assertions.assertThat((String)uuid2).isNotNull()).isNotEmpty();
        Assertions.assertThat((String)uuid1).isNotEqualTo((Object)uuid2);
        Assertions.assertThat((Comparable)UUID.fromString(uuid1)).isInstanceOf(UUID.class);
        Assertions.assertThat((Comparable)UUID.fromString(uuid2)).isInstanceOf(UUID.class);
    }

    @Test
    void generateUUIDFromTextWorks() {
        String input1 = "Hello";
        String input2 = "World";
        String uuidFromInput1 = Utils.generateUUIDFrom((String)input1);
        String uuidFromInput2 = Utils.generateUUIDFrom((String)input2);
        ((AbstractStringAssert)Assertions.assertThat((String)uuidFromInput1).isNotNull()).isNotEmpty();
        ((AbstractStringAssert)Assertions.assertThat((String)uuidFromInput2).isNotNull()).isNotEmpty();
        Assertions.assertThat((String)uuidFromInput1).isNotEqualTo((Object)uuidFromInput2);
        Assertions.assertThat((Comparable)UUID.fromString(uuidFromInput1)).isInstanceOf(UUID.class);
        Assertions.assertThat((Comparable)UUID.fromString(uuidFromInput2)).isInstanceOf(UUID.class);
        Assertions.assertThat((String)Utils.generateUUIDFrom((String)input1)).isEqualTo(uuidFromInput1);
    }

    @Test
    void generateUUIDFromEmptyInputWorks() {
        String uuidFromEmptyInput = Utils.generateUUIDFrom((String)"");
        ((AbstractStringAssert)Assertions.assertThat((String)uuidFromEmptyInput).isNotNull()).isNotEmpty();
        Assertions.assertThat((Comparable)UUID.fromString(uuidFromEmptyInput)).isInstanceOf(UUID.class);
    }

    @Test
    void generateUUIDFromNullInputWorks() {
        Assertions.assertThatExceptionOfType(NullPointerException.class).isThrownBy(() -> Utils.generateUUIDFrom(null));
    }

    @MethodSource
    @ParameterizedTest
    void test_quoted(String string, String expected) {
        Assertions.assertThat((String)Utils.quoted((Object)string)).isEqualTo(expected);
    }

    static Stream<Arguments> test_quoted() {
        return Stream.of(Arguments.of((Object[])new Object[]{null, "null"}), Arguments.of((Object[])new Object[]{"", "\"\""}), Arguments.of((Object[])new Object[]{" ", "\" \""}), Arguments.of((Object[])new Object[]{"hello", "\"hello\""}));
    }

    @Test
    void first_chars() {
        Assertions.assertThat((String)Utils.firstChars(null, (int)3)).isNull();
        Assertions.assertThat((String)Utils.firstChars((String)"", (int)3)).isEmpty();
        Assertions.assertThat((String)Utils.firstChars((String)"foo", (int)3)).isEqualTo("foo");
        Assertions.assertThat((String)Utils.firstChars((String)"foobar", (int)3)).isEqualTo("foo");
    }

    @Test
    void read_bytes() throws IOException {
        HttpServer httpServer = HttpServer.create(new InetSocketAddress(0), 0);
        try {
            int port = httpServer.getAddress().getPort();
            httpServer.createContext("/ok_endpoint", exchange -> {
                byte[] response = "hello".getBytes();
                exchange.sendResponseHeaders(200, response.length);
                exchange.getResponseBody().write(response);
                exchange.close();
            });
            httpServer.createContext("/error_endpoint", exchange -> {
                byte[] response = "nope".getBytes();
                exchange.sendResponseHeaders(500, response.length);
                exchange.getResponseBody().write(response);
                exchange.close();
            });
            httpServer.start();
            Assertions.assertThat((byte[])Utils.readBytes((String)("http://localhost:" + port + "/ok_endpoint"))).isEqualTo((Object)"hello".getBytes());
            Assertions.assertThatExceptionOfType(RuntimeException.class).isThrownBy(() -> Utils.readBytes((String)("http://localhost:" + port + "/error_endpoint"))).withMessageContaining("Error while reading: 500");
        }
        finally {
            httpServer.stop(0);
        }
    }

    @Test
    void copy_if_not_null_set() {
        Assertions.assertThat((Collection)Utils.copyIfNotNull((Set)null)).isNull();
        Assertions.assertThat((Collection)Utils.copyIfNotNull(Collections.emptySet())).isEmpty();
        Assertions.assertThat((Collection)Utils.copyIfNotNull(Set.of("one"))).containsExactly((Object[])new String[]{"one"});
        Assertions.assertThat((Collection)Utils.copyIfNotNull(Set.of("one", "two"))).containsExactlyInAnyOrder((Object[])new String[]{"one", "two"});
    }

    @Test
    void copy_set() {
        Assertions.assertThat((Collection)Utils.copy((Set)null)).isEmpty();
        Assertions.assertThat((Collection)Utils.copy(Collections.emptySet())).isEmpty();
        Assertions.assertThat((Collection)Utils.copy(Set.of("one"))).containsExactly((Object[])new String[]{"one"});
        Assertions.assertThat((Collection)Utils.copy(Set.of("one", "two"))).containsExactlyInAnyOrder((Object[])new String[]{"one", "two"});
    }

    @Test
    void copy_if_not_null_list() {
        Assertions.assertThat((List)Utils.copyIfNotNull((List)null)).isNull();
        Assertions.assertThat((List)Utils.copyIfNotNull(Collections.emptyList())).isEmpty();
        Assertions.assertThat((List)Utils.copyIfNotNull(Collections.singletonList("one"))).containsExactly((Object[])new String[]{"one"});
        Assertions.assertThat((List)Utils.copyIfNotNull(Arrays.asList("one", "two"))).containsExactly((Object[])new String[]{"one", "two"});
    }

    @Test
    void copy_list() {
        Assertions.assertThat((List)Utils.copy((List)null)).isEmpty();
        Assertions.assertThat((List)Utils.copy(Collections.emptyList())).isEmpty();
        Assertions.assertThat((List)Utils.copy(Collections.singletonList("one"))).containsExactly((Object[])new String[]{"one"});
        Assertions.assertThat((List)Utils.copy(Arrays.asList("one", "two"))).containsExactly((Object[])new String[]{"one", "two"});
    }

    @Test
    void copy_if_not_null_map() {
        Assertions.assertThat((Map)Utils.copyIfNotNull((Map)null)).isNull();
        Assertions.assertThat((Map)Utils.copyIfNotNull(Collections.emptyMap())).isEmpty();
        Assertions.assertThat((Map)Utils.copyIfNotNull(Collections.singletonMap("key", "value"))).containsExactly(new Map.Entry[]{Assertions.entry((Object)"key", (Object)"value")});
    }

    @Test
    void copy_map() {
        Assertions.assertThat((Map)Utils.copy((Map)null)).isEmpty();
        Assertions.assertThat((Map)Utils.copy(Collections.emptyMap())).isEmpty();
        Assertions.assertThat((Map)Utils.copy(Collections.singletonMap("key", "value"))).containsExactly(new Map.Entry[]{Assertions.entry((Object)"key", (Object)"value")});
    }

    @Test
    void ensure_trailing_forward_slash() {
        Assertions.assertThat((String)Utils.ensureTrailingForwardSlash((String)"https://example.com")).isEqualTo("https://example.com/");
        Assertions.assertThat((String)Utils.ensureTrailingForwardSlash((String)"https://example.com/")).isEqualTo("https://example.com/");
        Assertions.assertThat((String)Utils.ensureTrailingForwardSlash((String)"https://example.com/a")).isEqualTo("https://example.com/a/");
        Assertions.assertThat((String)Utils.ensureTrailingForwardSlash((String)"https://example.com/a/")).isEqualTo("https://example.com/a/");
        Assertions.assertThat((String)Utils.ensureTrailingForwardSlash((String)"https://example.com/a/b")).isEqualTo("https://example.com/a/b/");
    }

    @Test
    void shouldThrowNullPointerExceptionForNullInput() {
        Assertions.assertThat((Map)Utils.toStringValueMap(null)).isNull();
    }

    @Test
    void shouldReturnEmptyMapForEmptyInput() {
        HashMap input = new HashMap();
        Map result = Utils.toStringValueMap(input);
        Assertions.assertThat((Map)result).isEmpty();
    }

    @Test
    void shouldConvertValuesToString() {
        HashMap<String, Object> input = new HashMap<String, Object>();
        input.put("int", 42);
        input.put("double", 3.14);
        input.put("boolean", true);
        input.put("string", "hello");
        Map result = Utils.toStringValueMap(input);
        ((MapAssert)((MapAssert)((MapAssert)Assertions.assertThat((Map)result).containsEntry((Object)"int", (Object)"42")).containsEntry((Object)"double", (Object)"3.14")).containsEntry((Object)"boolean", (Object)"true")).containsEntry((Object)"string", (Object)"hello");
    }

    @Test
    void shouldHandleNullValuesCorrectly() {
        HashMap<String, Object> input = new HashMap<String, Object>();
        input.put("key1", null);
        Map result = Utils.toStringValueMap(input);
        Assertions.assertThat((Map)result).containsEntry((Object)"key1", null);
    }

    @MethodSource
    @ParameterizedTest
    void test_firstNotNull(Object[] values, Object expected) {
        Assertions.assertThat((Object)Utils.firstNotNull((String)"testParam", (Object[])values)).isEqualTo(expected);
    }

    static Stream<Arguments> test_firstNotNull() {
        return Stream.of(Arguments.of((Object[])new Object[]{new Object[]{"first", "second"}, "first"}), Arguments.of((Object[])new Object[]{new Object[]{null, "second"}, "second"}), Arguments.of((Object[])new Object[]{new Object[]{null, null, "third"}, "third"}), Arguments.of((Object[])new Object[]{new Object[]{42, null}, 42}), Arguments.of((Object[])new Object[]{new Object[]{null, true}, true}));
    }

    @Test
    void firstNotNull_throwsWhenAllValuesAreNull() {
        Assertions.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> Utils.firstNotNull((String)"testParam", (Object[])new Object[]{null, null})).withMessageContaining("At least one of the given 'testParam' values must be not null");
    }

    @Test
    void firstNotNull_throwsWhenValuesArrayIsEmpty() {
        Assertions.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> Utils.firstNotNull((String)"testParam", (Object[])new Object[0])).withMessageContaining("testParam values cannot be null or empty");
    }

    @Test
    void shouldRetrieveAnnotationOnActualMethod() throws NoSuchMethodException {
        Method myMethod = MyInterface.class.getDeclaredMethod("myMethod", new Class[0]);
        Assertions.assertThat((Optional)Utils.getAnnotatedMethod((Method)myMethod, MyAnnotation.class)).contains((Object)myMethod);
        Assertions.assertThat((Optional)Utils.getAnnotatedMethod((Method)myMethod, AnotherAnnotation.class)).isEmpty();
    }

    @Test
    void shouldRetrieveAnnotationOnProxyMethod() throws NoSuchMethodException {
        Object proxyInstance = Proxy.newProxyInstance(MyInterface.class.getClassLoader(), new Class[]{MyInterface.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Exception {
                return null;
            }
        });
        Method proxyMethod = proxyInstance.getClass().getDeclaredMethod("myMethod", new Class[0]);
        Method myMethod = MyInterface.class.getDeclaredMethod("myMethod", new Class[0]);
        Assertions.assertThat((Optional)Utils.getAnnotatedMethod((Method)proxyMethod, MyAnnotation.class)).contains((Object)myMethod);
        Assertions.assertThat((Optional)Utils.getAnnotatedMethod((Method)proxyMethod, AnotherAnnotation.class)).isEmpty();
    }

    public static interface MyInterface {
        @MyAnnotation
        public void myMethod();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface MyAnnotation {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface AnotherAnnotation {
    }
}

