/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.internal;

import dev.langchain4j.internal.RetryUtils;
import java.util.concurrent.Callable;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class RetryUtilsTest {
    RetryUtilsTest() {
    }

    @Test
    void jitter() {
        Assertions.assertThat((double)RetryUtils.DEFAULT_RETRY_POLICY.rawDelayMs(0)).isEqualTo(500.0);
        Assertions.assertThat((double)RetryUtils.DEFAULT_RETRY_POLICY.rawDelayMs(1)).isEqualTo(750.0);
        Assertions.assertThat((double)RetryUtils.DEFAULT_RETRY_POLICY.rawDelayMs(2)).isEqualTo(1125.0);
        for (int i = 0; i < 100; ++i) {
            Assertions.assertThat((int)RetryUtils.DEFAULT_RETRY_POLICY.jitterDelayMillis(2)).isBetween(Integer.valueOf(1125), Integer.valueOf(1350));
        }
    }

    @Test
    void with_retry_directly() throws Exception {
        Callable mockAction = (Callable)Mockito.mock(Callable.class);
        Mockito.when((Object)((String)mockAction.call())).thenReturn((Object)"Success");
        String result = (String)RetryUtils.withRetry((Callable)mockAction, (int)1);
        Assertions.assertThat((String)result).isEqualTo("Success");
        ((Callable)Mockito.verify((Object)mockAction)).call();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{mockAction});
    }

    @Test
    void with_retry_no_attempts_directly() throws Exception {
        Callable mockAction = (Callable)Mockito.mock(Callable.class);
        Mockito.when((Object)((String)mockAction.call())).thenReturn((Object)"Success");
        String result = (String)RetryUtils.withRetry((Callable)mockAction);
        Assertions.assertThat((String)result).isEqualTo("Success");
        ((Callable)Mockito.verify((Object)mockAction)).call();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{mockAction});
    }

    @Test
    void successfulCall() throws Exception {
        Callable mockAction = (Callable)Mockito.mock(Callable.class);
        Mockito.when((Object)((String)mockAction.call())).thenReturn((Object)"Success");
        String result = (String)RetryUtils.retryPolicyBuilder().delayMillis(100).build().withRetry(mockAction, 2);
        Assertions.assertThat((String)result).isEqualTo("Success");
        ((Callable)Mockito.verify((Object)mockAction)).call();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{mockAction});
    }

    @Test
    void retryThenSuccess() throws Exception {
        Callable mockAction = (Callable)Mockito.mock(Callable.class);
        Mockito.when((Object)((String)mockAction.call())).thenThrow(new Throwable[]{new RuntimeException()}).thenReturn((Object)"Success");
        RetryUtils.RetryPolicy retryPolicy = RetryUtils.retryPolicyBuilder().delayMillis(100).build();
        long startTime = System.currentTimeMillis();
        String result = (String)retryPolicy.withRetry(mockAction, Integer.MAX_VALUE);
        long endTime = System.currentTimeMillis();
        long duration = endTime - startTime;
        Assertions.assertThat((String)result).isEqualTo("Success");
        ((Callable)Mockito.verify((Object)mockAction, (VerificationMode)Mockito.times((int)2))).call();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{mockAction});
        Assertions.assertThat((long)duration).isGreaterThanOrEqualTo(100L);
    }

    @Test
    void maxAttemptsReached() throws Exception {
        Callable mockAction = (Callable)Mockito.mock(Callable.class);
        Mockito.when((Object)((String)mockAction.call())).thenThrow(new Throwable[]{new RuntimeException()});
        RetryUtils.RetryPolicy policy = RetryUtils.retryPolicyBuilder().delayMillis(100).build();
        Assertions.assertThatThrownBy(() -> policy.withRetry(mockAction, 2)).isInstanceOf(RuntimeException.class);
        ((Callable)Mockito.verify((Object)mockAction, (VerificationMode)Mockito.times((int)3))).call();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{mockAction});
    }

    @Test
    void zeroAttemptsReached() throws Exception {
        Callable mockAction = (Callable)Mockito.mock(Callable.class);
        Mockito.when((Object)((String)mockAction.call())).thenThrow(new Throwable[]{new RuntimeException()});
        RetryUtils.RetryPolicy policy = RetryUtils.retryPolicyBuilder().delayMillis(100).build();
        Assertions.assertThatThrownBy(() -> policy.withRetry(mockAction, 0)).isInstanceOf(RuntimeException.class);
        ((Callable)Mockito.verify((Object)mockAction, (VerificationMode)Mockito.times((int)1))).call();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{mockAction});
    }

    @Test
    void illegalAttemptsReached() throws Exception {
        Callable mockAction = (Callable)Mockito.mock(Callable.class);
        Mockito.when((Object)((String)mockAction.call())).thenThrow(new Throwable[]{new RuntimeException()});
        RetryUtils.RetryPolicy policy = RetryUtils.retryPolicyBuilder().delayMillis(100).build();
        Assertions.assertThatThrownBy(() -> policy.withRetry(mockAction, -1)).isInstanceOf(RuntimeException.class);
        ((Callable)Mockito.verify((Object)mockAction, (VerificationMode)Mockito.times((int)1))).call();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{mockAction});
    }
}

