/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.data.message;

import dev.langchain4j.data.message.ChatMessageType;
import dev.langchain4j.data.message.Content;
import dev.langchain4j.data.message.TextContent;
import dev.langchain4j.data.message.UserMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.WithAssertions;
import org.junit.jupiter.api.Test;

class UserMessageTest
implements WithAssertions {
    UserMessageTest() {
    }

    @Test
    void accessors() {
        UserMessage m = new UserMessage("name", "text");
        this.assertThat((Comparable)m.type()).isEqualTo((Object)ChatMessageType.USER);
        this.assertThat(m.singleText()).isEqualTo("text");
        this.assertThat(m.contents()).containsExactly((Object[])new Content[]{TextContent.from((String)"text")});
        this.assertThat(m.name()).isEqualTo("name");
        this.assertThat(m).hasToString("UserMessage { name = \"name\" contents = [TextContent { text = \"text\" }] }");
    }

    @Test
    void equals_hash_code() {
        UserMessage m1 = new UserMessage("name", "text");
        UserMessage m2 = new UserMessage("name", "text");
        UserMessage m3 = new UserMessage("text");
        UserMessage m4 = new UserMessage("text");
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)this.assertThat(m1).isEqualTo((Object)m1)).isNotEqualTo(null)).isNotEqualTo(new Object())).isEqualTo((Object)m2)).hasSameHashCodeAs((Object)m2)).isNotEqualTo((Object)m3)).doesNotHaveSameHashCodeAs((Object)m3)).isNotEqualTo((Object)new UserMessage("foo", "text"))).isNotEqualTo((Object)new UserMessage("name", "foo"));
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)this.assertThat(m3).isEqualTo((Object)m3)).isNotEqualTo(null)).isNotEqualTo(new Object())).isEqualTo((Object)m4)).hasSameHashCodeAs((Object)m4);
    }

    @SafeVarargs
    public static <T> List<T> listOf(T ... elements) {
        return Collections.unmodifiableList(new ArrayList<T>(Arrays.asList(elements)));
    }

    @Test
    void has_single_text() {
        this.assertThat(new UserMessage("text").hasSingleText()).isTrue();
        this.assertThat(new UserMessage("name", "text").hasSingleText()).isTrue();
        this.assertThat(new UserMessage("name", UserMessageTest.listOf(new TextContent("text"))).hasSingleText()).isTrue();
        this.assertThat(new UserMessage("name", UserMessageTest.listOf(new TextContent("abc"), new TextContent("def"))).hasSingleText()).isFalse();
        this.assertThat(new UserMessage(UserMessageTest.listOf(new TextContent("text"))).hasSingleText()).isTrue();
        this.assertThat(new UserMessage(UserMessageTest.listOf(new TextContent("abc"), new TextContent("def"))).hasSingleText()).isFalse();
        this.assertThat(new UserMessage("text").singleText()).isEqualTo("text");
        this.assertThatExceptionOfType(RuntimeException.class).isThrownBy(() -> new UserMessage("name", UserMessageTest.listOf(new TextContent("abc"), new TextContent("def"))).singleText()).withMessageContaining("Expecting single text content, but got:");
    }

    @Test
    void builders() {
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)this.assertThat(new UserMessage("text")).isEqualTo((Object)UserMessage.from((String)"text"))).isEqualTo((Object)UserMessage.from((Content[])new Content[]{new TextContent("text")}))).isEqualTo((Object)UserMessage.from(UserMessageTest.listOf(new TextContent("text"))))).isEqualTo((Object)UserMessage.userMessage((String)"text"))).isEqualTo((Object)UserMessage.userMessage((Content[])new Content[]{new TextContent("text")}))).isEqualTo((Object)UserMessage.userMessage(UserMessageTest.listOf(new TextContent("text"))));
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)this.assertThat(new UserMessage("name", "text")).isEqualTo((Object)UserMessage.from((String)"name", (String)"text"))).isEqualTo((Object)UserMessage.from((String)"name", (Content[])new Content[]{new TextContent("text")}))).isEqualTo((Object)UserMessage.from((String)"name", UserMessageTest.listOf(new TextContent("text"))))).isEqualTo((Object)UserMessage.userMessage((String)"name", (String)"text"))).isEqualTo((Object)UserMessage.userMessage((String)"name", (Content[])new Content[]{new TextContent("text")}))).isEqualTo((Object)UserMessage.userMessage((String)"name", UserMessageTest.listOf(new TextContent("text"))));
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)this.assertThat(new UserMessage("name", UserMessageTest.listOf(new TextContent("abc"), new TextContent("def")))).isEqualTo((Object)UserMessage.from((String)"name", UserMessageTest.listOf(new TextContent("abc"), new TextContent("def"))))).isEqualTo((Object)UserMessage.from((String)"name", (Content[])new Content[]{new TextContent("abc"), new TextContent("def")}))).isEqualTo((Object)UserMessage.userMessage((String)"name", UserMessageTest.listOf(new TextContent("abc"), new TextContent("def"))))).isEqualTo((Object)UserMessage.userMessage((String)"name", (Content[])new Content[]{new TextContent("abc"), new TextContent("def")}));
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)this.assertThat(new UserMessage(UserMessageTest.listOf(new TextContent("abc"), new TextContent("def")))).isEqualTo((Object)UserMessage.from(UserMessageTest.listOf(new TextContent("abc"), new TextContent("def"))))).isEqualTo((Object)UserMessage.from((Content[])new Content[]{new TextContent("abc"), new TextContent("def")}))).isEqualTo((Object)UserMessage.userMessage(UserMessageTest.listOf(new TextContent("abc"), new TextContent("def"))))).isEqualTo((Object)UserMessage.userMessage((Content[])new Content[]{new TextContent("abc"), new TextContent("def")}));
    }
}

