/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla.parser.plugins.model;

import dev.hilla.parser.core.AbstractPlugin;
import dev.hilla.parser.core.NodeDependencies;
import dev.hilla.parser.core.NodePath;
import dev.hilla.parser.core.Plugin;
import dev.hilla.parser.core.PluginConfiguration;
import dev.hilla.parser.models.AnnotationInfoModel;
import dev.hilla.parser.models.AnnotationParameterModel;
import dev.hilla.parser.models.NamedModel;
import dev.hilla.parser.models.SignatureModel;
import dev.hilla.parser.plugins.backbone.BackbonePlugin;
import dev.hilla.parser.plugins.backbone.nodes.AnnotatedNode;
import dev.hilla.parser.plugins.backbone.nodes.TypedNode;
import dev.hilla.parser.plugins.model.ValidationConstraint;
import io.swagger.v3.oas.models.media.Schema;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public final class ModelPlugin
extends AbstractPlugin<PluginConfiguration> {
    private static final String VALIDATION_CONSTRAINTS_KEY = "x-validation-constraints";
    private static final String VALIDATION_CONSTRAINTS_PACKAGE_NAME = "jakarta.validation.constraints";

    private static ValidationConstraint convertAnnotation(AnnotationInfoModel annotation) {
        String simpleName = ModelPlugin.extractSimpleName(annotation.getName());
        Map<String, Object> attributes = annotation.getParameters().stream().filter(Predicate.not(AnnotationParameterModel::isDefault)).collect(Collectors.toMap(NamedModel::getName, AnnotationParameterModel::getValue));
        return new ValidationConstraint(simpleName, !attributes.isEmpty() ? attributes : null);
    }

    private static String extractSimpleName(String fullyQualifiedName) {
        return fullyQualifiedName.substring(fullyQualifiedName.lastIndexOf(".") + 1);
    }

    private static boolean isValidationConstraintAnnotation(AnnotationInfoModel annotation) {
        return annotation.getName().startsWith(VALIDATION_CONSTRAINTS_PACKAGE_NAME);
    }

    public void enter(NodePath<?> nodePath) {
        if (!(nodePath.getNode() instanceof TypedNode)) {
            return;
        }
        TypedNode typedNode = (TypedNode)nodePath.getNode();
        SignatureModel signature = typedNode.getType();
        if (signature.isTypeArgument() || signature.isTypeParameter()) {
            return;
        }
        Schema schema = typedNode.getTarget();
        this.addConstraintsToSchema((AnnotatedNode)typedNode, schema);
    }

    public void exit(NodePath<?> nodePath) {
    }

    public Collection<Class<? extends Plugin>> getRequiredPlugins() {
        return List.of(BackbonePlugin.class);
    }

    @Nonnull
    public NodeDependencies scan(@Nonnull NodeDependencies nodeDependencies) {
        return nodeDependencies;
    }

    private void addConstraintsToSchema(AnnotatedNode annotatedNode, Schema<?> schema) {
        List constraints = annotatedNode.getAnnotations().stream().filter(ModelPlugin::isValidationConstraintAnnotation).map(ModelPlugin::convertAnnotation).collect(Collectors.toList());
        if (!constraints.isEmpty()) {
            schema.addExtension(VALIDATION_CONSTRAINTS_KEY, constraints);
        }
    }
}

