/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla.parser.plugins.backbone;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonIncludeProperties;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.util.IgnorePropertiesUtil;
import dev.hilla.parser.core.AbstractPlugin;
import dev.hilla.parser.core.Node;
import dev.hilla.parser.core.NodeDependencies;
import dev.hilla.parser.core.NodePath;
import dev.hilla.parser.core.PluginConfiguration;
import dev.hilla.parser.jackson.JacksonObjectMapperFactory;
import dev.hilla.parser.models.ClassInfoModel;
import dev.hilla.parser.models.jackson.JacksonPropertyModel;
import dev.hilla.parser.plugins.backbone.BackbonePluginConfiguration;
import dev.hilla.parser.plugins.backbone.BackbonePluginException;
import dev.hilla.parser.plugins.backbone.nodes.EntityNode;
import dev.hilla.parser.plugins.backbone.nodes.PropertyNode;
import jakarta.annotation.Nonnull;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;

public final class PropertyPlugin
extends AbstractPlugin<BackbonePluginConfiguration> {
    private SerializationConfig serializationConfig = new JacksonObjectMapperFactory.Json().build().getSerializationConfig();

    public void enter(NodePath<?> nodePath) {
        if (nodePath.getNode() instanceof PropertyNode) {
            PropertyNode propertyNode = (PropertyNode)nodePath.getNode();
            propertyNode.setTarget(((JacksonPropertyModel)propertyNode.getSource()).getName());
        }
    }

    public void exit(NodePath<?> nodePath) {
    }

    @Nonnull
    public NodeDependencies scan(@Nonnull NodeDependencies nodeDependencies) {
        if (!(nodeDependencies.getNode() instanceof EntityNode)) {
            return nodeDependencies;
        }
        Node node = nodeDependencies.getNode();
        ClassInfoModel model = (ClassInfoModel)node.getSource();
        if (model.isEnum()) {
            return nodeDependencies;
        }
        Stream<Node> properties = this.collectProperties(model).map(PropertyNode::of);
        return nodeDependencies.appendChildNodes(properties);
    }

    public void setConfiguration(PluginConfiguration configuration) {
        super.setConfiguration(configuration);
        JacksonObjectMapperFactory factory = this.loadJacksonObjectMapperFactory();
        if (factory != null) {
            this.serializationConfig = factory.build().getSerializationConfig();
        }
    }

    private Stream<JacksonPropertyModel> collectProperties(@Nonnull ClassInfoModel model) {
        Object cls = Objects.requireNonNull(model).get();
        if (!(cls instanceof Class)) {
            throw new BackbonePluginException("Jackson: Only reflection models are supported");
        }
        BeanDescription description = this.serializationConfig.introspect(this.serializationConfig.constructType((Class)cls));
        PropertyProcessor processor = new PropertyProcessor(description);
        return processor.stream();
    }

    private JacksonObjectMapperFactory loadJacksonObjectMapperFactory() {
        BackbonePluginConfiguration config = (BackbonePluginConfiguration)this.getConfiguration();
        if (config != null && config.getObjectMapperFactoryClassName() != null) {
            Class<?> cls;
            try {
                cls = Class.forName(config.getObjectMapperFactoryClassName());
            }
            catch (ClassNotFoundException e) {
                throw new BackbonePluginException("ObjectMapper factory class is not found", e);
            }
            if (!JacksonObjectMapperFactory.class.isAssignableFrom(cls)) {
                throw new BackbonePluginException(String.format("Class %s does not implement JacksonObjectMapperFactory interface", cls.getName()));
            }
            try {
                return (JacksonObjectMapperFactory)cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new BackbonePluginException("Cannot instantiate ObjectMapper factory", e);
            }
        }
        return null;
    }

    private class PropertyProcessor {
        private final BeanDescription description;

        PropertyProcessor(BeanDescription description) {
            this.description = description;
        }

        public Stream<JacksonPropertyModel> stream() {
            Stream<JacksonPropertyModel> properties = this.description.findProperties().stream().map(JacksonPropertyModel::of);
            properties = this.filterSuperClassProperties(properties);
            properties = this.filterPropertiesWithIgnoredTypes(properties);
            if (PropertyPlugin.this.serializationConfig.isEnabled(MapperFeature.REQUIRE_SETTERS_FOR_GETTERS)) {
                properties = this.filterSetterlessGetters(properties);
            }
            return this.filterIgnoredProperties(properties);
        }

        private Stream<JacksonPropertyModel> filterIgnoredProperties(Stream<JacksonPropertyModel> properties) {
            Set<String> ignored = this.findIgnored();
            Set<String> included = this.findIncluded();
            if (included != null || ignored != null && !ignored.isEmpty()) {
                properties = properties.filter(property -> !IgnorePropertiesUtil.shouldIgnore((Object)property.getName(), (Collection)ignored, (Collection)included));
            }
            return properties;
        }

        private Stream<JacksonPropertyModel> filterPropertiesWithIgnoredTypes(Stream<JacksonPropertyModel> properties) {
            HashMap ignores = new HashMap();
            AnnotationIntrospector introspector = PropertyPlugin.this.serializationConfig.getAnnotationIntrospector();
            return properties.filter(property -> {
                Class type = property.get().getRawPrimaryType();
                Boolean result = (Boolean)ignores.get(type);
                if (result == null) {
                    AnnotatedClass classInfo;
                    result = PropertyPlugin.this.serializationConfig.getConfigOverride(type).getIsIgnoredType();
                    if (result == null && (result = introspector.isIgnorableType(classInfo = PropertyPlugin.this.serializationConfig.introspectClassAnnotations(type).getClassInfo())) == null) {
                        result = Boolean.FALSE;
                    }
                    ignores.put(type, result);
                }
                return result == false;
            });
        }

        private Stream<JacksonPropertyModel> filterSetterlessGetters(Stream<JacksonPropertyModel> properties) {
            return properties.filter(property -> property.couldDeserialize() || property.isExplicitlyIncluded());
        }

        private Stream<JacksonPropertyModel> filterSuperClassProperties(Stream<JacksonPropertyModel> properties) {
            return properties.filter(property -> property.getOwner().is(this.description.getBeanClass()));
        }

        private Set<String> findIgnored() {
            JsonIgnoreProperties.Value ignored = PropertyPlugin.this.serializationConfig.getDefaultPropertyIgnorals(this.description.getBeanClass(), this.description.getClassInfo());
            return ignored == null ? null : ignored.findIgnoredForSerialization();
        }

        private Set<String> findIncluded() {
            JsonIncludeProperties.Value included = PropertyPlugin.this.serializationConfig.getDefaultPropertyInclusions(this.description.getBeanClass(), this.description.getClassInfo());
            return included == null ? null : included.getIncluded();
        }
    }
}

