/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla.parser.plugins.backbone;

import dev.hilla.parser.core.AbstractPlugin;
import dev.hilla.parser.core.NodeDependencies;
import dev.hilla.parser.core.NodePath;
import dev.hilla.parser.core.RootNode;
import dev.hilla.parser.models.ClassInfoModel;
import dev.hilla.parser.models.ClassRefSignatureModel;
import dev.hilla.parser.models.FieldInfoModel;
import dev.hilla.parser.models.NamedModel;
import dev.hilla.parser.plugins.backbone.BackbonePluginConfiguration;
import dev.hilla.parser.plugins.backbone.nodes.EntityNode;
import dev.hilla.parser.plugins.backbone.nodes.TypedNode;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public final class EntityPlugin
extends AbstractPlugin<BackbonePluginConfiguration> {
    public void enter(NodePath<?> nodePath) {
        if (nodePath.getNode() instanceof EntityNode) {
            EntityNode entityNode;
            ClassInfoModel cls = (ClassInfoModel)(entityNode = (EntityNode)nodePath.getNode()).getSource();
            entityNode.setTarget(cls.isEnum() ? this.enumSchema(cls) : new ObjectSchema());
        }
    }

    public void exit(NodePath<?> nodePath) {
        if (nodePath.getNode() instanceof EntityNode && nodePath.getParentPath().getNode() instanceof RootNode) {
            Schema schema = (Schema)nodePath.getNode().getTarget();
            ClassInfoModel cls = (ClassInfoModel)nodePath.getNode().getSource();
            OpenAPI openApi = (OpenAPI)nodePath.getParentPath().getNode().getTarget();
            EntityPlugin.attachSchemaWithNameToOpenApi(schema, cls.getName(), openApi);
        }
    }

    @Nonnull
    public NodeDependencies scan(@Nonnull NodeDependencies nodeDependencies) {
        if (!(nodeDependencies.getNode() instanceof TypedNode)) {
            return nodeDependencies;
        }
        TypedNode typedNode = (TypedNode)nodeDependencies.getNode();
        if (!(typedNode.getType() instanceof ClassRefSignatureModel)) {
            return nodeDependencies;
        }
        ClassRefSignatureModel ref = (ClassRefSignatureModel)typedNode.getType();
        if (ref.isJDKClass() || ref.isDate() || ref.isIterable()) {
            return nodeDependencies;
        }
        return nodeDependencies.appendRelatedNodes(Stream.of(EntityNode.of(ref.getClassInfo())));
    }

    public static void attachSchemaWithNameToOpenApi(Schema<?> schema, String name, OpenAPI openApi) {
        Components components = openApi.getComponents();
        if (components == null) {
            components = new Components();
            openApi.setComponents(components);
        }
        components.addSchemas(name, schema);
    }

    private Schema<?> enumSchema(ClassInfoModel entity) {
        StringSchema schema = new StringSchema();
        schema.setEnum(entity.getFields().stream().filter(FieldInfoModel::isPublic).map(NamedModel::getName).collect(Collectors.toList()));
        return schema;
    }
}

