/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla.parser.plugins.backbone;

import dev.hilla.parser.core.AbstractNode;
import dev.hilla.parser.core.AbstractPlugin;
import dev.hilla.parser.core.Node;
import dev.hilla.parser.core.NodeDependencies;
import dev.hilla.parser.core.NodePath;
import dev.hilla.parser.models.ClassInfoModel;
import dev.hilla.parser.models.ClassRefSignatureModel;
import dev.hilla.parser.models.MethodInfoModel;
import dev.hilla.parser.models.NamedModel;
import dev.hilla.parser.models.SignatureModel;
import dev.hilla.parser.models.TypeArgumentModel;
import dev.hilla.parser.models.TypeParameterModel;
import dev.hilla.parser.models.TypeVariableModel;
import dev.hilla.parser.plugins.backbone.BackbonePluginConfiguration;
import dev.hilla.parser.plugins.backbone.nodes.EndpointExposedNode;
import dev.hilla.parser.plugins.backbone.nodes.EndpointNode;
import dev.hilla.parser.plugins.backbone.nodes.EndpointNonExposedNode;
import dev.hilla.parser.plugins.backbone.nodes.EndpointSignatureNode;
import dev.hilla.parser.plugins.backbone.nodes.MethodNode;
import dev.hilla.parser.plugins.backbone.nodes.TypeSignatureNode;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public final class EndpointExposedPlugin
extends AbstractPlugin<BackbonePluginConfiguration> {
    public void enter(NodePath<?> nodePath) {
    }

    public void exit(NodePath<?> nodePath) {
    }

    @Nonnull
    public Node<?, ?> resolve(@Nonnull Node<?, ?> node, @Nonnull NodePath<?> parentPath) {
        if (node instanceof MethodNode && parentPath.getNode() instanceof EndpointExposedNode) {
            return MethodNode.of((MethodInfoModel)((MethodNode)node).getSource());
        }
        if (!(node instanceof TypeSignatureNode)) {
            return node;
        }
        SignatureModel signature = (SignatureModel)node.getSource();
        if (!(signature instanceof TypeParameterModel)) {
            return node;
        }
        return TypeSignatureNode.of(this.resolveTypeParameter((TypeParameterModel)signature, parentPath));
    }

    @Nonnull
    public NodeDependencies scan(@Nonnull NodeDependencies nodeDependencies) {
        Node node = nodeDependencies.getNode();
        if (node instanceof EndpointNode || node instanceof EndpointExposedNode || node instanceof EndpointNonExposedNode) {
            ClassInfoModel cls = (ClassInfoModel)node.getSource();
            return nodeDependencies.appendChildNodes(this.scanEndpointClassSignature(cls));
        }
        if (node instanceof EndpointSignatureNode) {
            ClassRefSignatureModel classRef = (ClassRefSignatureModel)node.getSource();
            ClassInfoModel classInfo = classRef.getClassInfo();
            return nodeDependencies.appendChildNodes(Stream.of(this.createEndpointHierarchyClassNode(classInfo)));
        }
        return nodeDependencies;
    }

    private Node<?, ?> createEndpointHierarchyClassNode(ClassInfoModel classInfo) {
        String endpointExposedAnnotationName = this.getStorage().getParserConfig().getEndpointExposedAnnotationName();
        boolean exposed = classInfo.getAnnotations().stream().map(NamedModel::getName).anyMatch(endpointExposedAnnotationName::equals);
        AbstractNode classInfoNode = exposed ? EndpointExposedNode.of(classInfo) : EndpointNonExposedNode.of(classInfo);
        return classInfoNode;
    }

    private SignatureModel resolveTypeParameter(TypeParameterModel typeParameter, NodePath<?> path) {
        Optional<NodePath> closestEndpointSignaturePath = path.stream().filter(p -> p.getNode() instanceof EndpointSignatureNode).findFirst();
        if (closestEndpointSignaturePath.isEmpty()) {
            return typeParameter;
        }
        NodePath endpointSignaturePath = closestEndpointSignaturePath.get();
        ClassRefSignatureModel classRef = (ClassRefSignatureModel)endpointSignaturePath.getNode().getSource();
        int paramIndex = classRef.getClassInfo().getTypeParameters().indexOf(typeParameter);
        TypeArgumentModel typeArg = (TypeArgumentModel)classRef.getTypeArguments().get(paramIndex);
        if (!typeArg.getWildcard().equals((Object)TypeArgumentModel.Wildcard.NONE)) {
            return typeParameter;
        }
        SignatureModel signature = (SignatureModel)typeArg.getAssociatedTypes().get(0);
        if (signature instanceof TypeVariableModel) {
            TypeParameterModel endpointTypeParameter = ((TypeVariableModel)signature).resolve();
            return this.resolveTypeParameter(endpointTypeParameter, endpointSignaturePath.getParentPath());
        }
        return signature;
    }

    private Stream<Node<?, ?>> scanEndpointClassSignature(ClassInfoModel endpointClass) {
        return Stream.concat(endpointClass.getSuperClass().stream(), endpointClass.getInterfaces().stream()).map(EndpointSignatureNode::of);
    }
}

