/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla.parser.models;

import dev.hilla.parser.models.AnnotationInfoModel;
import dev.hilla.parser.models.BaseSignatureModel;
import dev.hilla.parser.models.ClassInfoModel;
import dev.hilla.parser.models.MethodInfoModel;
import dev.hilla.parser.models.MethodParameterInfoModel;
import dev.hilla.parser.models.ReflectionModel;
import dev.hilla.parser.models.SignatureModel;
import dev.hilla.parser.models.TypeParameterModel;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

abstract class MethodInfoReflectionModel
extends MethodInfoModel
implements ReflectionModel {
    MethodInfoReflectionModel() {
    }

    @Override
    public abstract Executable get();

    @Override
    public String getClassName() {
        return this.get().getDeclaringClass().getName();
    }

    @Override
    public int getModifiers() {
        return this.get().getModifiers();
    }

    @Override
    public boolean isAbstract() {
        return Modifier.isAbstract(this.getModifiers());
    }

    @Override
    public boolean isFinal() {
        return Modifier.isFinal(this.getModifiers());
    }

    @Override
    public boolean isNative() {
        return Modifier.isNative(this.getModifiers());
    }

    @Override
    public boolean isPrivate() {
        return Modifier.isPrivate(this.getModifiers());
    }

    @Override
    public boolean isProtected() {
        return Modifier.isProtected(this.getModifiers());
    }

    @Override
    public boolean isPublic() {
        return Modifier.isPublic(this.getModifiers());
    }

    @Override
    public boolean isStatic() {
        return Modifier.isStatic(this.getModifiers());
    }

    @Override
    public boolean isStrict() {
        return Modifier.isStrict(this.getModifiers());
    }

    @Override
    public boolean isSynchronized() {
        return Modifier.isSynchronized(this.getModifiers());
    }

    @Override
    public boolean isSynthetic() {
        return this.get().isSynthetic();
    }

    @Override
    public boolean isVarArgs() {
        return this.get().isVarArgs();
    }

    @Override
    protected List<AnnotationInfoModel> prepareAnnotations() {
        return MethodInfoReflectionModel.processAnnotations(this.get().getAnnotations());
    }

    @Override
    protected ClassInfoModel prepareOwner() {
        return ClassInfoModel.of(this.get().getDeclaringClass());
    }

    @Override
    protected List<MethodParameterInfoModel> prepareParameters() {
        return Arrays.stream(this.get().getParameters()).map(MethodParameterInfoModel::of).collect(Collectors.toList());
    }

    static final class Regular
    extends MethodInfoReflectionModel {
        private final Method origin;

        Regular(Method origin) {
            this.origin = origin;
        }

        @Override
        public Method get() {
            return this.origin;
        }

        @Override
        public String getName() {
            return this.origin.getName();
        }

        @Override
        public boolean isBridge() {
            return this.origin.isBridge();
        }

        @Override
        public boolean isConstructor() {
            return false;
        }

        @Override
        protected SignatureModel prepareResultType() {
            return SignatureModel.of(this.origin.getAnnotatedReturnType());
        }

        @Override
        protected List<TypeParameterModel> prepareTypeParameters() {
            return Arrays.stream(this.origin.getTypeParameters()).map(TypeParameterModel::of).collect(Collectors.toList());
        }
    }

    static final class Constructor
    extends MethodInfoReflectionModel {
        private static final String constructorName = "<init>";
        private final java.lang.reflect.Constructor<?> origin;

        Constructor(java.lang.reflect.Constructor<?> origin) {
            this.origin = origin;
        }

        @Override
        public java.lang.reflect.Constructor<?> get() {
            return this.origin;
        }

        @Override
        public String getName() {
            return constructorName;
        }

        @Override
        public boolean isBridge() {
            return false;
        }

        @Override
        public boolean isConstructor() {
            return true;
        }

        @Override
        protected SignatureModel prepareResultType() {
            return BaseSignatureModel.of(Void.TYPE);
        }

        @Override
        protected List<TypeParameterModel> prepareTypeParameters() {
            return List.of();
        }
    }
}

