/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla.parser.models;

import dev.hilla.parser.models.AnnotationInfoModel;
import dev.hilla.parser.models.ClassInfoModel;
import dev.hilla.parser.models.ClassRefSignatureModel;
import dev.hilla.parser.models.SourceSignatureModel;
import dev.hilla.parser.models.TypeArgumentModel;
import io.github.classgraph.AnnotationInfo;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.ClassRefTypeSignature;
import io.github.classgraph.TypeArgument;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.Collectors;

abstract class ClassRefSignatureSourceModel
extends ClassRefSignatureModel
implements SourceSignatureModel {
    protected final ClassRefTypeSignature origin;

    ClassRefSignatureSourceModel(ClassRefTypeSignature origin) {
        this.origin = origin;
    }

    public ClassRefTypeSignature get() {
        return this.origin;
    }

    protected List<AnnotationInfo> getOriginAnnotations() {
        return this.origin.getTypeAnnotationInfo();
    }

    protected ClassInfo getOriginClassInfo() {
        return this.origin.getClassInfo();
    }

    protected List<TypeArgument> getOriginTypeArguments() {
        return this.origin.getTypeArguments();
    }

    @Override
    protected List<AnnotationInfoModel> prepareAnnotations() {
        return ClassRefSignatureSourceModel.processAnnotations(this.getOriginAnnotations());
    }

    @Override
    protected ClassInfoModel prepareClassInfo() {
        return this.origin.getBaseClassName().equals("java.lang.Object") ? ClassInfoModel.of(Object.class) : ClassInfoModel.of(this.getOriginClassInfo());
    }

    @Override
    protected Optional<ClassRefSignatureModel> prepareOwner() {
        return Optional.empty();
    }

    @Override
    protected List<TypeArgumentModel> prepareTypeArguments() {
        return this.getOriginTypeArguments().stream().map(TypeArgumentModel::of).collect(Collectors.toList());
    }

    static final class SuffixedBase
    extends ClassRefSignatureSourceModel {
        SuffixedBase(ClassRefTypeSignature origin) {
            super(origin);
        }

        @Override
        protected ClassInfo getOriginClassInfo() {
            ClassInfoList outerClasses = this.origin.getClassInfo().getOuterClasses();
            return (ClassInfo)outerClasses.get(outerClasses.size() - 1);
        }
    }

    static final class Suffixed
    extends ClassRefSignatureSourceModel {
        private final int currentSuffixIndex;

        Suffixed(ClassRefTypeSignature origin) {
            this(origin, origin.getSuffixes().size() - 1);
        }

        Suffixed(ClassRefTypeSignature origin, int currentSuffixIndex) {
            super(origin);
            this.currentSuffixIndex = currentSuffixIndex;
        }

        @Override
        protected List<AnnotationInfo> getOriginAnnotations() {
            List suffixAnnotations = this.origin.getSuffixTypeAnnotationInfo();
            return suffixAnnotations != null ? (List)this.origin.getSuffixTypeAnnotationInfo().get(this.currentSuffixIndex) : null;
        }

        @Override
        protected ClassInfo getOriginClassInfo() {
            if (this.currentSuffixIndex == this.origin.getSuffixes().size() - 1) {
                return this.origin.getClassInfo();
            }
            ClassInfoList outerClasses = this.origin.getClassInfo().getOuterClasses();
            String currentSuffix = (String)this.origin.getSuffixes().get(this.currentSuffixIndex);
            for (ClassInfo cls : outerClasses) {
                if (!cls.getName().endsWith(currentSuffix)) continue;
                return cls;
            }
            throw new NoSuchElementException();
        }

        @Override
        protected List<TypeArgument> getOriginTypeArguments() {
            return (List)this.origin.getSuffixTypeArguments().get(this.currentSuffixIndex);
        }

        @Override
        protected Optional<ClassRefSignatureModel> prepareOwner() {
            return this.currentSuffixIndex > 0 ? Optional.of(new Suffixed(this.origin, this.currentSuffixIndex - 1)) : Optional.of(new SuffixedBase(this.origin));
        }
    }

    static final class Regular
    extends ClassRefSignatureSourceModel {
        public Regular(ClassRefTypeSignature origin) {
            super(origin);
        }
    }
}

