/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla.parser.core;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import dev.hilla.parser.core.OpenAPIFileType;
import dev.hilla.parser.core.ParserException;
import dev.hilla.parser.core.Plugin;
import dev.hilla.parser.core.PluginExecutor;
import dev.hilla.parser.core.PluginManager;
import dev.hilla.parser.core.RootNode;
import dev.hilla.parser.core.ScanResult;
import dev.hilla.parser.core.SharedStorage;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.swagger.v3.oas.models.OpenAPI;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Parser {
    private static final Logger logger = LoggerFactory.getLogger(Parser.class);
    private final Config config;
    private static final String ENDPOINT_EXPOSED_AND_ACL_ANNOTATIONS_ERROR_TEMPLATE = "Class `%s` is annotated with `%s` and `%s` annotation. %n\nClasses annotated with `%s` must not contain any of access control annotations and %n\nthis exception is for preventing the application startup with misconfiguration. The class level access %n\ncontrol rules of the child class will be applied for the inherited methods of this class. If the access %n\ncontrol rules for an inherited method should not follow the rules of the child endpoint, that method %n\nshould be overridden and annotated with the desired access control annotations explicitly. %n\n".stripIndent();
    private static final Set<String> ACL_ANNOTATIONS = Set.of("jakarta.annotation.security.DenyAll", "jakarta.annotation.security.PermitAll", "jakarta.annotation.security.RolesAllowed", "com.vaadin.flow.server.auth.AnonymousAllowed");

    public Parser() {
        try {
            String basicOpenAPIString = new String(Objects.requireNonNull(Parser.class.getResourceAsStream("OpenAPIBase.json")).readAllBytes());
            OpenAPI openAPI = Parser.parseOpenAPIFile(basicOpenAPIString, OpenAPIFileType.JSON, null);
            this.config = new Config(openAPI);
        }
        catch (IOException e) {
            throw new ParserException("Failed to parse openAPI specification", e);
        }
    }

    private static OpenAPI parseOpenAPIFile(@Nonnull String source, @Nonnull OpenAPIFileType type, OpenAPI origin) {
        try {
            ObjectMapper mapper = type.getMapper();
            ObjectReader reader = origin != null ? mapper.readerForUpdating((Object)origin) : mapper.reader();
            return (OpenAPI)reader.readValue(source, OpenAPI.class);
        }
        catch (IOException e) {
            throw new ParserException("Failed to parse openAPI specification", e);
        }
    }

    @Nonnull
    public Parser addPlugin(@Nonnull Plugin plugin) {
        this.config.plugins.add(Objects.requireNonNull(plugin));
        return this;
    }

    @Nonnull
    public Parser adjustOpenAPI(@Nonnull Consumer<OpenAPI> action) {
        action.accept(this.config.openAPI);
        return this;
    }

    @Nonnull
    public Parser classLoader(@Nonnull ClassLoader classLoader) {
        this.config.classLoader = classLoader;
        return this;
    }

    @Nonnull
    public Parser classPath(String ... classPathElements) {
        return this.classPath(classPathElements, true);
    }

    @Nonnull
    public Parser classPath(@Nonnull String[] classPathElements, boolean override) {
        return this.classPath(Arrays.asList(Objects.requireNonNull(classPathElements)), override);
    }

    @Nonnull
    public Parser classPath(@Nonnull Collection<String> classPathElements) {
        return this.classPath(classPathElements, true);
    }

    @Nonnull
    public Parser classPath(@Nonnull Collection<String> classPathElements, boolean override) {
        if (override || this.config.classPathElements == null) {
            this.config.classPathElements = new HashSet<String>(Objects.requireNonNull(classPathElements));
        }
        return this;
    }

    @Nonnull
    public Parser endpointAnnotation(@Nonnull String annotationFullyQualifiedName) {
        return this.endpointAnnotation(annotationFullyQualifiedName, true);
    }

    @Nonnull
    public Parser endpointAnnotation(@Nonnull String annotationFullyQualifiedName, boolean override) {
        if (override || this.config.endpointAnnotationName == null) {
            this.config.endpointAnnotationName = Objects.requireNonNull(annotationFullyQualifiedName);
        }
        return this;
    }

    @Nonnull
    public Parser endpointExposedAnnotation(@Nonnull String annotationFullyQualifiedName) {
        return this.endpointExposedAnnotation(annotationFullyQualifiedName, true);
    }

    @Nonnull
    public Parser endpointExposedAnnotation(@Nonnull String annotationFullyQualifiedName, boolean override) {
        if (override || this.config.endpointExposedAnnotationName == null) {
            this.config.endpointExposedAnnotationName = Objects.requireNonNull(annotationFullyQualifiedName);
        }
        return this;
    }

    @Nonnull
    public Parser exposedPackages(@Nonnull Collection<String> exposedPackages) {
        return this.exposedPackages(exposedPackages, true);
    }

    @Nonnull
    public Parser exposedPackages(@Nonnull Collection<String> exposedPackages, boolean override) {
        if (override || this.config.exposedPackages == null) {
            this.config.exposedPackages = Objects.requireNonNull(exposedPackages);
        }
        return this;
    }

    @Nonnull
    public OpenAPI execute() {
        Objects.requireNonNull(this.config.classLoader, "[JVM Parser] classLoader is not provided.");
        Objects.requireNonNull(this.config.classPathElements, "[JVM Parser] classPath is not provided.");
        Objects.requireNonNull(this.config.endpointAnnotationName, "[JVM Parser] endpointAnnotationName is not provided.");
        logger.debug("JVM Parser started");
        SharedStorage storage = new SharedStorage(this.config);
        ClassGraph classGraph = new ClassGraph().enableAnnotationInfo().ignoreClassVisibility().overrideClassLoaders(new ClassLoader[]{this.config.getClassLoader()});
        Collection<String> packages = this.config.exposedPackages;
        if (packages != null && !packages.isEmpty()) {
            logger.info("Search for endpoints in packages {}", packages);
            classGraph.acceptPackages((String[])packages.toArray(String[]::new));
            classGraph.overrideClasspath(this.config.getClassPathElements());
        } else {
            List buildDirectories = this.config.getClassPathElements().stream().filter(e -> !e.endsWith(".jar")).collect(Collectors.toList());
            logger.info("Search for endpoints in directories {}", buildDirectories);
            classGraph.overrideClasspath(buildDirectories);
        }
        try (io.github.classgraph.ScanResult scanResult = classGraph.scan();){
            this.validateEndpointExposedClassesForAclAnnotations(scanResult);
            RootNode rootNode = new RootNode(new ScanResult(scanResult), storage.getOpenAPI());
            PluginManager pluginManager = new PluginManager(storage.getParserConfig().getPlugins());
            pluginManager.setStorage(storage);
            PluginExecutor pluginExecutor = new PluginExecutor(pluginManager, rootNode);
            pluginExecutor.execute();
        }
        logger.debug("JVM Parser finished successfully");
        return storage.getOpenAPI();
    }

    private void validateEndpointExposedClassesForAclAnnotations(io.github.classgraph.ScanResult scanResult) {
        Optional.ofNullable(this.config.getEndpointExposedAnnotationName()).ifPresent(endpointExposedAnnotation -> scanResult.getClassesWithAnnotation(endpointExposedAnnotation).forEach(classInfo -> {
            this.checkClassLevelAnnotation((ClassInfo)classInfo);
            this.checkMethodLevelAnnotation((ClassInfo)classInfo);
        }));
    }

    private void checkClassLevelAnnotation(ClassInfo classInfo) {
        classInfo.getAnnotationInfo().forEach(annotationInfo -> this.throwIfAnnotationIsAclAnnotation(annotationInfo.getName(), classInfo));
    }

    private void checkMethodLevelAnnotation(ClassInfo classInfo) {
        for (Method method : classInfo.loadClass().getMethods()) {
            Annotation[] annotations;
            for (Annotation annotation : annotations = method.getDeclaredAnnotations()) {
                this.throwIfAnnotationIsAclAnnotation(annotation.annotationType().getName(), classInfo);
            }
        }
    }

    private void throwIfAnnotationIsAclAnnotation(String annotationName, ClassInfo classInfo) {
        String endpointExposedAnnotation = this.config.getEndpointExposedAnnotationName();
        if (ACL_ANNOTATIONS.contains(annotationName)) {
            throw new ParserException(String.format(ENDPOINT_EXPOSED_AND_ACL_ANNOTATIONS_ERROR_TEMPLATE, classInfo.getName(), endpointExposedAnnotation, annotationName, endpointExposedAnnotation));
        }
    }

    @Nonnull
    public Config getConfig() {
        return this.config;
    }

    @Nonnull
    public Parser openAPISource(@Nonnull String source, @Nonnull OpenAPIFileType type) {
        this.config.openAPI = Parser.parseOpenAPIFile(Objects.requireNonNull(source), Objects.requireNonNull(type), this.config.openAPI);
        return this;
    }

    @Nonnull
    public Parser plugins(Plugin ... plugins) {
        return this.plugins(Arrays.asList(plugins));
    }

    @Nonnull
    public Parser plugins(@Nonnull Collection<? extends Plugin> plugins) {
        this.config.plugins.clear();
        this.config.plugins.addAll(Objects.requireNonNull(plugins));
        return this;
    }

    public static final class Config {
        private final List<Plugin> plugins = new ArrayList<Plugin>();
        private Set<String> classPathElements;
        private String endpointAnnotationName;
        private String endpointExposedAnnotationName;
        private Collection<String> exposedPackages;
        private OpenAPI openAPI;
        private ClassLoader classLoader;

        private Config(OpenAPI openAPI) {
            this.openAPI = openAPI;
        }

        @Nonnull
        public ClassLoader getClassLoader() {
            return this.classLoader;
        }

        @Nonnull
        public Set<String> getClassPathElements() {
            return this.classPathElements;
        }

        @Nonnull
        public String getEndpointAnnotationName() {
            return this.endpointAnnotationName;
        }

        @Nonnull
        public String getEndpointExposedAnnotationName() {
            return this.endpointExposedAnnotationName;
        }

        @Nonnull
        public Collection<String> getExposedPackages() {
            return this.exposedPackages;
        }

        @Nonnull
        public OpenAPI getOpenAPI() {
            return this.openAPI;
        }

        @Nonnull
        public Collection<Plugin> getPlugins() {
            return this.plugins;
        }
    }
}

