/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla.devmode.devtools;

import com.vaadin.base.devserver.DevToolsInterface;
import com.vaadin.base.devserver.DevToolsMessageHandler;
import dev.hilla.ApplicationContextProvider;
import elemental.json.Json;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.sql.Connection;
import java.util.Optional;
import javax.sql.DataSource;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.h2.H2ConsoleProperties;

public class DevToolsDatabase
implements DevToolsMessageHandler {
    private boolean autowired = false;
    @Autowired
    private Optional<H2ConsoleProperties> h2ConsoleProperties;
    @Autowired
    private ObjectProvider<DataSource> dataSource;

    public void handleConnect(DevToolsInterface devToolsInterface) {
        DataSource ds;
        this.initIfNeeded();
        JsonObject data = Json.createObject();
        if (this.h2ConsoleProperties.isPresent() && this.h2ConsoleProperties.get().getEnabled() && (ds = (DataSource)this.dataSource.getIfAvailable()) != null) {
            JsonObject h2 = Json.createObject();
            h2.put("path", this.h2ConsoleProperties.get().getPath());
            h2.put("jdbcUrl", this.getConnectionUrl(ds));
            data.put("h2", (JsonValue)h2);
        }
        devToolsInterface.send("devtools-database-init", data);
    }

    private void initIfNeeded() {
        if (!this.autowired) {
            ApplicationContextProvider.getApplicationContext().getAutowireCapableBeanFactory().autowireBean((Object)this);
            this.autowired = true;
        }
    }

    private String getConnectionUrl(DataSource dataSource) {
        String string;
        block8: {
            Connection connection = dataSource.getConnection();
            try {
                string = connection.getMetaData().getURL();
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    return null;
                }
            }
            connection.close();
        }
        return string;
    }

    public boolean handleMessage(String command, JsonObject data, DevToolsInterface devToolsInterface) {
        return false;
    }
}

