/*
 * Decompiled with CFR 0.152.
 */
package org.geojson;

import java.io.Serializable;
import java.util.Arrays;
import org.geojson.jackson.LngLatAltDeserializer;
import org.geojson.jackson.LngLatAltSerializer;
import tools.jackson.databind.annotation.JsonDeserialize;
import tools.jackson.databind.annotation.JsonSerialize;

@JsonDeserialize(using=LngLatAltDeserializer.class)
@JsonSerialize(using=LngLatAltSerializer.class)
public class LngLatAlt
implements Serializable {
    private double longitude;
    private double latitude;
    private double altitude = Double.NaN;
    private double[] additionalElements = new double[0];

    public LngLatAlt() {
    }

    public LngLatAlt(double longitude, double latitude) {
        this.longitude = longitude;
        this.latitude = latitude;
    }

    public LngLatAlt(double longitude, double latitude, double altitude) {
        this.longitude = longitude;
        this.latitude = latitude;
        this.altitude = altitude;
    }

    public LngLatAlt(double longitude, double latitude, double altitude, double ... additionalElements) {
        this.longitude = longitude;
        this.latitude = latitude;
        this.altitude = altitude;
        this.setAdditionalElements(additionalElements);
        this.checkAltitudeAndAdditionalElements();
    }

    public boolean hasAltitude() {
        return !Double.isNaN(this.altitude);
    }

    public boolean hasAdditionalElements() {
        return this.additionalElements.length > 0;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    public double getAltitude() {
        return this.altitude;
    }

    public void setAltitude(double altitude) {
        this.altitude = altitude;
        this.checkAltitudeAndAdditionalElements();
    }

    public double[] getAdditionalElements() {
        return this.additionalElements;
    }

    public void setAdditionalElements(double ... additionalElements) {
        this.additionalElements = additionalElements != null ? additionalElements : new double[0];
        for (double element : this.additionalElements) {
            if (Double.isNaN(element)) {
                throw new IllegalArgumentException("No additional elements may be NaN.");
            }
            if (!Double.isInfinite(element)) continue;
            throw new IllegalArgumentException("No additional elements may be infinite.");
        }
        this.checkAltitudeAndAdditionalElements();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LngLatAlt)) {
            return false;
        }
        LngLatAlt lngLatAlt = (LngLatAlt)o;
        return Double.compare(lngLatAlt.latitude, this.latitude) == 0 && Double.compare(lngLatAlt.longitude, this.longitude) == 0 && Double.compare(lngLatAlt.altitude, this.altitude) == 0 && Arrays.equals(lngLatAlt.getAdditionalElements(), this.additionalElements);
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.longitude);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.latitude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.altitude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        for (double element : this.additionalElements) {
            temp = Double.doubleToLongBits(element);
            result = 31 * result + (int)(temp ^ temp >>> 32);
        }
        return result;
    }

    public String toString() {
        String s = "LngLatAlt{longitude=" + this.longitude + ", latitude=" + this.latitude + ", altitude=" + this.altitude;
        if (this.hasAdditionalElements()) {
            s = s + ", additionalElements=[";
            String suffix = "";
            double[] dArray = this.additionalElements;
            int n = dArray.length;
            for (int i = 0; i < n; ++i) {
                Double element = dArray[i];
                if (element == null) continue;
                s = s + suffix + element;
                suffix = ", ";
            }
            s = s + ']';
        }
        s = s + '}';
        return s;
    }

    private void checkAltitudeAndAdditionalElements() {
        if (!this.hasAltitude() && this.hasAdditionalElements()) {
            throw new IllegalArgumentException("Additional Elements are only valid if Altitude is also provided.");
        }
    }
}

