/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.collections;

import de.flapdoodle.checks.Preconditions;
import de.flapdoodle.collections.GeneratedImmutableTypedMap;
import de.flapdoodle.collections.TypedMap;
import de.flapdoodle.reflection.TypeInfo;
import de.flapdoodle.types.Pair;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.immutables.value.Value;

public class MutableTypedMap<K>
implements TypedMap<K> {
    private final Map<Pair<K, ? extends TypeInfo<?>>, Object> map;

    protected MutableTypedMap() {
        this.map = new LinkedHashMap();
    }

    protected MutableTypedMap(Map<Pair<K, ? extends TypeInfo<?>>, Object> map) {
        this.map = new LinkedHashMap(map);
    }

    @Override
    @Value.Auxiliary
    public <T> T get(TypeInfo<T> type, K key) {
        return (T)this.map.get(Pair.of(key, type));
    }

    @Override
    public Set<Pair<K, ? extends TypeInfo<?>>> keySet() {
        return this.map.keySet();
    }

    @Value.Auxiliary
    public <T> T put(TypeInfo<T> type, K key, T value) {
        Preconditions.checkNotNull(value, "value is null", new Object[0]);
        Pair<K, TypeInfo<T>> mapKey = Pair.of(key, type);
        return (T)this.map.put(mapKey, value);
    }

    public <T> void putAll(TypeInfo<T> type, Map<K, T> src) {
        src.forEach((key, value) -> this.put(type, key, value));
    }

    public TypedMap<K> asImmutable() {
        return GeneratedImmutableTypedMap.builder().putAllMap(this.map).build();
    }

    public static <K> MutableTypedMap<K> empty() {
        return new MutableTypedMap<K>();
    }
}

