/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.transitions;

import de.flapdoodle.embed.process.io.directories.TempDir;
import de.flapdoodle.embed.process.io.directories.UUIDNaming;
import de.flapdoodle.embed.process.transitions.ImmutableInitTempDirectory;
import de.flapdoodle.reverse.State;
import de.flapdoodle.reverse.StateID;
import de.flapdoodle.reverse.StateLookup;
import de.flapdoodle.reverse.TearDown;
import de.flapdoodle.reverse.Transition;
import de.flapdoodle.reverse.naming.HasLabel;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Set;
import org.immutables.value.Value;

@Value.Immutable
public abstract class InitTempDirectory
implements Transition<TempDir>,
HasLabel {
    public String transitionLabel() {
        return "InitTempDirectory";
    }

    @Value.Default
    protected TempDir tempDir() {
        return TempDir.platformTempDir().get();
    }

    public StateID<TempDir> destination() {
        return StateID.of(TempDir.class);
    }

    public Set<StateID<?>> sources() {
        return Collections.emptySet();
    }

    public State<TempDir> result(StateLookup lookup) {
        return State.of((Object)this.tempDir(), (TearDown[])new TearDown[0]);
    }

    public static ImmutableInitTempDirectory withPlatformTemp() {
        return InitTempDirectory.builder().build();
    }

    public static ImmutableInitTempDirectory.Builder builder() {
        return ImmutableInitTempDirectory.builder();
    }

    public static ImmutableInitTempDirectory with(Path path) {
        return InitTempDirectory.builder().tempDir(TempDir.of(path)).build();
    }

    public static ImmutableInitTempDirectory withPlatformTempRandomSubDir() {
        return InitTempDirectory.builder().tempDir(TempDir.platformTempSubDir(new UUIDNaming()).get()).build();
    }
}

