package de.flapdoodle.embed.mongo.config;

import de.flapdoodle.embed.mongo.distribution.IFeatureAwareVersion;
import de.flapdoodle.embed.process.config.ExecutableProcessConfig;
import de.flapdoodle.embed.process.config.SupportConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link MongoRestoreConfig}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableMongoRestoreConfig.builder()}.
 */
@Generated(from = "MongoRestoreConfig", generator = "Immutables")
@SuppressWarnings({"all"})
public final class ImmutableMongoRestoreConfig implements MongoRestoreConfig {
  private final Long stopTimeoutInMillis;
  private final IFeatureAwareVersion version;
  private final Timeout timeout;
  private final Net net;
  private final MongoCmdOptions cmdOptions;
  private final String password;
  private final String userName;
  private final boolean isVerbose;
  private final String databaseName;
  private final String collectionName;
  private final Long oplogLimit;
  private final String archive;
  private final String dir;
  private final Integer numberOfParallelCollections;
  private final Integer numberOfInsertionWorkersPerCollection;
  private final String writeConcern;
  private final boolean isObjectCheck;
  private final boolean isOplogReplay;
  private final boolean isRestoreDbUsersAndRoles;
  private final boolean isGzip;
  private final boolean isDropCollection;
  private final boolean isNoIndexRestore;
  private final boolean isNoOptionsRestore;
  private final boolean isKeepIndexVersion;
  private final boolean isMaintainInsertionOrder;
  private final boolean isStopOnError;
  private final boolean isBypassDocumentValidation;
  private final String pidFile;
  private final SupportConfig supportConfig;

  private ImmutableMongoRestoreConfig(ImmutableMongoRestoreConfig.Builder builder) {
    this.stopTimeoutInMillis = builder.stopTimeoutInMillis;
    this.version = builder.version;
    this.databaseName = builder.databaseName;
    this.collectionName = builder.collectionName;
    this.oplogLimit = builder.oplogLimit;
    this.archive = builder.archive;
    this.dir = builder.dir;
    this.numberOfParallelCollections = builder.numberOfParallelCollections;
    this.numberOfInsertionWorkersPerCollection = builder.numberOfInsertionWorkersPerCollection;
    this.writeConcern = builder.writeConcern;
    this.isDropCollection = builder.isDropCollection;
    if (builder.timeout != null) {
      initShim.timeout(builder.timeout);
    }
    if (builder.net != null) {
      initShim.net(builder.net);
    }
    if (builder.cmdOptions != null) {
      initShim.cmdOptions(builder.cmdOptions);
    }
    if (builder.password != null) {
      initShim.password(builder.password);
    }
    if (builder.userName != null) {
      initShim.userName(builder.userName);
    }
    if (builder.isVerboseIsSet()) {
      initShim.isVerbose(builder.isVerbose);
    }
    if (builder.isObjectCheckIsSet()) {
      initShim.isObjectCheck(builder.isObjectCheck);
    }
    if (builder.isOplogReplayIsSet()) {
      initShim.isOplogReplay(builder.isOplogReplay);
    }
    if (builder.isRestoreDbUsersAndRolesIsSet()) {
      initShim.isRestoreDbUsersAndRoles(builder.isRestoreDbUsersAndRoles);
    }
    if (builder.isGzipIsSet()) {
      initShim.isGzip(builder.isGzip);
    }
    if (builder.isNoIndexRestoreIsSet()) {
      initShim.isNoIndexRestore(builder.isNoIndexRestore);
    }
    if (builder.isNoOptionsRestoreIsSet()) {
      initShim.isNoOptionsRestore(builder.isNoOptionsRestore);
    }
    if (builder.isKeepIndexVersionIsSet()) {
      initShim.isKeepIndexVersion(builder.isKeepIndexVersion);
    }
    if (builder.isMaintainInsertionOrderIsSet()) {
      initShim.isMaintainInsertionOrder(builder.isMaintainInsertionOrder);
    }
    if (builder.isStopOnErrorIsSet()) {
      initShim.isStopOnError(builder.isStopOnError);
    }
    if (builder.isBypassDocumentValidationIsSet()) {
      initShim.isBypassDocumentValidation(builder.isBypassDocumentValidation);
    }
    if (builder.pidFile != null) {
      initShim.pidFile(builder.pidFile);
    }
    if (builder.supportConfig != null) {
      initShim.supportConfig(builder.supportConfig);
    }
    this.timeout = initShim.timeout();
    this.net = initShim.net();
    this.cmdOptions = initShim.cmdOptions();
    this.password = initShim.password();
    this.userName = initShim.userName();
    this.isVerbose = initShim.isVerbose();
    this.isObjectCheck = initShim.isObjectCheck();
    this.isOplogReplay = initShim.isOplogReplay();
    this.isRestoreDbUsersAndRoles = initShim.isRestoreDbUsersAndRoles();
    this.isGzip = initShim.isGzip();
    this.isNoIndexRestore = initShim.isNoIndexRestore();
    this.isNoOptionsRestore = initShim.isNoOptionsRestore();
    this.isKeepIndexVersion = initShim.isKeepIndexVersion();
    this.isMaintainInsertionOrder = initShim.isMaintainInsertionOrder();
    this.isStopOnError = initShim.isStopOnError();
    this.isBypassDocumentValidation = initShim.isBypassDocumentValidation();
    this.pidFile = initShim.pidFile();
    this.supportConfig = initShim.supportConfig();
    this.initShim = null;
  }

  private ImmutableMongoRestoreConfig(
      Long stopTimeoutInMillis,
      IFeatureAwareVersion version,
      Timeout timeout,
      Net net,
      MongoCmdOptions cmdOptions,
      String password,
      String userName,
      boolean isVerbose,
      String databaseName,
      String collectionName,
      Long oplogLimit,
      String archive,
      String dir,
      Integer numberOfParallelCollections,
      Integer numberOfInsertionWorkersPerCollection,
      String writeConcern,
      boolean isObjectCheck,
      boolean isOplogReplay,
      boolean isRestoreDbUsersAndRoles,
      boolean isGzip,
      boolean isDropCollection,
      boolean isNoIndexRestore,
      boolean isNoOptionsRestore,
      boolean isKeepIndexVersion,
      boolean isMaintainInsertionOrder,
      boolean isStopOnError,
      boolean isBypassDocumentValidation,
      String pidFile,
      SupportConfig supportConfig) {
    this.stopTimeoutInMillis = stopTimeoutInMillis;
    this.version = version;
    this.timeout = timeout;
    this.net = net;
    this.cmdOptions = cmdOptions;
    this.password = password;
    this.userName = userName;
    this.isVerbose = isVerbose;
    this.databaseName = databaseName;
    this.collectionName = collectionName;
    this.oplogLimit = oplogLimit;
    this.archive = archive;
    this.dir = dir;
    this.numberOfParallelCollections = numberOfParallelCollections;
    this.numberOfInsertionWorkersPerCollection = numberOfInsertionWorkersPerCollection;
    this.writeConcern = writeConcern;
    this.isObjectCheck = isObjectCheck;
    this.isOplogReplay = isOplogReplay;
    this.isRestoreDbUsersAndRoles = isRestoreDbUsersAndRoles;
    this.isGzip = isGzip;
    this.isDropCollection = isDropCollection;
    this.isNoIndexRestore = isNoIndexRestore;
    this.isNoOptionsRestore = isNoOptionsRestore;
    this.isKeepIndexVersion = isKeepIndexVersion;
    this.isMaintainInsertionOrder = isMaintainInsertionOrder;
    this.isStopOnError = isStopOnError;
    this.isBypassDocumentValidation = isBypassDocumentValidation;
    this.pidFile = pidFile;
    this.supportConfig = supportConfig;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "MongoRestoreConfig", generator = "Immutables")
  private final class InitShim {
    private byte timeoutBuildStage = STAGE_UNINITIALIZED;
    private Timeout timeout;

    Timeout timeout() {
      if (timeoutBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (timeoutBuildStage == STAGE_UNINITIALIZED) {
        timeoutBuildStage = STAGE_INITIALIZING;
        this.timeout = Objects.requireNonNull(timeoutInitialize(), "timeout");
        timeoutBuildStage = STAGE_INITIALIZED;
      }
      return this.timeout;
    }

    void timeout(Timeout timeout) {
      this.timeout = timeout;
      timeoutBuildStage = STAGE_INITIALIZED;
    }

    private byte netBuildStage = STAGE_UNINITIALIZED;
    private Net net;

    Net net() {
      if (netBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (netBuildStage == STAGE_UNINITIALIZED) {
        netBuildStage = STAGE_INITIALIZING;
        this.net = Objects.requireNonNull(netInitialize(), "net");
        netBuildStage = STAGE_INITIALIZED;
      }
      return this.net;
    }

    void net(Net net) {
      this.net = net;
      netBuildStage = STAGE_INITIALIZED;
    }

    private byte cmdOptionsBuildStage = STAGE_UNINITIALIZED;
    private MongoCmdOptions cmdOptions;

    MongoCmdOptions cmdOptions() {
      if (cmdOptionsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (cmdOptionsBuildStage == STAGE_UNINITIALIZED) {
        cmdOptionsBuildStage = STAGE_INITIALIZING;
        this.cmdOptions = Objects.requireNonNull(cmdOptionsInitialize(), "cmdOptions");
        cmdOptionsBuildStage = STAGE_INITIALIZED;
      }
      return this.cmdOptions;
    }

    void cmdOptions(MongoCmdOptions cmdOptions) {
      this.cmdOptions = cmdOptions;
      cmdOptionsBuildStage = STAGE_INITIALIZED;
    }

    private byte passwordBuildStage = STAGE_UNINITIALIZED;
    private String password;

    String password() {
      if (passwordBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (passwordBuildStage == STAGE_UNINITIALIZED) {
        passwordBuildStage = STAGE_INITIALIZING;
        this.password = Objects.requireNonNull(passwordInitialize(), "password");
        passwordBuildStage = STAGE_INITIALIZED;
      }
      return this.password;
    }

    void password(String password) {
      this.password = password;
      passwordBuildStage = STAGE_INITIALIZED;
    }

    private byte userNameBuildStage = STAGE_UNINITIALIZED;
    private String userName;

    String userName() {
      if (userNameBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (userNameBuildStage == STAGE_UNINITIALIZED) {
        userNameBuildStage = STAGE_INITIALIZING;
        this.userName = Objects.requireNonNull(userNameInitialize(), "userName");
        userNameBuildStage = STAGE_INITIALIZED;
      }
      return this.userName;
    }

    void userName(String userName) {
      this.userName = userName;
      userNameBuildStage = STAGE_INITIALIZED;
    }

    private byte isVerboseBuildStage = STAGE_UNINITIALIZED;
    private boolean isVerbose;

    boolean isVerbose() {
      if (isVerboseBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (isVerboseBuildStage == STAGE_UNINITIALIZED) {
        isVerboseBuildStage = STAGE_INITIALIZING;
        this.isVerbose = isVerboseInitialize();
        isVerboseBuildStage = STAGE_INITIALIZED;
      }
      return this.isVerbose;
    }

    void isVerbose(boolean isVerbose) {
      this.isVerbose = isVerbose;
      isVerboseBuildStage = STAGE_INITIALIZED;
    }

    private byte isObjectCheckBuildStage = STAGE_UNINITIALIZED;
    private boolean isObjectCheck;

    boolean isObjectCheck() {
      if (isObjectCheckBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (isObjectCheckBuildStage == STAGE_UNINITIALIZED) {
        isObjectCheckBuildStage = STAGE_INITIALIZING;
        this.isObjectCheck = isObjectCheckInitialize();
        isObjectCheckBuildStage = STAGE_INITIALIZED;
      }
      return this.isObjectCheck;
    }

    void isObjectCheck(boolean isObjectCheck) {
      this.isObjectCheck = isObjectCheck;
      isObjectCheckBuildStage = STAGE_INITIALIZED;
    }

    private byte isOplogReplayBuildStage = STAGE_UNINITIALIZED;
    private boolean isOplogReplay;

    boolean isOplogReplay() {
      if (isOplogReplayBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (isOplogReplayBuildStage == STAGE_UNINITIALIZED) {
        isOplogReplayBuildStage = STAGE_INITIALIZING;
        this.isOplogReplay = isOplogReplayInitialize();
        isOplogReplayBuildStage = STAGE_INITIALIZED;
      }
      return this.isOplogReplay;
    }

    void isOplogReplay(boolean isOplogReplay) {
      this.isOplogReplay = isOplogReplay;
      isOplogReplayBuildStage = STAGE_INITIALIZED;
    }

    private byte isRestoreDbUsersAndRolesBuildStage = STAGE_UNINITIALIZED;
    private boolean isRestoreDbUsersAndRoles;

    boolean isRestoreDbUsersAndRoles() {
      if (isRestoreDbUsersAndRolesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (isRestoreDbUsersAndRolesBuildStage == STAGE_UNINITIALIZED) {
        isRestoreDbUsersAndRolesBuildStage = STAGE_INITIALIZING;
        this.isRestoreDbUsersAndRoles = isRestoreDbUsersAndRolesInitialize();
        isRestoreDbUsersAndRolesBuildStage = STAGE_INITIALIZED;
      }
      return this.isRestoreDbUsersAndRoles;
    }

    void isRestoreDbUsersAndRoles(boolean isRestoreDbUsersAndRoles) {
      this.isRestoreDbUsersAndRoles = isRestoreDbUsersAndRoles;
      isRestoreDbUsersAndRolesBuildStage = STAGE_INITIALIZED;
    }

    private byte isGzipBuildStage = STAGE_UNINITIALIZED;
    private boolean isGzip;

    boolean isGzip() {
      if (isGzipBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (isGzipBuildStage == STAGE_UNINITIALIZED) {
        isGzipBuildStage = STAGE_INITIALIZING;
        this.isGzip = isGzipInitialize();
        isGzipBuildStage = STAGE_INITIALIZED;
      }
      return this.isGzip;
    }

    void isGzip(boolean isGzip) {
      this.isGzip = isGzip;
      isGzipBuildStage = STAGE_INITIALIZED;
    }

    private byte isNoIndexRestoreBuildStage = STAGE_UNINITIALIZED;
    private boolean isNoIndexRestore;

    boolean isNoIndexRestore() {
      if (isNoIndexRestoreBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (isNoIndexRestoreBuildStage == STAGE_UNINITIALIZED) {
        isNoIndexRestoreBuildStage = STAGE_INITIALIZING;
        this.isNoIndexRestore = isNoIndexRestoreInitialize();
        isNoIndexRestoreBuildStage = STAGE_INITIALIZED;
      }
      return this.isNoIndexRestore;
    }

    void isNoIndexRestore(boolean isNoIndexRestore) {
      this.isNoIndexRestore = isNoIndexRestore;
      isNoIndexRestoreBuildStage = STAGE_INITIALIZED;
    }

    private byte isNoOptionsRestoreBuildStage = STAGE_UNINITIALIZED;
    private boolean isNoOptionsRestore;

    boolean isNoOptionsRestore() {
      if (isNoOptionsRestoreBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (isNoOptionsRestoreBuildStage == STAGE_UNINITIALIZED) {
        isNoOptionsRestoreBuildStage = STAGE_INITIALIZING;
        this.isNoOptionsRestore = isNoOptionsRestoreInitialize();
        isNoOptionsRestoreBuildStage = STAGE_INITIALIZED;
      }
      return this.isNoOptionsRestore;
    }

    void isNoOptionsRestore(boolean isNoOptionsRestore) {
      this.isNoOptionsRestore = isNoOptionsRestore;
      isNoOptionsRestoreBuildStage = STAGE_INITIALIZED;
    }

    private byte isKeepIndexVersionBuildStage = STAGE_UNINITIALIZED;
    private boolean isKeepIndexVersion;

    boolean isKeepIndexVersion() {
      if (isKeepIndexVersionBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (isKeepIndexVersionBuildStage == STAGE_UNINITIALIZED) {
        isKeepIndexVersionBuildStage = STAGE_INITIALIZING;
        this.isKeepIndexVersion = isKeepIndexVersionInitialize();
        isKeepIndexVersionBuildStage = STAGE_INITIALIZED;
      }
      return this.isKeepIndexVersion;
    }

    void isKeepIndexVersion(boolean isKeepIndexVersion) {
      this.isKeepIndexVersion = isKeepIndexVersion;
      isKeepIndexVersionBuildStage = STAGE_INITIALIZED;
    }

    private byte isMaintainInsertionOrderBuildStage = STAGE_UNINITIALIZED;
    private boolean isMaintainInsertionOrder;

    boolean isMaintainInsertionOrder() {
      if (isMaintainInsertionOrderBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (isMaintainInsertionOrderBuildStage == STAGE_UNINITIALIZED) {
        isMaintainInsertionOrderBuildStage = STAGE_INITIALIZING;
        this.isMaintainInsertionOrder = isMaintainInsertionOrderInitialize();
        isMaintainInsertionOrderBuildStage = STAGE_INITIALIZED;
      }
      return this.isMaintainInsertionOrder;
    }

    void isMaintainInsertionOrder(boolean isMaintainInsertionOrder) {
      this.isMaintainInsertionOrder = isMaintainInsertionOrder;
      isMaintainInsertionOrderBuildStage = STAGE_INITIALIZED;
    }

    private byte isStopOnErrorBuildStage = STAGE_UNINITIALIZED;
    private boolean isStopOnError;

    boolean isStopOnError() {
      if (isStopOnErrorBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (isStopOnErrorBuildStage == STAGE_UNINITIALIZED) {
        isStopOnErrorBuildStage = STAGE_INITIALIZING;
        this.isStopOnError = isStopOnErrorInitialize();
        isStopOnErrorBuildStage = STAGE_INITIALIZED;
      }
      return this.isStopOnError;
    }

    void isStopOnError(boolean isStopOnError) {
      this.isStopOnError = isStopOnError;
      isStopOnErrorBuildStage = STAGE_INITIALIZED;
    }

    private byte isBypassDocumentValidationBuildStage = STAGE_UNINITIALIZED;
    private boolean isBypassDocumentValidation;

    boolean isBypassDocumentValidation() {
      if (isBypassDocumentValidationBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (isBypassDocumentValidationBuildStage == STAGE_UNINITIALIZED) {
        isBypassDocumentValidationBuildStage = STAGE_INITIALIZING;
        this.isBypassDocumentValidation = isBypassDocumentValidationInitialize();
        isBypassDocumentValidationBuildStage = STAGE_INITIALIZED;
      }
      return this.isBypassDocumentValidation;
    }

    void isBypassDocumentValidation(boolean isBypassDocumentValidation) {
      this.isBypassDocumentValidation = isBypassDocumentValidation;
      isBypassDocumentValidationBuildStage = STAGE_INITIALIZED;
    }

    private byte pidFileBuildStage = STAGE_UNINITIALIZED;
    private String pidFile;

    String pidFile() {
      if (pidFileBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (pidFileBuildStage == STAGE_UNINITIALIZED) {
        pidFileBuildStage = STAGE_INITIALIZING;
        this.pidFile = Objects.requireNonNull(pidFileInitialize(), "pidFile");
        pidFileBuildStage = STAGE_INITIALIZED;
      }
      return this.pidFile;
    }

    void pidFile(String pidFile) {
      this.pidFile = pidFile;
      pidFileBuildStage = STAGE_INITIALIZED;
    }

    private byte supportConfigBuildStage = STAGE_UNINITIALIZED;
    private SupportConfig supportConfig;

    SupportConfig supportConfig() {
      if (supportConfigBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (supportConfigBuildStage == STAGE_UNINITIALIZED) {
        supportConfigBuildStage = STAGE_INITIALIZING;
        this.supportConfig = Objects.requireNonNull(supportConfigInitialize(), "supportConfig");
        supportConfigBuildStage = STAGE_INITIALIZED;
      }
      return this.supportConfig;
    }

    void supportConfig(SupportConfig supportConfig) {
      this.supportConfig = supportConfig;
      supportConfigBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (timeoutBuildStage == STAGE_INITIALIZING) attributes.add("timeout");
      if (netBuildStage == STAGE_INITIALIZING) attributes.add("net");
      if (cmdOptionsBuildStage == STAGE_INITIALIZING) attributes.add("cmdOptions");
      if (passwordBuildStage == STAGE_INITIALIZING) attributes.add("password");
      if (userNameBuildStage == STAGE_INITIALIZING) attributes.add("userName");
      if (isVerboseBuildStage == STAGE_INITIALIZING) attributes.add("isVerbose");
      if (isObjectCheckBuildStage == STAGE_INITIALIZING) attributes.add("isObjectCheck");
      if (isOplogReplayBuildStage == STAGE_INITIALIZING) attributes.add("isOplogReplay");
      if (isRestoreDbUsersAndRolesBuildStage == STAGE_INITIALIZING) attributes.add("isRestoreDbUsersAndRoles");
      if (isGzipBuildStage == STAGE_INITIALIZING) attributes.add("isGzip");
      if (isNoIndexRestoreBuildStage == STAGE_INITIALIZING) attributes.add("isNoIndexRestore");
      if (isNoOptionsRestoreBuildStage == STAGE_INITIALIZING) attributes.add("isNoOptionsRestore");
      if (isKeepIndexVersionBuildStage == STAGE_INITIALIZING) attributes.add("isKeepIndexVersion");
      if (isMaintainInsertionOrderBuildStage == STAGE_INITIALIZING) attributes.add("isMaintainInsertionOrder");
      if (isStopOnErrorBuildStage == STAGE_INITIALIZING) attributes.add("isStopOnError");
      if (isBypassDocumentValidationBuildStage == STAGE_INITIALIZING) attributes.add("isBypassDocumentValidation");
      if (pidFileBuildStage == STAGE_INITIALIZING) attributes.add("pidFile");
      if (supportConfigBuildStage == STAGE_INITIALIZING) attributes.add("supportConfig");
      return "Cannot build MongoRestoreConfig, attribute initializers form cycle " + attributes;
    }
  }

  private Timeout timeoutInitialize() {
    return MongoRestoreConfig.super.timeout();
  }

  private Net netInitialize() {
    return MongoRestoreConfig.super.net();
  }

  private MongoCmdOptions cmdOptionsInitialize() {
    return MongoRestoreConfig.super.cmdOptions();
  }

  private String passwordInitialize() {
    return MongoRestoreConfig.super.password();
  }

  private String userNameInitialize() {
    return MongoRestoreConfig.super.userName();
  }

  private boolean isVerboseInitialize() {
    return MongoRestoreConfig.super.isVerbose();
  }

  private boolean isObjectCheckInitialize() {
    return MongoRestoreConfig.super.isObjectCheck();
  }

  private boolean isOplogReplayInitialize() {
    return MongoRestoreConfig.super.isOplogReplay();
  }

  private boolean isRestoreDbUsersAndRolesInitialize() {
    return MongoRestoreConfig.super.isRestoreDbUsersAndRoles();
  }

  private boolean isGzipInitialize() {
    return MongoRestoreConfig.super.isGzip();
  }

  private boolean isNoIndexRestoreInitialize() {
    return MongoRestoreConfig.super.isNoIndexRestore();
  }

  private boolean isNoOptionsRestoreInitialize() {
    return MongoRestoreConfig.super.isNoOptionsRestore();
  }

  private boolean isKeepIndexVersionInitialize() {
    return MongoRestoreConfig.super.isKeepIndexVersion();
  }

  private boolean isMaintainInsertionOrderInitialize() {
    return MongoRestoreConfig.super.isMaintainInsertionOrder();
  }

  private boolean isStopOnErrorInitialize() {
    return MongoRestoreConfig.super.isStopOnError();
  }

  private boolean isBypassDocumentValidationInitialize() {
    return MongoRestoreConfig.super.isBypassDocumentValidation();
  }

  private String pidFileInitialize() {
    return MongoRestoreConfig.super.pidFile();
  }

  private SupportConfig supportConfigInitialize() {
    return MongoRestoreConfig.super.supportConfig();
  }

  /**
   * @return The value of the {@code stopTimeoutInMillis} attribute
   */
  @Override
  public OptionalLong stopTimeoutInMillis() {
    return stopTimeoutInMillis != null
        ? OptionalLong.of(stopTimeoutInMillis)
        : OptionalLong.empty();
  }

  /**
   * @return The value of the {@code version} attribute
   */
  @Override
  public IFeatureAwareVersion version() {
    return version;
  }

  /**
   * @return The value of the {@code timeout} attribute
   */
  @Override
  public Timeout timeout() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.timeout()
        : this.timeout;
  }

  /**
   * @return The value of the {@code net} attribute
   */
  @Override
  public Net net() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.net()
        : this.net;
  }

  /**
   * @return The value of the {@code cmdOptions} attribute
   */
  @Override
  public MongoCmdOptions cmdOptions() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.cmdOptions()
        : this.cmdOptions;
  }

  /**
   * @return The value of the {@code password} attribute
   */
  @Override
  public String password() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.password()
        : this.password;
  }

  /**
   * @return The value of the {@code userName} attribute
   */
  @Override
  public String userName() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.userName()
        : this.userName;
  }

  /**
   * @return The value of the {@code isVerbose} attribute
   */
  @Override
  public boolean isVerbose() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isVerbose()
        : this.isVerbose;
  }

  /**
   * @return The value of the {@code databaseName} attribute
   */
  @Override
  public Optional<String> getDatabaseName() {
    return Optional.ofNullable(databaseName);
  }

  /**
   * @return The value of the {@code collectionName} attribute
   */
  @Override
  public Optional<String> getCollectionName() {
    return Optional.ofNullable(collectionName);
  }

  /**
   * @return The value of the {@code oplogLimit} attribute
   */
  @Override
  public OptionalLong getOplogLimit() {
    return oplogLimit != null
        ? OptionalLong.of(oplogLimit)
        : OptionalLong.empty();
  }

  /**
   * @return The value of the {@code archive} attribute
   */
  @Override
  public Optional<String> getArchive() {
    return Optional.ofNullable(archive);
  }

  /**
   * @return The value of the {@code dir} attribute
   */
  @Override
  public Optional<String> getDir() {
    return Optional.ofNullable(dir);
  }

  /**
   * @return The value of the {@code numberOfParallelCollections} attribute
   */
  @Override
  public OptionalInt getNumberOfParallelCollections() {
    return numberOfParallelCollections != null
        ? OptionalInt.of(numberOfParallelCollections)
        : OptionalInt.empty();
  }

  /**
   * @return The value of the {@code numberOfInsertionWorkersPerCollection} attribute
   */
  @Override
  public OptionalInt getNumberOfInsertionWorkersPerCollection() {
    return numberOfInsertionWorkersPerCollection != null
        ? OptionalInt.of(numberOfInsertionWorkersPerCollection)
        : OptionalInt.empty();
  }

  /**
   * @return The value of the {@code writeConcern} attribute
   */
  @Override
  public Optional<String> getWriteConcern() {
    return Optional.ofNullable(writeConcern);
  }

  /**
   * @return The value of the {@code isObjectCheck} attribute
   */
  @Override
  public boolean isObjectCheck() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isObjectCheck()
        : this.isObjectCheck;
  }

  /**
   * @return The value of the {@code isOplogReplay} attribute
   */
  @Override
  public boolean isOplogReplay() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isOplogReplay()
        : this.isOplogReplay;
  }

  /**
   * @return The value of the {@code isRestoreDbUsersAndRoles} attribute
   */
  @Override
  public boolean isRestoreDbUsersAndRoles() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isRestoreDbUsersAndRoles()
        : this.isRestoreDbUsersAndRoles;
  }

  /**
   * @return The value of the {@code isGzip} attribute
   */
  @Override
  public boolean isGzip() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isGzip()
        : this.isGzip;
  }

  /**
   * @return The value of the {@code isDropCollection} attribute
   */
  @Override
  public boolean isDropCollection() {
    return isDropCollection;
  }

  /**
   * @return The value of the {@code isNoIndexRestore} attribute
   */
  @Override
  public boolean isNoIndexRestore() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isNoIndexRestore()
        : this.isNoIndexRestore;
  }

  /**
   * @return The value of the {@code isNoOptionsRestore} attribute
   */
  @Override
  public boolean isNoOptionsRestore() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isNoOptionsRestore()
        : this.isNoOptionsRestore;
  }

  /**
   * @return The value of the {@code isKeepIndexVersion} attribute
   */
  @Override
  public boolean isKeepIndexVersion() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isKeepIndexVersion()
        : this.isKeepIndexVersion;
  }

  /**
   * @return The value of the {@code isMaintainInsertionOrder} attribute
   */
  @Override
  public boolean isMaintainInsertionOrder() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isMaintainInsertionOrder()
        : this.isMaintainInsertionOrder;
  }

  /**
   * @return The value of the {@code isStopOnError} attribute
   */
  @Override
  public boolean isStopOnError() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isStopOnError()
        : this.isStopOnError;
  }

  /**
   * @return The value of the {@code isBypassDocumentValidation} attribute
   */
  @Override
  public boolean isBypassDocumentValidation() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isBypassDocumentValidation()
        : this.isBypassDocumentValidation;
  }

  /**
   * @return The value of the {@code pidFile} attribute
   */
  @Override
  public String pidFile() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.pidFile()
        : this.pidFile;
  }

  /**
   * @return The value of the {@code supportConfig} attribute
   */
  @Override
  public SupportConfig supportConfig() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.supportConfig()
        : this.supportConfig;
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link MongoRestoreConfig#stopTimeoutInMillis() stopTimeoutInMillis} attribute.
   * @param value The value for stopTimeoutInMillis
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongoRestoreConfig withStopTimeoutInMillis(long value) {
    Long newValue = value;
    if (Objects.equals(this.stopTimeoutInMillis, newValue)) return this;
    return new ImmutableMongoRestoreConfig(
        newValue,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.isVerbose,
        this.databaseName,
        this.collectionName,
        this.oplogLimit,
        this.archive,
        this.dir,
        this.numberOfParallelCollections,
        this.numberOfInsertionWorkersPerCollection,
        this.writeConcern,
        this.isObjectCheck,
        this.isOplogReplay,
        this.isRestoreDbUsersAndRoles,
        this.isGzip,
        this.isDropCollection,
        this.isNoIndexRestore,
        this.isNoOptionsRestore,
        this.isKeepIndexVersion,
        this.isMaintainInsertionOrder,
        this.isStopOnError,
        this.isBypassDocumentValidation,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link MongoRestoreConfig#stopTimeoutInMillis() stopTimeoutInMillis} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for stopTimeoutInMillis
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongoRestoreConfig withStopTimeoutInMillis(OptionalLong optional) {
    Long value = optional.isPresent() ? optional.getAsLong() : null;
    if (Objects.equals(this.stopTimeoutInMillis, value)) return this;
    return new ImmutableMongoRestoreConfig(
        value,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.isVerbose,
        this.databaseName,
        this.collectionName,
        this.oplogLimit,
        this.archive,
        this.dir,
        this.numberOfParallelCollections,
        this.numberOfInsertionWorkersPerCollection,
        this.writeConcern,
        this.isObjectCheck,
        this.isOplogReplay,
        this.isRestoreDbUsersAndRoles,
        this.isGzip,
        this.isDropCollection,
        this.isNoIndexRestore,
        this.isNoOptionsRestore,
        this.isKeepIndexVersion,
        this.isMaintainInsertionOrder,
        this.isStopOnError,
        this.isBypassDocumentValidation,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoRestoreConfig#version() version} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for version
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoRestoreConfig withVersion(IFeatureAwareVersion value) {
    if (this.version == value) return this;
    IFeatureAwareVersion newValue = Objects.requireNonNull(value, "version");
    return new ImmutableMongoRestoreConfig(
        this.stopTimeoutInMillis,
        newValue,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.isVerbose,
        this.databaseName,
        this.collectionName,
        this.oplogLimit,
        this.archive,
        this.dir,
        this.numberOfParallelCollections,
        this.numberOfInsertionWorkersPerCollection,
        this.writeConcern,
        this.isObjectCheck,
        this.isOplogReplay,
        this.isRestoreDbUsersAndRoles,
        this.isGzip,
        this.isDropCollection,
        this.isNoIndexRestore,
        this.isNoOptionsRestore,
        this.isKeepIndexVersion,
        this.isMaintainInsertionOrder,
        this.isStopOnError,
        this.isBypassDocumentValidation,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoRestoreConfig#timeout() timeout} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for timeout
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoRestoreConfig withTimeout(Timeout value) {
    if (this.timeout == value) return this;
    Timeout newValue = Objects.requireNonNull(value, "timeout");
    return new ImmutableMongoRestoreConfig(
        this.stopTimeoutInMillis,
        this.version,
        newValue,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.isVerbose,
        this.databaseName,
        this.collectionName,
        this.oplogLimit,
        this.archive,
        this.dir,
        this.numberOfParallelCollections,
        this.numberOfInsertionWorkersPerCollection,
        this.writeConcern,
        this.isObjectCheck,
        this.isOplogReplay,
        this.isRestoreDbUsersAndRoles,
        this.isGzip,
        this.isDropCollection,
        this.isNoIndexRestore,
        this.isNoOptionsRestore,
        this.isKeepIndexVersion,
        this.isMaintainInsertionOrder,
        this.isStopOnError,
        this.isBypassDocumentValidation,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoRestoreConfig#net() net} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for net
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoRestoreConfig withNet(Net value) {
    if (this.net == value) return this;
    Net newValue = Objects.requireNonNull(value, "net");
    return new ImmutableMongoRestoreConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        newValue,
        this.cmdOptions,
        this.password,
        this.userName,
        this.isVerbose,
        this.databaseName,
        this.collectionName,
        this.oplogLimit,
        this.archive,
        this.dir,
        this.numberOfParallelCollections,
        this.numberOfInsertionWorkersPerCollection,
        this.writeConcern,
        this.isObjectCheck,
        this.isOplogReplay,
        this.isRestoreDbUsersAndRoles,
        this.isGzip,
        this.isDropCollection,
        this.isNoIndexRestore,
        this.isNoOptionsRestore,
        this.isKeepIndexVersion,
        this.isMaintainInsertionOrder,
        this.isStopOnError,
        this.isBypassDocumentValidation,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoRestoreConfig#cmdOptions() cmdOptions} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for cmdOptions
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoRestoreConfig withCmdOptions(MongoCmdOptions value) {
    if (this.cmdOptions == value) return this;
    MongoCmdOptions newValue = Objects.requireNonNull(value, "cmdOptions");
    return new ImmutableMongoRestoreConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        newValue,
        this.password,
        this.userName,
        this.isVerbose,
        this.databaseName,
        this.collectionName,
        this.oplogLimit,
        this.archive,
        this.dir,
        this.numberOfParallelCollections,
        this.numberOfInsertionWorkersPerCollection,
        this.writeConcern,
        this.isObjectCheck,
        this.isOplogReplay,
        this.isRestoreDbUsersAndRoles,
        this.isGzip,
        this.isDropCollection,
        this.isNoIndexRestore,
        this.isNoOptionsRestore,
        this.isKeepIndexVersion,
        this.isMaintainInsertionOrder,
        this.isStopOnError,
        this.isBypassDocumentValidation,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoRestoreConfig#password() password} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for password
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoRestoreConfig withPassword(String value) {
    String newValue = Objects.requireNonNull(value, "password");
    if (this.password.equals(newValue)) return this;
    return new ImmutableMongoRestoreConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        newValue,
        this.userName,
        this.isVerbose,
        this.databaseName,
        this.collectionName,
        this.oplogLimit,
        this.archive,
        this.dir,
        this.numberOfParallelCollections,
        this.numberOfInsertionWorkersPerCollection,
        this.writeConcern,
        this.isObjectCheck,
        this.isOplogReplay,
        this.isRestoreDbUsersAndRoles,
        this.isGzip,
        this.isDropCollection,
        this.isNoIndexRestore,
        this.isNoOptionsRestore,
        this.isKeepIndexVersion,
        this.isMaintainInsertionOrder,
        this.isStopOnError,
        this.isBypassDocumentValidation,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoRestoreConfig#userName() userName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for userName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoRestoreConfig withUserName(String value) {
    String newValue = Objects.requireNonNull(value, "userName");
    if (this.userName.equals(newValue)) return this;
    return new ImmutableMongoRestoreConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        newValue,
        this.isVerbose,
        this.databaseName,
        this.collectionName,
        this.oplogLimit,
        this.archive,
        this.dir,
        this.numberOfParallelCollections,
        this.numberOfInsertionWorkersPerCollection,
        this.writeConcern,
        this.isObjectCheck,
        this.isOplogReplay,
        this.isRestoreDbUsersAndRoles,
        this.isGzip,
        this.isDropCollection,
        this.isNoIndexRestore,
        this.isNoOptionsRestore,
        this.isKeepIndexVersion,
        this.isMaintainInsertionOrder,
        this.isStopOnError,
        this.isBypassDocumentValidation,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoRestoreConfig#isVerbose() isVerbose} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for isVerbose
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoRestoreConfig withIsVerbose(boolean value) {
    if (this.isVerbose == value) return this;
    return new ImmutableMongoRestoreConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        value,
        this.databaseName,
        this.collectionName,
        this.oplogLimit,
        this.archive,
        this.dir,
        this.numberOfParallelCollections,
        this.numberOfInsertionWorkersPerCollection,
        this.writeConcern,
        this.isObjectCheck,
        this.isOplogReplay,
        this.isRestoreDbUsersAndRoles,
        this.isGzip,
        this.isDropCollection,
        this.isNoIndexRestore,
        this.isNoOptionsRestore,
        this.isKeepIndexVersion,
        this.isMaintainInsertionOrder,
        this.isStopOnError,
        this.isBypassDocumentValidation,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link MongoRestoreConfig#getDatabaseName() databaseName} attribute.
   * @param value The value for databaseName
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongoRestoreConfig withDatabaseName(String value) {
    String newValue = Objects.requireNonNull(value, "databaseName");
    if (Objects.equals(this.databaseName, newValue)) return this;
    return new ImmutableMongoRestoreConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.isVerbose,
        newValue,
        this.collectionName,
        this.oplogLimit,
        this.archive,
        this.dir,
        this.numberOfParallelCollections,
        this.numberOfInsertionWorkersPerCollection,
        this.writeConcern,
        this.isObjectCheck,
        this.isOplogReplay,
        this.isRestoreDbUsersAndRoles,
        this.isGzip,
        this.isDropCollection,
        this.isNoIndexRestore,
        this.isNoOptionsRestore,
        this.isKeepIndexVersion,
        this.isMaintainInsertionOrder,
        this.isStopOnError,
        this.isBypassDocumentValidation,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link MongoRestoreConfig#getDatabaseName() databaseName} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for databaseName
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongoRestoreConfig withDatabaseName(Optional<String> optional) {
    String value = optional.orElse(null);
    if (Objects.equals(this.databaseName, value)) return this;
    return new ImmutableMongoRestoreConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.isVerbose,
        value,
        this.collectionName,
        this.oplogLimit,
        this.archive,
        this.dir,
        this.numberOfParallelCollections,
        this.numberOfInsertionWorkersPerCollection,
        this.writeConcern,
        this.isObjectCheck,
        this.isOplogReplay,
        this.isRestoreDbUsersAndRoles,
        this.isGzip,
        this.isDropCollection,
        this.isNoIndexRestore,
        this.isNoOptionsRestore,
        this.isKeepIndexVersion,
        this.isMaintainInsertionOrder,
        this.isStopOnError,
        this.isBypassDocumentValidation,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link MongoRestoreConfig#getCollectionName() collectionName} attribute.
   * @param value The value for collectionName
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongoRestoreConfig withCollectionName(String value) {
    String newValue = Objects.requireNonNull(value, "collectionName");
    if (Objects.equals(this.collectionName, newValue)) return this;
    return new ImmutableMongoRestoreConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.isVerbose,
        this.databaseName,
        newValue,
        this.oplogLimit,
        this.archive,
        this.dir,
        this.numberOfParallelCollections,
        this.numberOfInsertionWorkersPerCollection,
        this.writeConcern,
        this.isObjectCheck,
        this.isOplogReplay,
        this.isRestoreDbUsersAndRoles,
        this.isGzip,
        this.isDropCollection,
        this.isNoIndexRestore,
        this.isNoOptionsRestore,
        this.isKeepIndexVersion,
        this.isMaintainInsertionOrder,
        this.isStopOnError,
        this.isBypassDocumentValidation,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link MongoRestoreConfig#getCollectionName() collectionName} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for collectionName
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongoRestoreConfig withCollectionName(Optional<String> optional) {
    String value = optional.orElse(null);
    if (Objects.equals(this.collectionName, value)) return this;
    return new ImmutableMongoRestoreConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.isVerbose,
        this.databaseName,
        value,
        this.oplogLimit,
        this.archive,
        this.dir,
        this.numberOfParallelCollections,
        this.numberOfInsertionWorkersPerCollection,
        this.writeConcern,
        this.isObjectCheck,
        this.isOplogReplay,
        this.isRestoreDbUsersAndRoles,
        this.isGzip,
        this.isDropCollection,
        this.isNoIndexRestore,
        this.isNoOptionsRestore,
        this.isKeepIndexVersion,
        this.isMaintainInsertionOrder,
        this.isStopOnError,
        this.isBypassDocumentValidation,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link MongoRestoreConfig#getOplogLimit() oplogLimit} attribute.
   * @param value The value for oplogLimit
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongoRestoreConfig withOplogLimit(long value) {
    Long newValue = value;
    if (Objects.equals(this.oplogLimit, newValue)) return this;
    return new ImmutableMongoRestoreConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.isVerbose,
        this.databaseName,
        this.collectionName,
        newValue,
        this.archive,
        this.dir,
        this.numberOfParallelCollections,
        this.numberOfInsertionWorkersPerCollection,
        this.writeConcern,
        this.isObjectCheck,
        this.isOplogReplay,
        this.isRestoreDbUsersAndRoles,
        this.isGzip,
        this.isDropCollection,
        this.isNoIndexRestore,
        this.isNoOptionsRestore,
        this.isKeepIndexVersion,
        this.isMaintainInsertionOrder,
        this.isStopOnError,
        this.isBypassDocumentValidation,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link MongoRestoreConfig#getOplogLimit() oplogLimit} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for oplogLimit
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongoRestoreConfig withOplogLimit(OptionalLong optional) {
    Long value = optional.isPresent() ? optional.getAsLong() : null;
    if (Objects.equals(this.oplogLimit, value)) return this;
    return new ImmutableMongoRestoreConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.isVerbose,
        this.databaseName,
        this.collectionName,
        value,
        this.archive,
        this.dir,
        this.numberOfParallelCollections,
        this.numberOfInsertionWorkersPerCollection,
        this.writeConcern,
        this.isObjectCheck,
        this.isOplogReplay,
        this.isRestoreDbUsersAndRoles,
        this.isGzip,
        this.isDropCollection,
        this.isNoIndexRestore,
        this.isNoOptionsRestore,
        this.isKeepIndexVersion,
        this.isMaintainInsertionOrder,
        this.isStopOnError,
        this.isBypassDocumentValidation,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link MongoRestoreConfig#getArchive() archive} attribute.
   * @param value The value for archive
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongoRestoreConfig withArchive(String value) {
    String newValue = Objects.requireNonNull(value, "archive");
    if (Objects.equals(this.archive, newValue)) return this;
    return new ImmutableMongoRestoreConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.isVerbose,
        this.databaseName,
        this.collectionName,
        this.oplogLimit,
        newValue,
        this.dir,
        this.numberOfParallelCollections,
        this.numberOfInsertionWorkersPerCollection,
        this.writeConcern,
        this.isObjectCheck,
        this.isOplogReplay,
        this.isRestoreDbUsersAndRoles,
        this.isGzip,
        this.isDropCollection,
        this.isNoIndexRestore,
        this.isNoOptionsRestore,
        this.isKeepIndexVersion,
        this.isMaintainInsertionOrder,
        this.isStopOnError,
        this.isBypassDocumentValidation,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link MongoRestoreConfig#getArchive() archive} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for archive
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongoRestoreConfig withArchive(Optional<String> optional) {
    String value = optional.orElse(null);
    if (Objects.equals(this.archive, value)) return this;
    return new ImmutableMongoRestoreConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.isVerbose,
        this.databaseName,
        this.collectionName,
        this.oplogLimit,
        value,
        this.dir,
        this.numberOfParallelCollections,
        this.numberOfInsertionWorkersPerCollection,
        this.writeConcern,
        this.isObjectCheck,
        this.isOplogReplay,
        this.isRestoreDbUsersAndRoles,
        this.isGzip,
        this.isDropCollection,
        this.isNoIndexRestore,
        this.isNoOptionsRestore,
        this.isKeepIndexVersion,
        this.isMaintainInsertionOrder,
        this.isStopOnError,
        this.isBypassDocumentValidation,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link MongoRestoreConfig#getDir() dir} attribute.
   * @param value The value for dir
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongoRestoreConfig withDir(String value) {
    String newValue = Objects.requireNonNull(value, "dir");
    if (Objects.equals(this.dir, newValue)) return this;
    return new ImmutableMongoRestoreConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.isVerbose,
        this.databaseName,
        this.collectionName,
        this.oplogLimit,
        this.archive,
        newValue,
        this.numberOfParallelCollections,
        this.numberOfInsertionWorkersPerCollection,
        this.writeConcern,
        this.isObjectCheck,
        this.isOplogReplay,
        this.isRestoreDbUsersAndRoles,
        this.isGzip,
        this.isDropCollection,
        this.isNoIndexRestore,
        this.isNoOptionsRestore,
        this.isKeepIndexVersion,
        this.isMaintainInsertionOrder,
        this.isStopOnError,
        this.isBypassDocumentValidation,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link MongoRestoreConfig#getDir() dir} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for dir
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongoRestoreConfig withDir(Optional<String> optional) {
    String value = optional.orElse(null);
    if (Objects.equals(this.dir, value)) return this;
    return new ImmutableMongoRestoreConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.isVerbose,
        this.databaseName,
        this.collectionName,
        this.oplogLimit,
        this.archive,
        value,
        this.numberOfParallelCollections,
        this.numberOfInsertionWorkersPerCollection,
        this.writeConcern,
        this.isObjectCheck,
        this.isOplogReplay,
        this.isRestoreDbUsersAndRoles,
        this.isGzip,
        this.isDropCollection,
        this.isNoIndexRestore,
        this.isNoOptionsRestore,
        this.isKeepIndexVersion,
        this.isMaintainInsertionOrder,
        this.isStopOnError,
        this.isBypassDocumentValidation,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link MongoRestoreConfig#getNumberOfParallelCollections() numberOfParallelCollections} attribute.
   * @param value The value for numberOfParallelCollections
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongoRestoreConfig withNumberOfParallelCollections(int value) {
    Integer newValue = value;
    if (Objects.equals(this.numberOfParallelCollections, newValue)) return this;
    return new ImmutableMongoRestoreConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.isVerbose,
        this.databaseName,
        this.collectionName,
        this.oplogLimit,
        this.archive,
        this.dir,
        newValue,
        this.numberOfInsertionWorkersPerCollection,
        this.writeConcern,
        this.isObjectCheck,
        this.isOplogReplay,
        this.isRestoreDbUsersAndRoles,
        this.isGzip,
        this.isDropCollection,
        this.isNoIndexRestore,
        this.isNoOptionsRestore,
        this.isKeepIndexVersion,
        this.isMaintainInsertionOrder,
        this.isStopOnError,
        this.isBypassDocumentValidation,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link MongoRestoreConfig#getNumberOfParallelCollections() numberOfParallelCollections} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for numberOfParallelCollections
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongoRestoreConfig withNumberOfParallelCollections(OptionalInt optional) {
    Integer value = optional.isPresent() ? optional.getAsInt() : null;
    if (Objects.equals(this.numberOfParallelCollections, value)) return this;
    return new ImmutableMongoRestoreConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.isVerbose,
        this.databaseName,
        this.collectionName,
        this.oplogLimit,
        this.archive,
        this.dir,
        value,
        this.numberOfInsertionWorkersPerCollection,
        this.writeConcern,
        this.isObjectCheck,
        this.isOplogReplay,
        this.isRestoreDbUsersAndRoles,
        this.isGzip,
        this.isDropCollection,
        this.isNoIndexRestore,
        this.isNoOptionsRestore,
        this.isKeepIndexVersion,
        this.isMaintainInsertionOrder,
        this.isStopOnError,
        this.isBypassDocumentValidation,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link MongoRestoreConfig#getNumberOfInsertionWorkersPerCollection() numberOfInsertionWorkersPerCollection} attribute.
   * @param value The value for numberOfInsertionWorkersPerCollection
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongoRestoreConfig withNumberOfInsertionWorkersPerCollection(int value) {
    Integer newValue = value;
    if (Objects.equals(this.numberOfInsertionWorkersPerCollection, newValue)) return this;
    return new ImmutableMongoRestoreConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.isVerbose,
        this.databaseName,
        this.collectionName,
        this.oplogLimit,
        this.archive,
        this.dir,
        this.numberOfParallelCollections,
        newValue,
        this.writeConcern,
        this.isObjectCheck,
        this.isOplogReplay,
        this.isRestoreDbUsersAndRoles,
        this.isGzip,
        this.isDropCollection,
        this.isNoIndexRestore,
        this.isNoOptionsRestore,
        this.isKeepIndexVersion,
        this.isMaintainInsertionOrder,
        this.isStopOnError,
        this.isBypassDocumentValidation,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link MongoRestoreConfig#getNumberOfInsertionWorkersPerCollection() numberOfInsertionWorkersPerCollection} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for numberOfInsertionWorkersPerCollection
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongoRestoreConfig withNumberOfInsertionWorkersPerCollection(OptionalInt optional) {
    Integer value = optional.isPresent() ? optional.getAsInt() : null;
    if (Objects.equals(this.numberOfInsertionWorkersPerCollection, value)) return this;
    return new ImmutableMongoRestoreConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.isVerbose,
        this.databaseName,
        this.collectionName,
        this.oplogLimit,
        this.archive,
        this.dir,
        this.numberOfParallelCollections,
        value,
        this.writeConcern,
        this.isObjectCheck,
        this.isOplogReplay,
        this.isRestoreDbUsersAndRoles,
        this.isGzip,
        this.isDropCollection,
        this.isNoIndexRestore,
        this.isNoOptionsRestore,
        this.isKeepIndexVersion,
        this.isMaintainInsertionOrder,
        this.isStopOnError,
        this.isBypassDocumentValidation,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link MongoRestoreConfig#getWriteConcern() writeConcern} attribute.
   * @param value The value for writeConcern
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongoRestoreConfig withWriteConcern(String value) {
    String newValue = Objects.requireNonNull(value, "writeConcern");
    if (Objects.equals(this.writeConcern, newValue)) return this;
    return new ImmutableMongoRestoreConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.isVerbose,
        this.databaseName,
        this.collectionName,
        this.oplogLimit,
        this.archive,
        this.dir,
        this.numberOfParallelCollections,
        this.numberOfInsertionWorkersPerCollection,
        newValue,
        this.isObjectCheck,
        this.isOplogReplay,
        this.isRestoreDbUsersAndRoles,
        this.isGzip,
        this.isDropCollection,
        this.isNoIndexRestore,
        this.isNoOptionsRestore,
        this.isKeepIndexVersion,
        this.isMaintainInsertionOrder,
        this.isStopOnError,
        this.isBypassDocumentValidation,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link MongoRestoreConfig#getWriteConcern() writeConcern} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for writeConcern
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongoRestoreConfig withWriteConcern(Optional<String> optional) {
    String value = optional.orElse(null);
    if (Objects.equals(this.writeConcern, value)) return this;
    return new ImmutableMongoRestoreConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.isVerbose,
        this.databaseName,
        this.collectionName,
        this.oplogLimit,
        this.archive,
        this.dir,
        this.numberOfParallelCollections,
        this.numberOfInsertionWorkersPerCollection,
        value,
        this.isObjectCheck,
        this.isOplogReplay,
        this.isRestoreDbUsersAndRoles,
        this.isGzip,
        this.isDropCollection,
        this.isNoIndexRestore,
        this.isNoOptionsRestore,
        this.isKeepIndexVersion,
        this.isMaintainInsertionOrder,
        this.isStopOnError,
        this.isBypassDocumentValidation,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoRestoreConfig#isObjectCheck() isObjectCheck} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for isObjectCheck
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoRestoreConfig withIsObjectCheck(boolean value) {
    if (this.isObjectCheck == value) return this;
    return new ImmutableMongoRestoreConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.isVerbose,
        this.databaseName,
        this.collectionName,
        this.oplogLimit,
        this.archive,
        this.dir,
        this.numberOfParallelCollections,
        this.numberOfInsertionWorkersPerCollection,
        this.writeConcern,
        value,
        this.isOplogReplay,
        this.isRestoreDbUsersAndRoles,
        this.isGzip,
        this.isDropCollection,
        this.isNoIndexRestore,
        this.isNoOptionsRestore,
        this.isKeepIndexVersion,
        this.isMaintainInsertionOrder,
        this.isStopOnError,
        this.isBypassDocumentValidation,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoRestoreConfig#isOplogReplay() isOplogReplay} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for isOplogReplay
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoRestoreConfig withIsOplogReplay(boolean value) {
    if (this.isOplogReplay == value) return this;
    return new ImmutableMongoRestoreConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.isVerbose,
        this.databaseName,
        this.collectionName,
        this.oplogLimit,
        this.archive,
        this.dir,
        this.numberOfParallelCollections,
        this.numberOfInsertionWorkersPerCollection,
        this.writeConcern,
        this.isObjectCheck,
        value,
        this.isRestoreDbUsersAndRoles,
        this.isGzip,
        this.isDropCollection,
        this.isNoIndexRestore,
        this.isNoOptionsRestore,
        this.isKeepIndexVersion,
        this.isMaintainInsertionOrder,
        this.isStopOnError,
        this.isBypassDocumentValidation,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoRestoreConfig#isRestoreDbUsersAndRoles() isRestoreDbUsersAndRoles} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for isRestoreDbUsersAndRoles
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoRestoreConfig withIsRestoreDbUsersAndRoles(boolean value) {
    if (this.isRestoreDbUsersAndRoles == value) return this;
    return new ImmutableMongoRestoreConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.isVerbose,
        this.databaseName,
        this.collectionName,
        this.oplogLimit,
        this.archive,
        this.dir,
        this.numberOfParallelCollections,
        this.numberOfInsertionWorkersPerCollection,
        this.writeConcern,
        this.isObjectCheck,
        this.isOplogReplay,
        value,
        this.isGzip,
        this.isDropCollection,
        this.isNoIndexRestore,
        this.isNoOptionsRestore,
        this.isKeepIndexVersion,
        this.isMaintainInsertionOrder,
        this.isStopOnError,
        this.isBypassDocumentValidation,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoRestoreConfig#isGzip() isGzip} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for isGzip
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoRestoreConfig withIsGzip(boolean value) {
    if (this.isGzip == value) return this;
    return new ImmutableMongoRestoreConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.isVerbose,
        this.databaseName,
        this.collectionName,
        this.oplogLimit,
        this.archive,
        this.dir,
        this.numberOfParallelCollections,
        this.numberOfInsertionWorkersPerCollection,
        this.writeConcern,
        this.isObjectCheck,
        this.isOplogReplay,
        this.isRestoreDbUsersAndRoles,
        value,
        this.isDropCollection,
        this.isNoIndexRestore,
        this.isNoOptionsRestore,
        this.isKeepIndexVersion,
        this.isMaintainInsertionOrder,
        this.isStopOnError,
        this.isBypassDocumentValidation,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoRestoreConfig#isDropCollection() isDropCollection} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for isDropCollection
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoRestoreConfig withIsDropCollection(boolean value) {
    if (this.isDropCollection == value) return this;
    return new ImmutableMongoRestoreConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.isVerbose,
        this.databaseName,
        this.collectionName,
        this.oplogLimit,
        this.archive,
        this.dir,
        this.numberOfParallelCollections,
        this.numberOfInsertionWorkersPerCollection,
        this.writeConcern,
        this.isObjectCheck,
        this.isOplogReplay,
        this.isRestoreDbUsersAndRoles,
        this.isGzip,
        value,
        this.isNoIndexRestore,
        this.isNoOptionsRestore,
        this.isKeepIndexVersion,
        this.isMaintainInsertionOrder,
        this.isStopOnError,
        this.isBypassDocumentValidation,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoRestoreConfig#isNoIndexRestore() isNoIndexRestore} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for isNoIndexRestore
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoRestoreConfig withIsNoIndexRestore(boolean value) {
    if (this.isNoIndexRestore == value) return this;
    return new ImmutableMongoRestoreConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.isVerbose,
        this.databaseName,
        this.collectionName,
        this.oplogLimit,
        this.archive,
        this.dir,
        this.numberOfParallelCollections,
        this.numberOfInsertionWorkersPerCollection,
        this.writeConcern,
        this.isObjectCheck,
        this.isOplogReplay,
        this.isRestoreDbUsersAndRoles,
        this.isGzip,
        this.isDropCollection,
        value,
        this.isNoOptionsRestore,
        this.isKeepIndexVersion,
        this.isMaintainInsertionOrder,
        this.isStopOnError,
        this.isBypassDocumentValidation,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoRestoreConfig#isNoOptionsRestore() isNoOptionsRestore} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for isNoOptionsRestore
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoRestoreConfig withIsNoOptionsRestore(boolean value) {
    if (this.isNoOptionsRestore == value) return this;
    return new ImmutableMongoRestoreConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.isVerbose,
        this.databaseName,
        this.collectionName,
        this.oplogLimit,
        this.archive,
        this.dir,
        this.numberOfParallelCollections,
        this.numberOfInsertionWorkersPerCollection,
        this.writeConcern,
        this.isObjectCheck,
        this.isOplogReplay,
        this.isRestoreDbUsersAndRoles,
        this.isGzip,
        this.isDropCollection,
        this.isNoIndexRestore,
        value,
        this.isKeepIndexVersion,
        this.isMaintainInsertionOrder,
        this.isStopOnError,
        this.isBypassDocumentValidation,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoRestoreConfig#isKeepIndexVersion() isKeepIndexVersion} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for isKeepIndexVersion
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoRestoreConfig withIsKeepIndexVersion(boolean value) {
    if (this.isKeepIndexVersion == value) return this;
    return new ImmutableMongoRestoreConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.isVerbose,
        this.databaseName,
        this.collectionName,
        this.oplogLimit,
        this.archive,
        this.dir,
        this.numberOfParallelCollections,
        this.numberOfInsertionWorkersPerCollection,
        this.writeConcern,
        this.isObjectCheck,
        this.isOplogReplay,
        this.isRestoreDbUsersAndRoles,
        this.isGzip,
        this.isDropCollection,
        this.isNoIndexRestore,
        this.isNoOptionsRestore,
        value,
        this.isMaintainInsertionOrder,
        this.isStopOnError,
        this.isBypassDocumentValidation,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoRestoreConfig#isMaintainInsertionOrder() isMaintainInsertionOrder} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for isMaintainInsertionOrder
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoRestoreConfig withIsMaintainInsertionOrder(boolean value) {
    if (this.isMaintainInsertionOrder == value) return this;
    return new ImmutableMongoRestoreConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.isVerbose,
        this.databaseName,
        this.collectionName,
        this.oplogLimit,
        this.archive,
        this.dir,
        this.numberOfParallelCollections,
        this.numberOfInsertionWorkersPerCollection,
        this.writeConcern,
        this.isObjectCheck,
        this.isOplogReplay,
        this.isRestoreDbUsersAndRoles,
        this.isGzip,
        this.isDropCollection,
        this.isNoIndexRestore,
        this.isNoOptionsRestore,
        this.isKeepIndexVersion,
        value,
        this.isStopOnError,
        this.isBypassDocumentValidation,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoRestoreConfig#isStopOnError() isStopOnError} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for isStopOnError
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoRestoreConfig withIsStopOnError(boolean value) {
    if (this.isStopOnError == value) return this;
    return new ImmutableMongoRestoreConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.isVerbose,
        this.databaseName,
        this.collectionName,
        this.oplogLimit,
        this.archive,
        this.dir,
        this.numberOfParallelCollections,
        this.numberOfInsertionWorkersPerCollection,
        this.writeConcern,
        this.isObjectCheck,
        this.isOplogReplay,
        this.isRestoreDbUsersAndRoles,
        this.isGzip,
        this.isDropCollection,
        this.isNoIndexRestore,
        this.isNoOptionsRestore,
        this.isKeepIndexVersion,
        this.isMaintainInsertionOrder,
        value,
        this.isBypassDocumentValidation,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoRestoreConfig#isBypassDocumentValidation() isBypassDocumentValidation} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for isBypassDocumentValidation
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoRestoreConfig withIsBypassDocumentValidation(boolean value) {
    if (this.isBypassDocumentValidation == value) return this;
    return new ImmutableMongoRestoreConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.isVerbose,
        this.databaseName,
        this.collectionName,
        this.oplogLimit,
        this.archive,
        this.dir,
        this.numberOfParallelCollections,
        this.numberOfInsertionWorkersPerCollection,
        this.writeConcern,
        this.isObjectCheck,
        this.isOplogReplay,
        this.isRestoreDbUsersAndRoles,
        this.isGzip,
        this.isDropCollection,
        this.isNoIndexRestore,
        this.isNoOptionsRestore,
        this.isKeepIndexVersion,
        this.isMaintainInsertionOrder,
        this.isStopOnError,
        value,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoRestoreConfig#pidFile() pidFile} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for pidFile
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoRestoreConfig withPidFile(String value) {
    String newValue = Objects.requireNonNull(value, "pidFile");
    if (this.pidFile.equals(newValue)) return this;
    return new ImmutableMongoRestoreConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.isVerbose,
        this.databaseName,
        this.collectionName,
        this.oplogLimit,
        this.archive,
        this.dir,
        this.numberOfParallelCollections,
        this.numberOfInsertionWorkersPerCollection,
        this.writeConcern,
        this.isObjectCheck,
        this.isOplogReplay,
        this.isRestoreDbUsersAndRoles,
        this.isGzip,
        this.isDropCollection,
        this.isNoIndexRestore,
        this.isNoOptionsRestore,
        this.isKeepIndexVersion,
        this.isMaintainInsertionOrder,
        this.isStopOnError,
        this.isBypassDocumentValidation,
        newValue,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoRestoreConfig#supportConfig() supportConfig} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for supportConfig
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoRestoreConfig withSupportConfig(SupportConfig value) {
    if (this.supportConfig == value) return this;
    SupportConfig newValue = Objects.requireNonNull(value, "supportConfig");
    return new ImmutableMongoRestoreConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.isVerbose,
        this.databaseName,
        this.collectionName,
        this.oplogLimit,
        this.archive,
        this.dir,
        this.numberOfParallelCollections,
        this.numberOfInsertionWorkersPerCollection,
        this.writeConcern,
        this.isObjectCheck,
        this.isOplogReplay,
        this.isRestoreDbUsersAndRoles,
        this.isGzip,
        this.isDropCollection,
        this.isNoIndexRestore,
        this.isNoOptionsRestore,
        this.isKeepIndexVersion,
        this.isMaintainInsertionOrder,
        this.isStopOnError,
        this.isBypassDocumentValidation,
        this.pidFile,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableMongoRestoreConfig} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableMongoRestoreConfig
        && equalTo((ImmutableMongoRestoreConfig) another);
  }

  private boolean equalTo(ImmutableMongoRestoreConfig another) {
    return Objects.equals(stopTimeoutInMillis, another.stopTimeoutInMillis)
        && version.equals(another.version)
        && timeout.equals(another.timeout)
        && net.equals(another.net)
        && cmdOptions.equals(another.cmdOptions)
        && password.equals(another.password)
        && userName.equals(another.userName)
        && isVerbose == another.isVerbose
        && Objects.equals(databaseName, another.databaseName)
        && Objects.equals(collectionName, another.collectionName)
        && Objects.equals(oplogLimit, another.oplogLimit)
        && Objects.equals(archive, another.archive)
        && Objects.equals(dir, another.dir)
        && Objects.equals(numberOfParallelCollections, another.numberOfParallelCollections)
        && Objects.equals(numberOfInsertionWorkersPerCollection, another.numberOfInsertionWorkersPerCollection)
        && Objects.equals(writeConcern, another.writeConcern)
        && isObjectCheck == another.isObjectCheck
        && isOplogReplay == another.isOplogReplay
        && isRestoreDbUsersAndRoles == another.isRestoreDbUsersAndRoles
        && isGzip == another.isGzip
        && isDropCollection == another.isDropCollection
        && isNoIndexRestore == another.isNoIndexRestore
        && isNoOptionsRestore == another.isNoOptionsRestore
        && isKeepIndexVersion == another.isKeepIndexVersion
        && isMaintainInsertionOrder == another.isMaintainInsertionOrder
        && isStopOnError == another.isStopOnError
        && isBypassDocumentValidation == another.isBypassDocumentValidation
        && pidFile.equals(another.pidFile)
        && supportConfig.equals(another.supportConfig);
  }

  /**
   * Computes a hash code from attributes: {@code stopTimeoutInMillis}, {@code version}, {@code timeout}, {@code net}, {@code cmdOptions}, {@code password}, {@code userName}, {@code isVerbose}, {@code databaseName}, {@code collectionName}, {@code oplogLimit}, {@code archive}, {@code dir}, {@code numberOfParallelCollections}, {@code numberOfInsertionWorkersPerCollection}, {@code writeConcern}, {@code isObjectCheck}, {@code isOplogReplay}, {@code isRestoreDbUsersAndRoles}, {@code isGzip}, {@code isDropCollection}, {@code isNoIndexRestore}, {@code isNoOptionsRestore}, {@code isKeepIndexVersion}, {@code isMaintainInsertionOrder}, {@code isStopOnError}, {@code isBypassDocumentValidation}, {@code pidFile}, {@code supportConfig}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(stopTimeoutInMillis);
    h += (h << 5) + version.hashCode();
    h += (h << 5) + timeout.hashCode();
    h += (h << 5) + net.hashCode();
    h += (h << 5) + cmdOptions.hashCode();
    h += (h << 5) + password.hashCode();
    h += (h << 5) + userName.hashCode();
    h += (h << 5) + Boolean.hashCode(isVerbose);
    h += (h << 5) + Objects.hashCode(databaseName);
    h += (h << 5) + Objects.hashCode(collectionName);
    h += (h << 5) + Objects.hashCode(oplogLimit);
    h += (h << 5) + Objects.hashCode(archive);
    h += (h << 5) + Objects.hashCode(dir);
    h += (h << 5) + Objects.hashCode(numberOfParallelCollections);
    h += (h << 5) + Objects.hashCode(numberOfInsertionWorkersPerCollection);
    h += (h << 5) + Objects.hashCode(writeConcern);
    h += (h << 5) + Boolean.hashCode(isObjectCheck);
    h += (h << 5) + Boolean.hashCode(isOplogReplay);
    h += (h << 5) + Boolean.hashCode(isRestoreDbUsersAndRoles);
    h += (h << 5) + Boolean.hashCode(isGzip);
    h += (h << 5) + Boolean.hashCode(isDropCollection);
    h += (h << 5) + Boolean.hashCode(isNoIndexRestore);
    h += (h << 5) + Boolean.hashCode(isNoOptionsRestore);
    h += (h << 5) + Boolean.hashCode(isKeepIndexVersion);
    h += (h << 5) + Boolean.hashCode(isMaintainInsertionOrder);
    h += (h << 5) + Boolean.hashCode(isStopOnError);
    h += (h << 5) + Boolean.hashCode(isBypassDocumentValidation);
    h += (h << 5) + pidFile.hashCode();
    h += (h << 5) + supportConfig.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code MongoRestoreConfig} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("MongoRestoreConfig{");
    if (stopTimeoutInMillis != null) {
      builder.append("stopTimeoutInMillis=").append(stopTimeoutInMillis);
    }
    if (builder.length() > 19) builder.append(", ");
    builder.append("version=").append(version);
    builder.append(", ");
    builder.append("timeout=").append(timeout);
    builder.append(", ");
    builder.append("net=").append(net);
    builder.append(", ");
    builder.append("cmdOptions=").append(cmdOptions);
    builder.append(", ");
    builder.append("password=").append(password);
    builder.append(", ");
    builder.append("userName=").append(userName);
    builder.append(", ");
    builder.append("isVerbose=").append(isVerbose);
    if (databaseName != null) {
      builder.append(", ");
      builder.append("databaseName=").append(databaseName);
    }
    if (collectionName != null) {
      builder.append(", ");
      builder.append("collectionName=").append(collectionName);
    }
    if (oplogLimit != null) {
      builder.append(", ");
      builder.append("oplogLimit=").append(oplogLimit);
    }
    if (archive != null) {
      builder.append(", ");
      builder.append("archive=").append(archive);
    }
    if (dir != null) {
      builder.append(", ");
      builder.append("dir=").append(dir);
    }
    if (numberOfParallelCollections != null) {
      builder.append(", ");
      builder.append("numberOfParallelCollections=").append(numberOfParallelCollections);
    }
    if (numberOfInsertionWorkersPerCollection != null) {
      builder.append(", ");
      builder.append("numberOfInsertionWorkersPerCollection=").append(numberOfInsertionWorkersPerCollection);
    }
    if (writeConcern != null) {
      builder.append(", ");
      builder.append("writeConcern=").append(writeConcern);
    }
    builder.append(", ");
    builder.append("isObjectCheck=").append(isObjectCheck);
    builder.append(", ");
    builder.append("isOplogReplay=").append(isOplogReplay);
    builder.append(", ");
    builder.append("isRestoreDbUsersAndRoles=").append(isRestoreDbUsersAndRoles);
    builder.append(", ");
    builder.append("isGzip=").append(isGzip);
    builder.append(", ");
    builder.append("isDropCollection=").append(isDropCollection);
    builder.append(", ");
    builder.append("isNoIndexRestore=").append(isNoIndexRestore);
    builder.append(", ");
    builder.append("isNoOptionsRestore=").append(isNoOptionsRestore);
    builder.append(", ");
    builder.append("isKeepIndexVersion=").append(isKeepIndexVersion);
    builder.append(", ");
    builder.append("isMaintainInsertionOrder=").append(isMaintainInsertionOrder);
    builder.append(", ");
    builder.append("isStopOnError=").append(isStopOnError);
    builder.append(", ");
    builder.append("isBypassDocumentValidation=").append(isBypassDocumentValidation);
    builder.append(", ");
    builder.append("pidFile=").append(pidFile);
    builder.append(", ");
    builder.append("supportConfig=").append(supportConfig);
    return builder.append("}").toString();
  }

  /**
   * Creates an immutable copy of a {@link MongoRestoreConfig} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable MongoRestoreConfig instance
   */
  public static ImmutableMongoRestoreConfig copyOf(MongoRestoreConfig instance) {
    if (instance instanceof ImmutableMongoRestoreConfig) {
      return (ImmutableMongoRestoreConfig) instance;
    }
    return ImmutableMongoRestoreConfig.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableMongoRestoreConfig ImmutableMongoRestoreConfig}.
   * <pre>
   * ImmutableMongoRestoreConfig.builder()
   *    .stopTimeoutInMillis(long) // optional {@link MongoRestoreConfig#stopTimeoutInMillis() stopTimeoutInMillis}
   *    .version(de.flapdoodle.embed.mongo.distribution.IFeatureAwareVersion) // required {@link MongoRestoreConfig#version() version}
   *    .timeout(de.flapdoodle.embed.mongo.config.Timeout) // optional {@link MongoRestoreConfig#timeout() timeout}
   *    .net(de.flapdoodle.embed.mongo.config.Net) // optional {@link MongoRestoreConfig#net() net}
   *    .cmdOptions(de.flapdoodle.embed.mongo.config.MongoCmdOptions) // optional {@link MongoRestoreConfig#cmdOptions() cmdOptions}
   *    .password(String) // optional {@link MongoRestoreConfig#password() password}
   *    .userName(String) // optional {@link MongoRestoreConfig#userName() userName}
   *    .isVerbose(boolean) // optional {@link MongoRestoreConfig#isVerbose() isVerbose}
   *    .databaseName(String) // optional {@link MongoRestoreConfig#getDatabaseName() databaseName}
   *    .collectionName(String) // optional {@link MongoRestoreConfig#getCollectionName() collectionName}
   *    .oplogLimit(long) // optional {@link MongoRestoreConfig#getOplogLimit() oplogLimit}
   *    .archive(String) // optional {@link MongoRestoreConfig#getArchive() archive}
   *    .dir(String) // optional {@link MongoRestoreConfig#getDir() dir}
   *    .numberOfParallelCollections(int) // optional {@link MongoRestoreConfig#getNumberOfParallelCollections() numberOfParallelCollections}
   *    .numberOfInsertionWorkersPerCollection(int) // optional {@link MongoRestoreConfig#getNumberOfInsertionWorkersPerCollection() numberOfInsertionWorkersPerCollection}
   *    .writeConcern(String) // optional {@link MongoRestoreConfig#getWriteConcern() writeConcern}
   *    .isObjectCheck(boolean) // optional {@link MongoRestoreConfig#isObjectCheck() isObjectCheck}
   *    .isOplogReplay(boolean) // optional {@link MongoRestoreConfig#isOplogReplay() isOplogReplay}
   *    .isRestoreDbUsersAndRoles(boolean) // optional {@link MongoRestoreConfig#isRestoreDbUsersAndRoles() isRestoreDbUsersAndRoles}
   *    .isGzip(boolean) // optional {@link MongoRestoreConfig#isGzip() isGzip}
   *    .isDropCollection(boolean) // required {@link MongoRestoreConfig#isDropCollection() isDropCollection}
   *    .isNoIndexRestore(boolean) // optional {@link MongoRestoreConfig#isNoIndexRestore() isNoIndexRestore}
   *    .isNoOptionsRestore(boolean) // optional {@link MongoRestoreConfig#isNoOptionsRestore() isNoOptionsRestore}
   *    .isKeepIndexVersion(boolean) // optional {@link MongoRestoreConfig#isKeepIndexVersion() isKeepIndexVersion}
   *    .isMaintainInsertionOrder(boolean) // optional {@link MongoRestoreConfig#isMaintainInsertionOrder() isMaintainInsertionOrder}
   *    .isStopOnError(boolean) // optional {@link MongoRestoreConfig#isStopOnError() isStopOnError}
   *    .isBypassDocumentValidation(boolean) // optional {@link MongoRestoreConfig#isBypassDocumentValidation() isBypassDocumentValidation}
   *    .pidFile(String) // optional {@link MongoRestoreConfig#pidFile() pidFile}
   *    .supportConfig(de.flapdoodle.embed.process.config.SupportConfig) // optional {@link MongoRestoreConfig#supportConfig() supportConfig}
   *    .build();
   * </pre>
   * @return A new ImmutableMongoRestoreConfig builder
   */
  public static ImmutableMongoRestoreConfig.Builder builder() {
    return new ImmutableMongoRestoreConfig.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableMongoRestoreConfig ImmutableMongoRestoreConfig}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "MongoRestoreConfig", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_VERSION = 0x1L;
    private static final long INIT_BIT_IS_DROP_COLLECTION = 0x2L;
    private static final long OPT_BIT_IS_VERBOSE = 0x1L;
    private static final long OPT_BIT_IS_OBJECT_CHECK = 0x2L;
    private static final long OPT_BIT_IS_OPLOG_REPLAY = 0x4L;
    private static final long OPT_BIT_IS_RESTORE_DB_USERS_AND_ROLES = 0x8L;
    private static final long OPT_BIT_IS_GZIP = 0x10L;
    private static final long OPT_BIT_IS_NO_INDEX_RESTORE = 0x20L;
    private static final long OPT_BIT_IS_NO_OPTIONS_RESTORE = 0x40L;
    private static final long OPT_BIT_IS_KEEP_INDEX_VERSION = 0x80L;
    private static final long OPT_BIT_IS_MAINTAIN_INSERTION_ORDER = 0x100L;
    private static final long OPT_BIT_IS_STOP_ON_ERROR = 0x200L;
    private static final long OPT_BIT_IS_BYPASS_DOCUMENT_VALIDATION = 0x400L;
    private long initBits = 0x3L;
    private long optBits;

    private Long stopTimeoutInMillis;
    private IFeatureAwareVersion version;
    private Timeout timeout;
    private Net net;
    private MongoCmdOptions cmdOptions;
    private String password;
    private String userName;
    private boolean isVerbose;
    private String databaseName;
    private String collectionName;
    private Long oplogLimit;
    private String archive;
    private String dir;
    private Integer numberOfParallelCollections;
    private Integer numberOfInsertionWorkersPerCollection;
    private String writeConcern;
    private boolean isObjectCheck;
    private boolean isOplogReplay;
    private boolean isRestoreDbUsersAndRoles;
    private boolean isGzip;
    private boolean isDropCollection;
    private boolean isNoIndexRestore;
    private boolean isNoOptionsRestore;
    private boolean isKeepIndexVersion;
    private boolean isMaintainInsertionOrder;
    private boolean isStopOnError;
    private boolean isBypassDocumentValidation;
    private String pidFile;
    private SupportConfig supportConfig;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code de.flapdoodle.embed.mongo.config.MongoCommonConfig} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(MongoCommonConfig instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code de.flapdoodle.embed.process.config.ExecutableProcessConfig} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ExecutableProcessConfig instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code de.flapdoodle.embed.mongo.config.MongoRestoreConfig} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(MongoRestoreConfig instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      long bits = 0;
      if (object instanceof MongoCommonConfig) {
        MongoCommonConfig instance = (MongoCommonConfig) object;
        password(instance.password());
        cmdOptions(instance.cmdOptions());
        net(instance.net());
        userName(instance.userName());
        if ((bits & 0x2L) == 0) {
          version(instance.version());
          bits |= 0x2L;
        }
        timeout(instance.timeout());
        if ((bits & 0x4L) == 0) {
          pidFile(instance.pidFile());
          bits |= 0x4L;
        }
      }
      if (object instanceof ExecutableProcessConfig) {
        ExecutableProcessConfig instance = (ExecutableProcessConfig) object;
        if ((bits & 0x1L) == 0) {
          supportConfig(instance.supportConfig());
          bits |= 0x1L;
        }
        OptionalLong stopTimeoutInMillisOptional = instance.stopTimeoutInMillis();
        if (stopTimeoutInMillisOptional.isPresent()) {
          stopTimeoutInMillis(stopTimeoutInMillisOptional);
        }
      }
      if (object instanceof MongoRestoreConfig) {
        MongoRestoreConfig instance = (MongoRestoreConfig) object;
        OptionalInt numberOfInsertionWorkersPerCollectionOptional = instance.getNumberOfInsertionWorkersPerCollection();
        if (numberOfInsertionWorkersPerCollectionOptional.isPresent()) {
          numberOfInsertionWorkersPerCollection(numberOfInsertionWorkersPerCollectionOptional);
        }
        Optional<String> databaseNameOptional = instance.getDatabaseName();
        if (databaseNameOptional.isPresent()) {
          databaseName(databaseNameOptional);
        }
        OptionalLong oplogLimitOptional = instance.getOplogLimit();
        if (oplogLimitOptional.isPresent()) {
          oplogLimit(oplogLimitOptional);
        }
        isVerbose(instance.isVerbose());
        isGzip(instance.isGzip());
        isNoOptionsRestore(instance.isNoOptionsRestore());
        isKeepIndexVersion(instance.isKeepIndexVersion());
        Optional<String> writeConcernOptional = instance.getWriteConcern();
        if (writeConcernOptional.isPresent()) {
          writeConcern(writeConcernOptional);
        }
        Optional<String> archiveOptional = instance.getArchive();
        if (archiveOptional.isPresent()) {
          archive(archiveOptional);
        }
        Optional<String> dirOptional = instance.getDir();
        if (dirOptional.isPresent()) {
          dir(dirOptional);
        }
        if ((bits & 0x2L) == 0) {
          version(instance.version());
          bits |= 0x2L;
        }
        if ((bits & 0x4L) == 0) {
          pidFile(instance.pidFile());
          bits |= 0x4L;
        }
        Optional<String> collectionNameOptional = instance.getCollectionName();
        if (collectionNameOptional.isPresent()) {
          collectionName(collectionNameOptional);
        }
        isBypassDocumentValidation(instance.isBypassDocumentValidation());
        isNoIndexRestore(instance.isNoIndexRestore());
        OptionalInt numberOfParallelCollectionsOptional = instance.getNumberOfParallelCollections();
        if (numberOfParallelCollectionsOptional.isPresent()) {
          numberOfParallelCollections(numberOfParallelCollectionsOptional);
        }
        isOplogReplay(instance.isOplogReplay());
        isMaintainInsertionOrder(instance.isMaintainInsertionOrder());
        if ((bits & 0x1L) == 0) {
          supportConfig(instance.supportConfig());
          bits |= 0x1L;
        }
        isDropCollection(instance.isDropCollection());
        isStopOnError(instance.isStopOnError());
        isRestoreDbUsersAndRoles(instance.isRestoreDbUsersAndRoles());
        isObjectCheck(instance.isObjectCheck());
      }
    }

    /**
     * Initializes the optional value {@link MongoRestoreConfig#stopTimeoutInMillis() stopTimeoutInMillis} to stopTimeoutInMillis.
     * @param stopTimeoutInMillis The value for stopTimeoutInMillis
     * @return {@code this} builder for chained invocation
     */
    public final Builder stopTimeoutInMillis(long stopTimeoutInMillis) {
      this.stopTimeoutInMillis = stopTimeoutInMillis;
      return this;
    }

    /**
     * Initializes the optional value {@link MongoRestoreConfig#stopTimeoutInMillis() stopTimeoutInMillis} to stopTimeoutInMillis.
     * @param stopTimeoutInMillis The value for stopTimeoutInMillis
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder stopTimeoutInMillis(OptionalLong stopTimeoutInMillis) {
      this.stopTimeoutInMillis = stopTimeoutInMillis.isPresent() ? stopTimeoutInMillis.getAsLong() : null;
      return this;
    }

    /**
     * Initializes the value for the {@link MongoRestoreConfig#version() version} attribute.
     * @param version The value for version 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder version(IFeatureAwareVersion version) {
      this.version = Objects.requireNonNull(version, "version");
      initBits &= ~INIT_BIT_VERSION;
      return this;
    }

    /**
     * Initializes the value for the {@link MongoRestoreConfig#timeout() timeout} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoRestoreConfig#timeout() timeout}.</em>
     * @param timeout The value for timeout 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder timeout(Timeout timeout) {
      this.timeout = Objects.requireNonNull(timeout, "timeout");
      return this;
    }

    /**
     * Initializes the value for the {@link MongoRestoreConfig#net() net} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoRestoreConfig#net() net}.</em>
     * @param net The value for net 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder net(Net net) {
      this.net = Objects.requireNonNull(net, "net");
      return this;
    }

    /**
     * Initializes the value for the {@link MongoRestoreConfig#cmdOptions() cmdOptions} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoRestoreConfig#cmdOptions() cmdOptions}.</em>
     * @param cmdOptions The value for cmdOptions 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder cmdOptions(MongoCmdOptions cmdOptions) {
      this.cmdOptions = Objects.requireNonNull(cmdOptions, "cmdOptions");
      return this;
    }

    /**
     * Initializes the value for the {@link MongoRestoreConfig#password() password} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoRestoreConfig#password() password}.</em>
     * @param password The value for password 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder password(String password) {
      this.password = Objects.requireNonNull(password, "password");
      return this;
    }

    /**
     * Initializes the value for the {@link MongoRestoreConfig#userName() userName} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoRestoreConfig#userName() userName}.</em>
     * @param userName The value for userName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder userName(String userName) {
      this.userName = Objects.requireNonNull(userName, "userName");
      return this;
    }

    /**
     * Initializes the value for the {@link MongoRestoreConfig#isVerbose() isVerbose} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoRestoreConfig#isVerbose() isVerbose}.</em>
     * @param isVerbose The value for isVerbose 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder isVerbose(boolean isVerbose) {
      this.isVerbose = isVerbose;
      optBits |= OPT_BIT_IS_VERBOSE;
      return this;
    }

    /**
     * Initializes the optional value {@link MongoRestoreConfig#getDatabaseName() databaseName} to databaseName.
     * @param databaseName The value for databaseName
     * @return {@code this} builder for chained invocation
     */
    public final Builder databaseName(String databaseName) {
      this.databaseName = Objects.requireNonNull(databaseName, "databaseName");
      return this;
    }

    /**
     * Initializes the optional value {@link MongoRestoreConfig#getDatabaseName() databaseName} to databaseName.
     * @param databaseName The value for databaseName
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder databaseName(Optional<String> databaseName) {
      this.databaseName = databaseName.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link MongoRestoreConfig#getCollectionName() collectionName} to collectionName.
     * @param collectionName The value for collectionName
     * @return {@code this} builder for chained invocation
     */
    public final Builder collectionName(String collectionName) {
      this.collectionName = Objects.requireNonNull(collectionName, "collectionName");
      return this;
    }

    /**
     * Initializes the optional value {@link MongoRestoreConfig#getCollectionName() collectionName} to collectionName.
     * @param collectionName The value for collectionName
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder collectionName(Optional<String> collectionName) {
      this.collectionName = collectionName.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link MongoRestoreConfig#getOplogLimit() oplogLimit} to oplogLimit.
     * @param oplogLimit The value for oplogLimit
     * @return {@code this} builder for chained invocation
     */
    public final Builder oplogLimit(long oplogLimit) {
      this.oplogLimit = oplogLimit;
      return this;
    }

    /**
     * Initializes the optional value {@link MongoRestoreConfig#getOplogLimit() oplogLimit} to oplogLimit.
     * @param oplogLimit The value for oplogLimit
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder oplogLimit(OptionalLong oplogLimit) {
      this.oplogLimit = oplogLimit.isPresent() ? oplogLimit.getAsLong() : null;
      return this;
    }

    /**
     * Initializes the optional value {@link MongoRestoreConfig#getArchive() archive} to archive.
     * @param archive The value for archive
     * @return {@code this} builder for chained invocation
     */
    public final Builder archive(String archive) {
      this.archive = Objects.requireNonNull(archive, "archive");
      return this;
    }

    /**
     * Initializes the optional value {@link MongoRestoreConfig#getArchive() archive} to archive.
     * @param archive The value for archive
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder archive(Optional<String> archive) {
      this.archive = archive.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link MongoRestoreConfig#getDir() dir} to dir.
     * @param dir The value for dir
     * @return {@code this} builder for chained invocation
     */
    public final Builder dir(String dir) {
      this.dir = Objects.requireNonNull(dir, "dir");
      return this;
    }

    /**
     * Initializes the optional value {@link MongoRestoreConfig#getDir() dir} to dir.
     * @param dir The value for dir
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder dir(Optional<String> dir) {
      this.dir = dir.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link MongoRestoreConfig#getNumberOfParallelCollections() numberOfParallelCollections} to numberOfParallelCollections.
     * @param numberOfParallelCollections The value for numberOfParallelCollections
     * @return {@code this} builder for chained invocation
     */
    public final Builder numberOfParallelCollections(int numberOfParallelCollections) {
      this.numberOfParallelCollections = numberOfParallelCollections;
      return this;
    }

    /**
     * Initializes the optional value {@link MongoRestoreConfig#getNumberOfParallelCollections() numberOfParallelCollections} to numberOfParallelCollections.
     * @param numberOfParallelCollections The value for numberOfParallelCollections
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder numberOfParallelCollections(OptionalInt numberOfParallelCollections) {
      this.numberOfParallelCollections = numberOfParallelCollections.isPresent() ? numberOfParallelCollections.getAsInt() : null;
      return this;
    }

    /**
     * Initializes the optional value {@link MongoRestoreConfig#getNumberOfInsertionWorkersPerCollection() numberOfInsertionWorkersPerCollection} to numberOfInsertionWorkersPerCollection.
     * @param numberOfInsertionWorkersPerCollection The value for numberOfInsertionWorkersPerCollection
     * @return {@code this} builder for chained invocation
     */
    public final Builder numberOfInsertionWorkersPerCollection(int numberOfInsertionWorkersPerCollection) {
      this.numberOfInsertionWorkersPerCollection = numberOfInsertionWorkersPerCollection;
      return this;
    }

    /**
     * Initializes the optional value {@link MongoRestoreConfig#getNumberOfInsertionWorkersPerCollection() numberOfInsertionWorkersPerCollection} to numberOfInsertionWorkersPerCollection.
     * @param numberOfInsertionWorkersPerCollection The value for numberOfInsertionWorkersPerCollection
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder numberOfInsertionWorkersPerCollection(OptionalInt numberOfInsertionWorkersPerCollection) {
      this.numberOfInsertionWorkersPerCollection = numberOfInsertionWorkersPerCollection.isPresent() ? numberOfInsertionWorkersPerCollection.getAsInt() : null;
      return this;
    }

    /**
     * Initializes the optional value {@link MongoRestoreConfig#getWriteConcern() writeConcern} to writeConcern.
     * @param writeConcern The value for writeConcern
     * @return {@code this} builder for chained invocation
     */
    public final Builder writeConcern(String writeConcern) {
      this.writeConcern = Objects.requireNonNull(writeConcern, "writeConcern");
      return this;
    }

    /**
     * Initializes the optional value {@link MongoRestoreConfig#getWriteConcern() writeConcern} to writeConcern.
     * @param writeConcern The value for writeConcern
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder writeConcern(Optional<String> writeConcern) {
      this.writeConcern = writeConcern.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link MongoRestoreConfig#isObjectCheck() isObjectCheck} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoRestoreConfig#isObjectCheck() isObjectCheck}.</em>
     * @param isObjectCheck The value for isObjectCheck 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder isObjectCheck(boolean isObjectCheck) {
      this.isObjectCheck = isObjectCheck;
      optBits |= OPT_BIT_IS_OBJECT_CHECK;
      return this;
    }

    /**
     * Initializes the value for the {@link MongoRestoreConfig#isOplogReplay() isOplogReplay} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoRestoreConfig#isOplogReplay() isOplogReplay}.</em>
     * @param isOplogReplay The value for isOplogReplay 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder isOplogReplay(boolean isOplogReplay) {
      this.isOplogReplay = isOplogReplay;
      optBits |= OPT_BIT_IS_OPLOG_REPLAY;
      return this;
    }

    /**
     * Initializes the value for the {@link MongoRestoreConfig#isRestoreDbUsersAndRoles() isRestoreDbUsersAndRoles} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoRestoreConfig#isRestoreDbUsersAndRoles() isRestoreDbUsersAndRoles}.</em>
     * @param isRestoreDbUsersAndRoles The value for isRestoreDbUsersAndRoles 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder isRestoreDbUsersAndRoles(boolean isRestoreDbUsersAndRoles) {
      this.isRestoreDbUsersAndRoles = isRestoreDbUsersAndRoles;
      optBits |= OPT_BIT_IS_RESTORE_DB_USERS_AND_ROLES;
      return this;
    }

    /**
     * Initializes the value for the {@link MongoRestoreConfig#isGzip() isGzip} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoRestoreConfig#isGzip() isGzip}.</em>
     * @param isGzip The value for isGzip 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder isGzip(boolean isGzip) {
      this.isGzip = isGzip;
      optBits |= OPT_BIT_IS_GZIP;
      return this;
    }

    /**
     * Initializes the value for the {@link MongoRestoreConfig#isDropCollection() isDropCollection} attribute.
     * @param isDropCollection The value for isDropCollection 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder isDropCollection(boolean isDropCollection) {
      this.isDropCollection = isDropCollection;
      initBits &= ~INIT_BIT_IS_DROP_COLLECTION;
      return this;
    }

    /**
     * Initializes the value for the {@link MongoRestoreConfig#isNoIndexRestore() isNoIndexRestore} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoRestoreConfig#isNoIndexRestore() isNoIndexRestore}.</em>
     * @param isNoIndexRestore The value for isNoIndexRestore 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder isNoIndexRestore(boolean isNoIndexRestore) {
      this.isNoIndexRestore = isNoIndexRestore;
      optBits |= OPT_BIT_IS_NO_INDEX_RESTORE;
      return this;
    }

    /**
     * Initializes the value for the {@link MongoRestoreConfig#isNoOptionsRestore() isNoOptionsRestore} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoRestoreConfig#isNoOptionsRestore() isNoOptionsRestore}.</em>
     * @param isNoOptionsRestore The value for isNoOptionsRestore 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder isNoOptionsRestore(boolean isNoOptionsRestore) {
      this.isNoOptionsRestore = isNoOptionsRestore;
      optBits |= OPT_BIT_IS_NO_OPTIONS_RESTORE;
      return this;
    }

    /**
     * Initializes the value for the {@link MongoRestoreConfig#isKeepIndexVersion() isKeepIndexVersion} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoRestoreConfig#isKeepIndexVersion() isKeepIndexVersion}.</em>
     * @param isKeepIndexVersion The value for isKeepIndexVersion 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder isKeepIndexVersion(boolean isKeepIndexVersion) {
      this.isKeepIndexVersion = isKeepIndexVersion;
      optBits |= OPT_BIT_IS_KEEP_INDEX_VERSION;
      return this;
    }

    /**
     * Initializes the value for the {@link MongoRestoreConfig#isMaintainInsertionOrder() isMaintainInsertionOrder} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoRestoreConfig#isMaintainInsertionOrder() isMaintainInsertionOrder}.</em>
     * @param isMaintainInsertionOrder The value for isMaintainInsertionOrder 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder isMaintainInsertionOrder(boolean isMaintainInsertionOrder) {
      this.isMaintainInsertionOrder = isMaintainInsertionOrder;
      optBits |= OPT_BIT_IS_MAINTAIN_INSERTION_ORDER;
      return this;
    }

    /**
     * Initializes the value for the {@link MongoRestoreConfig#isStopOnError() isStopOnError} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoRestoreConfig#isStopOnError() isStopOnError}.</em>
     * @param isStopOnError The value for isStopOnError 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder isStopOnError(boolean isStopOnError) {
      this.isStopOnError = isStopOnError;
      optBits |= OPT_BIT_IS_STOP_ON_ERROR;
      return this;
    }

    /**
     * Initializes the value for the {@link MongoRestoreConfig#isBypassDocumentValidation() isBypassDocumentValidation} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoRestoreConfig#isBypassDocumentValidation() isBypassDocumentValidation}.</em>
     * @param isBypassDocumentValidation The value for isBypassDocumentValidation 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder isBypassDocumentValidation(boolean isBypassDocumentValidation) {
      this.isBypassDocumentValidation = isBypassDocumentValidation;
      optBits |= OPT_BIT_IS_BYPASS_DOCUMENT_VALIDATION;
      return this;
    }

    /**
     * Initializes the value for the {@link MongoRestoreConfig#pidFile() pidFile} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoRestoreConfig#pidFile() pidFile}.</em>
     * @param pidFile The value for pidFile 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder pidFile(String pidFile) {
      this.pidFile = Objects.requireNonNull(pidFile, "pidFile");
      return this;
    }

    /**
     * Initializes the value for the {@link MongoRestoreConfig#supportConfig() supportConfig} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoRestoreConfig#supportConfig() supportConfig}.</em>
     * @param supportConfig The value for supportConfig 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder supportConfig(SupportConfig supportConfig) {
      this.supportConfig = Objects.requireNonNull(supportConfig, "supportConfig");
      return this;
    }

    /**
     * Builds a new {@link ImmutableMongoRestoreConfig ImmutableMongoRestoreConfig}.
     * @return An immutable instance of MongoRestoreConfig
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableMongoRestoreConfig build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableMongoRestoreConfig(this);
    }

    private boolean isVerboseIsSet() {
      return (optBits & OPT_BIT_IS_VERBOSE) != 0;
    }

    private boolean isObjectCheckIsSet() {
      return (optBits & OPT_BIT_IS_OBJECT_CHECK) != 0;
    }

    private boolean isOplogReplayIsSet() {
      return (optBits & OPT_BIT_IS_OPLOG_REPLAY) != 0;
    }

    private boolean isRestoreDbUsersAndRolesIsSet() {
      return (optBits & OPT_BIT_IS_RESTORE_DB_USERS_AND_ROLES) != 0;
    }

    private boolean isGzipIsSet() {
      return (optBits & OPT_BIT_IS_GZIP) != 0;
    }

    private boolean isNoIndexRestoreIsSet() {
      return (optBits & OPT_BIT_IS_NO_INDEX_RESTORE) != 0;
    }

    private boolean isNoOptionsRestoreIsSet() {
      return (optBits & OPT_BIT_IS_NO_OPTIONS_RESTORE) != 0;
    }

    private boolean isKeepIndexVersionIsSet() {
      return (optBits & OPT_BIT_IS_KEEP_INDEX_VERSION) != 0;
    }

    private boolean isMaintainInsertionOrderIsSet() {
      return (optBits & OPT_BIT_IS_MAINTAIN_INSERTION_ORDER) != 0;
    }

    private boolean isStopOnErrorIsSet() {
      return (optBits & OPT_BIT_IS_STOP_ON_ERROR) != 0;
    }

    private boolean isBypassDocumentValidationIsSet() {
      return (optBits & OPT_BIT_IS_BYPASS_DOCUMENT_VALIDATION) != 0;
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_VERSION) != 0) attributes.add("version");
      if ((initBits & INIT_BIT_IS_DROP_COLLECTION) != 0) attributes.add("isDropCollection");
      return "Cannot build MongoRestoreConfig, some of required attributes are not set " + attributes;
    }
  }
}
