/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.packageresolver.linux;

import de.flapdoodle.checks.Preconditions;
import de.flapdoodle.embed.mongo.packageresolver.ExplainRules;
import de.flapdoodle.embed.mongo.packageresolver.HasExplanation;
import de.flapdoodle.embed.mongo.packageresolver.PackageFinder;
import de.flapdoodle.embed.mongo.packageresolver.PlatformMatch;
import de.flapdoodle.embed.process.config.store.Package;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.embed.process.distribution.Version;
import de.flapdoodle.os.CommonOS;
import de.flapdoodle.os.ImmutablePlatform;
import de.flapdoodle.os.OS;
import de.flapdoodle.os.Platform;
import de.flapdoodle.types.Pair;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public abstract class AbstractVersionMappedPackageFinder<S extends de.flapdoodle.os.Version, D extends de.flapdoodle.os.Version>
implements PackageFinder,
HasExplanation {
    private final PackageFinder delegate;
    private final List<Pair<S, D>> mappings;
    private final Map<S, D> map;

    protected AbstractVersionMappedPackageFinder(PackageFinder delegate, Pair<S, D> ... mappings) {
        this.delegate = delegate;
        this.mappings = Arrays.asList(mappings);
        this.map = this.mappings.stream().collect(Collectors.toMap(Pair::first, Pair::second));
        Preconditions.checkArgument((mappings.length == this.map.keySet().size() ? 1 : 0) != 0, (String)"invalid mapping: %s", (Object[])new Object[]{Arrays.asList(mappings)});
    }

    @Override
    public Optional<Package> packageFor(Distribution distribution) {
        return this.mapDistribution(distribution).flatMap(this.delegate::packageFor);
    }

    protected Optional<Distribution> mapDistribution(Distribution distribution) {
        if (PlatformMatch.withOs((OS)CommonOS.Linux).withVersion(this.map.keySet()).match(distribution)) {
            if (!distribution.platform().version().isPresent()) {
                throw new RuntimeException("version not set: " + distribution);
            }
            de.flapdoodle.os.Version currentVersion = (de.flapdoodle.os.Version)distribution.platform().version().get();
            de.flapdoodle.os.Version destinationVersion = (de.flapdoodle.os.Version)this.map.get(currentVersion);
            Preconditions.checkNotNull((Object)destinationVersion, (String)"could not find mapping for %s in %s", (Object[])new Object[]{currentVersion, this.map});
            Distribution asDestinationDist = Distribution.of((Version)distribution.version(), (Platform)ImmutablePlatform.copyOf((Platform)distribution.platform()).withVersion(destinationVersion));
            return Optional.of(asDestinationDist);
        }
        return Optional.empty();
    }

    @Override
    public String explain() {
        List destinationVersions = this.mappings.stream().map(Pair::second).distinct().collect(Collectors.toList());
        return destinationVersions.stream().map(uv -> this.mappings.stream().filter(v -> v.second() == uv).map(it -> ((de.flapdoodle.os.Version)it.first()).name()).collect(Collectors.joining(", ", uv.name() + " for ", ""))).collect(Collectors.joining(" and ", "use '" + ExplainRules.finderLabel(this.delegate) + "' with ", ""));
    }
}

