/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.packageresolver.linux;

import de.flapdoodle.embed.mongo.packageresolver.ExplainRules;
import de.flapdoodle.embed.mongo.packageresolver.HasExplanation;
import de.flapdoodle.embed.mongo.packageresolver.ImmutablePlatformMatch;
import de.flapdoodle.embed.mongo.packageresolver.PackageFinder;
import de.flapdoodle.embed.mongo.packageresolver.PlatformMatch;
import de.flapdoodle.embed.process.config.store.Package;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.os.CommonOS;
import de.flapdoodle.os.ImmutablePlatform;
import de.flapdoodle.os.OS;
import de.flapdoodle.os.Platform;
import de.flapdoodle.os.Version;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public class AbstractFallbackToOlderVersionPackageFinder<S extends Version>
implements PackageFinder,
HasExplanation {
    private final PackageFinder packageFinder;
    private final Function<S, Integer> ordinalOf;
    private final List<S> versions;

    @SafeVarargs
    public AbstractFallbackToOlderVersionPackageFinder(PackageFinder packageFinder, Function<S, Integer> ordinalOf, S ... versions) {
        this.packageFinder = packageFinder;
        this.ordinalOf = ordinalOf;
        this.versions = Arrays.asList(versions);
    }

    @Override
    public final Optional<Package> packageFor(Distribution distribution) {
        if (this.platformMatch().match(distribution)) {
            Optional<Package> matchingPackage;
            if (!distribution.platform().version().isPresent()) {
                throw new RuntimeException("version not set: " + distribution);
            }
            Version currentVersion = (Version)distribution.platform().version().get();
            do {
                Distribution asUbuntudistribution;
                if ((matchingPackage = this.packageFinder.packageFor(asUbuntudistribution = Distribution.of((de.flapdoodle.embed.process.distribution.Version)distribution.version(), (Platform)ImmutablePlatform.copyOf((Platform)distribution.platform()).withVersion(currentVersion)))).isPresent()) continue;
                currentVersion = AbstractFallbackToOlderVersionPackageFinder.downgradeVersionFrom(this.versions, this.ordinalOf, currentVersion).orElse(null);
            } while (!matchingPackage.isPresent() && currentVersion != null);
            return matchingPackage;
        }
        return Optional.empty();
    }

    private static <S extends Version> Optional<S> downgradeVersionFrom(List<S> values, Function<S, Integer> ordinalOf, S currentVersion) {
        for (int i = values.size() - 1; i >= 0; --i) {
            Version version = (Version)values.get(i);
            if (ordinalOf.apply(version) >= ordinalOf.apply(currentVersion)) continue;
            return Optional.of(version);
        }
        return Optional.empty();
    }

    @Override
    public final String explain() {
        ArrayList<S> copy = new ArrayList<S>(this.versions);
        Collections.reverse(copy);
        return copy.stream().map(Version::name).collect(Collectors.joining(", ", "use '" + ExplainRules.finderLabel(this.packageFinder) + "' with ", " until package found."));
    }

    public ImmutablePlatformMatch platformMatch() {
        return PlatformMatch.withOs((OS)CommonOS.Linux).withVersion(this.versions);
    }
}

