/*
 * Decompiled with CFR 0.152.
 */
package de.defmacro.ast.search;

import de.defmacro.ast.search.AbstractStatement;
import de.defmacro.ast.search.MethodInvocationResultVisitor;
import de.defmacro.ast.search.ResultVisitor;
import de.defmacro.ast.syntax.IWaitExpressionSyntax;
import de.defmacro.ast.syntax.SyntaxException;
import java.util.List;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.NumberLiteral;

public class Wait
extends AbstractStatement
implements IWaitExpressionSyntax {
    private long fTimeout = -1L;
    private boolean fAnyTimout = false;

    @Override
    public Wait withTimeout(long timeout) {
        if (timeout < 0L) {
            throw new SyntaxException("timeout must be > 0");
        }
        this.fTimeout = timeout;
        this.fAnyTimout = false;
        return this;
    }

    @Override
    public Wait withoutTimeout() {
        this.fTimeout = -1L;
        this.fAnyTimout = false;
        return this;
    }

    @Override
    public Wait withAnyTimeout() {
        this.fTimeout = Long.MAX_VALUE;
        this.fAnyTimout = true;
        return this;
    }

    @Override
    protected ResultVisitor createResultVisitor() {
        return new MethodInvocationResultVisitor("wait"){

            @Override
            public void visitMethodInvocation(MethodInvocation node) {
                if (!this.checkWaitTimout(node)) {
                    this.setMatch(false);
                    this.setMatchedNode(null);
                }
            }

            private boolean checkWaitTimout(MethodInvocation invocation) {
                List arguments = invocation.arguments();
                if (Wait.this.fTimeout < 0L) {
                    return arguments.size() == 0;
                }
                if (arguments.size() == 1) {
                    Object o = arguments.get(0);
                    if (o instanceof NumberLiteral) {
                        NumberLiteral literal = (NumberLiteral)o;
                        try {
                            long time = Long.valueOf(literal.getToken());
                            if (!Wait.this.fAnyTimout) {
                                return time == Wait.this.fTimeout;
                            }
                            return true;
                        }
                        catch (NumberFormatException e) {
                            e.printStackTrace();
                            return false;
                        }
                    }
                    return Wait.this.fAnyTimout;
                }
                return false;
            }
        };
    }
}

