/*
 * Decompiled with CFR 0.152.
 */
package de.defmacro.ast.search;

import de.defmacro.ast.JavaParser;
import de.defmacro.ast.search.AnonymousClassExpression;
import de.defmacro.ast.search.ClassContainer;
import de.defmacro.ast.search.ClassExpression;
import de.defmacro.ast.search.CompilationUnitExpression;
import de.defmacro.ast.search.ExpressionFactory;
import de.defmacro.ast.search.IStatement;
import de.defmacro.ast.search.InnerClassExpression;
import de.defmacro.ast.search.MethodExpression;
import de.defmacro.ast.syntax.IBackToClassSyntax;
import de.defmacro.ast.syntax.IBackToplevelSyntax;
import de.defmacro.ast.syntax.IClassSyntax;
import de.defmacro.ast.syntax.ICompilationUnitSyntax;
import de.defmacro.ast.syntax.IExpressionSyntax;
import de.defmacro.ast.syntax.INextMethodSyntax;
import de.defmacro.ast.syntax.ISearchSyntax;
import de.defmacro.ast.syntax.SyntaxException;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Modifier;

public class SearchIn
implements ICompilationUnitSyntax,
ISearchSyntax {
    private Delegate fDelegate;

    public SearchIn(CompilationUnit unit) {
        if (unit == null) {
            throw new NullPointerException("unit must not be null");
        }
        this.fDelegate = new Delegate(unit);
    }

    @Override
    public IClassSyntax inClass(String clazz) {
        this.fDelegate.inClass(clazz);
        return this.fDelegate;
    }

    @Override
    public IBackToplevelSyntax isClass(String clazz) {
        this.fDelegate.isClass(clazz);
        return this.fDelegate;
    }

    @Override
    public IBackToplevelSyntax isInPackage(String pack) {
        this.fDelegate.isInPackage(pack);
        return this.fDelegate;
    }

    @Override
    public boolean searchThis() {
        return this.fDelegate.searchThis();
    }

    public static void main(String[] args) throws Exception {
        new SearchIn(new JavaParser().parseCompilationUnit(new File("./..."))).inClass("Bla").isMethod("blubb").withArgumentTypes(String.class, Integer.class).withModifiers(Modifier.ModifierKeyword.PUBLIC_KEYWORD).withStatement(ExpressionFactory.and(ExpressionFactory.waitStatement(), ExpressionFactory.notifyStatement())).searchThis();
        new SearchIn(new JavaParser().parseCompilationUnit(new File("./..."))).inClass("").isAnonymousClass().andIsAnonymousClass().searchThis();
        new SearchIn(null).inClass("*").isAnonymousClass();
        new SearchIn(null).inClass("*").inInnerClass("*");
    }

    private static class Delegate
    implements ISearchSyntax,
    ICompilationUnitSyntax,
    IClassSyntax,
    INextMethodSyntax,
    IBackToplevelSyntax,
    IBackToClassSyntax,
    IExpressionSyntax {
        private final List<String> fClasses;
        private final List<ClassExpression> fClassSearchs = new ArrayList<ClassExpression>();
        private final CompilationUnit fUnit;
        private ClassExpression fCurrentClass;
        private MethodExpression fCurrentMethod;

        public Delegate(CompilationUnit unit) {
            this.fClasses = new ArrayList<String>();
            this.fUnit = unit;
        }

        @Override
        public INextMethodSyntax isMethod(String methodName) {
            MethodExpression search = new MethodExpression(methodName);
            this.is(search);
            return this;
        }

        @Override
        public INextMethodSyntax is(MethodExpression expression) {
            this.fCurrentClass.addMethodSearch(expression);
            this.fCurrentMethod = expression;
            return this;
        }

        @Override
        public INextMethodSyntax andIsMethod(String methodName) {
            this.isMethod(methodName);
            return this;
        }

        @Override
        public INextMethodSyntax andIs(MethodExpression expr) {
            this.is(expr);
            return this;
        }

        @Override
        public INextMethodSyntax withReturnType(Class<?> returnType) {
            this.fCurrentMethod.setReturnType(returnType);
            return this;
        }

        @Override
        public INextMethodSyntax withArgumentTypes(Class<?> ... types) {
            this.fCurrentMethod.setArguments(types);
            return this;
        }

        @Override
        public INextMethodSyntax withModifiers(Modifier.ModifierKeyword ... modifiers) {
            this.fCurrentMethod.addModifier(modifiers);
            return this;
        }

        @Override
        public INextMethodSyntax withStatement(IStatement expr) {
            this.fCurrentMethod.addExpression(expr);
            return this;
        }

        @Override
        public INextMethodSyntax withoutArguments() {
            return this;
        }

        @Override
        public boolean searchThis() {
            return new CompilationUnitExpression(this.fClassSearchs).eval(new ClassContainer(this.fUnit));
        }

        @Override
        public IClassSyntax inClass(String clazz) {
            return this.addClass(clazz);
        }

        @Override
        public IBackToplevelSyntax isClass(String clazz) {
            return this.addClass(clazz);
        }

        @Override
        public IBackToplevelSyntax isInPackage(String pack) {
            throw new UnsupportedOperationException();
        }

        private Delegate addClass(String clazz) {
            this.checkClass(clazz);
            this.fCurrentClass = new ClassExpression(clazz);
            this.fClassSearchs.add(this.fCurrentClass);
            this.fClasses.add(clazz);
            return this;
        }

        private void checkClass(String clazz) {
            if (this.fClasses.contains(clazz)) {
                throw new SyntaxException("You cannot search twice for class = '" + clazz + "'");
            }
        }

        @Override
        public IBackToClassSyntax isAnonymousClass() {
            this.fCurrentClass.addAnonymousClassSearch(new AnonymousClassExpression());
            return this;
        }

        @Override
        public IClassSyntax inAnonymousClass() {
            AnonymousClassExpression exp = new AnonymousClassExpression();
            this.fCurrentClass.addAnonymousClassSearch(exp);
            this.fCurrentClass = exp;
            return this;
        }

        @Override
        public IBackToClassSyntax isInnerClass(String name) {
            this.fCurrentClass.addInnerClassSearch(new InnerClassExpression(name));
            return this;
        }

        @Override
        public IClassSyntax inInnerClass(String name) {
            InnerClassExpression exp = new InnerClassExpression(name);
            this.fCurrentClass.addInnerClassSearch(exp);
            this.fCurrentClass = exp;
            return this;
        }

        @Override
        public IClassSyntax andInClass(String clazz) {
            return this.addClass(clazz);
        }

        @Override
        public IBackToplevelSyntax andIsClass(String clazz) {
            return this.addClass(clazz);
        }

        @Override
        public IClassSyntax andInAnonymousClass() {
            return this.inAnonymousClass();
        }

        @Override
        public IBackToClassSyntax andIsAnonymousClass() {
            return this.isAnonymousClass();
        }

        @Override
        public IClassSyntax andInInnerClass(String name) {
            return this.inInnerClass(name);
        }

        @Override
        public IBackToClassSyntax andIsInnerClass(String name) {
            return this.isInnerClass(name);
        }
    }
}

