/*
 * Decompiled with CFR 0.152.
 */
package de.defmacro.ast.search;

import de.defmacro.ast.search.ClassDeclaration;
import de.defmacro.ast.search.IEvaluable;
import de.defmacro.ast.search.ResultVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;

public class MethodExpression
extends ResultVisitor
implements IEvaluable<ClassDeclaration> {
    private final String fMethodName;
    private final List<IEvaluable<Block>> fExpressions;
    private final List<Modifier.ModifierKeyword> fModifiers;
    private Class<?> fReturnType;
    private List<Class<?>> fParameters;

    public MethodExpression() {
        this(null);
    }

    public MethodExpression(String methodName) {
        this.fMethodName = methodName;
        this.fExpressions = new ArrayList<IEvaluable<Block>>();
        this.fParameters = Collections.emptyList();
        this.fModifiers = new ArrayList<Modifier.ModifierKeyword>(1);
    }

    @Override
    public boolean eval(ClassDeclaration subSearch) {
        subSearch.getASTNode().accept(this);
        return this.hasMatch();
    }

    @Override
    public boolean visit(MethodDeclaration node) {
        if (node.getName().getIdentifier().equals(this.fMethodName) && this.hasParameters(node.parameters()) && this.hasModifiers(node.modifiers()) && this.hasReturnType(node)) {
            for (IEvaluable<Block> expr : this.fExpressions) {
                if (expr.eval(node.getBody())) continue;
                this.setMatch(false);
                return true;
            }
            this.setMatch(true);
            return true;
        }
        return true;
    }

    private boolean hasReturnType(MethodDeclaration node) {
        if (this.fReturnType == null) {
            return true;
        }
        return this.testTypeEquals(this.fReturnType, node.getReturnType2());
    }

    private boolean hasModifiers(List modifiers) {
        for (Modifier.ModifierKeyword modifierWanted : this.fModifiers) {
            if (this.containsModifier(modifiers, modifierWanted)) continue;
            return false;
        }
        return true;
    }

    private boolean containsModifier(List modifiers, Modifier.ModifierKeyword keyword) {
        for (int i = 0; i < modifiers.size(); ++i) {
            Modifier modifier;
            Object obj = modifiers.get(i);
            if (!(obj instanceof Modifier) || !(modifier = (Modifier)obj).getKeyword().equals(keyword)) continue;
            return true;
        }
        return false;
    }

    private boolean hasParameters(List<SingleVariableDeclaration> parameters) {
        if (parameters.size() != this.fParameters.size()) {
            return false;
        }
        for (int i = 0; i < parameters.size(); ++i) {
            SingleVariableDeclaration parameter = parameters.get(i);
            if (this.testTypeEquals(this.fParameters.get(i), parameter.getType())) continue;
            return false;
        }
        return true;
    }

    private boolean testTypeEquals(Class<?> expected, Type actual) {
        if (actual.isSimpleType()) {
            SimpleType simpleDeclaration = (SimpleType)actual;
            return this.testNameEquals(expected, simpleDeclaration.getName());
        }
        if (actual.isPrimitiveType()) {
            PrimitiveType primitive = (PrimitiveType)actual;
            return this.testPrimitiveTypeEquals(expected, primitive.getPrimitiveTypeCode());
        }
        System.err.println("warning: not simple type, feature not implemented. type is: " + actual.getClass());
        throw new UnsupportedOperationException();
    }

    private boolean testNameEquals(Class<?> expected, Name actual) {
        if (actual.isQualifiedName()) {
            return actual.getFullyQualifiedName().equals(expected.getCanonicalName());
        }
        return actual.getFullyQualifiedName().equals(expected.getSimpleName());
    }

    private boolean testPrimitiveTypeEquals(Class<?> expected, PrimitiveType.Code actual) {
        String name = actual.toString();
        if (name.equals(PrimitiveType.BOOLEAN.toString())) {
            return expected.equals(Boolean.TYPE);
        }
        if (name.equals(PrimitiveType.INT.toString())) {
            return expected.equals(Integer.TYPE);
        }
        if (name.equals(PrimitiveType.CHAR.toString())) {
            return expected.equals(Character.TYPE);
        }
        if (name.equals(PrimitiveType.SHORT.toString())) {
            return expected.equals(Short.TYPE);
        }
        if (name.equals(PrimitiveType.LONG.toString())) {
            return expected.equals(Long.TYPE);
        }
        if (name.equals(PrimitiveType.FLOAT.toString())) {
            return expected.equals(Float.TYPE);
        }
        if (name.equals(PrimitiveType.DOUBLE.toString())) {
            return expected.equals(Double.TYPE);
        }
        if (name.equals(PrimitiveType.BYTE.toString())) {
            return expected.equals(Byte.TYPE);
        }
        if (name.equals(PrimitiveType.VOID.toString())) {
            return expected.equals(Void.TYPE);
        }
        System.err.println("warning: unknown primitive type: " + actual);
        throw new UnsupportedOperationException();
    }

    public void addExpression(IEvaluable<Block> expression) {
        this.fExpressions.add(expression);
    }

    protected void setArguments(Class<?> ... classes) {
        if (classes == null) {
            throw new NullPointerException("classes must not be null, this is a vararg argument");
        }
        this.fParameters = Arrays.asList(classes);
    }

    public void addModifier(Modifier.ModifierKeyword ... modifiers) {
        for (Modifier.ModifierKeyword modifier : modifiers) {
            if (this.fModifiers.contains(modifiers)) continue;
            this.fModifiers.add(modifier);
        }
    }

    public void setReturnType(Class<?> returnType) {
        this.fReturnType = returnType;
    }
}

