/*
 * Decompiled with CFR 0.152.
 */
package de.defmacro.ast.search;

import de.defmacro.ast.search.ClassDeclaration;
import de.defmacro.ast.search.IStatement;
import de.defmacro.ast.search.MethodExpression;
import de.defmacro.ast.search.Notify;
import de.defmacro.ast.search.NotifyAll;
import de.defmacro.ast.search.Synchronized;
import de.defmacro.ast.search.Wait;
import org.eclipse.jdt.core.dom.Block;

public class ExpressionFactory {
    public static MethodExpression method(String name) {
        return new MethodExpression(name);
    }

    public static Wait waitStatement() {
        return new Wait();
    }

    public static Notify notifyStatement() {
        return new Notify();
    }

    public static NotifyAll notifyAllStatement() {
        return new NotifyAll();
    }

    public static Synchronized synchronizedStatement() {
        return new Synchronized();
    }

    public static MethodExpression not(final MethodExpression expr) {
        return new MethodExpression(){

            @Override
            public boolean eval(ClassDeclaration subSearch) {
                return !expr.eval(subSearch);
            }
        };
    }

    public static IStatement not(final IStatement expr) {
        return new IStatement(){

            @Override
            public final boolean eval(Block block) {
                return !expr.eval(block);
            }
        };
    }

    public static IStatement or(final IStatement ... statements) {
        return new IStatement(){

            @Override
            public boolean eval(Block block) {
                for (IStatement stmt : statements) {
                    if (!stmt.eval(block)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static IStatement and(final IStatement ... statements) {
        return new IStatement(){

            @Override
            public boolean eval(Block block) {
                for (IStatement stmt : statements) {
                    if (stmt.eval(block)) continue;
                    return false;
                }
                return true;
            }
        };
    }
}

