/*
 * Decompiled with CFR 0.152.
 */
package de.defmacro.ast.search;

import de.defmacro.ast.search.AnonymousClassExpression;
import de.defmacro.ast.search.ClassContainer;
import de.defmacro.ast.search.ClassDeclaration;
import de.defmacro.ast.search.IEvaluable;
import de.defmacro.ast.search.InnerClassExpression;
import de.defmacro.ast.search.MethodExpression;
import de.defmacro.ast.search.ResultVisitor;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.TypeDeclaration;

public class ClassExpression
extends ResultVisitor
implements IEvaluable<ClassContainer> {
    private final String fName;
    private final List<MethodExpression> fMethods;
    private final List<AnonymousClassExpression> fAnonymousClasses;
    private final List<InnerClassExpression> fInnerClasses;

    public ClassExpression(String name) {
        if (name == null) {
            throw new NullPointerException("name must not be null");
        }
        this.fName = name.trim();
        this.fMethods = new ArrayList<MethodExpression>();
        this.fAnonymousClasses = new ArrayList<AnonymousClassExpression>();
        this.fInnerClasses = new ArrayList<InnerClassExpression>();
    }

    public void addMethodSearch(MethodExpression search) {
        this.fMethods.add(search);
    }

    public void addAnonymousClassSearch(AnonymousClassExpression exp) {
        this.fAnonymousClasses.add(exp);
    }

    public void addInnerClassSearch(InnerClassExpression exp) {
        this.fInnerClasses.add(exp);
    }

    @Override
    public boolean eval(ClassContainer node) {
        node.getASTNode().accept(this);
        return this.hasMatch();
    }

    @Override
    public boolean visit(TypeDeclaration node) {
        if (this.classNameMatches(node)) {
            this.setMatch(true);
            this.evaluateMethodExpression(new ClassDeclaration(node));
            ClassContainer classContainer = new ClassContainer(node);
            for (AnonymousClassExpression anony : this.fAnonymousClasses) {
                if (anony.eval(classContainer)) continue;
                this.setMatch(false);
                return true;
            }
            for (InnerClassExpression inner : this.fInnerClasses) {
                if (inner.eval(classContainer)) continue;
                this.setMatch(false);
                return true;
            }
            return true;
        }
        return true;
    }

    protected boolean classNameMatches(TypeDeclaration node) {
        return this.fName.equals("*") || node.getName().getFullyQualifiedName().equals(this.fName);
    }

    protected void evaluateMethodExpression(ClassDeclaration node) {
        for (MethodExpression search : this.fMethods) {
            if (search.eval(node)) continue;
            this.setMatch(false);
        }
    }
}

