/*
 * Decompiled with CFR 0.152.
 */
package de.defmacro.ast;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Hashtable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;

public class JavaParser {
    private static final String NL = System.getProperty("line.separator");
    private final ASTParser fParser;

    public JavaParser(int level) {
        this.fParser = ASTParser.newParser(level);
    }

    public JavaParser() {
        this(8);
        Hashtable options = JavaCore.getOptions();
        JavaCore.setComplianceOptions("1.8", options);
        this.fParser.setCompilerOptions(options);
    }

    public CompilationUnit parseCompilationUnit(File file) throws IOException {
        return this.parseCompilationUnit(this.readContentFromFile(file), null);
    }

    public CompilationUnit parseCompilationUnit(String content) throws IOException {
        return this.parseCompilationUnit(content, null);
    }

    public CompilationUnit parseCompilationUnit(String content, IProgressMonitor monitor) throws IOException {
        this.fParser.setSource(content.toCharArray());
        this.fParser.setKind(8);
        return (CompilationUnit)this.fParser.createAST(monitor);
    }

    private String readContentFromFile(File file) throws IOException {
        try (BufferedReader br = new BufferedReader(new FileReader(file));){
            StringBuilder s = new StringBuilder();
            String line = null;
            while ((line = br.readLine()) != null) {
                s.append(line);
                s.append(NL);
            }
            String string = s.toString();
            return string;
        }
    }
}

